/*
 * Decompiled with CFR 0.152.
 */
package com.rabbit.blade.presenter;

import android.app.Application;
import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.blankj.utilcode.utils.Utils;
import java.util.HashMap;
import java.util.Map;

public class ComponentApplication
extends Application {
    private final Map<String, Object> components = new HashMap<String, Object>();

    public void putComponent(@NonNull String componentName, @Nullable Object component) {
        this.components.put(componentName, component);
    }

    public void removeComponent(@NonNull String componentName) {
        if (this.components.containsKey(componentName)) {
            this.components.remove(componentName);
        }
    }

    @Nullable
    public <T> T getComponent(@NonNull String componentName) {
        if (!this.components.isEmpty() && this.components.containsKey(componentName)) {
            return (T)this.components.get(componentName);
        }
        return null;
    }

    public static <T> void registerComponent(@NonNull Context context, @NonNull String compName, @NonNull T t) {
        Context applicationContext = context.getApplicationContext();
        if (applicationContext instanceof ComponentApplication) {
            ((ComponentApplication)applicationContext).putComponent(compName, t);
        }
    }

    public static <T> void registerComponent(@NonNull String compName, @NonNull T t) {
        Context context = Utils.getContext();
        if (context != null) {
            ComponentApplication.registerComponent(context, compName, t);
        }
    }

    public static <T> void unRegisterComponent(@NonNull Context context, @NonNull String compName) {
        Context applicationContext = context.getApplicationContext();
        if (applicationContext instanceof ComponentApplication) {
            ((ComponentApplication)applicationContext).removeComponent(compName);
        }
    }

    public static <T> void unRegisterComponent(@NonNull String compName) {
        Context context = Utils.getContext();
        if (context != null) {
            ComponentApplication.unRegisterComponent(context, compName);
        }
    }

    @Nullable
    public static <T> T findComponent(@NonNull Context context, @NonNull String compName) {
        Context applicationContext = context.getApplicationContext();
        if (applicationContext instanceof ComponentApplication) {
            return ((ComponentApplication)applicationContext).getComponent(compName);
        }
        return null;
    }

    @Nullable
    public static <T> T findComponent(@NonNull String compName) {
        Context context = Utils.getContext();
        if (context != null) {
            return ComponentApplication.findComponent(context, compName);
        }
        return null;
    }
}

