/*
 * Decompiled with CFR 0.152.
 */
package com.rabbit.blade.presenter.main;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v7.app.AppCompatActivity;
import android.text.TextUtils;
import com.rabbit.blade.comm.exeption.OkException;
import com.rabbit.blade.presenter.AndroidApplication;
import com.rabbit.blade.presenter.assist.AssistProvider;
import com.rabbit.blade.presenter.assist.Cake;
import com.rabbit.blade.presenter.assist.DialogLoader;
import com.rabbit.blade.presenter.assist.FlyHunter;
import com.rabbit.blade.presenter.assist.FlyRepo;
import com.rabbit.blade.presenter.assist.Loader;
import com.rabbit.blade.presenter.assist.ToastCake;
import com.rabbit.blade.presenter.di.components.ActivityComponent;
import com.rabbit.blade.presenter.navigate.Navigator;

public class SmartActivity
extends AppCompatActivity
implements FlyHunter,
AssistProvider {
    private ActivityComponent activityComponent;

    public ActivityComponent getActivityComponent() {
        if (this.activityComponent == null) {
            this.activityComponent = ((AndroidApplication)this.getApplication()).createActivityComponent(this);
        }
        return this.activityComponent;
    }

    protected void onDestroy() {
        this.activityComponent = null;
        super.onDestroy();
    }

    @Override
    public boolean handleOkException(@Nullable String okCode, @Nullable String userMsg, @Nullable OkException ex, @Nullable String mark) {
        return false;
    }

    @Override
    public void defaultOkException(@Nullable String code, @Nullable String userMsg, @Nullable OkException ex, @Nullable String mark) {
        if (!TextUtils.isEmpty((CharSequence)userMsg)) {
            this.getActivityComponent().activityCake().showCake(userMsg);
        }
    }

    @Override
    public boolean handlerThrowable(@Nullable Throwable throwable, @Nullable String mark) {
        return false;
    }

    @Override
    public void defaultThrowable(@Nullable Throwable throwable, @Nullable String mark) {
        if (throwable == null) {
            this.getActivityComponent().activityCake().showCake("\u9519\u8bef\u4f46\u6ca1\u6709\u63d0\u793a\u4fe1\u606f,\u8bf7\u63d0\u4ea4\u9519\u8bef\u65e5\u5fd7\uff01");
            return;
        }
        try {
            FlyRepo.recognizeFly(throwable);
        }
        catch (RuntimeException e) {
            this.getActivityComponent().activityCake().showCake(e.getMessage());
            return;
        }
        this.getActivityComponent().activityCake().showCake(throwable.getMessage());
    }

    @Override
    public Cake provideCake() {
        return new ToastCake((Context)this);
    }

    @Override
    public FlyHunter provideFlyHunter() {
        return this;
    }

    @Override
    public Loader provideLoader() {
        return new DialogLoader((Activity)this);
    }

    public void startActivity(Intent intent) {
        boolean result = false;
        if (Navigator.getInterceptor() != null) {
            result = Navigator.getInterceptor().startActivity((Context)this, intent);
        }
        if (!result) {
            super.startActivity(intent);
        }
    }

    public void startActivity(Intent intent, @Nullable Bundle options) {
        boolean result = false;
        if (Navigator.getInterceptor() != null) {
            result = Navigator.getInterceptor().startActivity((Context)this, intent, options);
        }
        if (!result) {
            super.startActivity(intent, options);
        }
    }

    public void startActivityForResult(Intent intent, int requestCode) {
        boolean result = false;
        if (Navigator.getInterceptor() != null) {
            result = Navigator.getInterceptor().startActivityForResult((Activity)this, intent, requestCode);
        }
        if (!result) {
            super.startActivityForResult(intent, requestCode);
        }
    }

    public void startActivityForResult(Intent intent, int requestCode, @Nullable Bundle options) {
        boolean result = false;
        if (Navigator.getInterceptor() != null) {
            result = Navigator.getInterceptor().startActivityForResult((Activity)this, intent, requestCode, options);
        }
        if (!result) {
            super.startActivityForResult(intent, requestCode, options);
        }
    }
}

