/*
 * Decompiled with CFR 0.152.
 */
package com.rabbit.blade.presenter.splite;

import android.app.Application;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.res.Configuration;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.blankj.utilcode.utils.Utils;
import com.rabbit.blade.comm.event.DefaultBusProvider;
import com.rabbit.blade.comm.util.LogUtil;
import com.rabbit.blade.presenter.ComponentApplication;
import com.rabbit.blade.presenter.splite.BoundedApplication;
import com.rabbit.blade.presenter.splite.ForkedBar;
import com.rabbit.blade.presenter.splite.ForkedEvent;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public abstract class ForkedApplication
extends ComponentApplication {
    public static final String FORKED_RECEIVER_ACTION = "com.rabbit.blade.action.FORKED";
    public static final String FORKED_METADATA_NAME = "com.rabbit.blade.forked";
    private static final String TAG_BOUNDED_APPLICATION = "TAG_BOUNDED_APPLICATION";

    public abstract void afterForkedApplications();

    public abstract void preForkedApplications();

    public void onCreate() {
        super.onCreate();
        this.preForkedApplications();
        this.initForkedApplications();
        this.afterForkedApplications();
        DefaultBusProvider.instance().postSticky((Object)new ForkedEvent("onAttach", (Object)this));
    }

    public void onTerminate() {
        super.onTerminate();
        DefaultBusProvider.instance().postSticky((Object)new ForkedEvent("onTerminate", null));
    }

    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        DefaultBusProvider.instance().postSticky((Object)new ForkedEvent("onConfigurationChanged", newConfig));
    }

    public void onLowMemory() {
        super.onLowMemory();
        DefaultBusProvider.instance().postSticky((Object)new ForkedEvent("onLowMemory", null));
    }

    public void onTrimMemory(int level) {
        super.onTrimMemory(level);
        DefaultBusProvider.instance().postSticky((Object)new ForkedEvent("onTrimMemory", level));
    }

    public void detach() {
        DefaultBusProvider.instance().postSticky((Object)new ForkedEvent("onDetach", null));
    }

    protected Map<String, BoundedApplication> getBoundedApplications() {
        HashMap boundedApplications = (HashMap)this.getComponent(TAG_BOUNDED_APPLICATION);
        if (boundedApplications == null) {
            boundedApplications = new HashMap();
            this.putComponent(TAG_BOUNDED_APPLICATION, boundedApplications);
        }
        return boundedApplications;
    }

    @Nullable
    public <T extends BoundedApplication> T getForkedApplication(@NonNull String tag) {
        Map<String, BoundedApplication> boundedApplications = this.getBoundedApplications();
        if (boundedApplications != null && !boundedApplications.isEmpty()) {
            return (T)boundedApplications.get(tag);
        }
        return null;
    }

    @Nullable
    public static <T extends BoundedApplication> T findForkedApplication(@NonNull Context context, @NonNull String appTag) {
        Context applicationContext = context.getApplicationContext();
        if (applicationContext instanceof ForkedApplication) {
            ForkedApplication forkedApplication = (ForkedApplication)applicationContext;
            return forkedApplication.getForkedApplication(appTag);
        }
        return null;
    }

    @Nullable
    public static <T extends BoundedApplication> T findForkedApplication(@NonNull String appTag) {
        Context context = Utils.getContext();
        if (context != null) {
            return ForkedApplication.findForkedApplication(context, appTag);
        }
        return null;
    }

    private void initForkedApplications() {
        this.sendBroadcast(new Intent(FORKED_RECEIVER_ACTION));
        this.listForkedBar();
    }

    private void listForkedBar() {
        Bundle metaData = null;
        try {
            metaData = this.getPackageManager().getApplicationInfo((String)this.getPackageName(), (int)128).metaData;
        }
        catch (PackageManager.NameNotFoundException e) {
            LogUtil.getUtils().w((Object)e.getMessage());
        }
        if (metaData != null) {
            ArrayList<String> forkedObjects = null;
            Set metaDataKeys = metaData.keySet();
            if (metaDataKeys != null) {
                forkedObjects = new ArrayList<String>();
                for (String metaDataKey : metaDataKeys) {
                    if (TextUtils.isEmpty((CharSequence)metaDataKey) || !metaDataKey.startsWith(FORKED_METADATA_NAME)) continue;
                    forkedObjects.add(metaData.getString(metaDataKey));
                }
            }
            if (forkedObjects != null) {
                try {
                    for (String forkedObject : forkedObjects) {
                        if (forkedObject == null) continue;
                        Constructor<?> constructor = Class.forName(forkedObject).getConstructor(Application.class);
                        ((ForkedBar)constructor.newInstance(new Object[]{this})).fork();
                    }
                }
                catch (NoSuchMethodException e) {
                    LogUtil.getUtils().w((Object)e.getMessage());
                }
                catch (ClassNotFoundException e) {
                    LogUtil.getUtils().w((Object)e.getMessage());
                }
                catch (IllegalAccessException e) {
                    LogUtil.getUtils().w((Object)e.getMessage());
                }
                catch (InstantiationException e) {
                    LogUtil.getUtils().w((Object)e.getMessage());
                }
                catch (InvocationTargetException e) {
                    LogUtil.getUtils().w((Object)e.getMessage());
                }
            }
        }
    }
}

