/*
 * Decompiled with CFR 0.152.
 */
package com.rabbit.blade.presenter.splite;

import android.app.Application;
import android.content.res.Configuration;
import android.support.annotation.NonNull;
import com.rabbit.blade.comm.util.LogUtil;
import com.rabbit.blade.presenter.AndroidApplication;
import com.rabbit.blade.presenter.di.components.ApplicationComponent;
import com.rabbit.blade.presenter.splite.BoundedApplication;
import com.rabbit.blade.presenter.splite.ForkedApplication;
import com.rabbit.blade.presenter.splite.ForkedEvent;
import java.lang.reflect.Method;
import org.greenrobot.eventbus.Subscribe;
import org.greenrobot.eventbus.ThreadMode;

public class ForkedHandler {
    private Application application;
    private BoundedApplication boundedApplication;

    public ForkedHandler(@NonNull Application application) {
        this.application = application;
    }

    public void registProvider(@NonNull Provider provider) {
        this.boundedApplication = provider.boundedApplication();
        String boundedApplicationTag = provider.boundedApplicationTag();
        ((ForkedApplication)this.application).getBoundedApplications().put(boundedApplicationTag, this.boundedApplication);
    }

    public void handleForkedEvent(ForkedEvent forkedEvent) {
        if (forkedEvent != null) {
            switch (forkedEvent.getLifeCycle()) {
                case "onAttach": {
                    this.boundedApplication.onAttach(this.application);
                    break;
                }
                case "onConfigurationChanged": {
                    this.boundedApplication.onConfigurationChanged((Configuration)forkedEvent.getObject());
                    break;
                }
                case "onLowMemory": {
                    this.boundedApplication.onLowMemory();
                    break;
                }
                case "onTerminate": {
                    this.boundedApplication.onTerminate();
                    break;
                }
                case "onTrimMemory": {
                    this.boundedApplication.onTrimMemory((Integer)forkedEvent.getObject());
                    break;
                }
                case "onDetach": {
                    this.boundedApplication.onDetach();
                    break;
                }
            }
        }
    }

    public static <T> boolean checkForkedEventSubscriber(Application application, Class<T> forkedClass) {
        ApplicationComponent applicationComponent = ((AndroidApplication)application).getApplicationComponent();
        Method method = null;
        try {
            method = forkedClass.getMethod("handleForkedEvent", ForkedEvent.class);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        if (method == null) {
            applicationComponent.applicationCake().showCake("The class " + forkedClass.getSimpleName() + "  must override with method \"handleForkedEvent\"");
            return false;
        }
        Subscribe annotation = method.getAnnotation(Subscribe.class);
        if (annotation == null) {
            applicationComponent.applicationCake().showCake("\"handleForkedEvent\" method must annotation with \"@Subscribe\"");
            return false;
        }
        ThreadMode threadMode = annotation.threadMode();
        int priority = annotation.priority();
        boolean sticky = annotation.sticky();
        LogUtil.getUtils().d((Object)("\"handleForkedEvent\" \"@Subscribe\" annotation threadMode : " + threadMode));
        LogUtil.getUtils().d((Object)("\"handleForkedEvent\" \"@Subscribe\" annotation priority : " + priority));
        LogUtil.getUtils().d((Object)("\"handleForkedEvent\" \"@Subscribe\" annotation sticky : " + sticky));
        if (priority == 0) {
            applicationComponent.applicationCake().showCake("\"priority\" in \"@Subscribe\" annotation is default value,Are you sure? ");
        }
        if (!sticky) {
            applicationComponent.applicationCake().showCake("\"sticky\" in \"@Subscribe\" annotation is false,Are you sure? ");
        }
        return true;
    }

    public static interface Provider {
        @NonNull
        public BoundedApplication boundedApplication();

        @NonNull
        public String boundedApplicationTag();
    }
}

