/*
 * Decompiled with CFR 0.152.
 */
package com.rabbit.blade.presenter;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.blankj.utilcode.utils.Utils;
import com.rabbit.blade.presenter.ComponentApplication;

public final class ComponentService {
    public static <T> void registerComponent(@NonNull Context context, @NonNull String compName, @NonNull T t) {
        Context applicationContext = context.getApplicationContext();
        if (applicationContext instanceof ComponentApplication) {
            ((ComponentApplication)applicationContext).putComponent(compName, t);
        }
    }

    public static <T> void registerComponent(@NonNull String compName, @NonNull T t) {
        Context context = Utils.getContext();
        if (context != null) {
            ComponentService.registerComponent(context, compName, t);
        }
    }

    public static void unRegisterComponent(@NonNull Context context, @NonNull String compName) {
        Context applicationContext = context.getApplicationContext();
        if (applicationContext instanceof ComponentApplication) {
            ((ComponentApplication)applicationContext).removeComponent(compName);
        }
    }

    public static void unRegisterComponent(@NonNull String compName) {
        Context context = Utils.getContext();
        if (context != null) {
            ComponentService.unRegisterComponent(context, compName);
        }
    }

    @Nullable
    public static <T> T findComponent(@NonNull Context context, @NonNull String compName) {
        Context applicationContext = context.getApplicationContext();
        if (applicationContext instanceof ComponentApplication) {
            return ((ComponentApplication)applicationContext).getComponent(compName);
        }
        return null;
    }

    @Nullable
    public static <T> T findComponent(@NonNull String compName) {
        Context context = Utils.getContext();
        if (context != null) {
            return ComponentService.findComponent(context, compName);
        }
        return null;
    }

    @Nullable
    public static ComponentApplication acquireComponentApplication() {
        Context context = Utils.getContext();
        if (context != null) {
            return (ComponentApplication)context.getApplicationContext();
        }
        return null;
    }
}

