/*
 * Decompiled with CFR 0.152.
 */
package com.rabbit.blade.presenter.di.modules;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.rabbit.blade.comm.annotation.qua.AroundQua;
import com.rabbit.blade.comm.annotation.scop.PerActivity;
import com.rabbit.blade.presenter.assist.AssistProvider;
import com.rabbit.blade.presenter.assist.Cake;
import com.rabbit.blade.presenter.assist.FlyHunter;
import com.rabbit.blade.presenter.assist.Loader;
import com.rabbit.blade.presenter.di.components.FragmentComponent;
import com.rabbit.blade.presenter.main.SmartActivity;
import dagger.Module;
import dagger.Provides;

@Module(subcomponents={FragmentComponent.class})
public class ActivityModule {
    private final SmartActivity smartActivity;

    public ActivityModule(@NonNull SmartActivity smartActivity) {
        this.smartActivity = smartActivity;
    }

    @Provides
    @PerActivity
    @AroundQua
    Activity provideActivity() {
        return this.smartActivity;
    }

    @Provides
    @PerActivity
    @AroundQua
    Context provideContext() {
        return this.smartActivity;
    }

    @Provides
    @PerActivity
    Intent provideIntent() {
        return this.smartActivity.getIntent();
    }

    @Provides
    @PerActivity
    @AroundQua
    @Nullable
    Bundle provideBundle(Intent intent) {
        return intent.getExtras();
    }

    @Provides
    @PerActivity
    @AroundQua
    AssistProvider provideAssist() {
        return this.smartActivity;
    }

    @Provides
    @PerActivity
    @AroundQua
    Loader provideLoader(@AroundQua AssistProvider assistProvider) {
        return assistProvider.provideLoader();
    }

    @Provides
    @PerActivity
    @AroundQua
    Cake provideCake(@AroundQua AssistProvider assistProvider) {
        return assistProvider.provideCake();
    }

    @Provides
    @PerActivity
    @AroundQua
    FlyHunter provideFlyHunter(@AroundQua AssistProvider assistProvider) {
        return assistProvider.provideFlyHunter();
    }

    public static interface Provider {
        @AroundQua
        public Activity activity();

        @AroundQua
        public Context activityContext();

        public Intent intent();

        @Nullable
        @AroundQua
        public Bundle activityBundle();

        @AroundQua
        public AssistProvider activityAssist();

        @AroundQua
        public Loader activityLoader();

        @AroundQua
        public Cake activityCake();

        @Nullable
        @AroundQua
        public FlyHunter activityFlyHunter();
    }
}

