/*
 * Decompiled with CFR 0.152.
 */
package com.rabbit.blade.presenter.di.modules;

import android.content.Context;
import androidx.annotation.NonNull;
import com.rabbit.blade.comm.annotation.qua.AroundQua;
import com.rabbit.blade.comm.annotation.qua.ConnSecurityQua;
import com.rabbit.blade.data.cache.ConfigCache;
import com.rabbit.blade.data.net.OkHttpsBuilder;
import com.rabbit.blade.data.net.ServiceGenerator;
import dagger.Module;
import dagger.Provides;
import javax.inject.Singleton;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.logging.HttpLoggingInterceptor;

@Module
public class NetworkModule {
    private boolean isLog = true;

    public NetworkModule() {
    }

    public NetworkModule(boolean isLog) {
        this.isLog = isLog;
    }

    @Singleton
    @Provides
    @ConnSecurityQua(value="http")
    OkHttpClient.Builder provideOkHttpClientBuilder() {
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        if (this.isLog) {
            builder.addInterceptor((Interceptor)NetworkModule.getHttpLoggingInterceptor());
        }
        return builder;
    }

    @Singleton
    @Provides
    @ConnSecurityQua(value="https")
    OkHttpClient.Builder provideOkHttpsClientBuilder(@AroundQua(value="qua_application") Context context, ConfigCache configCache) {
        OkHttpClient.Builder builder = new OkHttpsBuilder(context, configCache).build();
        if (this.isLog) {
            builder.addInterceptor((Interceptor)NetworkModule.getHttpLoggingInterceptor());
        }
        return builder;
    }

    @Singleton
    @Provides
    @ConnSecurityQua(value="http")
    ServiceGenerator provideHttpServiceGenerator(@ConnSecurityQua(value="http") OkHttpClient.Builder builder, ConfigCache configCache) {
        return new ServiceGenerator(builder, configCache.getConfig("baseUrl"));
    }

    @Singleton
    @Provides
    @ConnSecurityQua(value="https")
    ServiceGenerator provideHttpsServiceGenerator(@ConnSecurityQua(value="https") OkHttpClient.Builder builder, ConfigCache configCache) {
        return new ServiceGenerator(builder, configCache.getConfig("baseUrl"));
    }

    @NonNull
    public static HttpLoggingInterceptor getHttpLoggingInterceptor() {
        HttpLoggingInterceptor loggingInterceptor = new HttpLoggingInterceptor();
        loggingInterceptor.setLevel(HttpLoggingInterceptor.Level.BODY);
        return loggingInterceptor;
    }

    public static interface Provider {
        @ConnSecurityQua(value="http")
        public OkHttpClient.Builder okHttpClient();

        @ConnSecurityQua(value="https")
        public OkHttpClient.Builder okHttpsClient();

        @ConnSecurityQua(value="http")
        public ServiceGenerator httpService();

        @ConnSecurityQua(value="https")
        public ServiceGenerator httpsService();
    }
}

