/*
 * Decompiled with CFR 0.152.
 */
package com.rabbit.blade.presenter.gui.mvp.cement;

import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AbsListView;
import android.widget.BaseAdapter;
import androidx.annotation.Nullable;
import com.rabbit.blade.comm.util.LogUtil;
import com.rabbit.blade.presenter.gui.mvp.annotation.MVP;
import com.rabbit.blade.presenter.gui.mvp.presenter.Presenter;
import com.rabbit.blade.presenter.gui.mvp.view.AdapterView;
import com.rabbit.blade.presenter.gui.mvp.view.Vu;

public abstract class CementAdapter<D>
extends BaseAdapter {
    private LayoutInflater inflater;
    @Nullable
    private final AbsListView absListView;

    public CementAdapter(@Nullable AbsListView absListView) {
        this.absListView = absListView;
    }

    public CementAdapter() {
        this.absListView = null;
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        Vu.AdapterVu<D> adapterVu;
        if (convertView == null) {
            if (this.inflater == null) {
                this.inflater = (LayoutInflater)parent.getContext().getSystemService("layout_inflater");
            }
            MVP.ADAPTER mvpBinderAnn = ((Object)((Object)this)).getClass().getAnnotation(MVP.ADAPTER.class);
            Presenter presenter = this.getPresenter(mvpBinderAnn);
            adapterVu = this.getAdapterVu(position, mvpBinderAnn);
            if (adapterVu != null) {
                adapterVu.bindPresenter(presenter);
                adapterVu.bindListView(this.absListView);
                convertView = adapterVu.initView(this.inflater, parent);
                if (convertView != null) {
                    convertView.setTag(adapterVu);
                }
                adapterVu.onViewCreated(position);
            }
        } else {
            adapterVu = (Vu.AdapterVu<D>)convertView.getTag();
            adapterVu.onViewReused(position);
        }
        if (adapterVu != null) {
            adapterVu.displayDataSource(position, this.getDataSource(position));
        }
        return convertView;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Vu.AdapterVu<D> getAdapterVu(int position, MVP.ADAPTER mvpBinderAnn) {
        Vu.AdapterVu adapterVu = null;
        try {
            Class<? extends Vu.AdapterVu> v;
            if (mvpBinderAnn != null && !(v = mvpBinderAnn.view()).getName().equals(AdapterView.class.getName())) {
                adapterVu = v.newInstance();
            }
        }
        catch (Exception e) {
            LogUtil.getUtils().w((Object)e.getMessage());
        }
        finally {
            if (adapterVu == null) {
                adapterVu = this.provideVu(position);
            }
        }
        return adapterVu;
    }

    private Presenter getPresenter(MVP.ADAPTER mvpBinderAnn) {
        Presenter presenter = null;
        if (mvpBinderAnn != null && mvpBinderAnn.presentable() && this instanceof Presenter) {
            presenter = (Presenter)((Object)this);
        }
        if (presenter == null) {
            presenter = this.providePresenter();
        }
        return presenter;
    }

    public void updateItem(int position) {
        if (this.absListView != null) {
            int firstVisPosition = this.absListView.getFirstVisiblePosition();
            int lastVisPosition = this.absListView.getLastVisiblePosition();
            if (position < firstVisPosition - 1 || position > lastVisPosition) {
                return;
            }
            View view = this.absListView.getChildAt(position - firstVisPosition);
            if (view != null) {
                Vu.AdapterVu vu = (Vu.AdapterVu)view.getTag();
                vu.displayDataSource(position, this.getDataSource(position));
                vu.onViewUpdate(position);
            }
        }
    }

    public abstract D getDataSource(int var1);

    @Nullable
    public Vu.AdapterVu<D> provideVu(int position) {
        return null;
    }

    @Nullable
    public Presenter providePresenter() {
        return null;
    }
}

