/*
 * Decompiled with CFR 0.152.
 */
package com.rabbit.blade.presenter.main;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import com.rabbit.blade.comm.exeption.OkException;
import com.rabbit.blade.presenter.AndroidApplication;
import com.rabbit.blade.presenter.assist.AssistProvider;
import com.rabbit.blade.presenter.assist.Cake;
import com.rabbit.blade.presenter.assist.DialogLoader;
import com.rabbit.blade.presenter.assist.FlyHunter;
import com.rabbit.blade.presenter.assist.FlyRepo;
import com.rabbit.blade.presenter.assist.Loader;
import com.rabbit.blade.presenter.assist.ToastCake;
import com.rabbit.blade.presenter.di.components.ActivityComponent;
import com.rabbit.blade.presenter.di.components.FragmentComponent;
import com.rabbit.blade.presenter.main.SmartActivity;
import com.rabbit.blade.presenter.navigate.Navigator;

public class SmartFragment
extends Fragment
implements FlyHunter,
AssistProvider {
    private FragmentComponent fragmentComponent;

    public FragmentComponent getFragmentComponent() {
        if (this.fragmentComponent == null) {
            this.fragmentComponent = ((AndroidApplication)this.getActivity().getApplication()).createFragmentComponent(this, this.getActivityComponent());
        }
        return this.fragmentComponent;
    }

    public ActivityComponent getActivityComponent() {
        FragmentActivity activity = this.getActivity();
        if (activity instanceof SmartActivity) {
            return ((SmartActivity)activity).getActivityComponent();
        }
        throw new IllegalStateException("the fragment's host activity is not a instance of SmartActivity");
    }

    public void onDestroyView() {
        this.fragmentComponent = null;
        super.onDestroyView();
    }

    @Override
    public boolean handleOkException(@Nullable String okCode, @Nullable String userMsg, @Nullable OkException ex, @Nullable String mark) {
        return false;
    }

    @Override
    public void defaultOkException(@Nullable String code, @Nullable String userMsg, @Nullable OkException ex, @Nullable String mark) {
        if (!TextUtils.isEmpty((CharSequence)userMsg)) {
            this.getFragmentComponent().fragmentCake().showCake(userMsg);
        }
    }

    @Override
    public boolean handlerThrowable(@Nullable Throwable throwable, @Nullable String mark) {
        return false;
    }

    @Override
    public void defaultThrowable(@Nullable Throwable throwable, @Nullable String mark) {
        if (throwable == null) {
            this.getFragmentComponent().fragmentCake().showCake("\u9519\u8bef\u4f46\u6ca1\u6709\u63d0\u793a\u4fe1\u606f,\u8bf7\u63d0\u4ea4\u9519\u8bef\u65e5\u5fd7\uff01");
            return;
        }
        try {
            FlyRepo.recognizeFly(throwable);
        }
        catch (RuntimeException e) {
            this.getFragmentComponent().fragmentCake().showCake(e.getMessage());
            return;
        }
        this.getFragmentComponent().fragmentCake().showCake(throwable.getMessage());
    }

    @Override
    @NonNull
    public Cake provideCake() {
        return new ToastCake((Context)this.getActivity());
    }

    @Override
    @NonNull
    public FlyHunter provideFlyHunter() {
        return this;
    }

    @Override
    @Nullable
    public Loader provideLoader() {
        return new DialogLoader((Activity)this.getActivity());
    }

    public void startActivity(Intent intent) {
        boolean result = false;
        if (Navigator.getInterceptor() != null) {
            result = Navigator.getInterceptor().startActivity(this, intent);
        }
        if (!result) {
            super.startActivity(intent);
        }
    }

    public void startActivity(Intent intent, @Nullable Bundle options) {
        boolean result = false;
        if (Navigator.getInterceptor() != null) {
            result = Navigator.getInterceptor().startActivity(this, intent, options);
        }
        if (!result) {
            super.startActivity(intent, options);
        }
    }

    public void startActivityForResult(Intent intent, int requestCode) {
        boolean result = false;
        if (Navigator.getInterceptor() != null) {
            result = Navigator.getInterceptor().startActivityForResult(this, intent, requestCode);
        }
        if (!result) {
            super.startActivityForResult(intent, requestCode);
        }
    }

    public void startActivityForResult(Intent intent, int requestCode, @Nullable Bundle options) {
        boolean result = false;
        if (Navigator.getInterceptor() != null) {
            result = Navigator.getInterceptor().startActivityForResult(this, intent, requestCode, options);
        }
        if (!result) {
            super.startActivityForResult(intent, requestCode, options);
        }
    }
}

