/*
 * Decompiled with CFR 0.152.
 */
package com.rabbit.blade.presenter.navigate;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Fragment;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import com.blankj.utilcode.utils.Utils;
import com.rabbit.blade.presenter.navigate.Interceptor;
import com.rabbit.blade.presenter.stack.ActivityStack;

public final class Navigator {
    private static Interceptor INTERCEPTOR = null;

    public static synchronized void registerInterceptor(@Nullable Interceptor interceptor) {
        INTERCEPTOR = interceptor;
    }

    public static void unRegisterInterceptor() {
        Navigator.registerInterceptor(null);
    }

    public static Interceptor getInterceptor() {
        return INTERCEPTOR;
    }

    private static Context getContext(@Nullable Context sourceContext) {
        Context context = sourceContext;
        if (context == null) {
            context = ActivityStack.getInstance().getTopActivity();
        }
        if (context == null) {
            context = Utils.getContext();
        }
        return context;
    }

    public static void startActivity(@Nullable Context sourceContext, @NonNull Intent intent) {
        boolean result = false;
        if (INTERCEPTOR != null) {
            result = INTERCEPTOR.startActivity(sourceContext, intent);
        }
        if (!result) {
            Context context = Navigator.getContext(sourceContext);
            if (!(context instanceof Activity)) {
                intent.setFlags(0x10000000);
            }
            context.startActivity(intent);
        }
    }

    @RequiresApi(api=11)
    public static void startActivity(@NonNull Fragment sourceFragment, @NonNull Intent intent) {
        boolean result = false;
        if (INTERCEPTOR != null) {
            result = INTERCEPTOR.startActivity(sourceFragment, intent);
        }
        if (!result) {
            sourceFragment.startActivity(intent);
        }
    }

    public static void startActivity(@NonNull androidx.fragment.app.Fragment sourceFragment, @NonNull Intent intent) {
        boolean result = false;
        if (INTERCEPTOR != null) {
            result = INTERCEPTOR.startActivity(sourceFragment, intent);
        }
        if (!result) {
            sourceFragment.startActivity(intent);
        }
    }

    @TargetApi(value=16)
    public static void startActivity(@Nullable Context sourceContext, @NonNull Intent intent, @Nullable Bundle options) {
        boolean result = false;
        if (INTERCEPTOR != null) {
            result = INTERCEPTOR.startActivity(sourceContext, intent, options);
        }
        if (!result) {
            Context context = Navigator.getContext(sourceContext);
            if (!(context instanceof Activity)) {
                intent.setFlags(0x10000000);
            }
            context.startActivity(intent, options);
        }
    }

    @TargetApi(value=16)
    public static void startActivity(@NonNull Fragment sourceFragment, @NonNull Intent intent, @Nullable Bundle options) {
        boolean result = false;
        if (INTERCEPTOR != null) {
            result = INTERCEPTOR.startActivity(sourceFragment, intent, options);
        }
        if (!result) {
            sourceFragment.startActivity(intent, options);
        }
    }

    public static void startActivity(@NonNull androidx.fragment.app.Fragment sourceFragment, @NonNull Intent intent, @Nullable Bundle options) {
        boolean result = false;
        if (INTERCEPTOR != null) {
            result = INTERCEPTOR.startActivity(sourceFragment, intent, options);
        }
        if (!result) {
            sourceFragment.startActivity(intent, options);
        }
    }

    public static void startActivityForResult(@NonNull Activity sourceActivity, @NonNull Intent intent, int requestCode) {
        boolean result = false;
        if (INTERCEPTOR != null) {
            result = INTERCEPTOR.startActivityForResult(sourceActivity, intent, requestCode);
        }
        if (!result) {
            sourceActivity.startActivityForResult(intent, requestCode);
        }
    }

    @RequiresApi(api=11)
    public static void startActivityForResult(@NonNull Fragment sourceFragment, @NonNull Intent intent, int requestCode) {
        boolean result = false;
        if (INTERCEPTOR != null) {
            result = INTERCEPTOR.startActivityForResult(sourceFragment, intent, requestCode);
        }
        if (!result) {
            sourceFragment.startActivityForResult(intent, requestCode);
        }
    }

    public static void startActivityForResult(@NonNull androidx.fragment.app.Fragment sourceFragment, @NonNull Intent intent, int requestCode) {
        boolean result = false;
        if (INTERCEPTOR != null) {
            result = INTERCEPTOR.startActivityForResult(sourceFragment, intent, requestCode);
        }
        if (!result) {
            sourceFragment.startActivityForResult(intent, requestCode);
        }
    }

    @TargetApi(value=16)
    public static void startActivityForResult(@NonNull Activity sourceActivity, @NonNull Intent intent, int requestCode, @Nullable Bundle options) {
        boolean result = false;
        if (INTERCEPTOR != null) {
            result = INTERCEPTOR.startActivityForResult(sourceActivity, intent, requestCode, options);
        }
        if (!result) {
            sourceActivity.startActivityForResult(intent, requestCode, options);
        }
    }

    @TargetApi(value=16)
    public static void startActivityForResult(@NonNull Fragment sourceFragment, @NonNull Intent intent, int requestCode, @Nullable Bundle options) {
        boolean result = false;
        if (INTERCEPTOR != null) {
            result = INTERCEPTOR.startActivityForResult(sourceFragment, intent, requestCode, options);
        }
        if (!result) {
            sourceFragment.startActivityForResult(intent, requestCode, options);
        }
    }

    public static void startActivityForResult(@NonNull androidx.fragment.app.Fragment sourceFragment, @NonNull Intent intent, int requestCode, @Nullable Bundle options) {
        boolean result = false;
        if (INTERCEPTOR != null) {
            result = INTERCEPTOR.startActivityForResult(sourceFragment, intent, requestCode, options);
        }
        if (!result) {
            sourceFragment.startActivityForResult(intent, requestCode, options);
        }
    }
}

