/*
 * Decompiled with CFR 0.152.
 */
package com.rabbit.blade.presenter.split;

import android.content.Context;
import android.content.pm.PackageManager;
import android.content.res.Configuration;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.rabbit.blade.comm.event.DefaultBusProvider;
import com.rabbit.blade.comm.util.ConfigObject;
import com.rabbit.blade.comm.util.LogUtil;
import com.rabbit.blade.presenter.ComponentApplication;
import com.rabbit.blade.presenter.split.BoundedApplication;
import com.rabbit.blade.presenter.split.ForkedEvent;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;

public abstract class ForkedApplication
extends ComponentApplication {
    public static final String FORKED_METADATA_NAME = "com.rabbit.blade.forked";
    private static final String TAG_BOUNDED_APPLICATIONS = "TAG_BOUNDED_APPLICATIONS";

    @Override
    public void onCreate() {
        super.onCreate();
        this.preFork();
        this.forkApplication();
        this.afterFork();
    }

    public void preFork() {
    }

    public void afterFork() {
        DefaultBusProvider.instance().postSticky((Object)new ForkedEvent("onAttach", (Object)this));
    }

    public void onTerminate() {
        super.onTerminate();
        DefaultBusProvider.instance().postSticky((Object)new ForkedEvent("onTerminate", null));
    }

    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        DefaultBusProvider.instance().postSticky((Object)new ForkedEvent("onConfigurationChanged", newConfig));
    }

    public void onLowMemory() {
        super.onLowMemory();
        DefaultBusProvider.instance().postSticky((Object)new ForkedEvent("onLowMemory", null));
    }

    public void onTrimMemory(int level) {
        super.onTrimMemory(level);
        DefaultBusProvider.instance().postSticky((Object)new ForkedEvent("onTrimMemory", level));
    }

    public void detach() {
        DefaultBusProvider.instance().postSticky((Object)new ForkedEvent("onDetach", null));
    }

    @NonNull
    public Map<String, BoundedApplication> getBoundedApplications() {
        HashMap boundedApplications = (HashMap)this.getComponent(TAG_BOUNDED_APPLICATIONS);
        if (boundedApplications == null) {
            boundedApplications = new HashMap();
            this.putComponent(TAG_BOUNDED_APPLICATIONS, boundedApplications);
        }
        return boundedApplications;
    }

    public void putBoundedApplication(@NonNull String tag, @NonNull BoundedApplication boundedApplication) {
        this.getBoundedApplications().put(tag, boundedApplication);
    }

    public void removeBoundedApplication(@NonNull String tag) {
        this.getBoundedApplications().remove(tag);
    }

    @Nullable
    public <T extends BoundedApplication> T getBoundedApplication(@NonNull String tag) {
        Map<String, BoundedApplication> boundedApplications = this.getBoundedApplications();
        if (!boundedApplications.isEmpty()) {
            return (T)boundedApplications.get(tag);
        }
        return null;
    }

    private void forkApplication() {
        try {
            ConfigObject.buildConfigObject((Context)this, (String)FORKED_METADATA_NAME, null, null);
        }
        catch (PackageManager.NameNotFoundException e) {
            LogUtil.getUtils().w((Object)e.getMessage());
        }
        catch (ClassNotFoundException e) {
            LogUtil.getUtils().w((Object)e.getMessage());
        }
        catch (IllegalAccessException e) {
            LogUtil.getUtils().w((Object)e.getMessage());
        }
        catch (InstantiationException e) {
            LogUtil.getUtils().w((Object)e.getMessage());
        }
        catch (NoSuchMethodException e) {
            LogUtil.getUtils().w((Object)e.getMessage());
        }
        catch (InvocationTargetException e) {
            LogUtil.getUtils().w((Object)e.getMessage());
        }
    }
}

