/*
 * Decompiled with CFR 0.152.
 */
package com.rabbit.blade.presenter.stack;

import android.app.Activity;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import java.util.Iterator;
import java.util.LinkedList;

public final class ActivityStack {
    @Nullable
    private static ActivityStack instance;
    private final LinkedList<Activity> activities = new LinkedList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NonNull
    public static ActivityStack getInstance() {
        if (instance != null) return instance;
        Class<ActivityStack> clazz = ActivityStack.class;
        synchronized (ActivityStack.class) {
            if (instance != null) return instance;
            instance = new ActivityStack();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private ActivityStack() {
    }

    @NonNull
    public LinkedList<Activity> getAllActivities() {
        return this.activities;
    }

    @Nullable
    public Activity getTopActivity() {
        if (this.activities.isEmpty()) {
            return null;
        }
        return this.activities.getFirst();
    }

    public void pushActivity(@NonNull Activity activity) {
        if (!this.activities.contains(activity)) {
            this.activities.addFirst(activity);
        }
    }

    public boolean popActivity(@NonNull Activity activity, boolean isFinish) {
        if (this.activities.isEmpty()) {
            return false;
        }
        if (this.activities.contains(activity)) {
            if (isFinish) {
                activity.finish();
            }
            return this.activities.remove(activity);
        }
        return false;
    }

    public void popAllActivities(boolean isFinish) {
        if (this.activities.isEmpty()) {
            return;
        }
        if (isFinish) {
            Iterator iterator = this.activities.iterator();
            while (iterator.hasNext()) {
                ((Activity)iterator.next()).finish();
            }
        }
        this.activities.clear();
    }

    public void popActivitiesUntil(int position, boolean isFinish) {
        if (this.activities.isEmpty() || position < 0) {
            return;
        }
        for (int i = 0; i < position; ++i) {
            if (isFinish) {
                this.activities.getFirst().finish();
            }
            this.activities.removeFirst();
        }
    }

    public void popActivitiesUntil(@NonNull Activity activity, boolean isFinish) {
        if (this.activities.isEmpty() || !this.activities.contains(activity)) {
            return;
        }
        int position = this.activities.indexOf(activity) - 1;
        this.popActivitiesUntil(position, isFinish);
    }

    public void pop2TopActivity(boolean isFinish) {
        int position = this.activities.size() - 1;
        for (int i = 0; i < position; ++i) {
            if (isFinish) {
                this.activities.getLast().finish();
            }
            this.activities.removeLast();
        }
    }

    public <T extends Activity> void popActivitiesUntil(@NonNull Class<T> cls, boolean isFinish) {
        if (this.activities.isEmpty()) {
            return;
        }
        int position = -1;
        for (int i = 0; i < this.activities.size(); ++i) {
            if (!this.activities.get(i).getClass().equals(cls)) continue;
            position = i;
            break;
        }
        this.popActivitiesUntil(position, isFinish);
    }

    public void exitApp() {
        this.popAllActivities(true);
    }

    @Nullable
    public Activity getActivityByClassName(@NonNull String activityName) {
        if (this.activities.isEmpty()) {
            return null;
        }
        for (Activity ac : this.activities) {
            if (!ac.getClass().getName().equals(activityName)) continue;
            return ac;
        }
        return null;
    }

    @Nullable
    public Activity getActivityByClass(Class<? extends Activity> cs) {
        if (this.activities.isEmpty()) {
            return null;
        }
        for (Activity ac : this.activities) {
            if (!ac.getClass().equals(cs)) continue;
            return ac;
        }
        return null;
    }
}

