/*
 * Decompiled with CFR 0.152.
 */
package com.rabbit.blade.presenter.stack;

import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import androidx.fragment.app.FragmentManager;
import androidx.fragment.app.FragmentTransaction;
import com.rabbit.blade.presenter.R;

public final class FragmentStack {
    private static int anim_In = R.anim.anim_fade_in;
    private static int anim_out = R.anim.anim_fade_out;

    public static void setCustomAnimations(int in_anim, int out_anim) {
        anim_In = in_anim;
        anim_out = out_anim;
    }

    public static void addFragmentToStack(FragmentActivity context, int containerId, Fragment newFragment) {
        FragmentManager fragmentManager = context.getSupportFragmentManager();
        FragmentTransaction ft = fragmentManager.beginTransaction();
        ft.replace(containerId, newFragment, newFragment.getClass().getSimpleName());
        ft.setCustomAnimations(anim_In, anim_out);
        ft.setTransition(4097);
        ft.addToBackStack(null);
        ft.commit();
    }

    public static void popBackStack(FragmentActivity mActivity) {
        FragmentManager fragmentManager = mActivity.getSupportFragmentManager();
        fragmentManager.popBackStack();
    }

    public static void addFragmentToStack(Fragment context, int containerId, Fragment newFragment) {
        FragmentManager fragmentManager = context.getFragmentManager();
        FragmentTransaction ft = fragmentManager.beginTransaction();
        ft.replace(containerId, newFragment, newFragment.getClass().getSimpleName());
        ft.setCustomAnimations(anim_In, anim_out);
        ft.setTransition(4097);
        ft.addToBackStack(null);
        ft.commit();
    }

    public static void replaceFragment(FragmentActivity context, int containerId, Fragment newFragment) {
        FragmentManager fragmentManager = context.getSupportFragmentManager();
        FragmentTransaction ft = fragmentManager.beginTransaction();
        ft.setCustomAnimations(anim_In, anim_out);
        ft.replace(containerId, newFragment, newFragment.getClass().getSimpleName());
        ft.commit();
    }

    public static void replaceChildFrament(Fragment context, int containerId, Fragment newFragment) {
        FragmentManager fragmentManager = context.getChildFragmentManager();
        FragmentTransaction ft = fragmentManager.beginTransaction();
        ft.replace(containerId, newFragment, newFragment.getClass().getSimpleName()).commit();
    }

    public static void addChildFrament(Fragment context, int containerId, Fragment newFragment) {
        FragmentStack.addChildFragmentByTag(context, containerId, newFragment, newFragment.getClass().getSimpleName());
    }

    public static void addChildFragmentByTag(Fragment context, int containerId, Fragment newFragment, String tag) {
        FragmentManager fragmentManager = context.getChildFragmentManager();
        FragmentTransaction ft = fragmentManager.beginTransaction();
        ft.add(containerId, newFragment, tag).commit();
    }

    public static void addFrament(FragmentActivity context, int containerId, Fragment newFragment) {
        block2: {
            try {
                FragmentManager fragmentManager = context.getSupportFragmentManager();
                FragmentTransaction ft = fragmentManager.beginTransaction();
                ft.setCustomAnimations(anim_In, anim_out);
                ft.add(containerId, newFragment, newFragment.getClass().getSimpleName()).commit();
            }
            catch (IllegalStateException e) {
                if (!e.getMessage().startsWith("Fragment already added")) break block2;
                FragmentStack.removeFragment(context, newFragment);
                FragmentStack.addFrament(context, containerId, newFragment);
            }
        }
    }

    public static void showFragment(FragmentActivity context, Fragment fragment) {
        FragmentManager fragmentManager = context.getSupportFragmentManager();
        FragmentTransaction ft = fragmentManager.beginTransaction();
        ft.setCustomAnimations(anim_In, anim_out);
        ft.show(fragment).commit();
    }

    public static void showChildFragment(Fragment context, Fragment fragment) {
        FragmentManager fragmentManager = context.getChildFragmentManager();
        FragmentTransaction ft = fragmentManager.beginTransaction();
        ft.setCustomAnimations(anim_In, anim_out);
        ft.show(fragment).commit();
    }

    public static void hideFragment(FragmentActivity context, Fragment fragment) {
        FragmentManager fragmentManager = context.getSupportFragmentManager();
        FragmentTransaction ft = fragmentManager.beginTransaction();
        ft.hide(fragment).commit();
    }

    public static void hideChildFragment(Fragment context, Fragment fragment) {
        FragmentManager fragmentManager = context.getChildFragmentManager();
        FragmentTransaction ft = fragmentManager.beginTransaction();
        ft.setCustomAnimations(anim_In, anim_out);
        ft.hide(fragment).commit();
    }

    public static void removeFragment(FragmentActivity context, Fragment fragment) {
        FragmentManager fragmentManager = context.getSupportFragmentManager();
        fragmentManager.beginTransaction().remove(fragment).commit();
    }

    public static Fragment findFragment(FragmentActivity context, Class<?> fragment) {
        FragmentManager fragmentManager = context.getSupportFragmentManager();
        return fragmentManager.findFragmentByTag(fragment.getSimpleName());
    }

    public static Fragment findFragment(Fragment context, Class<?> fragment) {
        FragmentManager fragmentManager = context.getFragmentManager();
        return fragmentManager.findFragmentByTag(fragment.getSimpleName());
    }

    public static Fragment findChildFragment(Fragment context, Class<?> fragment) {
        return FragmentStack.findChildFragmentByTag(context, fragment, fragment.getSimpleName());
    }

    public static Fragment findChildFragmentByTag(Fragment context, Class<?> fragment, String tag) {
        FragmentManager fragmentManager = context.getChildFragmentManager();
        return fragmentManager.findFragmentByTag(tag);
    }
}

