/*
 * Decompiled with CFR 0.152.
 */
package com.sargeraswang.util.ExcelUtil;

import com.sargeraswang.util.ExcelUtil.ExcelCell;
import com.sargeraswang.util.ExcelUtil.ExcelLog;
import com.sargeraswang.util.ExcelUtil.ExcelLogs;
import com.sargeraswang.util.ExcelUtil.ExcelSheet;
import com.sargeraswang.util.ExcelUtil.FieldForSortting;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.beanutils.BeanComparator;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.ComparatorUtils;
import org.apache.commons.collections.comparators.ComparableComparator;
import org.apache.commons.collections.comparators.ComparatorChain;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFDateUtil;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.ss.util.CellReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExcelUtil {
    private static Logger LG = LoggerFactory.getLogger(ExcelUtil.class);
    private static Map<Class<?>, CellType[]> validateMap = new HashMap();

    private static String getCellTypeByInt(CellType cellType) {
        if (cellType == CellType.BLANK) {
            return "Null type";
        }
        if (cellType == CellType.BOOLEAN) {
            return "Boolean type";
        }
        if (cellType == CellType.ERROR) {
            return "Error type";
        }
        if (cellType == CellType.FORMULA) {
            return "Formula type";
        }
        if (cellType == CellType.NUMERIC) {
            return "Numeric type";
        }
        if (cellType == CellType.STRING) {
            return "String type";
        }
        return "Unknown type";
    }

    private static Object getCellValue(Cell cell) {
        if (cell == null || cell.getCellTypeEnum() == CellType.STRING && StringUtils.isBlank((CharSequence)cell.getStringCellValue())) {
            return null;
        }
        CellType cellType = cell.getCellTypeEnum();
        if (cellType == CellType.BLANK) {
            return null;
        }
        if (cellType == CellType.BOOLEAN) {
            return cell.getBooleanCellValue();
        }
        if (cellType == CellType.ERROR) {
            return cell.getErrorCellValue();
        }
        if (cellType == CellType.FORMULA) {
            try {
                if (HSSFDateUtil.isCellDateFormatted((Cell)cell)) {
                    return cell.getDateCellValue();
                }
                return cell.getNumericCellValue();
            }
            catch (IllegalStateException e) {
                return cell.getRichStringCellValue();
            }
        }
        if (cellType == CellType.NUMERIC) {
            if (DateUtil.isCellDateFormatted((Cell)cell)) {
                return cell.getDateCellValue();
            }
            return cell.getNumericCellValue();
        }
        if (cellType == CellType.STRING) {
            return cell.getStringCellValue();
        }
        return null;
    }

    public static <T> void exportExcel(Map<String, String> headers, Collection<T> dataset, OutputStream out) {
        ExcelUtil.exportExcel(headers, dataset, out, null);
    }

    public static <T> void exportExcel(Map<String, String> headers, Collection<T> dataset, OutputStream out, String pattern) {
        HSSFWorkbook workbook = new HSSFWorkbook();
        HSSFSheet sheet = workbook.createSheet();
        ExcelUtil.write2Sheet(sheet, headers, dataset, pattern);
        try {
            workbook.write(out);
        }
        catch (IOException e) {
            LG.error(e.toString(), (Throwable)e);
        }
    }

    public static void exportExcel(String[][] datalist, OutputStream out) {
        try {
            HSSFWorkbook workbook = new HSSFWorkbook();
            HSSFSheet sheet = workbook.createSheet();
            for (int i = 0; i < datalist.length; ++i) {
                String[] r = datalist[i];
                HSSFRow row = sheet.createRow(i);
                for (int j = 0; j < r.length; ++j) {
                    HSSFCell cell = row.createCell(j);
                    if (r[j].length() > Short.MAX_VALUE) {
                        r[j] = "--\u6b64\u5b57\u6bb5\u8fc7\u957f(\u8d85\u8fc732767),\u5df2\u88ab\u622a\u65ad--" + r[j];
                        r[j] = r[j].substring(0, 32766);
                    }
                    cell.setCellValue(r[j]);
                }
            }
            if (datalist.length > 0) {
                int colcount = datalist[0].length;
                for (int i = 0; i < colcount; ++i) {
                    sheet.autoSizeColumn(i);
                }
            }
            workbook.write(out);
        }
        catch (IOException e) {
            LG.error(e.toString(), (Throwable)e);
        }
    }

    public static <T> void exportExcel(List<ExcelSheet<T>> sheets, OutputStream out) {
        ExcelUtil.exportExcel(sheets, out, null);
    }

    public static <T> void exportExcel(List<ExcelSheet<T>> sheets, OutputStream out, String pattern) {
        if (CollectionUtils.isEmpty(sheets)) {
            return;
        }
        HSSFWorkbook workbook = new HSSFWorkbook();
        for (ExcelSheet<T> sheet : sheets) {
            HSSFSheet hssfSheet = workbook.createSheet(sheet.getSheetName());
            ExcelUtil.write2Sheet(hssfSheet, sheet.getHeaders(), sheet.getDataset(), pattern);
        }
        try {
            workbook.write(out);
        }
        catch (IOException e) {
            LG.error(e.toString(), (Throwable)e);
        }
    }

    private static <T> void write2Sheet(HSSFSheet sheet, Map<String, String> headers, Collection<T> dataset, String pattern) {
        if (StringUtils.isEmpty((CharSequence)pattern)) {
            pattern = "yyyy-MM-dd";
        }
        HSSFRow row = sheet.createRow(0);
        Set<String> keys = headers.keySet();
        Iterator<String> it1 = keys.iterator();
        String key2 = "";
        int c = 0;
        while (it1.hasNext()) {
            key2 = it1.next();
            if (!headers.containsKey(key2)) continue;
            HSSFCell cell = row.createCell(c);
            HSSFRichTextString text = new HSSFRichTextString(headers.get(key2));
            cell.setCellValue((RichTextString)text);
            ++c;
        }
        Iterator<T> it = dataset.iterator();
        int index = 0;
        while (it.hasNext()) {
            row = sheet.createRow(++index);
            T t = it.next();
            try {
                int cellNum;
                if (t instanceof Map) {
                    Map map = (Map)t;
                    cellNum = 0;
                    for (String key2 : keys) {
                        if (!headers.containsKey(key2)) {
                            LG.error("Map \u4e2d \u4e0d\u5b58\u5728 key [" + key2 + "]");
                            continue;
                        }
                        Object value = map.get(key2);
                        HSSFCell cell = row.createCell(cellNum);
                        cellNum = ExcelUtil.setCellValue(cell, value, pattern, cellNum, null, row);
                        ++cellNum;
                    }
                    continue;
                }
                List<FieldForSortting> fields = ExcelUtil.sortFieldByAnno(t.getClass());
                cellNum = 0;
                for (int i = 0; i < fields.size(); ++i) {
                    HSSFCell cell = row.createCell(cellNum);
                    Field field = fields.get(i).getField();
                    field.setAccessible(true);
                    Object value = field.get(t);
                    cellNum = ExcelUtil.setCellValue(cell, value, pattern, cellNum, field, row);
                    ++cellNum;
                }
            }
            catch (Exception e) {
                LG.error(e.toString(), (Throwable)e);
            }
        }
        for (int i = 0; i < headers.size(); ++i) {
            sheet.autoSizeColumn(i);
        }
    }

    private static int setCellValue(HSSFCell cell, Object value, String pattern, int cellNum, Field field, HSSFRow row) {
        String textValue = null;
        if (value instanceof Integer) {
            int intValue = (Integer)value;
            cell.setCellValue((double)intValue);
        } else if (value instanceof Float) {
            float fValue = ((Float)value).floatValue();
            cell.setCellValue((double)fValue);
        } else if (value instanceof Double) {
            double dValue = (Double)value;
            cell.setCellValue(dValue);
        } else if (value instanceof Long) {
            long longValue = (Long)value;
            cell.setCellValue((double)longValue);
        } else if (value instanceof Boolean) {
            boolean bValue = (Boolean)value;
            cell.setCellValue(bValue);
        } else if (value instanceof Date) {
            Date date = (Date)value;
            SimpleDateFormat sdf = new SimpleDateFormat(pattern);
            textValue = sdf.format(date);
        } else if (value instanceof String[]) {
            String[] strArr = (String[])value;
            for (int j = 0; j < strArr.length; ++j) {
                String str = strArr[j];
                cell.setCellValue(str);
                if (j == strArr.length - 1) continue;
                cell = row.createCell(++cellNum);
            }
        } else if (value instanceof Double[]) {
            Double[] douArr = (Double[])value;
            for (int j = 0; j < douArr.length; ++j) {
                Double val = douArr[j];
                if (val != null) {
                    cell.setCellValue(val.doubleValue());
                }
                if (j == douArr.length - 1) continue;
                cell = row.createCell(++cellNum);
            }
        } else {
            ExcelCell anno;
            String empty = "";
            if (field != null && (anno = field.getAnnotation(ExcelCell.class)) != null) {
                empty = anno.defaultValue();
            }
            String string = textValue = value == null ? empty : value.toString();
        }
        if (textValue != null) {
            HSSFRichTextString richString = new HSSFRichTextString(textValue);
            cell.setCellValue((RichTextString)richString);
        }
        return cellNum;
    }

    public static <T> Collection<T> importExcel(Class<T> clazz, InputStream inputStream, String pattern, ExcelLogs logs, Integer ... arrayCount) {
        Workbook workBook;
        try {
            workBook = WorkbookFactory.create((InputStream)inputStream);
        }
        catch (Exception e) {
            LG.error("load excel file error", (Throwable)e);
            return null;
        }
        ArrayList list = new ArrayList();
        Sheet sheet = workBook.getSheetAt(0);
        Iterator rowIterator = sheet.rowIterator();
        try {
            ArrayList<ExcelLog> logList = new ArrayList<ExcelLog>();
            HashMap<String, Integer> titleMap = new HashMap<String, Integer>();
            while (rowIterator.hasNext()) {
                Row row = (Row)rowIterator.next();
                if (row.getRowNum() == 0) {
                    if (clazz != Map.class) continue;
                    Iterator cellIterator = row.cellIterator();
                    Integer index = 0;
                    while (cellIterator.hasNext()) {
                        String value = ((Cell)cellIterator.next()).getStringCellValue();
                        titleMap.put(value, index);
                        Integer n = index;
                        Integer n2 = index = Integer.valueOf(index + 1);
                    }
                    continue;
                }
                boolean allRowIsNull = true;
                Iterator cellIterator = row.cellIterator();
                while (cellIterator.hasNext()) {
                    Object cellValue = ExcelUtil.getCellValue((Cell)cellIterator.next());
                    if (cellValue == null) continue;
                    allRowIsNull = false;
                    break;
                }
                if (allRowIsNull) {
                    LG.warn("Excel row " + row.getRowNum() + " all row value is null!");
                    continue;
                }
                StringBuilder log = new StringBuilder();
                if (clazz == Map.class) {
                    HashMap<String, String> map = new HashMap<String, String>();
                    for (String k : titleMap.keySet()) {
                        Integer index = (Integer)titleMap.get(k);
                        Cell cell = row.getCell(index.intValue());
                        if (cell == null) {
                            map.put(k, null);
                            continue;
                        }
                        cell.setCellType(CellType.STRING);
                        String value = cell.getStringCellValue();
                        map.put(k, value);
                    }
                    list.add(map);
                    continue;
                }
                T t = clazz.newInstance();
                int arrayIndex = 0;
                int cellIndex = 0;
                List<FieldForSortting> fields = ExcelUtil.sortFieldByAnno(clazz);
                for (FieldForSortting ffs : fields) {
                    Field field = ffs.getField();
                    field.setAccessible(true);
                    if (field.getType().isArray()) {
                        Integer count = arrayCount[arrayIndex];
                        Object[] value = field.getType().equals(String[].class) ? new String[count.intValue()] : new Double[count.intValue()];
                        for (int i = 0; i < count; ++i) {
                            Cell cell = row.getCell(cellIndex);
                            String errMsg = ExcelUtil.validateCell(cell, field, cellIndex);
                            if (StringUtils.isBlank((CharSequence)errMsg)) {
                                value[i] = ExcelUtil.getCellValue(cell);
                            } else {
                                log.append(errMsg);
                                log.append(";");
                                logs.setHasError(true);
                            }
                            ++cellIndex;
                        }
                        field.set(t, value);
                        ++arrayIndex;
                        continue;
                    }
                    Cell cell = row.getCell(cellIndex);
                    String errMsg = ExcelUtil.validateCell(cell, field, cellIndex);
                    if (StringUtils.isBlank((CharSequence)errMsg)) {
                        Object value = null;
                        if (field.getType().equals(Date.class) && cell.getCellTypeEnum() == CellType.STRING) {
                            Object strDate = ExcelUtil.getCellValue(cell);
                            try {
                                value = new SimpleDateFormat(pattern).parse(strDate.toString());
                            }
                            catch (ParseException e) {
                                errMsg = MessageFormat.format("the cell [{0}] can not be converted to a date ", CellReference.convertNumToColString((int)cell.getColumnIndex()));
                            }
                        } else {
                            value = ExcelUtil.getCellValue(cell);
                            ExcelCell annoCell = field.getAnnotation(ExcelCell.class);
                            if (value instanceof String && !field.getType().equals(String.class) && StringUtils.isNotBlank((CharSequence)annoCell.defaultValue())) {
                                value = annoCell.defaultValue();
                            }
                        }
                        field.set(t, value);
                    }
                    if (StringUtils.isNotBlank((CharSequence)errMsg)) {
                        log.append(errMsg);
                        log.append(";");
                        logs.setHasError(true);
                    }
                    ++cellIndex;
                }
                list.add(t);
                logList.add(new ExcelLog(t, log.toString(), row.getRowNum() + 1));
            }
            logs.setLogList(logList);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(MessageFormat.format("can not instance class:{0}", clazz.getSimpleName()), e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(MessageFormat.format("can not instance class:{0}", clazz.getSimpleName()), e);
        }
        return list;
    }

    private static String validateCell(Cell cell, Field field, int cellNum) {
        String columnName = CellReference.convertNumToColString((int)cellNum);
        String result = null;
        CellType[] cellTypeArr = validateMap.get(field.getType());
        if (cellTypeArr == null) {
            result = MessageFormat.format("Unsupported type [{0}]", field.getType().getSimpleName());
            return result;
        }
        ExcelCell annoCell = field.getAnnotation(ExcelCell.class);
        if (cell == null || cell.getCellTypeEnum() == CellType.STRING && StringUtils.isBlank((CharSequence)cell.getStringCellValue())) {
            if (annoCell != null && !annoCell.valid().allowNull()) {
                result = MessageFormat.format("the cell [{0}] can not null", columnName);
            }
        } else {
            if (cell.getCellTypeEnum() == CellType.BLANK && annoCell.valid().allowNull()) {
                return result;
            }
            List<CellType> cellTypes = Arrays.asList(cellTypeArr);
            if (!cellTypes.contains(cell.getCellTypeEnum()) || StringUtils.isNotBlank((CharSequence)annoCell.defaultValue()) && cell.getCellTypeEnum() == CellType.STRING) {
                StringBuilder strType = new StringBuilder();
                for (int i = 0; i < cellTypes.size(); ++i) {
                    CellType cellType = cellTypes.get(i);
                    strType.append(ExcelUtil.getCellTypeByInt(cellType));
                    if (i == cellTypes.size() - 1) continue;
                    strType.append(",");
                }
                result = MessageFormat.format("the cell [{0}] type must [{1}]", columnName, strType.toString());
            } else {
                if (annoCell.valid().in().length != 0 && cell.getCellTypeEnum() == CellType.STRING) {
                    String[] in = annoCell.valid().in();
                    String cellValue = cell.getStringCellValue();
                    boolean isIn = false;
                    for (String str : in) {
                        if (!str.equals(cellValue)) continue;
                        isIn = true;
                    }
                    if (!isIn) {
                        result = MessageFormat.format("the cell [{0}] value must in {1}", columnName, in);
                    }
                }
                if (cell.getCellTypeEnum() == CellType.NUMERIC) {
                    double cellValue = cell.getNumericCellValue();
                    if (!Double.isNaN(annoCell.valid().lt()) && !(cellValue < annoCell.valid().lt())) {
                        result = MessageFormat.format("the cell [{0}] value must less than [{1}]", columnName, annoCell.valid().lt());
                    }
                    if (!Double.isNaN(annoCell.valid().gt()) && !(cellValue > annoCell.valid().gt())) {
                        result = MessageFormat.format("the cell [{0}] value must greater than [{1}]", columnName, annoCell.valid().gt());
                    }
                    if (!Double.isNaN(annoCell.valid().le()) && !(cellValue <= annoCell.valid().le())) {
                        result = MessageFormat.format("the cell [{0}] value must less than or equal [{1}]", columnName, annoCell.valid().le());
                    }
                    if (!Double.isNaN(annoCell.valid().ge()) && !(cellValue >= annoCell.valid().ge())) {
                        result = MessageFormat.format("the cell [{0}] value must greater than or equal [{1}]", columnName, annoCell.valid().ge());
                    }
                }
            }
        }
        return result;
    }

    private static List<FieldForSortting> sortFieldByAnno(Class<?> clazz) {
        Field[] fieldsArr = clazz.getDeclaredFields();
        ArrayList<FieldForSortting> fields = new ArrayList<FieldForSortting>();
        ArrayList annoNullFields = new ArrayList();
        for (Field field : fieldsArr) {
            ExcelCell ec = field.getAnnotation(ExcelCell.class);
            if (ec == null) continue;
            int id = ec.index();
            fields.add(new FieldForSortting(field, id));
        }
        fields.addAll(annoNullFields);
        ExcelUtil.sortByProperties(fields, true, false, "index");
        return fields;
    }

    private static void sortByProperties(List<? extends Object> list, boolean isNullHigh, boolean isReversed, String ... props) {
        if (CollectionUtils.isNotEmpty(list)) {
            Object typeComp = ComparableComparator.getInstance();
            typeComp = isNullHigh ? ComparatorUtils.nullHighComparator((Comparator)typeComp) : ComparatorUtils.nullLowComparator((Comparator)typeComp);
            if (isReversed) {
                typeComp = ComparatorUtils.reversedComparator((Comparator)typeComp);
            }
            ArrayList<BeanComparator> sortCols = new ArrayList<BeanComparator>();
            if (props != null) {
                for (String prop : props) {
                    sortCols.add(new BeanComparator(prop, (Comparator)typeComp));
                }
            }
            if (sortCols.size() > 0) {
                ComparatorChain sortChain = new ComparatorChain(sortCols);
                Collections.sort(list, sortChain);
            }
        }
    }

    static {
        validateMap.put(String[].class, new CellType[]{CellType.STRING});
        validateMap.put(Double[].class, new CellType[]{CellType.NUMERIC});
        validateMap.put(String.class, new CellType[]{CellType.STRING});
        validateMap.put(Double.class, new CellType[]{CellType.NUMERIC});
        validateMap.put(Date.class, new CellType[]{CellType.NUMERIC, CellType.STRING});
        validateMap.put(Integer.class, new CellType[]{CellType.NUMERIC});
        validateMap.put(Float.class, new CellType[]{CellType.NUMERIC});
        validateMap.put(Long.class, new CellType[]{CellType.NUMERIC});
        validateMap.put(Boolean.class, new CellType[]{CellType.BOOLEAN});
    }
}

