/*
 * Decompiled with CFR 0.152.
 */
package com.scandit.datacapture.parser.internal.module;

import com.scandit.datacapture.core.internal.sdk.capture.NativeDataCaptureContext;
import com.scandit.datacapture.core.internal.sdk.component.NativeDataCaptureComponent;
import com.scandit.datacapture.internal.sdk.annotations.DjinniGenerated;
import com.scandit.datacapture.parser.ParserDataFormat;
import com.scandit.datacapture.parser.internal.module.NativeExpectedParsedData;
import com.scandit.datacapture.parser.internal.module.NativeExpectedParser;
import com.scandit.datacapture.parser.internal.module.NativeSetOptionsResult;
import java.util.concurrent.atomic.AtomicBoolean;

@DjinniGenerated
public abstract class NativeParser {
    public abstract String getIdentifier();

    public abstract NativeExpectedParsedData parseString(String var1);

    public abstract NativeExpectedParsedData parseRawData(byte[] var1);

    public abstract NativeSetOptionsResult setOptions(String var1);

    public abstract NativeDataCaptureComponent asDataCaptureComponent();

    public static NativeExpectedParser create(NativeDataCaptureContext dataCaptureContext, ParserDataFormat dataFormat) {
        return CppProxy.create(dataCaptureContext, dataFormat);
    }

    @DjinniGenerated
    private static final class CppProxy
    extends NativeParser {
        private final long nativeRef;
        private final AtomicBoolean destroyed = new AtomicBoolean(false);

        private CppProxy(long nativeRef) {
            if (nativeRef == 0L) {
                throw new RuntimeException("nativeRef is zero");
            }
            this.nativeRef = nativeRef;
        }

        private native void nativeDestroy(long var1);

        public void _djinni_private_destroy() {
            boolean destroyed = this.destroyed.getAndSet(true);
            if (!destroyed) {
                this.nativeDestroy(this.nativeRef);
            }
        }

        protected void finalize() throws Throwable {
            this._djinni_private_destroy();
            super.finalize();
        }

        @Override
        public String getIdentifier() {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            return this.native_getIdentifier(this.nativeRef);
        }

        private native String native_getIdentifier(long var1);

        @Override
        public NativeExpectedParsedData parseString(String data) {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            return this.native_parseString(this.nativeRef, data);
        }

        private native NativeExpectedParsedData native_parseString(long var1, String var3);

        @Override
        public NativeExpectedParsedData parseRawData(byte[] data) {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            return this.native_parseRawData(this.nativeRef, data);
        }

        private native NativeExpectedParsedData native_parseRawData(long var1, byte[] var3);

        @Override
        public NativeSetOptionsResult setOptions(String options) {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            return this.native_setOptions(this.nativeRef, options);
        }

        private native NativeSetOptionsResult native_setOptions(long var1, String var3);

        @Override
        public NativeDataCaptureComponent asDataCaptureComponent() {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            return this.native_asDataCaptureComponent(this.nativeRef);
        }

        private native NativeDataCaptureComponent native_asDataCaptureComponent(long var1);

        public static native NativeExpectedParser create(NativeDataCaptureContext var0, ParserDataFormat var1);
    }
}

