/*
 * Decompiled with CFR 0.152.
 */
package com.scwang.smartrefresh.header;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.view.animation.PathInterpolatorCompat;
import android.util.AttributeSet;
import android.view.View;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.DecelerateInterpolator;
import com.scwang.smartrefresh.header.flyrefresh.MountainSceneView;
import com.scwang.smartrefresh.layout.api.RefreshHeader;
import com.scwang.smartrefresh.layout.api.RefreshKernel;
import com.scwang.smartrefresh.layout.api.RefreshLayout;
import com.scwang.smartrefresh.layout.header.FalsifyHeader;
import com.scwang.smartrefresh.layout.util.DensityUtil;

public class FlyRefreshHeader
extends FalsifyHeader
implements RefreshHeader {
    protected View mFlyView;
    protected AnimatorSet mFlyAnimator;
    protected RefreshLayout mRefreshLayout;
    protected RefreshKernel mRefreshKernel;
    protected MountainSceneView mSceneView;
    protected int mOffset = 0;
    protected float mCurrentPercent;
    protected boolean mIsRefreshing = false;

    public FlyRefreshHeader(Context context) {
        super(context);
    }

    public FlyRefreshHeader(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public FlyRefreshHeader(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    public void onMoving(boolean isDragging, float percent, int offset, int height, int maxDragHeight) {
        if (isDragging || !this.mIsRefreshing) {
            if (offset < 0) {
                if (this.mOffset > 0) {
                    offset = 0;
                    percent = 0.0f;
                } else {
                    return;
                }
            }
            this.mOffset = offset;
            this.mCurrentPercent = percent;
            if (this.mSceneView != null) {
                this.mSceneView.updatePercent(percent);
                MountainSceneView sceneView = this.mSceneView;
                sceneView.postInvalidate();
            }
            if (this.mFlyView != null) {
                if (height + maxDragHeight > 0) {
                    this.mFlyView.setRotation(-45.0f * (float)offset / (float)(height + maxDragHeight));
                } else {
                    this.mFlyView.setRotation(-45.0f * percent);
                }
            }
        }
    }

    public void onReleased(@NonNull RefreshLayout layout, int height, int maxDragHeight) {
        this.mRefreshKernel.animSpinner(0);
        if (this.mCurrentPercent > 0.0f) {
            ValueAnimator valueAnimator = ValueAnimator.ofFloat((float[])new float[]{this.mCurrentPercent, 0.0f});
            valueAnimator.setDuration(300L);
            valueAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator animation) {
                    FlyRefreshHeader.this.onMoving(true, ((Float)animation.getAnimatedValue()).floatValue(), 0, 0, 0);
                }
            });
            valueAnimator.start();
            this.mCurrentPercent = 0.0f;
        }
        if (this.mFlyView != null && !this.mIsRefreshing) {
            if (this.mFlyAnimator != null) {
                this.mFlyAnimator.end();
                this.mFlyView.clearAnimation();
            }
            this.mIsRefreshing = true;
            layout.setEnableRefresh(false);
            int offDistX = ((View)this.mRefreshLayout).getWidth() - this.mFlyView.getLeft();
            int offDistY = -(this.mFlyView.getTop() - this.mOffset) * 2 / 3;
            ObjectAnimator transX = ObjectAnimator.ofFloat((Object)this.mFlyView, (String)"translationX", (float[])new float[]{0.0f, offDistX});
            ObjectAnimator transY = ObjectAnimator.ofFloat((Object)this.mFlyView, (String)"translationY", (float[])new float[]{0.0f, offDistY});
            transY.setInterpolator((TimeInterpolator)PathInterpolatorCompat.create((float)0.7f, (float)1.0f));
            ObjectAnimator rotation = ObjectAnimator.ofFloat((Object)this.mFlyView, (String)"rotation", (float[])new float[]{this.mFlyView.getRotation(), 0.0f});
            rotation.setInterpolator((TimeInterpolator)new DecelerateInterpolator());
            ObjectAnimator rotationX = ObjectAnimator.ofFloat((Object)this.mFlyView, (String)"rotationX", (float[])new float[]{this.mFlyView.getRotationX(), 50.0f});
            rotationX.setInterpolator((TimeInterpolator)new DecelerateInterpolator());
            AnimatorSet flyUpAnim = new AnimatorSet();
            flyUpAnim.setDuration(800L);
            flyUpAnim.playTogether(new Animator[]{transX, transY, rotation, rotationX, ObjectAnimator.ofFloat((Object)this.mFlyView, (String)"scaleX", (float[])new float[]{this.mFlyView.getScaleX(), 0.5f}), ObjectAnimator.ofFloat((Object)this.mFlyView, (String)"scaleY", (float[])new float[]{this.mFlyView.getScaleY(), 0.5f})});
            this.mFlyAnimator = flyUpAnim;
            this.mFlyAnimator.start();
        }
    }

    @Deprecated
    public void setPrimaryColors(int ... colors) {
        if (colors.length > 0 && this.mSceneView != null) {
            this.mSceneView.setPrimaryColor(colors[0]);
        }
    }

    public void onInitialized(@NonNull RefreshKernel kernel, int height, int maxDragHeight) {
        this.mRefreshKernel = kernel;
        this.mRefreshLayout = kernel.getRefreshLayout();
        this.mRefreshLayout.setEnableOverScrollDrag(false);
    }

    public int onFinish(@NonNull RefreshLayout layout, boolean success) {
        if (this.mIsRefreshing) {
            this.finishRefresh();
        }
        return super.onFinish(layout, success);
    }

    public void setUp(@Nullable MountainSceneView sceneView, @Nullable View flyView) {
        this.mFlyView = flyView;
        this.mSceneView = sceneView;
    }

    public void finishRefresh() {
        this.finishRefresh(null);
    }

    public void finishRefresh(final AnimatorListenerAdapter listenerAdapter) {
        if (this.mFlyView == null || !this.mIsRefreshing || this.mRefreshLayout == null) {
            return;
        }
        if (this.mFlyAnimator != null) {
            this.mFlyAnimator.end();
            this.mFlyView.clearAnimation();
        }
        this.mIsRefreshing = false;
        this.mRefreshLayout.finishRefresh(0);
        int offDistX = -this.mFlyView.getRight();
        int offDistY = -DensityUtil.dp2px((float)10.0f);
        AnimatorSet flyDownAnim = new AnimatorSet();
        flyDownAnim.setDuration(800L);
        ObjectAnimator transX1 = ObjectAnimator.ofFloat((Object)this.mFlyView, (String)"translationX", (float[])new float[]{this.mFlyView.getTranslationX(), offDistX});
        ObjectAnimator transY1 = ObjectAnimator.ofFloat((Object)this.mFlyView, (String)"translationY", (float[])new float[]{this.mFlyView.getTranslationY(), offDistY});
        transY1.setInterpolator((TimeInterpolator)PathInterpolatorCompat.create((float)0.1f, (float)1.0f));
        ObjectAnimator rotation1 = ObjectAnimator.ofFloat((Object)this.mFlyView, (String)"rotation", (float[])new float[]{this.mFlyView.getRotation(), 0.0f});
        ObjectAnimator rotationX1 = ObjectAnimator.ofFloat((Object)this.mFlyView, (String)"rotationX", (float[])new float[]{this.mFlyView.getRotationX(), 30.0f});
        rotation1.setInterpolator((TimeInterpolator)new AccelerateInterpolator());
        flyDownAnim.playTogether(new Animator[]{transX1, transY1, rotation1, rotationX1, ObjectAnimator.ofFloat((Object)this.mFlyView, (String)"scaleX", (float[])new float[]{this.mFlyView.getScaleX(), 0.9f}), ObjectAnimator.ofFloat((Object)this.mFlyView, (String)"scaleY", (float[])new float[]{this.mFlyView.getScaleY(), 0.9f})});
        flyDownAnim.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationStart(Animator animation) {
                if (FlyRefreshHeader.this.mFlyView != null) {
                    FlyRefreshHeader.this.mFlyView.setRotationY(180.0f);
                }
            }
        });
        AnimatorSet flyInAnim = new AnimatorSet();
        flyInAnim.setDuration(800L);
        flyInAnim.setInterpolator((TimeInterpolator)new DecelerateInterpolator());
        ObjectAnimator tranX2 = ObjectAnimator.ofFloat((Object)this.mFlyView, (String)"translationX", (float[])new float[]{offDistX, 0.0f});
        ObjectAnimator tranY2 = ObjectAnimator.ofFloat((Object)this.mFlyView, (String)"translationY", (float[])new float[]{offDistY, 0.0f});
        ObjectAnimator rotationX2 = ObjectAnimator.ofFloat((Object)this.mFlyView, (String)"rotationX", (float[])new float[]{30.0f, 0.0f});
        flyInAnim.playTogether(new Animator[]{tranX2, tranY2, rotationX2, ObjectAnimator.ofFloat((Object)this.mFlyView, (String)"scaleX", (float[])new float[]{0.9f, 1.0f}), ObjectAnimator.ofFloat((Object)this.mFlyView, (String)"scaleY", (float[])new float[]{0.9f, 1.0f})});
        flyInAnim.setStartDelay(100L);
        flyInAnim.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationStart(Animator animation) {
                if (FlyRefreshHeader.this.mFlyView != null) {
                    FlyRefreshHeader.this.mFlyView.setRotationY(0.0f);
                }
            }

            public void onAnimationEnd(Animator animation) {
                if (FlyRefreshHeader.this.mRefreshLayout != null) {
                    FlyRefreshHeader.this.mRefreshLayout.setEnableRefresh(true);
                }
                if (listenerAdapter != null) {
                    listenerAdapter.onAnimationEnd(animation);
                }
            }
        });
        this.mFlyAnimator = new AnimatorSet();
        this.mFlyAnimator.playSequentially(new Animator[]{flyDownAnim, flyInAnim});
        this.mFlyAnimator.start();
    }
}

