/*
 * Decompiled with CFR 0.152.
 */
package com.scwang.smartrefresh.header;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.PointF;
import android.support.annotation.ColorInt;
import android.support.annotation.NonNull;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.Animation;
import android.view.animation.Interpolator;
import android.view.animation.Transformation;
import com.scwang.smartrefresh.header.R;
import com.scwang.smartrefresh.header.storehouse.StoreHouseBarItem;
import com.scwang.smartrefresh.header.storehouse.StoreHousePath;
import com.scwang.smartrefresh.layout.api.RefreshHeader;
import com.scwang.smartrefresh.layout.api.RefreshInternal;
import com.scwang.smartrefresh.layout.api.RefreshKernel;
import com.scwang.smartrefresh.layout.api.RefreshLayout;
import com.scwang.smartrefresh.layout.internal.InternalAbstract;
import com.scwang.smartrefresh.layout.util.DensityUtil;
import java.util.ArrayList;
import java.util.List;

public class StoreHouseHeader
extends InternalAbstract
implements RefreshHeader {
    public List<StoreHouseBarItem> mItemList = new ArrayList<StoreHouseBarItem>();
    protected int mLineWidth = -1;
    protected float mScale = 1.0f;
    protected int mDropHeight = -1;
    protected static final float mInternalAnimationFactor = 0.7f;
    protected int mHorizontalRandomness = -1;
    protected float mProgress = 0.0f;
    protected int mDrawZoneWidth = 0;
    protected int mDrawZoneHeight = 0;
    protected int mOffsetX = 0;
    protected int mOffsetY = 0;
    protected static final float mBarDarkAlpha = 0.4f;
    protected static final float mFromAlpha = 1.0f;
    protected static final float mToAlpha = 0.4f;
    protected int mLoadingAniDuration = 1000;
    protected int mLoadingAniSegDuration = 1000;
    protected static final int mLoadingAniItemDuration = 400;
    protected int mTextColor = -1;
    protected int mBackgroundColor = 0;
    protected boolean mIsInLoading = false;
    protected boolean mEnableFadeAnimation = false;
    protected Matrix mMatrix = new Matrix();
    protected RefreshKernel mRefreshKernel;
    protected AniController mAniController = new AniController();
    protected Transformation mTransformation = new Transformation();

    public StoreHouseHeader(Context context) {
        this(context, null);
    }

    public StoreHouseHeader(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public StoreHouseHeader(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        DensityUtil density = new DensityUtil();
        this.mLineWidth = density.dip2px(1.0f);
        this.mDropHeight = density.dip2px(40.0f);
        this.mHorizontalRandomness = Resources.getSystem().getDisplayMetrics().widthPixels / 2;
        this.mBackgroundColor = -13421773;
        this.setTextColor(-3355444);
        TypedArray ta = context.obtainStyledAttributes(attrs, R.styleable.StoreHouseHeader);
        this.mLineWidth = ta.getDimensionPixelOffset(R.styleable.StoreHouseHeader_shhLineWidth, this.mLineWidth);
        this.mDropHeight = ta.getDimensionPixelOffset(R.styleable.StoreHouseHeader_shhDropHeight, this.mDropHeight);
        this.mEnableFadeAnimation = ta.getBoolean(R.styleable.StoreHouseHeader_shhEnableFadeAnimation, this.mEnableFadeAnimation);
        if (ta.hasValue(R.styleable.StoreHouseHeader_shhText)) {
            this.initWithString(ta.getString(R.styleable.StoreHouseHeader_shhText));
        } else {
            this.initWithString("StoreHouse");
        }
        ta.recycle();
        StoreHouseHeader thisView = this;
        thisView.setMinimumHeight(this.mDrawZoneHeight + DensityUtil.dp2px((float)40.0f));
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        StoreHouseHeader thisView = this;
        super.setMeasuredDimension(View.resolveSize((int)super.getSuggestedMinimumWidth(), (int)widthMeasureSpec), View.resolveSize((int)super.getSuggestedMinimumHeight(), (int)heightMeasureSpec));
        this.mOffsetX = (thisView.getMeasuredWidth() - this.mDrawZoneWidth) / 2;
        this.mOffsetY = (thisView.getMeasuredHeight() - this.mDrawZoneHeight) / 2;
        this.mDropHeight = thisView.getMeasuredHeight() / 2;
    }

    protected void dispatchDraw(Canvas canvas) {
        StoreHouseHeader thisView = this;
        int c1 = canvas.save();
        int len = this.mItemList.size();
        float progress = thisView.isInEditMode() ? 1.0f : this.mProgress;
        for (int i = 0; i < len; ++i) {
            canvas.save();
            StoreHouseBarItem storeHouseBarItem = this.mItemList.get(i);
            float offsetX = (float)this.mOffsetX + storeHouseBarItem.midPoint.x;
            float offsetY = (float)this.mOffsetY + storeHouseBarItem.midPoint.y;
            if (this.mIsInLoading) {
                storeHouseBarItem.getTransformation(thisView.getDrawingTime(), this.mTransformation);
                canvas.translate(offsetX, offsetY);
            } else {
                if (progress == 0.0f) {
                    storeHouseBarItem.resetPosition(this.mHorizontalRandomness);
                    continue;
                }
                float startPadding = 0.3f * (float)i / (float)len;
                float endPadding = 0.3f - startPadding;
                if (progress == 1.0f || progress >= 1.0f - endPadding) {
                    canvas.translate(offsetX, offsetY);
                    storeHouseBarItem.setAlpha(0.4f);
                } else {
                    float realProgress = progress <= startPadding ? 0.0f : Math.min(1.0f, (progress - startPadding) / 0.7f);
                    offsetX += storeHouseBarItem.translationX * (1.0f - realProgress);
                    offsetY += (float)(-this.mDropHeight) * (1.0f - realProgress);
                    this.mMatrix.reset();
                    this.mMatrix.postRotate(360.0f * realProgress);
                    this.mMatrix.postScale(realProgress, realProgress);
                    this.mMatrix.postTranslate(offsetX, offsetY);
                    storeHouseBarItem.setAlpha(0.4f * realProgress);
                    canvas.concat(this.mMatrix);
                }
            }
            storeHouseBarItem.draw(canvas);
            canvas.restore();
        }
        if (this.mIsInLoading) {
            thisView.invalidate();
        }
        canvas.restoreToCount(c1);
        super.dispatchDraw(canvas);
    }

    public StoreHouseHeader setLoadingAniDuration(int duration) {
        this.mLoadingAniDuration = duration;
        this.mLoadingAniSegDuration = duration;
        return this;
    }

    public StoreHouseHeader setLineWidth(int width) {
        this.mLineWidth = width;
        for (int i = 0; i < this.mItemList.size(); ++i) {
            this.mItemList.get(i).setLineWidth(width);
        }
        return this;
    }

    public StoreHouseHeader setTextColor(@ColorInt int color) {
        this.mTextColor = color;
        for (int i = 0; i < this.mItemList.size(); ++i) {
            this.mItemList.get(i).setColor(color);
        }
        return this;
    }

    public StoreHouseHeader setDropHeight(int height) {
        this.mDropHeight = height;
        return this;
    }

    public StoreHouseHeader initWithString(String str) {
        this.initWithString(str, 25);
        return this;
    }

    public StoreHouseHeader initWithString(String str, int fontSize) {
        List<float[]> pointList = StoreHousePath.getPath(str, (float)fontSize * 0.01f, 14);
        this.initWithPointList(pointList);
        return this;
    }

    public StoreHouseHeader initWithStringArray(int id) {
        StoreHouseHeader thisView = this;
        String[] points = thisView.getResources().getStringArray(id);
        ArrayList<float[]> pointList = new ArrayList<float[]>();
        for (String point : points) {
            String[] x = point.split(",");
            float[] f = new float[4];
            for (int j = 0; j < 4; ++j) {
                f[j] = Float.parseFloat(x[j]);
            }
            pointList.add(f);
        }
        this.initWithPointList(pointList);
        return this;
    }

    public StoreHouseHeader setScale(float scale) {
        this.mScale = scale;
        return this;
    }

    public StoreHouseHeader initWithPointList(List<float[]> pointList) {
        float drawWidth = 0.0f;
        float drawHeight = 0.0f;
        boolean shouldLayout = this.mItemList.size() > 0;
        this.mItemList.clear();
        DensityUtil density = new DensityUtil();
        for (int i = 0; i < pointList.size(); ++i) {
            float[] line = pointList.get(i);
            PointF startPoint = new PointF((float)density.dip2px(line[0]) * this.mScale, (float)density.dip2px(line[1]) * this.mScale);
            PointF endPoint = new PointF((float)density.dip2px(line[2]) * this.mScale, (float)density.dip2px(line[3]) * this.mScale);
            drawWidth = Math.max(drawWidth, startPoint.x);
            drawWidth = Math.max(drawWidth, endPoint.x);
            drawHeight = Math.max(drawHeight, startPoint.y);
            drawHeight = Math.max(drawHeight, endPoint.y);
            StoreHouseBarItem item = new StoreHouseBarItem(i, startPoint, endPoint, this.mTextColor, this.mLineWidth);
            item.resetPosition(this.mHorizontalRandomness);
            this.mItemList.add(item);
        }
        this.mDrawZoneWidth = (int)Math.ceil(drawWidth);
        this.mDrawZoneHeight = (int)Math.ceil(drawHeight);
        if (shouldLayout) {
            StoreHouseHeader thisView = this;
            thisView.requestLayout();
        }
        return this;
    }

    public void onInitialized(@NonNull RefreshKernel kernel, int height, int maxDragHeight) {
        this.mRefreshKernel = kernel;
        this.mRefreshKernel.requestDrawBackgroundFor((RefreshInternal)this, this.mBackgroundColor);
    }

    public void onMoving(boolean isDragging, float percent, int offset, int height, int maxDragHeight) {
        this.mProgress = percent * 0.8f;
        StoreHouseHeader thisView = this;
        thisView.invalidate();
    }

    public void onReleased(@NonNull RefreshLayout layout, int height, int maxDragHeight) {
        this.mIsInLoading = true;
        this.mAniController.start();
        StoreHouseHeader thisView = this;
        thisView.invalidate();
    }

    public int onFinish(@NonNull RefreshLayout layout, boolean success) {
        this.mIsInLoading = false;
        this.mAniController.stop();
        if (success && this.mEnableFadeAnimation) {
            StoreHouseHeader thisView = this;
            thisView.startAnimation(new Animation(){
                {
                    super.setInterpolator((Interpolator)new AccelerateInterpolator());
                }

                protected void applyTransformation(float interpolatedTime, Transformation t) {
                    StoreHouseHeader thisView = StoreHouseHeader.this;
                    StoreHouseHeader.this.mProgress = 1.0f - interpolatedTime;
                    thisView.invalidate();
                    if (interpolatedTime == 1.0f) {
                        for (int i = 0; i < StoreHouseHeader.this.mItemList.size(); ++i) {
                            StoreHouseHeader.this.mItemList.get(i).resetPosition(StoreHouseHeader.this.mHorizontalRandomness);
                        }
                    }
                }
            });
            return 250;
        }
        for (int i = 0; i < this.mItemList.size(); ++i) {
            this.mItemList.get(i).resetPosition(this.mHorizontalRandomness);
        }
        return 0;
    }

    @Deprecated
    public void setPrimaryColors(int ... colors) {
        if (colors.length > 0) {
            this.mBackgroundColor = colors[0];
            if (this.mRefreshKernel != null) {
                this.mRefreshKernel.requestDrawBackgroundFor((RefreshInternal)this, this.mBackgroundColor);
            }
            if (colors.length > 1) {
                this.setTextColor(colors[1]);
            }
        }
    }

    private class AniController
    implements Runnable {
        int mTick = 0;
        int mCountPerSeg = 0;
        int mSegCount = 0;
        int mInterval = 0;
        boolean mRunning = true;

        private AniController() {
        }

        private void start() {
            this.mRunning = true;
            this.mTick = 0;
            this.mInterval = StoreHouseHeader.this.mLoadingAniDuration / StoreHouseHeader.this.mItemList.size();
            this.mCountPerSeg = StoreHouseHeader.this.mLoadingAniSegDuration / this.mInterval;
            this.mSegCount = StoreHouseHeader.this.mItemList.size() / this.mCountPerSeg + 1;
            this.run();
        }

        @Override
        public void run() {
            int pos = this.mTick % this.mCountPerSeg;
            for (int i = 0; i < this.mSegCount; ++i) {
                int index = i * this.mCountPerSeg + pos;
                if (index > this.mTick) continue;
                StoreHouseBarItem item = StoreHouseHeader.this.mItemList.get(index %= StoreHouseHeader.this.mItemList.size());
                item.setFillAfter(false);
                item.setFillEnabled(true);
                item.setFillBefore(false);
                item.setDuration(400L);
                item.start(1.0f, 0.4f);
            }
            ++this.mTick;
            if (this.mRunning && StoreHouseHeader.this.mRefreshKernel != null) {
                ViewGroup refreshView = StoreHouseHeader.this.mRefreshKernel.getRefreshLayout().getLayout();
                refreshView.postDelayed((Runnable)this, (long)this.mInterval);
            }
        }

        private void stop() {
            this.mRunning = false;
            StoreHouseHeader thisView = StoreHouseHeader.this;
            thisView.removeCallbacks(this);
        }
    }
}

