/*
 * Decompiled with CFR 0.152.
 */
package com.scwang.smartrefresh.header;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.drawable.Drawable;
import android.support.annotation.NonNull;
import android.util.AttributeSet;
import android.view.View;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import com.scwang.smartrefresh.header.internal.MaterialProgressDrawable;
import com.scwang.smartrefresh.header.waterdrop.WaterDropView;
import com.scwang.smartrefresh.layout.api.RefreshHeader;
import com.scwang.smartrefresh.layout.api.RefreshLayout;
import com.scwang.smartrefresh.layout.constant.RefreshState;
import com.scwang.smartrefresh.layout.constant.SpinnerStyle;
import com.scwang.smartrefresh.layout.internal.InternalAbstract;
import com.scwang.smartrefresh.layout.internal.ProgressDrawable;
import com.scwang.smartrefresh.layout.util.DensityUtil;

public class WaterDropHeader
extends InternalAbstract
implements RefreshHeader {
    protected static final float MAX_PROGRESS_ANGLE = 0.8f;
    protected RefreshState mState;
    protected ImageView mImageView;
    protected WaterDropView mWaterDropView;
    protected ProgressDrawable mProgressDrawable;
    protected MaterialProgressDrawable mProgress;

    public WaterDropHeader(Context context) {
        this(context, null);
    }

    public WaterDropHeader(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public WaterDropHeader(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        WaterDropHeader thisGroup = this;
        DensityUtil density = new DensityUtil();
        this.mSpinnerStyle = SpinnerStyle.Scale;
        this.mWaterDropView = new WaterDropView(context);
        this.mWaterDropView.updateCompleteState(0);
        thisGroup.addView(this.mWaterDropView, -1, -1);
        ProgressDrawable progressDrawable = this.mProgressDrawable = new ProgressDrawable();
        progressDrawable.setCallback((Drawable.Callback)this);
        progressDrawable.setBounds(0, 0, density.dip2px(20.0f), density.dip2px(20.0f));
        this.mImageView = new ImageView(context);
        this.mProgress = new MaterialProgressDrawable((View)this.mImageView);
        this.mProgress.setBackgroundColor(-1);
        this.mProgress.setAlpha(255);
        this.mProgress.setColorSchemeColors(-1, -16737844, -48060, -10053376, -5609780, -30720);
        this.mImageView.setImageDrawable((Drawable)this.mProgress);
        thisGroup.addView((View)this.mImageView, density.dip2px(30.0f), density.dip2px(30.0f));
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        ImageView imageView = this.mImageView;
        WaterDropView dropView = this.mWaterDropView;
        RelativeLayout.LayoutParams lpImage = (RelativeLayout.LayoutParams)imageView.getLayoutParams();
        imageView.measure(View.MeasureSpec.makeMeasureSpec((int)lpImage.width, (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)lpImage.height, (int)0x40000000));
        dropView.measure(View.MeasureSpec.makeMeasureSpec((int)View.MeasureSpec.getSize((int)widthMeasureSpec), (int)Integer.MIN_VALUE), heightMeasureSpec);
        int maxWidth = Math.max(imageView.getMeasuredWidth(), dropView.getMeasuredWidth());
        int maxHeight = Math.max(imageView.getMeasuredHeight(), dropView.getMeasuredHeight());
        super.setMeasuredDimension(View.resolveSize((int)maxWidth, (int)widthMeasureSpec), View.resolveSize((int)maxHeight, (int)heightMeasureSpec));
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        WaterDropHeader thisView = this;
        ImageView imageView = this.mImageView;
        WaterDropView dropView = this.mWaterDropView;
        int measuredWidth = thisView.getMeasuredWidth();
        int widthWaterDrop = dropView.getMeasuredWidth();
        int heightWaterDrop = dropView.getMeasuredHeight();
        int leftWaterDrop = measuredWidth / 2 - widthWaterDrop / 2;
        boolean topWaterDrop = false;
        dropView.layout(leftWaterDrop, 0, leftWaterDrop + widthWaterDrop, 0 + heightWaterDrop);
        int widthImage = imageView.getMeasuredWidth();
        int heightImage = imageView.getMeasuredHeight();
        int leftImage = measuredWidth / 2 - widthImage / 2;
        int topImage = widthWaterDrop / 2 - widthImage / 2;
        if (topImage + heightImage > dropView.getBottom() - (widthWaterDrop - widthImage) / 2) {
            topImage = dropView.getBottom() - (widthWaterDrop - widthImage) / 2 - heightImage;
        }
        imageView.layout(leftImage, topImage, leftImage + widthImage, topImage + heightImage);
    }

    protected void dispatchDraw(Canvas canvas) {
        super.dispatchDraw(canvas);
        WaterDropHeader thisView = this;
        WaterDropView dropView = this.mWaterDropView;
        ProgressDrawable progressDrawable = this.mProgressDrawable;
        if (this.mState == RefreshState.Refreshing) {
            canvas.save();
            canvas.translate((float)(thisView.getWidth() / 2 - progressDrawable.getBounds().width() / 2), (float)(this.mWaterDropView.getMaxCircleRadius() + dropView.getPaddingTop() - progressDrawable.getBounds().height() / 2));
            progressDrawable.draw(canvas);
            canvas.restore();
        }
    }

    public void invalidateDrawable(@NonNull Drawable drawable) {
        WaterDropHeader thisView = this;
        thisView.invalidate();
    }

    public void onMoving(boolean isDragging, float percent, int offset, int height, int maxDragHeight) {
        if (isDragging || this.mState != RefreshState.Refreshing && this.mState != RefreshState.RefreshReleased) {
            WaterDropView dropView = this.mWaterDropView;
            this.mWaterDropView.updateCompleteState(Math.max(offset, 0), height + maxDragHeight);
            dropView.postInvalidate();
        }
        if (isDragging) {
            float originalDragPercent = 1.0f * (float)offset / (float)height;
            float dragPercent = Math.min(1.0f, Math.abs(originalDragPercent));
            float adjustedPercent = (float)Math.max((double)dragPercent - 0.4, 0.0) * 5.0f / 3.0f;
            float extraOS = Math.abs(offset) - height;
            float tensionSlingshotPercent = Math.max(0.0f, Math.min(extraOS, (float)height * 2.0f) / (float)height);
            float tensionPercent = (float)((double)(tensionSlingshotPercent / 4.0f) - Math.pow(tensionSlingshotPercent / 4.0f, 2.0)) * 2.0f;
            float strokeStart = adjustedPercent * 0.8f;
            float rotation = (-0.25f + 0.4f * adjustedPercent + tensionPercent * 2.0f) * 0.5f;
            this.mProgress.showArrow(true);
            this.mProgress.setStartEndTrim(0.0f, Math.min(0.8f, strokeStart));
            this.mProgress.setArrowScale(Math.min(1.0f, adjustedPercent));
            this.mProgress.setProgressRotation(rotation);
        }
    }

    public void onStateChanged(@NonNull RefreshLayout refreshLayout, @NonNull RefreshState oldState, @NonNull RefreshState newState) {
        WaterDropView dropView = this.mWaterDropView;
        ImageView imageView = this.mImageView;
        this.mState = newState;
        switch (newState) {
            case None: {
                dropView.setVisibility(0);
                imageView.setVisibility(0);
                break;
            }
            case PullDownToRefresh: {
                dropView.setVisibility(0);
                imageView.setVisibility(0);
                break;
            }
            case PullDownCanceled: {
                break;
            }
            case ReleaseToRefresh: {
                dropView.setVisibility(0);
                imageView.setVisibility(0);
                break;
            }
            case Refreshing: {
                break;
            }
            case RefreshFinish: {
                dropView.setVisibility(8);
                imageView.setVisibility(8);
            }
        }
    }

    public void onReleased(@NonNull RefreshLayout layout, int height, int maxDragHeight) {
        ImageView imageView = this.mImageView;
        final WaterDropView dropView = this.mWaterDropView;
        this.mProgressDrawable.start();
        imageView.setVisibility(8);
        this.mWaterDropView.createAnimator().start();
        dropView.animate().setDuration(150L).alpha(0.0f).setListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                dropView.setVisibility(8);
                dropView.setAlpha(1.0f);
            }
        });
    }

    public int onFinish(@NonNull RefreshLayout layout, boolean success) {
        this.mProgressDrawable.stop();
        return 0;
    }

    @Deprecated
    public void setPrimaryColors(int ... colors) {
        if (colors.length > 0) {
            this.mWaterDropView.setIndicatorColor(colors[0]);
        }
    }
}

