/*
 * Decompiled with CFR 0.152.
 */
package com.scwang.smartrefresh.header.flyrefresh;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.RectF;
import android.support.annotation.ColorInt;
import android.support.v4.graphics.ColorUtils;
import android.support.v4.view.animation.PathInterpolatorCompat;
import android.util.AttributeSet;
import android.view.View;
import android.view.animation.Interpolator;
import com.scwang.smartrefresh.header.R;

public class MountainSceneView
extends View {
    protected int COLOR_BACKGROUND = -8466743;
    protected int COLOR_MOUNTAIN_1 = -7939369;
    protected int COLOR_MOUNTAIN_2 = -12807524;
    protected int COLOR_MOUNTAIN_3 = -12689549;
    protected int COLOR_TREE_1_BRANCH = -14716553;
    protected int COLOR_TREE_1_BRINK = -15974840;
    protected int COLOR_TREE_2_BRANCH = -13334385;
    protected int COLOR_TREE_2_BRINK = -14982807;
    protected int COLOR_TREE_3_BRANCH = -11030098;
    protected int COLOR_TREE_3_BRINK = -10312531;
    protected static final int WIDTH = 240;
    protected static final int HEIGHT = 180;
    protected static final int TREE_WIDTH = 100;
    protected static final int TREE_HEIGHT = 200;
    protected Paint mMountPaint = new Paint();
    protected Paint mTrunkPaint = new Paint();
    protected Paint mBranchPaint = new Paint();
    protected Paint mBoarderPaint = new Paint();
    protected Path mMount1 = new Path();
    protected Path mMount2 = new Path();
    protected Path mMount3 = new Path();
    protected Path mTrunk = new Path();
    protected Path mBranch = new Path();
    protected Matrix mTransMatrix = new Matrix();
    protected float mScaleX = 5.0f;
    protected float mScaleY = 5.0f;
    protected float mMoveFactor = 0.0f;
    protected float mBounceMax = 1.0f;
    protected float mTreeBendFactor = Float.MAX_VALUE;
    protected int mViewportHeight = 0;

    public MountainSceneView(Context context) {
        this(context, null);
    }

    public MountainSceneView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.mMountPaint.setAntiAlias(true);
        this.mMountPaint.setStyle(Paint.Style.FILL);
        this.mTrunkPaint.setAntiAlias(true);
        this.mBranchPaint.setAntiAlias(true);
        this.mBoarderPaint.setAntiAlias(true);
        this.mBoarderPaint.setStyle(Paint.Style.STROKE);
        this.mBoarderPaint.setStrokeWidth(2.0f);
        this.mBoarderPaint.setStrokeJoin(Paint.Join.ROUND);
        TypedArray ta = context.obtainStyledAttributes(attrs, R.styleable.MountainSceneView);
        if (ta.hasValue(R.styleable.MountainSceneView_msvPrimaryColor)) {
            this.setPrimaryColor(ta.getColor(R.styleable.MountainSceneView_msvPrimaryColor, -16777216));
        }
        this.mViewportHeight = ta.getDimensionPixelOffset(R.styleable.MountainSceneView_msvViewportHeight, 0);
        ta.recycle();
        this.updateMountainPath(this.mMoveFactor, 180);
        this.updateTreePath(this.mMoveFactor, true);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        MountainSceneView thisView = this;
        int width = thisView.getMeasuredWidth();
        int height = thisView.getMeasuredHeight();
        this.mScaleX = 1.0f * (float)width / 240.0f;
        this.mScaleY = 1.0f * (float)(this.mViewportHeight > 0 ? this.mViewportHeight : height) / 180.0f;
        this.updateMountainPath(this.mMoveFactor, height);
        this.updateTreePath(this.mMoveFactor, true);
    }

    private void updateMountainPath(float factor, int height) {
        this.mTransMatrix.reset();
        this.mTransMatrix.setScale(this.mScaleX, this.mScaleY);
        float offset1 = 10.0f * factor;
        this.mMount1.reset();
        this.mMount1.moveTo(0.0f, 95.0f + offset1);
        this.mMount1.lineTo(55.0f, 74.0f + offset1);
        this.mMount1.lineTo(146.0f, 104.0f + offset1);
        this.mMount1.lineTo(227.0f, 72.0f + offset1);
        this.mMount1.lineTo(240.0f, 80.0f + offset1);
        this.mMount1.lineTo(240.0f, 180.0f);
        this.mMount1.lineTo(0.0f, 180.0f);
        this.mMount1.close();
        this.mMount1.transform(this.mTransMatrix);
        float offset2 = 20.0f * factor;
        this.mMount2.reset();
        this.mMount2.moveTo(0.0f, 103.0f + offset2);
        this.mMount2.lineTo(67.0f, 90.0f + offset2);
        this.mMount2.lineTo(165.0f, 115.0f + offset2);
        this.mMount2.lineTo(221.0f, 87.0f + offset2);
        this.mMount2.lineTo(240.0f, 100.0f + offset2);
        this.mMount2.lineTo(240.0f, 180.0f);
        this.mMount2.lineTo(0.0f, 180.0f);
        this.mMount2.close();
        this.mMount2.transform(this.mTransMatrix);
        float offset3 = 30.0f * factor;
        this.mMount3.reset();
        this.mMount3.moveTo(0.0f, 114.0f + offset3);
        this.mMount3.cubicTo(30.0f, 106.0f + offset3, 196.0f, 97.0f + offset3, 240.0f, 104.0f + offset3);
        this.mMount3.lineTo(240.0f, (float)height / this.mScaleY);
        this.mMount3.lineTo(0.0f, (float)height / this.mScaleY);
        this.mMount3.close();
        this.mMount3.transform(this.mTransMatrix);
    }

    private void updateTreePath(float factor, boolean force) {
        float f;
        int i;
        int i2;
        if (factor == this.mTreeBendFactor && !force) {
            return;
        }
        Interpolator interpolator = PathInterpolatorCompat.create((float)0.8f, (float)(-0.5f * factor));
        float width = 100.0f;
        float height = 200.0f;
        float maxMove = 30.000002f * factor;
        float trunkSize = 5.0f;
        float branchSize = 20.0f;
        float x0 = 50.0f;
        float y0 = 200.0f;
        int N = 25;
        float dp = 0.04f;
        float dy = -8.0f;
        float y = 200.0f;
        float p = 0.0f;
        float[] xx = new float[26];
        float[] yy = new float[26];
        for (int i3 = 0; i3 <= 25; ++i3) {
            xx[i3] = interpolator.getInterpolation(p) * maxMove + 50.0f;
            yy[i3] = y;
            y += -8.0f;
            p += 0.04f;
        }
        this.mTrunk.reset();
        this.mTrunk.moveTo(45.0f, 200.0f);
        int max = 17;
        int max1 = (int)((float)max * 0.5f);
        float diff = max - max1;
        for (i2 = 0; i2 < max; ++i2) {
            if (i2 < max1) {
                this.mTrunk.lineTo(xx[i2] - 5.0f, yy[i2]);
                continue;
            }
            this.mTrunk.lineTo(xx[i2] - 5.0f * (float)(max - i2) / diff, yy[i2]);
        }
        for (i2 = max - 1; i2 >= 0; --i2) {
            if (i2 < max1) {
                this.mTrunk.lineTo(xx[i2] + 5.0f, yy[i2]);
                continue;
            }
            this.mTrunk.lineTo(xx[i2] + 5.0f * (float)(max - i2) / diff, yy[i2]);
        }
        this.mTrunk.close();
        this.mBranch.reset();
        int min = 10;
        diff = 25 - min;
        this.mBranch.moveTo(xx[min] - 20.0f, yy[min]);
        this.mBranch.addArc(new RectF(xx[min] - 20.0f, yy[min] - 20.0f, xx[min] + 20.0f, yy[min] + 20.0f), 0.0f, 180.0f);
        for (i = min; i <= 25; ++i) {
            f = (float)(i - min) / diff;
            this.mBranch.lineTo(xx[i] - 20.0f + f * f * 20.0f, yy[i]);
        }
        for (i = 25; i >= min; --i) {
            f = (float)(i - min) / diff;
            this.mBranch.lineTo(xx[i] + 20.0f - f * f * 20.0f, yy[i]);
        }
    }

    private void drawTree(Canvas canvas, float scale, float baseX, float baseY, int colorTrunk, int colorBranch) {
        canvas.save();
        float dx = baseX - 100.0f * scale / 2.0f;
        float dy = baseY - 200.0f * scale;
        canvas.translate(dx, dy);
        canvas.scale(scale, scale);
        this.mBranchPaint.setColor(colorBranch);
        canvas.drawPath(this.mBranch, this.mBranchPaint);
        this.mTrunkPaint.setColor(colorTrunk);
        canvas.drawPath(this.mTrunk, this.mTrunkPaint);
        this.mBoarderPaint.setColor(colorTrunk);
        canvas.drawPath(this.mBranch, this.mBoarderPaint);
        canvas.restore();
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        MountainSceneView thisView = this;
        canvas.drawColor(this.COLOR_BACKGROUND);
        this.mMountPaint.setColor(this.COLOR_MOUNTAIN_1);
        canvas.drawPath(this.mMount1, this.mMountPaint);
        canvas.save();
        canvas.scale(-1.0f, 1.0f, (float)(thisView.getWidth() / 2), 0.0f);
        this.drawTree(canvas, 0.12f * this.mScaleX, 180.0f * this.mScaleX, (93.0f + 20.0f * this.mMoveFactor) * this.mScaleY, this.COLOR_TREE_3_BRINK, this.COLOR_TREE_3_BRANCH);
        this.drawTree(canvas, 0.1f * this.mScaleX, 200.0f * this.mScaleX, (96.0f + 20.0f * this.mMoveFactor) * this.mScaleY, this.COLOR_TREE_3_BRINK, this.COLOR_TREE_3_BRANCH);
        canvas.restore();
        this.mMountPaint.setColor(this.COLOR_MOUNTAIN_2);
        canvas.drawPath(this.mMount2, this.mMountPaint);
        this.drawTree(canvas, 0.2f * this.mScaleX, 160.0f * this.mScaleX, (105.0f + 30.0f * this.mMoveFactor) * this.mScaleY, this.COLOR_TREE_1_BRINK, this.COLOR_TREE_1_BRANCH);
        this.drawTree(canvas, 0.14f * this.mScaleX, 180.0f * this.mScaleX, (105.0f + 30.0f * this.mMoveFactor) * this.mScaleY, this.COLOR_TREE_2_BRINK, this.COLOR_TREE_2_BRANCH);
        this.drawTree(canvas, 0.16f * this.mScaleX, 140.0f * this.mScaleX, (105.0f + 30.0f * this.mMoveFactor) * this.mScaleY, this.COLOR_TREE_2_BRINK, this.COLOR_TREE_2_BRANCH);
        this.mMountPaint.setColor(this.COLOR_MOUNTAIN_3);
        canvas.drawPath(this.mMount3, this.mMountPaint);
    }

    public void setPrimaryColor(@ColorInt int color) {
        this.COLOR_BACKGROUND = color;
        this.COLOR_MOUNTAIN_1 = ColorUtils.compositeColors((int)-1711276033, (int)color);
        this.COLOR_MOUNTAIN_2 = ColorUtils.compositeColors((int)-1724083556, (int)color);
        this.COLOR_MOUNTAIN_3 = ColorUtils.compositeColors((int)-868327565, (int)color);
        this.COLOR_TREE_1_BRANCH = ColorUtils.compositeColors((int)1428124023, (int)color);
        this.COLOR_TREE_1_BRINK = ColorUtils.compositeColors((int)-871612856, (int)color);
        this.COLOR_TREE_2_BRANCH = ColorUtils.compositeColors((int)1429506191, (int)color);
        this.COLOR_TREE_2_BRINK = ColorUtils.compositeColors((int)-870620823, (int)color);
        this.COLOR_TREE_3_BRANCH = ColorUtils.compositeColors((int)1431810478, (int)color);
        this.COLOR_TREE_3_BRINK = ColorUtils.compositeColors((int)-865950547, (int)color);
    }

    public void updatePercent(float percent) {
        this.mBounceMax = percent;
        float bendFactor = Math.max(0.0f, percent);
        this.mMoveFactor = Math.max(0.0f, this.mBounceMax);
        MountainSceneView thisView = this;
        int height = thisView.getMeasuredHeight();
        this.updateMountainPath(this.mMoveFactor, height > 0 ? height : 180);
        this.updateTreePath(bendFactor, false);
    }
}

