/*
 * Decompiled with CFR 0.152.
 */
package com.scwang.smartrefresh.header.fungame;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.support.annotation.NonNull;
import android.support.v4.graphics.ColorUtils;
import android.text.TextPaint;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.scwang.smartrefresh.header.R;
import com.scwang.smartrefresh.header.fungame.FunGameBase;
import com.scwang.smartrefresh.layout.api.RefreshKernel;
import com.scwang.smartrefresh.layout.api.RefreshLayout;
import com.scwang.smartrefresh.layout.constant.RefreshState;
import com.scwang.smartrefresh.layout.util.DensityUtil;

public abstract class FunGameView<T extends FunGameView>
extends FunGameBase {
    protected float DIVIDING_LINE_SIZE = 1.0f;
    protected View mShadowView;
    protected TextView mMaskViewTop;
    protected TextView mMaskViewBottom;
    public String mMaskTextBottom;
    public String mMaskTextTopPull;
    public String mMaskTextTopRelease;
    protected int mHalfHeaderHeight;
    protected static final int STATUS_GAME_PREPARE = 0;
    protected static final int STATUS_GAME_PLAY = 1;
    protected static final int STATUS_GAME_OVER = 2;
    protected static final int STATUS_GAME_FINISHED = 3;
    protected static final int STATUS_GAME_FAIL = 4;
    protected static final float VIEW_HEIGHT_RATIO = 0.161f;
    public String mTextGameOver;
    public String mTextLoading;
    public String mTextLoadingFinish;
    public String mTextLoadingFailed;
    protected Paint mPaint;
    protected Paint mPaintText;
    protected float controllerPosition;
    protected int controllerSize;
    protected int status = 0;
    protected int lModelColor;
    protected int rModelColor;
    protected int mModelColor;
    protected int mBackColor;
    protected int mBoundaryColor = -10461088;

    public FunGameView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        FunGameView thisView = this;
        FunGameView thisGroup = this;
        TypedArray ta = context.obtainStyledAttributes(attrs, R.styleable.FunGameView);
        this.mMaskTextBottom = thisView.getResources().getString(R.string.fgh_mask_bottom);
        this.mMaskTextTopPull = thisView.getResources().getString(R.string.fgh_mask_top_pull);
        this.mMaskTextTopRelease = thisView.getResources().getString(R.string.fgh_mask_top_release);
        if (ta.hasValue(R.styleable.FunGameView_fghMaskTextTop)) {
            this.mMaskTextTopPull = this.mMaskTextTopRelease = ta.getString(R.styleable.FunGameView_fghMaskTextTop);
        }
        if (ta.hasValue(R.styleable.FunGameView_fghMaskTextTopPull)) {
            this.mMaskTextTopPull = ta.getString(R.styleable.FunGameView_fghMaskTextTopPull);
        }
        if (ta.hasValue(R.styleable.FunGameView_fghMaskTextTopRelease)) {
            this.mMaskTextTopRelease = ta.getString(R.styleable.FunGameView_fghMaskTextTopRelease);
        }
        if (ta.hasValue(R.styleable.FunGameView_fghMaskTextBottom)) {
            this.mMaskTextBottom = ta.getString(R.styleable.FunGameView_fghMaskTextBottom);
        }
        DisplayMetrics metrics = thisView.getResources().getDisplayMetrics();
        int maskTextSizeTop = (int)TypedValue.applyDimension((int)2, (float)16.0f, (DisplayMetrics)metrics);
        int maskTextSizeBottom = maskTextSizeTop * 14 / 16;
        maskTextSizeTop = ta.getDimensionPixelSize(R.styleable.FunGameView_fghMaskTextSizeTop, maskTextSizeTop);
        maskTextSizeBottom = ta.getDimensionPixelSize(R.styleable.FunGameView_fghMaskTextSizeBottom, maskTextSizeBottom);
        RelativeLayout curtainLayout = new RelativeLayout(context);
        this.mShadowView = new RelativeLayout(context);
        this.mShadowView.setBackgroundColor(-12961222);
        this.mMaskViewTop = this.createMaskView(context, this.mMaskTextTopPull, maskTextSizeTop, 80);
        this.mMaskViewBottom = this.createMaskView(context, this.mMaskTextBottom, maskTextSizeBottom, 48);
        if (!thisView.isInEditMode()) {
            int height = DensityUtil.dp2px((float)100.0f);
            RelativeLayout.LayoutParams maskLp = new RelativeLayout.LayoutParams(-1, height);
            thisGroup.addView(this.mShadowView, (ViewGroup.LayoutParams)maskLp);
            thisGroup.addView((View)curtainLayout, (ViewGroup.LayoutParams)maskLp);
            this.mHalfHeaderHeight = (int)((float)height * 0.5f);
            RelativeLayout.LayoutParams lpTop = new RelativeLayout.LayoutParams(-1, this.mHalfHeaderHeight);
            RelativeLayout.LayoutParams lpBottom = new RelativeLayout.LayoutParams(-1, this.mHalfHeaderHeight);
            lpBottom.topMargin = height - this.mHalfHeaderHeight;
            curtainLayout.addView((View)this.mMaskViewTop, (ViewGroup.LayoutParams)lpTop);
            curtainLayout.addView((View)this.mMaskViewBottom, (ViewGroup.LayoutParams)lpBottom);
        }
        this.DIVIDING_LINE_SIZE = Math.max(1, DensityUtil.dp2px((float)0.5f));
        this.mPaint = new Paint(1);
        this.mPaint.setStrokeWidth(this.DIVIDING_LINE_SIZE);
        this.controllerPosition = this.DIVIDING_LINE_SIZE;
        this.mPaintText = new TextPaint(1);
        this.mPaintText.setColor(-4078910);
        this.mTextGameOver = context.getString(R.string.fgh_text_game_over);
        this.mTextLoading = context.getString(R.string.fgh_text_loading);
        this.mTextLoadingFinish = context.getString(R.string.fgh_text_loading_finish);
        this.mTextLoadingFailed = context.getString(R.string.fgh_text_loading_failed);
        this.mBackColor = ta.getColor(R.styleable.FunGameView_fghBackColor, 0);
        this.lModelColor = ta.getColor(R.styleable.FunGameView_fghLeftColor, -16777216);
        this.mModelColor = ta.getColor(R.styleable.FunGameView_fghMiddleColor, -16777216);
        this.rModelColor = ta.getColor(R.styleable.FunGameView_fghRightColor, -5921371);
        if (ta.hasValue(R.styleable.FunGameView_fghTextGameOver)) {
            this.mTextGameOver = ta.getString(R.styleable.FunGameView_fghTextGameOver);
        }
        if (ta.hasValue(R.styleable.FunGameView_fghTextLoading)) {
            this.mTextLoading = ta.getString(R.styleable.FunGameView_fghTextLoading);
        }
        if (ta.hasValue(R.styleable.FunGameView_fghTextLoadingFinished)) {
            this.mTextLoadingFinish = ta.getString(R.styleable.FunGameView_fghTextLoadingFinished);
        }
        if (ta.hasValue(R.styleable.FunGameView_fghTextLoadingFailed)) {
            this.mTextLoadingFailed = ta.getString(R.styleable.FunGameView_fghTextLoadingFailed);
        }
        ta.recycle();
    }

    protected TextView createMaskView(Context context, String text, int textSize, int gravity) {
        TextView maskView = new TextView(context);
        maskView.setTextColor(-16777216);
        maskView.setGravity(gravity | 1);
        maskView.setTextSize(0, (float)textSize);
        maskView.setText((CharSequence)text);
        TextView view = maskView;
        view.setBackgroundColor(-1);
        return maskView;
    }

    protected abstract void drawGame(Canvas var1, int var2, int var3);

    protected void dispatchDraw(Canvas canvas) {
        FunGameView thisView = this;
        int width = thisView.getWidth();
        int height = this.mHeaderHeight;
        this.drawBoundary(canvas, width, height);
        this.drawText(canvas, width, height);
        this.drawGame(canvas, width, height);
        super.dispatchDraw(canvas);
    }

    private void drawBoundary(Canvas canvas, int width, int height) {
        this.mPaint.setColor(this.mBackColor);
        canvas.drawRect(0.0f, 0.0f, (float)width, (float)height, this.mPaint);
        this.mPaint.setColor(this.mBoundaryColor);
        canvas.drawLine(0.0f, 0.0f, (float)width, 0.0f, this.mPaint);
        canvas.drawLine(0.0f, (float)height - this.DIVIDING_LINE_SIZE, (float)width, (float)height - this.DIVIDING_LINE_SIZE, this.mPaint);
    }

    private void drawText(Canvas canvas, int width, int height) {
        switch (this.status) {
            case 0: 
            case 1: {
                this.mPaintText.setTextSize((float)DensityUtil.dp2px((float)25.0f));
                this.promptText(canvas, this.mTextLoading, width, height);
                break;
            }
            case 3: {
                this.mPaintText.setTextSize((float)DensityUtil.dp2px((float)20.0f));
                this.promptText(canvas, this.mTextLoadingFinish, width, height);
                break;
            }
            case 4: {
                this.mPaintText.setTextSize((float)DensityUtil.dp2px((float)20.0f));
                this.promptText(canvas, this.mTextLoadingFailed, width, height);
                break;
            }
            case 2: {
                this.mPaintText.setTextSize((float)DensityUtil.dp2px((float)25.0f));
                this.promptText(canvas, this.mTextGameOver, width, height);
            }
        }
    }

    private void promptText(Canvas canvas, String text, int width, int height) {
        float textX = ((float)width - this.mPaintText.measureText(text)) * 0.5f;
        float textY = (float)height * 0.5f - (this.mPaintText.ascent() + this.mPaintText.descent()) * 0.5f;
        canvas.drawText(text, textX, textY, this.mPaintText);
    }

    protected abstract void resetConfigParams();

    public void postStatus(int status) {
        this.status = status;
        if (status == 0) {
            this.resetConfigParams();
        }
        FunGameView thisView = this;
        thisView.postInvalidate();
    }

    @Override
    protected void onManualOperationMove(float percent, int offset, int height, int maxDragHeight) {
        float maxDistance;
        FunGameView thisView = this;
        float distance = Math.max(offset, 0);
        if (distance > (maxDistance = (float)this.mHeaderHeight - 2.0f * this.DIVIDING_LINE_SIZE - (float)this.controllerSize)) {
            distance = maxDistance;
        }
        this.controllerPosition = distance;
        thisView.postInvalidate();
    }

    @Override
    public void onInitialized(@NonNull RefreshKernel kernel, int height, int maxDragHeight) {
        FunGameView thisView = this;
        if (this.mHeaderHeight != height && !thisView.isInEditMode()) {
            TextView topView = this.mMaskViewTop;
            TextView bottomView = this.mMaskViewBottom;
            this.mHalfHeaderHeight = (int)((float)height * 0.5f);
            RelativeLayout.LayoutParams lpTop = (RelativeLayout.LayoutParams)topView.getLayoutParams();
            RelativeLayout.LayoutParams lpBottom = (RelativeLayout.LayoutParams)bottomView.getLayoutParams();
            lpTop.height = lpBottom.height = this.mHalfHeaderHeight;
            lpBottom.topMargin = height - this.mHalfHeaderHeight;
            topView.setLayoutParams((ViewGroup.LayoutParams)lpTop);
            bottomView.setLayoutParams((ViewGroup.LayoutParams)lpBottom);
        }
        super.onInitialized(kernel, height, maxDragHeight);
        this.postStatus(0);
    }

    @Deprecated
    public void setPrimaryColors(int ... colors) {
        super.setPrimaryColors(colors);
        if (colors.length > 0) {
            this.mMaskViewTop.setTextColor(colors[0]);
            this.mMaskViewBottom.setTextColor(colors[0]);
            this.mBoundaryColor = this.mBackColor = colors[0];
            if (this.mBackColor == 0 || this.mBackColor == -1) {
                this.mBoundaryColor = -10461088;
            }
            if (colors.length > 1) {
                TextView topView = this.mMaskViewTop;
                TextView bottomView = this.mMaskViewBottom;
                View shadowView = this.mShadowView;
                shadowView.setBackgroundColor(colors[1]);
                topView.setBackgroundColor(colors[1]);
                bottomView.setBackgroundColor(colors[1]);
                this.mModelColor = colors[1];
                this.lModelColor = ColorUtils.setAlphaComponent((int)colors[1], (int)225);
                this.rModelColor = ColorUtils.setAlphaComponent((int)colors[1], (int)200);
                this.mPaintText.setColor(ColorUtils.setAlphaComponent((int)colors[1], (int)150));
            }
        }
    }

    @Override
    public void onStateChanged(@NonNull RefreshLayout refreshLayout, @NonNull RefreshState oldState, @NonNull RefreshState newState) {
        super.onStateChanged(refreshLayout, oldState, newState);
        switch (newState) {
            case PullDownToRefresh: {
                this.mMaskViewTop.setText((CharSequence)this.mMaskTextTopPull);
                break;
            }
            case ReleaseToRefresh: {
                this.mMaskViewTop.setText((CharSequence)this.mMaskTextTopRelease);
            }
        }
    }

    @Override
    public void onStartAnimator(@NonNull RefreshLayout layout, int height, int maxDragHeight) {
        super.onStartAnimator(layout, height, maxDragHeight);
        TextView topView = this.mMaskViewTop;
        View shadowView = this.mShadowView;
        TextView bottomView = this.mMaskViewBottom;
        AnimatorSet animatorSet = new AnimatorSet();
        animatorSet.play((Animator)ObjectAnimator.ofFloat((Object)topView, (String)"translationY", (float[])new float[]{topView.getTranslationY(), -this.mHalfHeaderHeight})).with((Animator)ObjectAnimator.ofFloat((Object)bottomView, (String)"translationY", (float[])new float[]{bottomView.getTranslationY(), this.mHalfHeaderHeight})).with((Animator)ObjectAnimator.ofFloat((Object)shadowView, (String)"alpha", (float[])new float[]{shadowView.getAlpha(), 0.0f}));
        animatorSet.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter((View)topView, (View)bottomView, shadowView){
            final /* synthetic */ View val$topView;
            final /* synthetic */ View val$bottomView;
            final /* synthetic */ View val$shadowView;
            {
                this.val$topView = view;
                this.val$bottomView = view2;
                this.val$shadowView = view3;
            }

            public void onAnimationEnd(Animator animation) {
                this.val$topView.setVisibility(8);
                this.val$bottomView.setVisibility(8);
                this.val$shadowView.setVisibility(8);
                FunGameView.this.postStatus(1);
            }
        });
        animatorSet.setDuration(800L);
        animatorSet.setStartDelay(200L);
        animatorSet.start();
    }

    @Override
    public int onFinish(@NonNull RefreshLayout layout, boolean success) {
        if (this.mManualOperation) {
            this.postStatus(success ? 3 : 4);
        } else {
            this.postStatus(0);
            TextView topView = this.mMaskViewTop;
            TextView bottomView = this.mMaskViewBottom;
            View shadowView = this.mShadowView;
            topView.setTranslationY(topView.getTranslationY() + (float)this.mHalfHeaderHeight);
            bottomView.setTranslationY(bottomView.getTranslationY() - (float)this.mHalfHeaderHeight);
            shadowView.setAlpha(1.0f);
            topView.setVisibility(0);
            bottomView.setVisibility(0);
            shadowView.setVisibility(0);
        }
        return super.onFinish(layout, success);
    }
}

