/*
 * Decompiled with CFR 0.152.
 */
package com.scwang.smartrefresh.header.internal;

import android.content.res.Resources;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.drawable.Animatable;
import android.graphics.drawable.Drawable;
import android.support.annotation.ColorInt;
import android.support.annotation.NonNull;
import android.support.v4.view.animation.FastOutSlowInInterpolator;
import android.util.DisplayMetrics;
import android.view.View;
import android.view.animation.Animation;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;
import android.view.animation.Transformation;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.List;

public class MaterialProgressDrawable
extends Drawable
implements Animatable {
    private static final Interpolator LINEAR_INTERPOLATOR = new LinearInterpolator();
    static final Interpolator MATERIAL_INTERPOLATOR = new FastOutSlowInInterpolator();
    private static final float FULL_ROTATION = 1080.0f;
    public static final byte LARGE = 0;
    public static final byte DEFAULT = 1;
    private static final byte CIRCLE_DIAMETER = 40;
    private static final float CENTER_RADIUS = 8.75f;
    private static final float STROKE_WIDTH = 2.5f;
    private static final byte CIRCLE_DIAMETER_LARGE = 56;
    private static final float CENTER_RADIUS_LARGE = 12.5f;
    private static final float STROKE_WIDTH_LARGE = 3.0f;
    private static final int[] COLORS = new int[]{-16777216};
    private static final float COLOR_START_DELAY_OFFSET = 0.75f;
    private static final float END_TRIM_START_DELAY_OFFSET = 0.5f;
    private static final float START_TRIM_DURATION_OFFSET = 0.5f;
    private static final int ANIMATION_DURATION = 1332;
    private static final byte NUM_POINTS = 5;
    private final List<Animation> mAnimators = new ArrayList<Animation>();
    private final Ring mRing = new Ring();
    private float mRotation;
    private static final byte ARROW_WIDTH = 10;
    private static final byte ARROW_HEIGHT = 5;
    private static final float ARROW_OFFSET_ANGLE = 5.0f;
    private static final byte ARROW_WIDTH_LARGE = 12;
    private static final byte ARROW_HEIGHT_LARGE = 6;
    private static final float MAX_PROGRESS_ARC = 0.8f;
    private View mParent;
    private Animation mAnimation;
    float mRotationCount;
    private float mWidth;
    private float mHeight;
    boolean mFinishing;

    public MaterialProgressDrawable(View parent) {
        this.mParent = parent;
        this.setColorSchemeColors(COLORS);
        this.updateSizes(1);
        this.setupAnimators();
    }

    private void setSizeParameters(int progressCircleWidth, int progressCircleHeight, float centerRadius, float strokeWidth, float arrowWidth, float arrowHeight) {
        DisplayMetrics metrics = Resources.getSystem().getDisplayMetrics();
        float screenDensity = metrics.density;
        this.mWidth = (float)progressCircleWidth * screenDensity;
        this.mHeight = (float)progressCircleHeight * screenDensity;
        this.mRing.setColorIndex(0);
        this.mRing.mPaint.setStrokeWidth(strokeWidth * screenDensity);
        this.mRing.mStrokeWidth = strokeWidth * screenDensity;
        this.mRing.mRingCenterRadius = centerRadius * screenDensity;
        this.mRing.mArrowWidth = (int)(arrowWidth * screenDensity);
        this.mRing.mArrowHeight = (int)(arrowHeight * screenDensity);
        this.mRing.setInsets((int)this.mWidth, (int)this.mHeight);
        MaterialProgressDrawable thisDrawable = this;
        thisDrawable.invalidateSelf();
    }

    public void updateSizes(int size) {
        if (size == 0) {
            this.setSizeParameters(56, 56, 12.5f, 3.0f, 12.0f, 6.0f);
        } else {
            this.setSizeParameters(40, 40, 8.75f, 2.5f, 10.0f, 5.0f);
        }
    }

    public void showArrow(boolean show) {
        if (this.mRing.mShowArrow != show) {
            this.mRing.mShowArrow = show;
            MaterialProgressDrawable thisDrawable = this;
            thisDrawable.invalidateSelf();
        }
    }

    public void setArrowScale(float scale) {
        if (this.mRing.mArrowScale != scale) {
            this.mRing.mArrowScale = scale;
            MaterialProgressDrawable thisDrawable = this;
            thisDrawable.invalidateSelf();
        }
    }

    public void setStartEndTrim(float startAngle, float endAngle) {
        this.mRing.mStartTrim = startAngle;
        this.mRing.mEndTrim = endAngle;
        MaterialProgressDrawable thisDrawable = this;
        thisDrawable.invalidateSelf();
    }

    public void setProgressRotation(float rotation) {
        this.mRing.mRotation = rotation;
        MaterialProgressDrawable thisDrawable = this;
        thisDrawable.invalidateSelf();
    }

    public void setBackgroundColor(@ColorInt int color) {
        this.mRing.mBackgroundColor = color;
    }

    public void setColorSchemeColors(int ... colors) {
        this.mRing.mColors = colors;
        this.mRing.setColorIndex(0);
    }

    public int getIntrinsicHeight() {
        return (int)this.mHeight;
    }

    public int getIntrinsicWidth() {
        return (int)this.mWidth;
    }

    public void draw(@NonNull Canvas c) {
        MaterialProgressDrawable thisDrawable = this;
        Rect bounds = thisDrawable.getBounds();
        int saveCount = c.save();
        c.rotate(this.mRotation, bounds.exactCenterX(), bounds.exactCenterY());
        this.mRing.draw(c, bounds);
        c.restoreToCount(saveCount);
    }

    public void setAlpha(int alpha) {
        this.mRing.mAlpha = alpha;
    }

    public int getAlpha() {
        return this.mRing.mAlpha;
    }

    public void setColorFilter(ColorFilter colorFilter) {
        this.mRing.mPaint.setColorFilter(colorFilter);
        MaterialProgressDrawable thisDrawable = this;
        thisDrawable.invalidateSelf();
    }

    void setRotation(float rotation) {
        this.mRotation = rotation;
        MaterialProgressDrawable thisDrawable = this;
        thisDrawable.invalidateSelf();
    }

    public int getOpacity() {
        return -3;
    }

    public boolean isRunning() {
        List<Animation> animators = this.mAnimators;
        int N = animators.size();
        for (int i = 0; i < N; ++i) {
            Animation animator = animators.get(i);
            if (!animator.hasStarted() || animator.hasEnded()) continue;
            return true;
        }
        return false;
    }

    public void start() {
        this.mAnimation.reset();
        this.mRing.storeOriginals();
        if (this.mRing.mEndTrim != this.mRing.mStartTrim) {
            this.mFinishing = true;
            this.mAnimation.setDuration(666L);
            this.mParent.startAnimation(this.mAnimation);
        } else {
            this.mRing.setColorIndex(0);
            this.mRing.resetOriginals();
            this.mAnimation.setDuration(1332L);
            this.mParent.startAnimation(this.mAnimation);
        }
    }

    public void stop() {
        this.mParent.clearAnimation();
        this.mRing.setColorIndex(0);
        this.mRing.resetOriginals();
        this.showArrow(false);
        this.setRotation(0.0f);
    }

    float getMinProgressArc(Ring ring) {
        return (float)Math.toRadians((double)ring.mStrokeWidth / (Math.PI * 2 * ring.mRingCenterRadius));
    }

    private int evaluateColorChange(float fraction, int startValue, int endValue) {
        int startInt = startValue;
        int startA = startInt >> 24 & 0xFF;
        int startR = startInt >> 16 & 0xFF;
        int startG = startInt >> 8 & 0xFF;
        int startB = startInt & 0xFF;
        int endInt = endValue;
        int endA = endInt >> 24 & 0xFF;
        int endR = endInt >> 16 & 0xFF;
        int endG = endInt >> 8 & 0xFF;
        int endB = endInt & 0xFF;
        return startA + (int)(fraction * (float)(endA - startA)) << 24 | startR + (int)(fraction * (float)(endR - startR)) << 16 | startG + (int)(fraction * (float)(endG - startG)) << 8 | startB + (int)(fraction * (float)(endB - startB));
    }

    void updateRingColor(float interpolatedTime, Ring ring) {
        if (interpolatedTime > 0.75f) {
            ring.mCurrentColor = this.evaluateColorChange((interpolatedTime - 0.75f) / 0.25f, ring.getStartingColor(), ring.getNextColor());
        }
    }

    void applyFinishTranslation(float interpolatedTime, Ring ring) {
        this.updateRingColor(interpolatedTime, ring);
        float targetRotation = (float)(Math.floor(ring.mStartingRotation / 0.8f) + 1.0);
        float minProgressArc = this.getMinProgressArc(ring);
        float startTrim = ring.mStartingStartTrim + (ring.mStartingEndTrim - minProgressArc - ring.mStartingStartTrim) * interpolatedTime;
        this.setStartEndTrim(startTrim, ring.mStartingEndTrim);
        float rotation = ring.mStartingRotation + (targetRotation - ring.mStartingRotation) * interpolatedTime;
        this.setProgressRotation(rotation);
    }

    private void setupAnimators() {
        final Ring ring = this.mRing;
        Animation animation = new Animation(){

            public void applyTransformation(float interpolatedTime, Transformation t) {
                if (MaterialProgressDrawable.this.mFinishing) {
                    MaterialProgressDrawable.this.applyFinishTranslation(interpolatedTime, ring);
                } else {
                    float minProgressArc = MaterialProgressDrawable.this.getMinProgressArc(ring);
                    float startingEndTrim = ring.mStartingEndTrim;
                    float startingTrim = ring.mStartingStartTrim;
                    float startingRotation = ring.mStartingRotation;
                    MaterialProgressDrawable.this.updateRingColor(interpolatedTime, ring);
                    if (interpolatedTime <= 0.5f) {
                        float scaledTime = interpolatedTime / 0.5f;
                        ring.mStartTrim = startingTrim + (0.8f - minProgressArc) * MATERIAL_INTERPOLATOR.getInterpolation(scaledTime);
                    }
                    if (interpolatedTime > 0.5f) {
                        float minArc = 0.8f - minProgressArc;
                        float scaledTime = (interpolatedTime - 0.5f) / 0.5f;
                        ring.mEndTrim = startingEndTrim + minArc * MATERIAL_INTERPOLATOR.getInterpolation(scaledTime);
                    }
                    MaterialProgressDrawable.this.setProgressRotation(startingRotation + 0.25f * interpolatedTime);
                    float groupRotation = 216.0f * interpolatedTime + 1080.0f * (MaterialProgressDrawable.this.mRotationCount / 5.0f);
                    MaterialProgressDrawable.this.setRotation(groupRotation);
                }
            }
        };
        animation.setRepeatCount(-1);
        animation.setRepeatMode(1);
        animation.setInterpolator(LINEAR_INTERPOLATOR);
        animation.setAnimationListener(new Animation.AnimationListener(){

            public void onAnimationStart(Animation animation) {
                MaterialProgressDrawable.this.mRotationCount = 0.0f;
            }

            public void onAnimationEnd(Animation animation) {
            }

            public void onAnimationRepeat(Animation animation) {
                ring.storeOriginals();
                ring.goToNextColor();
                ring.mStartTrim = ring.mEndTrim;
                if (MaterialProgressDrawable.this.mFinishing) {
                    MaterialProgressDrawable.this.mFinishing = false;
                    animation.setDuration(1332L);
                    MaterialProgressDrawable.this.showArrow(false);
                } else {
                    MaterialProgressDrawable.this.mRotationCount = (MaterialProgressDrawable.this.mRotationCount + 1.0f) % 5.0f;
                }
            }
        });
        this.mAnimation = animation;
    }

    private class Ring {
        final RectF mTempBounds = new RectF();
        final Paint mPaint = new Paint();
        final Paint mArrowPaint = new Paint();
        float mStartTrim = 0.0f;
        float mEndTrim = 0.0f;
        float mRotation = 0.0f;
        float mStrokeWidth = 5.0f;
        float mStrokeInset = 2.5f;
        int[] mColors;
        int mColorIndex;
        float mStartingStartTrim;
        float mStartingEndTrim;
        float mStartingRotation;
        boolean mShowArrow;
        Path mArrow;
        float mArrowScale;
        double mRingCenterRadius;
        int mArrowWidth;
        int mArrowHeight;
        int mAlpha;
        final Paint mCirclePaint = new Paint(1);
        int mBackgroundColor;
        int mCurrentColor;

        Ring() {
            this.mPaint.setStrokeCap(Paint.Cap.SQUARE);
            this.mPaint.setAntiAlias(true);
            this.mPaint.setStyle(Paint.Style.STROKE);
            this.mArrowPaint.setStyle(Paint.Style.FILL);
            this.mArrowPaint.setAntiAlias(true);
        }

        public void draw(Canvas c, Rect bounds) {
            RectF arcBounds = this.mTempBounds;
            arcBounds.set(bounds);
            arcBounds.inset(this.mStrokeInset, this.mStrokeInset);
            float startAngle = (this.mStartTrim + this.mRotation) * 360.0f;
            float endAngle = (this.mEndTrim + this.mRotation) * 360.0f;
            float sweepAngle = endAngle - startAngle;
            if (sweepAngle != 0.0f) {
                this.mPaint.setColor(this.mCurrentColor);
                c.drawArc(arcBounds, startAngle, sweepAngle, false, this.mPaint);
            }
            this.drawTriangle(c, startAngle, sweepAngle, bounds);
            if (this.mAlpha < 255) {
                this.mCirclePaint.setColor(this.mBackgroundColor);
                this.mCirclePaint.setAlpha(255 - this.mAlpha);
                c.drawCircle(bounds.exactCenterX(), bounds.exactCenterY(), (float)(bounds.width() / 2), this.mCirclePaint);
            }
        }

        private void drawTriangle(Canvas c, float startAngle, float sweepAngle, Rect bounds) {
            if (this.mShowArrow) {
                if (this.mArrow == null) {
                    this.mArrow = new Path();
                    this.mArrow.setFillType(Path.FillType.EVEN_ODD);
                } else {
                    this.mArrow.reset();
                }
                float inset = (float)((int)this.mStrokeInset / 2) * this.mArrowScale;
                float x = (float)(this.mRingCenterRadius * Math.cos(0.0) + (double)bounds.exactCenterX());
                float y = (float)(this.mRingCenterRadius * Math.sin(0.0) + (double)bounds.exactCenterY());
                this.mArrow.moveTo(0.0f, 0.0f);
                this.mArrow.lineTo((float)this.mArrowWidth * this.mArrowScale, 0.0f);
                this.mArrow.lineTo((float)this.mArrowWidth * this.mArrowScale / 2.0f, (float)this.mArrowHeight * this.mArrowScale);
                this.mArrow.offset(x - inset, y);
                this.mArrow.close();
                this.mArrowPaint.setColor(this.mCurrentColor);
                c.rotate(startAngle + sweepAngle - 5.0f, bounds.exactCenterX(), bounds.exactCenterY());
                c.drawPath(this.mArrow, this.mArrowPaint);
            }
        }

        public void setColorIndex(int index) {
            this.mColorIndex = index;
            this.mCurrentColor = this.mColors[this.mColorIndex];
        }

        public int getNextColor() {
            return this.mColors[this.getNextColorIndex()];
        }

        private int getNextColorIndex() {
            return (this.mColorIndex + 1) % this.mColors.length;
        }

        public void goToNextColor() {
            this.setColorIndex(this.getNextColorIndex());
        }

        public int getStartingColor() {
            return this.mColors[this.mColorIndex];
        }

        public void setInsets(int width, int height) {
            float minEdge = Math.min(width, height);
            float insets = this.mRingCenterRadius <= 0.0 || minEdge < 0.0f ? (float)Math.ceil(this.mStrokeWidth / 2.0f) : (float)((double)(minEdge / 2.0f) - this.mRingCenterRadius);
            this.mStrokeInset = insets;
        }

        public void storeOriginals() {
            this.mStartingStartTrim = this.mStartTrim;
            this.mStartingEndTrim = this.mEndTrim;
            this.mStartingRotation = this.mRotation;
        }

        public void resetOriginals() {
            this.mStartingStartTrim = 0.0f;
            this.mStartingEndTrim = 0.0f;
            this.mStartingRotation = 0.0f;
            this.mStartTrim = 0.0f;
            this.mEndTrim = 0.0f;
            this.mRotation = 0.0f;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ProgressDrawableSize {
    }
}

