/*
 * Decompiled with CFR 0.152.
 */
package com.scwang.smartrefresh.header.internal.pathview;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Path;
import android.graphics.Rect;
import android.graphics.Region;
import android.support.annotation.NonNull;
import com.scwang.smartrefresh.header.internal.pathview.PathParser;
import com.scwang.smartrefresh.layout.internal.PaintDrawable;
import java.util.ArrayList;
import java.util.List;

public class PathsDrawable
extends PaintDrawable {
    protected int mWidth = 1;
    protected int mHeight = 1;
    protected int mStartX = 0;
    protected int mStartY = 0;
    protected int mOriginWidth;
    protected int mOriginHeight;
    protected static final Region REGION = new Region();
    protected static final Region MAX_CLIP = new Region(Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE);
    protected List<Path> mPaths;
    protected List<Integer> mColors;
    protected List<Path> mltOriginPath;
    protected List<String> mltOriginSvg;
    private Bitmap mCachedBitmap;
    private boolean mCacheDirty;

    protected boolean onMeasure() {
        Integer top = null;
        Integer left = null;
        Integer right = null;
        Integer bottom = null;
        if (this.mPaths != null) {
            for (Path path : this.mPaths) {
                REGION.setPath(path, MAX_CLIP);
                Rect bounds = REGION.getBounds();
                top = Math.min(top == null ? bounds.top : top, bounds.top);
                left = Math.min(left == null ? bounds.left : left, bounds.left);
                right = Math.max(right == null ? bounds.right : right, bounds.right);
                bottom = Math.max(bottom == null ? bounds.bottom : bottom, bounds.bottom);
            }
        }
        this.mStartX = left == null ? 0 : left;
        this.mStartY = top == null ? 0 : top;
        this.mWidth = right == null ? 0 : right - this.mStartX;
        int n = this.mHeight = bottom == null ? 0 : bottom - this.mStartY;
        if (this.mOriginWidth == 0) {
            this.mOriginWidth = this.mWidth;
        }
        if (this.mOriginHeight == 0) {
            this.mOriginHeight = this.mHeight;
        }
        PathsDrawable drawable = this;
        Rect bounds = drawable.getBounds();
        if (this.mWidth == 0 || this.mHeight == 0) {
            if (this.mOriginWidth == 0) {
                this.mOriginWidth = 1;
            }
            if (this.mOriginHeight == 0) {
                this.mOriginHeight = 1;
            }
            this.mHeight = 1;
            this.mWidth = 1;
            return false;
        }
        super.setBounds(bounds.left, bounds.top, bounds.left + this.mWidth, bounds.top + this.mHeight);
        return true;
    }

    public void setBounds(int left, int top, int right, int bottom) {
        int width = right - left;
        int height = bottom - top;
        if (this.mltOriginPath != null && this.mltOriginPath.size() > 0 && (width != this.mWidth || height != this.mHeight)) {
            int ox = this.mStartX;
            int oy = this.mStartY;
            float ratioWidth = 1.0f * (float)width / (float)this.mOriginWidth;
            float ratioHeight = 1.0f * (float)height / (float)this.mOriginHeight;
            this.mPaths = PathParser.transformScale(ratioWidth, ratioHeight, this.mltOriginPath, this.mltOriginSvg);
            if (!this.onMeasure()) {
                this.mWidth = width;
                this.mHeight = height;
                this.mStartX = (int)(1.0f * (float)ox * (float)width / (float)this.mOriginWidth);
                this.mStartY = (int)(1.0f * (float)oy * (float)height / (float)this.mOriginHeight);
                super.setBounds(left, top, right, bottom);
            }
        } else {
            super.setBounds(left, top, right, bottom);
        }
    }

    public void setBounds(@NonNull Rect bounds) {
        this.setBounds(bounds.left, bounds.top, bounds.right, bounds.bottom);
    }

    public boolean parserPaths(String ... paths) {
        this.mOriginHeight = 0;
        this.mOriginWidth = 0;
        this.mltOriginSvg = new ArrayList<String>();
        this.mltOriginPath = new ArrayList<Path>();
        this.mPaths = this.mltOriginPath;
        for (String path : paths) {
            this.mltOriginSvg.add(path);
            this.mltOriginPath.add(PathParser.createPathFromPathData(path));
        }
        return this.onMeasure();
    }

    public void declareOriginal(int startX, int startY, int width, int height) {
        this.mStartX = startX;
        this.mStartY = startY;
        this.mOriginWidth = this.mWidth = width;
        this.mOriginHeight = this.mHeight = height;
        PathsDrawable drawable = this;
        Rect bounds = drawable.getBounds();
        super.setBounds(bounds.left, bounds.top, bounds.left + width, bounds.top + height);
    }

    public void parserColors(int ... colors) {
        this.mColors = new ArrayList<Integer>();
        for (int color : colors) {
            this.mColors.add(color);
        }
    }

    public void draw(@NonNull Canvas canvas) {
        PathsDrawable drawable = this;
        Rect bounds = drawable.getBounds();
        int width = bounds.width();
        int height = bounds.height();
        if (this.mPaint.getAlpha() == 255) {
            canvas.save();
            canvas.translate((float)(bounds.left - this.mStartX), (float)(bounds.top - this.mStartY));
            if (this.mPaths != null) {
                for (int i = 0; i < this.mPaths.size(); ++i) {
                    if (this.mColors != null && i < this.mColors.size()) {
                        this.mPaint.setColor(this.mColors.get(i).intValue());
                    }
                    canvas.drawPath(this.mPaths.get(i), this.mPaint);
                }
                this.mPaint.setAlpha(255);
            }
            canvas.restore();
        } else {
            this.createCachedBitmapIfNeeded(width, height);
            if (this.mCacheDirty) {
                this.mCachedBitmap.eraseColor(0);
                Canvas tmpCanvas = new Canvas(this.mCachedBitmap);
                this.drawCachedBitmap(tmpCanvas);
                this.mCacheDirty = false;
            }
            canvas.drawBitmap(this.mCachedBitmap, (float)bounds.left, (float)bounds.top, this.mPaint);
        }
    }

    public void setGeometricWidth(int width) {
        PathsDrawable drawable = this;
        Rect bounds = drawable.getBounds();
        float rate = 1.0f * (float)width / (float)bounds.width();
        this.setBounds((int)((float)bounds.left * rate), (int)((float)bounds.top * rate), (int)((float)bounds.right * rate), (int)((float)bounds.bottom * rate));
    }

    public void setGeometricHeight(int height) {
        PathsDrawable drawable = this;
        Rect bounds = drawable.getBounds();
        float rate = 1.0f * (float)height / (float)bounds.height();
        this.setBounds((int)((float)bounds.left * rate), (int)((float)bounds.top * rate), (int)((float)bounds.right * rate), (int)((float)bounds.bottom * rate));
    }

    private void drawCachedBitmap(Canvas canvas) {
        canvas.translate((float)(-this.mStartX), (float)(-this.mStartY));
        if (this.mPaths != null) {
            for (int i = 0; i < this.mPaths.size(); ++i) {
                if (this.mColors != null && i < this.mColors.size()) {
                    this.mPaint.setColor(this.mColors.get(i).intValue());
                }
                canvas.drawPath(this.mPaths.get(i), this.mPaint);
            }
        }
    }

    private void createCachedBitmapIfNeeded(int width, int height) {
        if (this.mCachedBitmap == null || width != this.mCachedBitmap.getWidth() || height != this.mCachedBitmap.getHeight()) {
            this.mCachedBitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            this.mCacheDirty = true;
        }
    }
}

