/*
 * Decompiled with CFR 0.152.
 */
package com.scwang.smartrefresh.header.waveswipe;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.RectF;
import android.os.Build;
import android.support.annotation.ColorInt;
import android.view.View;
import android.view.ViewTreeObserver;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.view.animation.BounceInterpolator;
import com.scwang.smartrefresh.header.waveswipe.DropBounceInterpolator;

public class WaveView
extends View
implements ViewTreeObserver.OnPreDrawListener {
    protected static final long DROP_CIRCLE_ANIMATOR_DURATION = 500L;
    protected static final long DROP_VERTEX_ANIMATION_DURATION = 500L;
    protected static final long DROP_BOUNCE_ANIMATOR_DURATION = 500L;
    protected static final int DROP_REMOVE_ANIMATOR_DURATION = 200;
    protected static final int WAVE_ANIMATOR_DURATION = 1000;
    protected static final float MAX_WAVE_HEIGHT = 0.2f;
    protected static final int SHADOW_COLOR = -1728053248;
    protected float mDropCircleRadius = 100.0f;
    protected Paint mPaint;
    protected Path mWavePath;
    protected Path mDropTangentPath;
    protected Path mDropCirclePath;
    protected Path mShadowPath;
    protected RectF mDropRect;
    protected int mWidth;
    protected float mCurrentCircleCenterY;
    protected int mMaxDropHeight;
    protected boolean mIsManualRefreshing = false;
    protected boolean mDropHeightUpdated = false;
    protected int mUpdateMaxDropHeight;
    protected ValueAnimator mDropVertexAnimator;
    protected ValueAnimator mDropBounceVerticalAnimator;
    protected ValueAnimator mDropBounceHorizontalAnimator;
    protected ValueAnimator mDropCircleAnimator;
    protected ValueAnimator mDisappearCircleAnimator;
    protected ValueAnimator mWaveReverseAnimator;
    protected static final float[][] BEGIN_PHASE_POINTS = new float[][]{{0.1655f, 0.0f}, {0.4188f, -0.0109f}, {0.4606f, -0.0049f}, {0.4893f, 0.0f}, {0.4893f, 0.0f}, {0.5f, 0.0f}};
    protected static final float[][] APPEAR_PHASE_POINTS = new float[][]{{0.1655f, 0.0f}, {0.5237f, 0.0553f}, {0.4557f, 0.0936f}, {0.3908f, 0.1302f}, {0.4303f, 0.2173f}, {0.5f, 0.2173f}};
    protected static final float[][] EXPAND_PHASE_POINTS = new float[][]{{0.1655f, 0.0f}, {0.5909f, 0.0f}, {0.4557f, 0.1642f}, {0.3941f, 0.2061f}, {0.4303f, 0.2889f}, {0.5f, 0.2889f}};
    protected ValueAnimator.AnimatorUpdateListener mAnimatorUpdateListener = new ValueAnimator.AnimatorUpdateListener(){

        public void onAnimationUpdate(ValueAnimator valueAnimator) {
            WaveView thisView = WaveView.this;
            thisView.postInvalidate();
        }
    };

    public WaveView(Context context) {
        super(context);
        WaveView thisView = this;
        float density = thisView.getResources().getDisplayMetrics().density;
        this.mPaint = new Paint();
        this.mPaint.setColor(-14575885);
        this.mPaint.setAntiAlias(true);
        this.mPaint.setStyle(Paint.Style.FILL);
        this.mPaint.setShadowLayer((float)((int)(0.5f + 2.0f * density)), 0.0f, 0.0f, -1728053248);
        this.mWavePath = new Path();
        this.mDropTangentPath = new Path();
        this.mDropCirclePath = new Path();
        this.mShadowPath = new Path();
        this.resetAnimator();
        this.mDropRect = new RectF();
        thisView.setLayerType(1, null);
        thisView.getViewTreeObserver().addOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this);
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        this.mWidth = w;
        this.mDropCircleRadius = (float)w / 14.4f;
        WaveView thisView = this;
        this.updateMaxDropHeight((int)Math.min((float)Math.min(w, h), (float)thisView.getHeight() - this.mDropCircleRadius));
        super.onSizeChanged(w, h, oldw, oldh);
    }

    public boolean onPreDraw() {
        WaveView thisView = this;
        thisView.getViewTreeObserver().removeOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this);
        if (this.mDropHeightUpdated) {
            this.updateMaxDropHeight(this.mUpdateMaxDropHeight);
        }
        return false;
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        WaveView thisView = this;
        canvas.drawPath(this.mWavePath, this.mPaint);
        if (!thisView.isInEditMode()) {
            this.mWavePath.rewind();
            this.mDropTangentPath.rewind();
            this.mDropCirclePath.rewind();
        }
        float circleCenterY = ((Float)this.mDropCircleAnimator.getAnimatedValue()).floatValue();
        float circleCenterX = (float)this.mWidth / 2.0f;
        float scale = ((Float)this.mDisappearCircleAnimator.getAnimatedValue()).floatValue();
        float vertical = ((Float)this.mDropBounceVerticalAnimator.getAnimatedValue()).floatValue();
        float horizontal = ((Float)this.mDropBounceHorizontalAnimator.getAnimatedValue()).floatValue();
        this.mDropRect.set(circleCenterX - this.mDropCircleRadius * (1.0f + vertical) * scale + this.mDropCircleRadius * horizontal / 2.0f, circleCenterY + this.mDropCircleRadius * (1.0f + horizontal) * scale - this.mDropCircleRadius * vertical / 2.0f, circleCenterX + this.mDropCircleRadius * (1.0f + vertical) * scale - this.mDropCircleRadius * horizontal / 2.0f, circleCenterY - this.mDropCircleRadius * (1.0f + horizontal) * scale + this.mDropCircleRadius * vertical / 2.0f);
        float vertex = ((Float)this.mDropVertexAnimator.getAnimatedValue()).floatValue();
        this.mDropTangentPath.moveTo(circleCenterX, vertex);
        double q = (Math.pow(this.mDropCircleRadius, 2.0) + (double)(circleCenterY * vertex) - Math.pow(circleCenterY, 2.0)) / (double)(vertex - circleCenterY);
        double b = -2.0 * (double)this.mWidth / 2.0;
        double c = Math.pow(q - (double)circleCenterY, 2.0) + Math.pow(circleCenterX, 2.0) - Math.pow(this.mDropCircleRadius, 2.0);
        double p1 = (-b + Math.sqrt(b * b - 4.0 * c)) / 2.0;
        double p2 = (-b - Math.sqrt(b * b - 4.0 * c)) / 2.0;
        this.mDropTangentPath.lineTo((float)p1, (float)q);
        this.mDropTangentPath.lineTo((float)p2, (float)q);
        this.mDropTangentPath.close();
        this.mShadowPath.set(this.mDropTangentPath);
        this.mShadowPath.addOval(this.mDropRect, Path.Direction.CCW);
        this.mDropCirclePath.addOval(this.mDropRect, Path.Direction.CCW);
        canvas.drawPath(this.mDropTangentPath, this.mPaint);
        canvas.drawPath(this.mDropCirclePath, this.mPaint);
    }

    protected void onDetachedFromWindow() {
        if (this.mDisappearCircleAnimator != null) {
            this.mDisappearCircleAnimator.end();
            this.mDisappearCircleAnimator.removeAllUpdateListeners();
        }
        if (this.mDropCircleAnimator != null) {
            this.mDropCircleAnimator.end();
            this.mDropCircleAnimator.removeAllUpdateListeners();
        }
        if (this.mDropVertexAnimator != null) {
            this.mDropVertexAnimator.end();
            this.mDropVertexAnimator.removeAllUpdateListeners();
        }
        if (this.mWaveReverseAnimator != null) {
            this.mWaveReverseAnimator.end();
            this.mWaveReverseAnimator.removeAllUpdateListeners();
        }
        if (this.mDropBounceHorizontalAnimator != null) {
            this.mDropBounceHorizontalAnimator.end();
            this.mDropBounceHorizontalAnimator.removeAllUpdateListeners();
        }
        if (this.mDropBounceVerticalAnimator != null) {
            this.mDropBounceVerticalAnimator.end();
            this.mDropBounceVerticalAnimator.removeAllUpdateListeners();
        }
        super.onDetachedFromWindow();
    }

    protected void resetAnimator() {
        this.mDropVertexAnimator = ValueAnimator.ofFloat((float[])new float[]{0.0f, 0.0f});
        this.mDropBounceVerticalAnimator = ValueAnimator.ofFloat((float[])new float[]{0.0f, 0.0f});
        this.mDropBounceHorizontalAnimator = ValueAnimator.ofFloat((float[])new float[]{0.0f, 0.0f});
        this.mDropCircleAnimator = ValueAnimator.ofFloat((float[])new float[]{-1000.0f, -1000.0f});
        this.mDropCircleAnimator.start();
        this.mDisappearCircleAnimator = ValueAnimator.ofFloat((float[])new float[]{1.0f, 1.0f});
        this.mDisappearCircleAnimator.setDuration(1L);
        this.mDisappearCircleAnimator.start();
    }

    protected void onPreDragWave() {
        if (this.mWaveReverseAnimator != null && this.mWaveReverseAnimator.isRunning()) {
            this.mWaveReverseAnimator.cancel();
        }
    }

    public void manualRefresh() {
        if (this.mIsManualRefreshing) {
            return;
        }
        this.mIsManualRefreshing = true;
        this.mDropCircleAnimator = ValueAnimator.ofFloat((float[])new float[]{this.mMaxDropHeight, this.mMaxDropHeight});
        this.mDropCircleAnimator.start();
        this.mDropVertexAnimator = ValueAnimator.ofFloat((float[])new float[]{(float)this.mMaxDropHeight - this.mDropCircleRadius, (float)this.mMaxDropHeight - this.mDropCircleRadius});
        this.mDropVertexAnimator.start();
        this.mCurrentCircleCenterY = this.mMaxDropHeight;
        WaveView thisView = this;
        thisView.postInvalidate();
    }

    public void beginPhase(float move1) {
        this.onPreDragWave();
        this.mWavePath.moveTo(0.0f, 0.0f);
        this.mWavePath.cubicTo((float)this.mWidth * BEGIN_PHASE_POINTS[0][0], BEGIN_PHASE_POINTS[0][1], (float)this.mWidth * BEGIN_PHASE_POINTS[1][0], (float)this.mWidth * (BEGIN_PHASE_POINTS[1][1] + move1), (float)this.mWidth * BEGIN_PHASE_POINTS[2][0], (float)this.mWidth * (BEGIN_PHASE_POINTS[2][1] + move1));
        this.mWavePath.cubicTo((float)this.mWidth * BEGIN_PHASE_POINTS[3][0], (float)this.mWidth * (BEGIN_PHASE_POINTS[3][1] + move1), (float)this.mWidth * BEGIN_PHASE_POINTS[4][0], (float)this.mWidth * (BEGIN_PHASE_POINTS[4][1] + move1), (float)this.mWidth * BEGIN_PHASE_POINTS[5][0], (float)this.mWidth * (BEGIN_PHASE_POINTS[5][1] + move1));
        this.mWavePath.cubicTo((float)this.mWidth - (float)this.mWidth * BEGIN_PHASE_POINTS[4][0], (float)this.mWidth * (BEGIN_PHASE_POINTS[4][1] + move1), (float)this.mWidth - (float)this.mWidth * BEGIN_PHASE_POINTS[3][0], (float)this.mWidth * (BEGIN_PHASE_POINTS[3][1] + move1), (float)this.mWidth - (float)this.mWidth * BEGIN_PHASE_POINTS[2][0], (float)this.mWidth * (BEGIN_PHASE_POINTS[2][1] + move1));
        this.mWavePath.cubicTo((float)this.mWidth - (float)this.mWidth * BEGIN_PHASE_POINTS[1][0], (float)this.mWidth * (BEGIN_PHASE_POINTS[1][1] + move1), (float)this.mWidth - (float)this.mWidth * BEGIN_PHASE_POINTS[0][0], BEGIN_PHASE_POINTS[0][1], (float)this.mWidth, 0.0f);
        WaveView thisView = this;
        if (Build.VERSION.SDK_INT >= 16) {
            thisView.postInvalidateOnAnimation();
        } else {
            thisView.invalidate();
        }
    }

    public void appearPhase(float move1, float move2) {
        this.onPreDragWave();
        this.mWavePath.moveTo(0.0f, 0.0f);
        this.mWavePath.cubicTo((float)this.mWidth * APPEAR_PHASE_POINTS[0][0], (float)this.mWidth * APPEAR_PHASE_POINTS[0][1], (float)this.mWidth * Math.min(BEGIN_PHASE_POINTS[1][0] + move2, APPEAR_PHASE_POINTS[1][0]), (float)this.mWidth * Math.max(BEGIN_PHASE_POINTS[1][1] + move1 - move2, APPEAR_PHASE_POINTS[1][1]), (float)this.mWidth * Math.max(BEGIN_PHASE_POINTS[2][0] - move2, APPEAR_PHASE_POINTS[2][0]), (float)this.mWidth * Math.max(BEGIN_PHASE_POINTS[2][1] + move1 - move2, APPEAR_PHASE_POINTS[2][1]));
        this.mWavePath.cubicTo((float)this.mWidth * Math.max(BEGIN_PHASE_POINTS[3][0] - move2, APPEAR_PHASE_POINTS[3][0]), (float)this.mWidth * Math.min(BEGIN_PHASE_POINTS[3][1] + move1 + move2, APPEAR_PHASE_POINTS[3][1]), (float)this.mWidth * Math.max(BEGIN_PHASE_POINTS[4][0] - move2, APPEAR_PHASE_POINTS[4][0]), (float)this.mWidth * Math.min(BEGIN_PHASE_POINTS[4][1] + move1 + move2, APPEAR_PHASE_POINTS[4][1]), (float)this.mWidth * APPEAR_PHASE_POINTS[5][0], (float)this.mWidth * Math.min(BEGIN_PHASE_POINTS[0][1] + move1 + move2, APPEAR_PHASE_POINTS[5][1]));
        this.mWavePath.cubicTo((float)this.mWidth - (float)this.mWidth * Math.max(BEGIN_PHASE_POINTS[4][0] - move2, APPEAR_PHASE_POINTS[4][0]), (float)this.mWidth * Math.min(BEGIN_PHASE_POINTS[4][1] + move1 + move2, APPEAR_PHASE_POINTS[4][1]), (float)this.mWidth - (float)this.mWidth * Math.max(BEGIN_PHASE_POINTS[3][0] - move2, APPEAR_PHASE_POINTS[3][0]), (float)this.mWidth * Math.min(BEGIN_PHASE_POINTS[3][1] + move1 + move2, APPEAR_PHASE_POINTS[3][1]), (float)this.mWidth - (float)this.mWidth * Math.max(BEGIN_PHASE_POINTS[2][0] - move2, APPEAR_PHASE_POINTS[2][0]), (float)this.mWidth * Math.max(BEGIN_PHASE_POINTS[2][1] + move1 - move2, APPEAR_PHASE_POINTS[2][1]));
        this.mWavePath.cubicTo((float)this.mWidth - (float)this.mWidth * Math.min(BEGIN_PHASE_POINTS[1][0] + move2, APPEAR_PHASE_POINTS[1][0]), (float)this.mWidth * Math.max(BEGIN_PHASE_POINTS[1][1] + move1 - move2, APPEAR_PHASE_POINTS[1][1]), (float)this.mWidth - (float)this.mWidth * APPEAR_PHASE_POINTS[0][0], (float)this.mWidth * APPEAR_PHASE_POINTS[0][1], (float)this.mWidth, 0.0f);
        this.mCurrentCircleCenterY = (float)this.mWidth * Math.min(BEGIN_PHASE_POINTS[3][1] + move1 + move2, APPEAR_PHASE_POINTS[3][1]) + this.mDropCircleRadius;
        WaveView thisView = this;
        if (Build.VERSION.SDK_INT >= 16) {
            thisView.postInvalidateOnAnimation();
        } else {
            thisView.invalidate();
        }
    }

    public void expandPhase(float move1, float move2, float move3) {
        this.onPreDragWave();
        this.mWavePath.moveTo(0.0f, 0.0f);
        this.mWavePath.cubicTo((float)this.mWidth * EXPAND_PHASE_POINTS[0][0], (float)this.mWidth * EXPAND_PHASE_POINTS[0][1], (float)this.mWidth * Math.min(Math.min(BEGIN_PHASE_POINTS[1][0] + move2, APPEAR_PHASE_POINTS[1][0]) + move3, EXPAND_PHASE_POINTS[1][0]), (float)this.mWidth * Math.max(Math.max(BEGIN_PHASE_POINTS[1][1] + move1 - move2, APPEAR_PHASE_POINTS[1][1]) - move3, EXPAND_PHASE_POINTS[1][1]), (float)this.mWidth * Math.max(BEGIN_PHASE_POINTS[2][0] - move2, EXPAND_PHASE_POINTS[2][0]), (float)this.mWidth * Math.min(Math.max(BEGIN_PHASE_POINTS[2][1] + move1 - move2, APPEAR_PHASE_POINTS[2][1]) + move3, EXPAND_PHASE_POINTS[2][1]));
        this.mWavePath.cubicTo((float)this.mWidth * Math.min(Math.max(BEGIN_PHASE_POINTS[3][0] - move2, APPEAR_PHASE_POINTS[3][0]) + move3, EXPAND_PHASE_POINTS[3][0]), (float)this.mWidth * Math.min(Math.min(BEGIN_PHASE_POINTS[3][1] + move1 + move2, APPEAR_PHASE_POINTS[3][1]) + move3, EXPAND_PHASE_POINTS[3][1]), (float)this.mWidth * Math.max(BEGIN_PHASE_POINTS[4][0] - move2, EXPAND_PHASE_POINTS[4][0]), (float)this.mWidth * Math.min(Math.min(BEGIN_PHASE_POINTS[4][1] + move1 + move2, APPEAR_PHASE_POINTS[4][1]) + move3, EXPAND_PHASE_POINTS[4][1]), (float)this.mWidth * EXPAND_PHASE_POINTS[5][0], (float)this.mWidth * Math.min(Math.min(BEGIN_PHASE_POINTS[0][1] + move1 + move2, APPEAR_PHASE_POINTS[5][1]) + move3, EXPAND_PHASE_POINTS[5][1]));
        this.mWavePath.cubicTo((float)this.mWidth - (float)this.mWidth * Math.max(BEGIN_PHASE_POINTS[4][0] - move2, EXPAND_PHASE_POINTS[4][0]), (float)this.mWidth * Math.min(Math.min(BEGIN_PHASE_POINTS[4][1] + move1 + move2, APPEAR_PHASE_POINTS[4][1]) + move3, EXPAND_PHASE_POINTS[4][1]), (float)this.mWidth - (float)this.mWidth * Math.min(Math.max(BEGIN_PHASE_POINTS[3][0] - move2, APPEAR_PHASE_POINTS[3][0]) + move3, EXPAND_PHASE_POINTS[3][0]), (float)this.mWidth * Math.min(Math.min(BEGIN_PHASE_POINTS[3][1] + move1 + move2, APPEAR_PHASE_POINTS[3][1]) + move3, EXPAND_PHASE_POINTS[3][1]), (float)this.mWidth - (float)this.mWidth * Math.max(BEGIN_PHASE_POINTS[2][0] - move2, EXPAND_PHASE_POINTS[2][0]), (float)this.mWidth * Math.min(Math.max(BEGIN_PHASE_POINTS[2][1] + move1 - move2, APPEAR_PHASE_POINTS[2][1]) + move3, EXPAND_PHASE_POINTS[2][1]));
        this.mWavePath.cubicTo((float)this.mWidth - (float)this.mWidth * Math.min(Math.min(BEGIN_PHASE_POINTS[1][0] + move2, APPEAR_PHASE_POINTS[1][0]) + move3, EXPAND_PHASE_POINTS[1][0]), (float)this.mWidth * Math.max(Math.max(BEGIN_PHASE_POINTS[1][1] + move1 - move2, APPEAR_PHASE_POINTS[1][1]) - move3, EXPAND_PHASE_POINTS[1][1]), (float)this.mWidth - (float)this.mWidth * EXPAND_PHASE_POINTS[0][0], (float)this.mWidth * EXPAND_PHASE_POINTS[0][1], (float)this.mWidth, 0.0f);
        this.mCurrentCircleCenterY = (float)this.mWidth * Math.min(Math.min(BEGIN_PHASE_POINTS[3][1] + move1 + move2, APPEAR_PHASE_POINTS[3][1]) + move3, EXPAND_PHASE_POINTS[3][1]) + this.mDropCircleRadius;
        WaveView thisView = this;
        if (Build.VERSION.SDK_INT >= 16) {
            thisView.postInvalidateOnAnimation();
        } else {
            thisView.invalidate();
        }
    }

    protected void updateMaxDropHeight(int height) {
        if (500.0f * ((float)this.mWidth / 1440.0f) > (float)height) {
            return;
        }
        WaveView thisView = this;
        this.mMaxDropHeight = (int)Math.min((float)height, (float)thisView.getHeight() - this.mDropCircleRadius);
        if (this.mIsManualRefreshing) {
            this.mIsManualRefreshing = false;
            this.manualRefresh();
        }
    }

    public void startDropAnimation() {
        this.mDisappearCircleAnimator = ValueAnimator.ofFloat((float[])new float[]{1.0f, 1.0f});
        this.mDisappearCircleAnimator.setDuration(1L);
        this.mDisappearCircleAnimator.start();
        this.mDropCircleAnimator = ValueAnimator.ofFloat((float[])new float[]{500.0f * ((float)this.mWidth / 1440.0f), this.mMaxDropHeight});
        this.mDropCircleAnimator.setDuration(500L);
        this.mDropCircleAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                WaveView.this.mCurrentCircleCenterY = ((Float)animation.getAnimatedValue()).floatValue();
                WaveView thisView = WaveView.this;
                if (Build.VERSION.SDK_INT >= 16) {
                    thisView.postInvalidateOnAnimation();
                } else {
                    thisView.invalidate();
                }
            }
        });
        this.mDropCircleAnimator.setInterpolator((TimeInterpolator)new AccelerateDecelerateInterpolator());
        this.mDropCircleAnimator.start();
        this.mDropVertexAnimator = ValueAnimator.ofFloat((float[])new float[]{0.0f, (float)this.mMaxDropHeight - this.mDropCircleRadius});
        this.mDropVertexAnimator.setDuration(500L);
        this.mDropVertexAnimator.addUpdateListener(this.mAnimatorUpdateListener);
        this.mDropVertexAnimator.start();
        this.mDropBounceVerticalAnimator = ValueAnimator.ofFloat((float[])new float[]{0.0f, 1.0f});
        this.mDropBounceVerticalAnimator.setDuration(500L);
        this.mDropBounceVerticalAnimator.addUpdateListener(this.mAnimatorUpdateListener);
        this.mDropBounceVerticalAnimator.setInterpolator((TimeInterpolator)new DropBounceInterpolator());
        this.mDropBounceVerticalAnimator.setStartDelay(500L);
        this.mDropBounceVerticalAnimator.start();
        this.mDropBounceHorizontalAnimator = ValueAnimator.ofFloat((float[])new float[]{0.0f, 1.0f});
        this.mDropBounceHorizontalAnimator.setDuration(500L);
        this.mDropBounceHorizontalAnimator.addUpdateListener(this.mAnimatorUpdateListener);
        this.mDropBounceHorizontalAnimator.setInterpolator((TimeInterpolator)new DropBounceInterpolator());
        this.mDropBounceHorizontalAnimator.setStartDelay(625L);
        this.mDropBounceHorizontalAnimator.start();
    }

    public void startDisappearCircleAnimation() {
        this.mDisappearCircleAnimator = ValueAnimator.ofFloat((float[])new float[]{1.0f, 0.0f});
        this.mDisappearCircleAnimator.addUpdateListener(this.mAnimatorUpdateListener);
        this.mDisappearCircleAnimator.setDuration(200L);
        this.mDisappearCircleAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animator) {
                WaveView.this.resetAnimator();
                WaveView.this.mIsManualRefreshing = false;
            }
        });
        this.mDisappearCircleAnimator.start();
    }

    public void startWaveAnimation(float h) {
        h = Math.min(h, 0.2f) * (float)this.mWidth;
        this.mWaveReverseAnimator = ValueAnimator.ofFloat((float[])new float[]{h, 0.0f});
        this.mWaveReverseAnimator.setDuration(1000L);
        this.mWaveReverseAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator valueAnimator) {
                float h = ((Float)valueAnimator.getAnimatedValue()).floatValue();
                WaveView.this.mWavePath.moveTo(0.0f, 0.0f);
                WaveView.this.mWavePath.quadTo(0.25f * (float)WaveView.this.mWidth, 0.0f, 0.333f * (float)WaveView.this.mWidth, h * 0.5f);
                WaveView.this.mWavePath.quadTo((float)WaveView.this.mWidth * 0.5f, h * 1.4f, 0.666f * (float)WaveView.this.mWidth, h * 0.5f);
                WaveView.this.mWavePath.quadTo(0.75f * (float)WaveView.this.mWidth, 0.0f, (float)WaveView.this.mWidth, 0.0f);
                WaveView thisView = WaveView.this;
                thisView.postInvalidate();
            }
        });
        this.mWaveReverseAnimator.setInterpolator((TimeInterpolator)new BounceInterpolator());
        this.mWaveReverseAnimator.start();
    }

    public void animationDropCircle() {
        if (this.mDisappearCircleAnimator.isRunning()) {
            return;
        }
        this.startDropAnimation();
        this.startWaveAnimation(0.1f);
    }

    public float getCurrentCircleCenterY() {
        return this.mCurrentCircleCenterY;
    }

    public void setShadow(int radius, int color) {
        this.mPaint.setShadowLayer((float)radius, 0.0f, 0.0f, color);
    }

    public void setWaveColor(@ColorInt int color) {
        this.mPaint.setColor(color);
        WaveView thisView = this;
        thisView.invalidate();
    }
}

