package com.scwang.smartrefresh.header;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.support.annotation.ColorInt;
import android.support.annotation.NonNull;
import android.util.AttributeSet;
import android.view.View;
import android.view.animation.Animation;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;
import android.view.animation.Transformation;

import com.scwang.smartrefresh.header.internal.pathview.PathsDrawable;
import com.scwang.smartrefresh.layout.api.RefreshHeader;
import com.scwang.smartrefresh.layout.api.RefreshLayout;
import com.scwang.smartrefresh.layout.constant.SpinnerStyle;
import com.scwang.smartrefresh.layout.internal.InternalAbstract;
import com.scwang.smartrefresh.layout.util.DensityUtil;

/**
 * Phoenix
 * Created by SCWANG on 2017/5/31.
 * from https://github.com/Yalantis/Phoenix
 */
public class PhoenixHeader extends InternalAbstract implements RefreshHeader/*, SizeDefinition*/ {

    //<editor-fold desc="static">
    protected static final int ANIMATION_DURATION = 1000;
    protected static final float SUN_INITIAL_ROTATE_GROWTH = 1.2f;
    protected static final Interpolator LINEAR_INTERPOLATOR = new LinearInterpolator();

    protected static String[] townPaths = new String[]{
            "m 527,396 v -8 h 39.5 39.5 v 8 8 H 566.5 527 Z m 84,-6 v -14 h 7.5 7.5 v 14 14 h -7.5 -7.5 z m 20,6 v -8 h 65.5 65.5 v 8 8 H 696.5 631 Z m 143,-54 v -62 h 52 52 v 62 62 h -52 -52 z m 44,34 c 0,-3.33333 -0.33333,-4 -2,-4 -1.91667,0 -2,-0.66667 -2,-16 v -16 h -10 -10 v 16 c 0,15.33333 -0.0833,16 -2,16 -1.66667,0 -2,0.66667 -2,4 v 4 h 14 14 z m -20,-12 v -8 h 6 6 v 8 8 h -6 -6 z m 0,-16 v -4 h 6 6 v 4 4 h -6 -6 z m 64,28 c 0,-3.33333 -0.33333,-4 -2,-4 -1.91667,0 -2,-0.66667 -2,-16 v -16 h -10 -10 v 16 c 0,15.33333 -0.0833,16 -2,16 -1.66667,0 -2,0.66667 -2,4 v 4 h 14 14 z m -20,-12 v -8 h 6 6 v 8 8 h -6 -6 z m 0,-16 v -4 h 6 6 v 4 4 h -6 -6 z m -24,-24 c 0,-3.33333 -0.33333,-4 -2,-4 -1.91667,0 -2,-0.66667 -2,-16 v -16 h -10 -10 v 16 c 0,15.33333 -0.0833,16 -2,16 -1.66667,0 -2,0.66667 -2,4 v 4 h 14 14 z m -20,-12 v -8 h 6 6 v 8 8 h -6 -6 z m 0,-16 v -4 h 6 6 v 4 4 h -6 -6 z m 64,28 c 0,-3.33333 -0.33333,-4 -2,-4 -1.91667,0 -2,-0.66667 -2,-16 v -16 h -10 -10 v 16 c 0,15.33333 -0.0833,16 -2,16 -1.66667,0 -2,0.66667 -2,4 v 4 h 14 14 z m -20,-12 v -8 h 6 6 v 8 8 h -6 -6 z m 0,-16 v -4 h 6 6 v 4 4 h -6 -6 z m 448,46 v -62 h 51.5 51.5 v 62 62 h -29.5 -29.5 v -26 -26 h -14.5 -14.5 v 26 26 h -7.5 -7.5 z m 88,42 c 0,-3.33333 -0.3333,-4 -2,-4 -1.9048,0 -2,-0.66667 -2,-14 v -14 h -10.5 -10.5 v 14 c 0,13.33333 -0.095,14 -2,14 -1.6667,0 -2,0.66667 -2,4 v 4 h 14.5 14.5 z m -21,-10 v -6 h 6.5 6.5 v 6 6 h -6.5 -6.5 z m 0,-14 v -4 h 6.5 6.5 v 4 4 h -6.5 -6.5 z m -23,-24 c 0,-3.33333 -0.3333,-4 -2,-4 -1.9048,0 -2,-0.66667 -2,-14 v -14 h -10.5 -10.5 v 14 c 0,13.33333 -0.095,14 -2,14 -1.6667,0 -2,0.66667 -2,4 v 4 h 14.5 14.5 z m -21,-10 v -6 h 6.5 6.5 v 6 6 h -6.5 -6.5 z m 0,-14 v -4 h 6.5 6.5 v 4 4 h -6.5 -6.5 z m 65,24 c 0,-3.33333 -0.3333,-4 -2,-4 -1.9048,0 -2,-0.66667 -2,-14 v -14 h -10.5 -10.5 v 14 c 0,13.33333 -0.095,14 -2,14 -1.6667,0 -2,0.66667 -2,4 v 4 h 14.5 14.5 z m -21,-10 v -6 h 6.5 6.5 v 6 6 h -6.5 -6.5 z m 0,-14 v -4 h 6.5 6.5 v 4 4 h -6.5 -6.5 z M 29.8125,370.31689 c 0.721875,-0.28887 1.584375,-0.25335 1.916667,0.0789 0.332291,0.33229 -0.258334,0.56864 -1.3125,0.52522 -1.164943,-0.048 -1.4019,-0.28494 -0.604167,-0.60416 z m 1811,0 c 0.7219,-0.28887 1.5844,-0.25335 1.9167,0.0789 0.3323,0.33229 -0.2584,0.56864 -1.3125,0.52522 -1.165,-0.048 -1.4019,-0.28494 -0.6042,-0.60416 z M 527,324 v -24 h 31.5 31.5 v 24 24 H 558.5 527 Z m 68,0 v -24 h 83.5 83.5 v 24 24 H 678.5 595 Z m 69,10 c 0,-1.95471 -0.66667,-2 -29.44098,-2 -28.44028,0 -31.71136,0.32647 -30.05902,3 0.38938,0.63003 11.51038,1 30.05902,1 C 663.33333,336 664,335.95471 664,334 Z m 24,0 c 0,-1.83333 -0.66667,-2 -8,-2 -7.33333,0 -8,0.16667 -8,2 0,1.83333 0.66667,2 8,2 7.33333,0 8,-0.16667 8,-2 z m 64,0 c 0,-1.94872 -0.66667,-2 -26,-2 -25.33333,0 -26,0.0513 -26,2 0,1.94872 0.66667,2 26,2 25.33333,0 26,-0.0513 26,-2 z M 363.5,317 c 0.99549,-1.1 2.03498,-2 2.30998,-2 0.275,0 -0.31449,0.9 -1.30998,2 -0.99549,1.1 -2.03498,2 -2.30998,2 -0.275,0 0.31449,-0.9 1.30998,-2 z m 1143.905,-0.25 -1.905,-2.25 2.25,1.90499 c 2.1144,1.79022 2.7052,2.59501 1.905,2.59501 -0.1898,0 -1.2023,-1.0125 -2.25,-2.25 z m -1095.00001,-1 -1.90499,-2.25 2.25,1.90499 c 2.11444,1.79022 2.70524,2.59501 1.90499,2.59501 -0.18976,0 -1.20226,-1.0125 -2.25,-2.25 z M 1458.5,316 c 0.9955,-1.1 2.035,-2 2.31,-2 0.275,0 -0.3145,0.9 -1.31,2 -0.9955,1.1 -2.035,2 -2.31,2 -0.275,0 0.3145,-0.9 1.31,-2 z M 161.92431,313.25 159.5,310.5 l 2.75,2.42431 c 2.57029,2.26589 3.20859,3.07569 2.42431,3.07569 -0.17912,0 -1.41662,-1.2375 -2.75,-2.75 z M 1709,313.5 c 1.2917,-1.375 2.5736,-2.5 2.8486,-2.5 0.275,0 -0.5569,1.125 -1.8486,2.5 -1.2917,1.375 -2.5736,2.5 -2.8486,2.5 -0.275,0 0.5569,-1.125 1.8486,-2.5 z m -1608,1.12244 c 0,-0.20765 0.7875,-0.99515 1.75,-1.75 1.58606,-1.24387 1.62143,-1.2085 0.37756,0.37756 C 101.82119,314.91575 101,315.44548 101,314.62244 Z M 1769,313.5 c -0.6847,-0.825 -1.0199,-1.5 -0.7449,-1.5 0.275,0 1.0602,0.675 1.7449,1.5 0.6847,0.825 1.0199,1.5 0.7449,1.5 -0.275,0 -1.0602,-0.675 -1.7449,-1.5 z M 527,282 v -6 h 7.5 7.5 v 6 6 h -7.5 -7.5 z m 20,0 v -6 h 5.5 5.5 v 6 6 h -5.5 -5.5 z m 16,0 v -6 h 5.5 5.5 v 6 6 h -5.5 -5.5 z m 16,0 v -6 h 5.5 5.5 v 6 6 h -5.5 -5.5 z m 16,0 v -6 h 5.5 5.5 v 6 6 h -5.5 -5.5 z m 16,0 v -6 h 5.5 5.5 v 6 6 h -5.5 -5.5 z m 16,0 v -6 h 5.5 5.5 v 6 6 h -5.5 -5.5 z m 16,0 v -6 h 5.5 5.5 v 6 6 h -5.5 -5.5 z m 16,0 v -6 h 5.5 5.5 v 6 6 h -5.5 -5.5 z m 15.2001,0.25 0.2999,-5.75 5.75,-0.2999 5.75,-0.29991 V 281.9501 288 h -6.0499 -6.04991 z m 16,0 0.2999,-5.75 5.75,-0.2999 5.75,-0.29991 V 281.9501 288 h -6.0499 -6.04991 z m 16,0 0.2999,-5.75 5.75,-0.2999 5.75,-0.29991 V 281.9501 288 h -6.0499 -6.04991 z m 16,0 0.2999,-5.75 5.75,-0.2999 5.75,-0.29991 V 281.9501 288 h -6.0499 -6.04991 z m 16,0 0.2999,-5.75 5.75,-0.2999 5.75,-0.29991 V 281.9501 288 h -6.0499 -6.04991 z m 16,0 0.2999,-5.75 3.75,-0.31037 3.75,-0.31036 V 281.93963 288 h -4.0499 -4.04991 z M 774,274 c 0,-1.91667 0.66667,-2 16,-2 15.33333,0 16,0.0833 16,2 0,1.91667 -0.66667,2 -16,2 -15.33333,0 -16,-0.0833 -16,-2 z m 36,0 c 0,-1.91667 0.66667,-2 16,-2 15.33333,0 16,0.0833 16,2 0,1.91667 -0.66667,2 -16,2 -15.33333,0 -16,-0.0833 -16,-2 z m 36,0 c 0,-1.91667 0.66667,-2 16,-2 15.33333,0 16,0.0833 16,2 0,1.91667 -0.66667,2 -16,2 -15.33333,0 -16,-0.0833 -16,-2 z m 444,0 c 0,-1.97411 0.6667,-2 51.5,-2 50.8333,0 51.5,0.0259 51.5,2 0,1.97411 -0.6667,2 -51.5,2 -50.8333,0 -51.5,-0.0259 -51.5,-2 z M 774,258 v -10 h 4 4 v 10 10 h -4 -4 z m 12,0 v -10 h 4 4 v 10 10 h -4 -4 z m 12,0 v -10 h 4 4 v 10 10 h -4 -4 z m 12,0 v -10 h 4 4 v 10 10 h -4 -4 z m 12,0 v -10 h 4 4 v 10 10 h -4 -4 z m 12,0 v -10 h 4 4 v 10 10 h -4 -4 z m 12,0 v -10 h 4 4 v 10 10 h -4 -4 z m 12,0 v -10 h 4 4 v 10 10 h -4 -4 z m 12,0 v -10 h 4 4 v 10 10 h -4 -4 z m 420,0 v -10 h 51.5 51.5 v 10 10 h -51.5 -51.5 z m 23.6418,-26.34524 c 2.672,-2.38988 10.2499,-9.1272 16.8397,-14.97183 l 11.9814,-10.6266 3.0186,2.80156 c 1.6602,1.54085 8.981,8.09794 16.2685,14.57131 7.2875,6.47336 13.25,11.94998 13.25,12.17027 0,0.22029 -14.8987,0.40053 -33.1082,0.40053 h -33.1081 z M 1394,228.5 c -0.6847,-0.825 -1.0199,-1.5 -0.7449,-1.5 0.275,0 1.0602,0.675 1.7449,1.5 0.6847,0.825 1.0199,1.5 0.7449,1.5 -0.275,0 -1.0602,-0.675 -1.7449,-1.5 z m -103,-0.87756 c 0,-0.20765 0.7875,-0.99515 1.75,-1.75 1.5861,-1.24387 1.6214,-1.2085 0.3776,0.37756 -1.3064,1.66575 -2.1276,2.19548 -2.1276,1.37244 z m 93.405,-7.87244 -1.905,-2.25 2.25,1.90499 c 2.1144,1.79022 2.7052,2.59501 1.905,2.59501 -0.1898,0 -1.2023,-1.0125 -2.25,-2.25 z M 1301,218.62244 c 0,-0.20765 0.7875,-0.99515 1.75,-1.75 1.5861,-1.24387 1.6214,-1.2085 0.3776,0.37756 -1.3064,1.66575 -2.1276,2.19548 -2.1276,1.37244 z M 1375,211.5 c -0.6847,-0.825 -1.0199,-1.5 -0.7449,-1.5 0.275,0 1.0602,0.675 1.7449,1.5 0.6847,0.825 1.0199,1.5 0.7449,1.5 -0.275,0 -1.0602,-0.675 -1.7449,-1.5 z m -65,-0.87756 c 0,-0.20765 0.7875,-0.99515 1.75,-1.75 1.5861,-1.24387 1.6214,-1.2085 0.3776,0.37756 -1.3064,1.66575 -2.1276,2.19548 -2.1276,1.37244 z M 1366,203.5 c -0.6847,-0.825 -1.0199,-1.5 -0.7449,-1.5 0.275,0 1.0602,0.675 1.7449,1.5 0.6847,0.825 1.0199,1.5 0.7449,1.5 -0.275,0 -1.0602,-0.675 -1.7449,-1.5 z M 1141.4469,172 c 0,-17.875 0.1356,-25.1875 0.3013,-16.25 0.1657,8.9375 0.1657,23.5625 0,32.5 -0.1657,8.9375 -0.3013,1.625 -0.3013,-16.25 z M 1319,202.62244 c 0,-0.20765 0.7875,-0.99515 1.75,-1.75 1.5861,-1.24387 1.6214,-1.2085 0.3776,0.37756 -1.3064,1.66575 -2.1276,2.19548 -2.1276,1.37244 z M 1357,195.5 c -0.6847,-0.825 -1.0199,-1.5 -0.7449,-1.5 0.275,0 1.0602,0.675 1.7449,1.5 0.6847,0.825 1.0199,1.5 0.7449,1.5 -0.275,0 -1.0602,-0.675 -1.7449,-1.5 z m -29,-0.87756 c 0,-0.20765 0.7875,-0.99515 1.75,-1.75 1.5861,-1.24387 1.6214,-1.2085 0.3776,0.37756 -1.3064,1.66575 -2.1276,2.19548 -2.1276,1.37244 z M 1348,187.5 c -0.6847,-0.825 -1.0199,-1.5 -0.7449,-1.5 0.275,0 1.0602,0.675 1.7449,1.5 0.6847,0.825 1.0199,1.5 0.7449,1.5 -0.275,0 -1.0602,-0.675 -1.7449,-1.5 z m -11,-0.87756 c 0,-0.20765 0.7875,-0.99515 1.75,-1.75 1.5861,-1.24387 1.6214,-1.2085 0.3776,0.37756 -1.3064,1.66575 -2.1276,2.19548 -2.1276,1.37244 z"  ,
            "m 918,382 c 0,-1.83333 0.66667,-2 8,-2 7.33333,0 8,0.16667 8,2 0,1.83333 -0.66667,2 -8,2 -7.33333,0 -8,-0.16667 -8,-2 z m 40,0 c 0,-1.83333 0.66667,-2 8,-2 7.33333,0 8,0.16667 8,2 0,1.83333 -0.66667,2 -8,2 -7.33333,0 -8,-0.16667 -8,-2 z m 40,0 c 0,-1.83333 0.66667,-2 8,-2 7.3333,0 8,0.16667 8,2 0,1.83333 -0.6667,2 -8,2 -7.33333,0 -8,-0.16667 -8,-2 z m -80,-10 v -4 h 8 8 v 4 4 h -8 -8 z m 40,0 v -4 h 8 8 v 4 4 h -8 -8 z m 40,0 v -4 h 8 8 v 4 4 h -8 -8 z M 32.75,370.33772 c 0.6875,-0.27741 1.8125,-0.27741 2.5,0 0.6875,0.27741 0.125,0.50439 -1.25,0.50439 -1.375,0 -1.9375,-0.22698 -1.25,-0.50439 z m 1804,0 c 0.6875,-0.27741 1.8125,-0.27741 2.5,0 0.6875,0.27741 0.125,0.50439 -1.25,0.50439 -1.375,0 -1.9375,-0.22698 -1.25,-0.50439 z M 918,346 c 0,-1.83333 0.66667,-2 8,-2 7.33333,0 8,0.16667 8,2 0,1.83333 -0.66667,2 -8,2 -7.33333,0 -8,-0.16667 -8,-2 z m 40,0 c 0,-1.83333 0.66667,-2 8,-2 7.33333,0 8,0.16667 8,2 0,1.83333 -0.66667,2 -8,2 -7.33333,0 -8,-0.16667 -8,-2 z m 40,0 c 0,-1.83333 0.66667,-2 8,-2 7.3333,0 8,0.16667 8,2 0,1.83333 -0.6667,2 -8,2 -7.33333,0 -8,-0.16667 -8,-2 z m -80,-10 v -4 h 8 8 v 4 4 h -8 -8 z m 40,0 v -4 h 8 8 v 4 4 h -8 -8 z m 40,0 v -4 h 8 8 v 4 4 h -8 -8 z m -80,-26 c 0,-1.83333 0.66667,-2 8,-2 7.33333,0 8,0.16667 8,2 0,1.83333 -0.66667,2 -8,2 -7.33333,0 -8,-0.16667 -8,-2 z m 40,0 c 0,-1.83333 0.66667,-2 8,-2 7.33333,0 8,0.16667 8,2 0,1.83333 -0.66667,2 -8,2 -7.33333,0 -8,-0.16667 -8,-2 z m 40,0 c 0,-1.83333 0.66667,-2 8,-2 7.3333,0 8,0.16667 8,2 0,1.83333 -0.6667,2 -8,2 -7.33333,0 -8,-0.16667 -8,-2 z m -564,-2.37756 c 0,-0.20765 0.7875,-0.99515 1.75,-1.75 1.58606,-1.24387 1.62143,-1.2085 0.37756,0.37756 C 434.82119,307.91575 434,308.44548 434,307.62244 Z M 485.40499,305.75 483.5,303.5 l 2.25,1.90499 c 2.11444,1.79022 2.70524,2.59501 1.90499,2.59501 -0.18976,0 -1.20226,-1.0125 -2.25,-2.25 z M 1436,306.5 c -0.6847,-0.825 -1.0199,-1.5 -0.7449,-1.5 0.275,0 1.0602,0.675 1.7449,1.5 0.6847,0.825 1.0199,1.5 0.7449,1.5 -0.275,0 -1.0602,-0.675 -1.7449,-1.5 z M 387.75,306.33772 c 0.6875,-0.27741 1.8125,-0.27741 2.5,0 0.6875,0.27741 0.125,0.50439 -1.25,0.50439 -1.375,0 -1.9375,-0.22698 -1.25,-0.50439 z m 1094,0 c 0.6875,-0.27741 1.8125,-0.27741 2.5,0 0.6875,0.27741 0.125,0.50439 -1.25,0.50439 -1.375,0 -1.9375,-0.22698 -1.25,-0.50439 z M 918,300 v -4 h 8 8 v 4 4 h -8 -8 z m 40,0 v -4 h 8 8 v 4 4 h -8 -8 z m 40,0 v -4 h 8 8 v 4 4 h -8 -8 z m -80,-26 c 0,-1.83333 0.66667,-2 8,-2 7.33333,0 8,0.16667 8,2 0,1.83333 -0.66667,2 -8,2 -7.33333,0 -8,-0.16667 -8,-2 z m 40,0 c 0,-1.83333 0.66667,-2 8,-2 7.33333,0 8,0.16667 8,2 0,1.83333 -0.66667,2 -8,2 -7.33333,0 -8,-0.16667 -8,-2 z m 40,0 c 0,-1.83333 0.66667,-2 8,-2 7.3333,0 8,0.16667 8,2 0,1.83333 -0.6667,2 -8,2 -7.33333,0 -8,-0.16667 -8,-2 z m -80,-10 v -4 h 8 8 v 4 4 h -8 -8 z m 40,0 v -4 h 8 8 v 4 4 h -8 -8 z m 40,0 v -4 h 8 8 v 4 4 h -8 -8 z m -80,-26 c 0,-1.83333 0.66667,-2 8,-2 7.33333,0 8,0.16667 8,2 0,1.83333 -0.66667,2 -8,2 -7.33333,0 -8,-0.16667 -8,-2 z m 40,0 c 0,-1.83333 0.66667,-2 8,-2 7.33333,0 8,0.16667 8,2 0,1.83333 -0.66667,2 -8,2 -7.33333,0 -8,-0.16667 -8,-2 z m 40,0 c 0,-1.83333 0.66667,-2 8,-2 7.3333,0 8,0.16667 8,2 0,1.83333 -0.6667,2 -8,2 -7.33333,0 -8,-0.16667 -8,-2 z m -80,-10 v -4 h 8 8 v 4 4 h -8 -8 z m 40,0 v -4 h 8 8 v 4 4 h -8 -8 z m 40,0 v -4 h 8 8 v 4 4 h -8 -8 z m -80,-26 c 0,-1.83333 0.66667,-2 8,-2 7.33333,0 8,0.16667 8,2 0,1.83333 -0.66667,2 -8,2 -7.33333,0 -8,-0.16667 -8,-2 z m 40,0 c 0,-1.83333 0.66667,-2 8,-2 7.33333,0 8,0.16667 8,2 0,1.83333 -0.66667,2 -8,2 -7.33333,0 -8,-0.16667 -8,-2 z m 40,0 c 0,-1.83333 0.66667,-2 8,-2 7.3333,0 8,0.16667 8,2 0,1.83333 -0.6667,2 -8,2 -7.33333,0 -8,-0.16667 -8,-2 z m -80,-10 v -4 h 8 8 v 4 4 h -8 -8 z m 40,0 v -4 h 8 8 v 4 4 h -8 -8 z m 40,0 v -4 h 8 8 v 4 4 h -8 -8 z m -80,-26 c 0,-1.83333 0.66667,-2 8,-2 7.33333,0 8,0.16667 8,2 0,1.83333 -0.66667,2 -8,2 -7.33333,0 -8,-0.16667 -8,-2 z m 40,0 c 0,-1.83333 0.66667,-2 8,-2 7.33333,0 8,0.16667 8,2 0,1.83333 -0.66667,2 -8,2 -7.33333,0 -8,-0.16667 -8,-2 z m 40,0 c 0,-1.83333 0.66667,-2 8,-2 7.3333,0 8,0.16667 8,2 0,1.83333 -0.6667,2 -8,2 -7.33333,0 -8,-0.16667 -8,-2 z m -80,-10 v -4 h 8 8 v 4 4 h -8 -8 z m 40,0 v -4 h 8 8 v 4 4 h -8 -8 z m 40,0 v -4 h 8 8 v 4 4 h -8 -8 z m -80,-26 c 0,-1.83333 0.66667,-2 8,-2 7.33333,0 8,0.16667 8,2 0,1.83333 -0.66667,2 -8,2 -7.33333,0 -8,-0.16667 -8,-2 z m 40,0 c 0,-1.83333 0.66667,-2 8,-2 7.33333,0 8,0.16667 8,2 0,1.83333 -0.66667,2 -8,2 -7.33333,0 -8,-0.16667 -8,-2 z m 40,0 c 0,-1.83333 0.66667,-2 8,-2 7.3333,0 8,0.16667 8,2 0,1.83333 -0.6667,2 -8,2 -7.33333,0 -8,-0.16667 -8,-2 z m -80,-10 v -4 h 8 8 v 4 4 h -8 -8 z m 40,0 v -4 h 8 8 v 4 4 h -8 -8 z m 40,0 v -4 h 8 8 v 4 4 h -8 -8 z M 918,94 c 0,-1.833333 0.66667,-2 8,-2 7.33333,0 8,0.166667 8,2 0,1.833333 -0.66667,2 -8,2 -7.33333,0 -8,-0.166667 -8,-2 z m 40,0 c 0,-1.833333 0.66667,-2 8,-2 7.33333,0 8,0.166667 8,2 0,1.833333 -0.66667,2 -8,2 -7.33333,0 -8,-0.166667 -8,-2 z m 40,0 c 0,-1.833333 0.66667,-2 8,-2 7.3333,0 8,0.166667 8,2 0,1.833333 -0.6667,2 -8,2 -7.33333,0 -8,-0.166667 -8,-2 z M 918,84 v -4 h 8 8 v 4 4 h -8 -8 z m 40,0 v -4 h 8 8 v 4 4 h -8 -8 z m 40,0 v -4 h 8 8 v 4 4 h -8 -8 z"  ,
            "M 4.5739313,406 C 6.1329087,390.62752 17.222484,379.98335 32.5,379.19556 c 6.349167,-0.3274 7.623849,-0.0454 13.709769,3.03352 l 6.709769,3.39448 1.998297,-6.56178 c 5.136604,-16.86699 17.015502,-29.38079 34.72114,-36.5769 5.16164,-2.09785 5.86426,-2.74348 6.936094,-6.37356 5.154111,-17.45591 23.527961,-28.88239 41.762181,-25.97142 8.34594,1.33237 14.35275,4.46572 20.73472,10.81589 l 5.57197,5.54421 3.32907,-2.25213 c 6.54497,-4.42769 14.65489,-5.09439 22.18665,-1.8239 1.18896,0.51628 1.85615,0.10158 2.35247,-1.46219 1.05757,-3.33211 7.39525,-9.87388 11.68701,-12.06337 7.23167,-3.68932 14.39827,-4.13543 23.30086,-1.45042 1.67658,0.50565 2.39169,-0.30815 4.42215,-5.03249 3.27759,-7.62603 10.43307,-14.74295 18.80259,-18.70124 6.07019,-2.87084 7.71185,-3.20318 15.77526,-3.19355 7.71529,0.009 9.8465,0.40492 14.93013,2.77216 7.35743,3.42605 13.31091,8.25668 16.54026,13.42071 l 2.47038,3.95037 9.02962,-0.0438 c 7.41544,-0.036 9.85838,0.36168 13.66573,2.22462 6.52502,3.1927 12.10496,8.24858 14.88295,13.48514 2.17316,4.09644 2.64122,4.43724 5.46495,3.97901 5.13645,-0.83353 11.65968,1.52475 15.56677,5.62771 l 3.55078,3.72879 3.79778,-4.36579 c 5.1783,-5.95279 12.42156,-9.47438 20.71688,-10.07229 9.02781,-0.65072 15.4615,1.59319 22.11856,7.71438 l 5.17953,4.76259 4.44007,-1.96406 c 3.00957,-1.33128 5.68986,-1.79642 8.31925,-1.44375 3.65414,0.49013 3.9889,0.30808 5.77025,-3.13807 2.68961,-5.20323 9.71564,-11.67993 15.55611,-14.33986 6.95882,-3.16927 17.97335,-3.16151 25.09189,0.0177 6.89689,3.08019 13.92869,10.43489 16.85081,17.62461 l 2.36103,5.80918 9.59878,-0.19361 c 5.27933,-0.10648 10.07704,0.10197 10.66157,0.46324 0.61329,0.37903 -0.5943,1.87548 -2.85512,3.53811 -3.07459,2.26107 -5.41383,3.0203 -10.86758,3.52717 l -6.94967,0.6459 -1.30921,-4.36976 c -4.02335,-13.42874 -18.85899,-23.02547 -33.26717,-21.51952 -10.13485,1.0593 -20.27562,7.78121 -24.67467,16.35585 -1.81846,3.54454 -2.06491,3.66981 -6.76394,3.438 -3.21294,-0.1585 -6.11836,0.40028 -8.51608,1.63783 l -3.63936,1.8784 -4.25534,-4.31809 C 404.74267,326.05322 397.13098,323 389.14063,323 c -8.81293,0 -14.67534,2.46351 -21.21261,8.91399 l -5.66117,5.58601 -2.32695,-2.89183 c -3.28645,-4.08428 -10.22613,-6.94873 -15.41711,-6.36363 -4.07398,0.4592 -4.23458,0.3627 -6.49832,-3.90448 -2.88192,-5.43248 -8.83317,-10.90017 -14.90207,-13.69122 -3.56971,-1.6417 -6.63508,-2.13634 -13.46018,-2.17197 l -8.83777,-0.0462 -3.41786,-4.70973 C 290.60953,294.35478 278.11638,288 266.5,288 c -7.13081,0 -16.96947,3.24874 -22.74437,7.51023 -5.62304,4.14943 -11.28119,11.49825 -12.92054,16.78125 -0.87243,2.81152 -1.58413,3.63506 -2.75357,3.18631 -13.86254,-5.31956 -28.24371,0.0421 -36.08698,13.45405 -0.69326,1.18547 -1.51606,1.22849 -4.78196,0.25 -7.07459,-2.1196 -14.51841,-0.90988 -19.65288,3.19386 l -2.65786,2.1243 -6.24982,-6.10291 c -8.11829,-7.92746 -14.86653,-10.68447 -26.15202,-10.68447 -5.8209,0 -9.5382,0.59299 -13.64709,2.17703 -9.85759,3.80025 -18.83585,13.36668 -22.22847,23.68467 -1.598023,4.86007 -1.896764,5.14628 -7.075558,6.77875 -15.31023,4.82612 -30.615041,21.10102 -35.129657,37.35632 l -1.724546,6.20939 -2.781269,-1.98044 c -6.42973,-4.57837 -16.855946,-6.19291 -25.138154,-3.89273 -7.540377,2.09415 -17.1209318,11.94164 -19.76831,20.3191 C 4.1852701,410.96485 4.1113608,410.56123 4.5739313,406 Z M 1867,409.46016 c 0,-2.36037 -3.6559,-8.99868 -7.1433,-12.97058 -9.1835,-10.45943 -25.0776,-12.59415 -36.9649,-4.96469 l -3.6082,2.3158 -1.7137,-6.17034 c -4.5035,-16.2155 -19.8253,-32.49643 -35.1188,-37.31728 -5.1788,-1.63247 -5.4775,-1.91868 -7.0755,-6.77875 -3.3927,-10.31799 -12.3709,-19.88442 -22.2285,-23.68467 -4.1089,-1.58404 -7.8262,-2.17703 -13.6471,-2.17703 -11.2855,0 -18.0337,2.75701 -26.152,10.68447 l -6.2498,6.10291 -2.6579,-2.1243 c -5.1345,-4.10374 -12.5783,-5.31346 -19.6529,-3.19386 -3.2659,0.97849 -4.0887,0.93547 -4.7819,-0.25 -6.5917,-11.27181 -18.7592,-17.43715 -29.7577,-15.0784 -2.6138,0.56055 -5.4619,1.2915 -6.3293,1.62435 -1.1695,0.44875 -1.8812,-0.37479 -2.7536,-3.18631 -2.9015,-9.35059 -13.1479,-18.8575 -24.0202,-22.28688 -15.7846,-4.97878 -33.0149,0.57538 -42.5513,13.71639 l -3.4178,4.70973 -8.8378,0.0462 c -6.8251,0.0356 -9.8905,0.53027 -13.4602,2.17197 -6.0689,2.79105 -12.0201,8.25874 -14.9021,13.69122 -2.2637,4.26718 -2.4243,4.36368 -6.4983,3.90448 -5.191,-0.5851 -12.1306,2.27935 -15.4171,6.36363 l -2.3269,2.89183 -5.6612,-5.58601 C 1497.5347,325.46351 1491.6723,323 1482.8594,323 c -7.9904,0 -15.6021,3.05322 -20.8253,8.3535 l -4.2554,4.31809 -3.6393,-1.8784 c -2.3978,-1.23755 -5.3032,-1.79633 -8.5161,-1.63783 -4.6991,0.23181 -4.9455,0.10654 -6.764,-3.438 -4.5554,-8.87949 -14.4301,-15.23729 -25.5782,-16.46847 L 1406.5,311.5 l -0.3189,-3.89244 -0.3188,-3.89244 6.38,0.51214 c 3.5091,0.28167 8.6026,1.49229 11.3189,2.69028 5.7461,2.53417 12.79,9.00802 15.4949,14.24085 1.7814,3.44615 2.1161,3.6282 5.7703,3.13807 2.6293,-0.35267 5.3096,0.11247 8.3192,1.44375 l 4.4401,1.96406 5.1795,-4.76259 c 6.6571,-6.12119 13.0908,-8.3651 22.1186,-7.71438 8.2953,0.59791 15.5385,4.1195 20.7168,10.07229 l 3.7978,4.36579 3.5508,-3.72879 c 3.9071,-4.10296 10.4303,-6.46124 15.5668,-5.62771 2.8237,0.45823 3.2918,0.11743 5.4649,-3.97901 2.778,-5.23656 8.358,-10.29244 14.883,-13.48514 3.8073,-1.86294 6.2503,-2.26063 13.6657,-2.22462 l 9.0296,0.0438 2.4704,-3.95037 c 3.2294,-5.16403 9.1828,-9.99466 16.5403,-13.42071 5.0836,-2.36724 7.2148,-2.76295 14.9301,-2.77216 8.0634,-0.01 9.7051,0.32271 15.7753,3.19355 8.3695,3.95829 15.525,11.07521 18.8025,18.70124 2.0305,4.72434 2.7456,5.53814 4.4222,5.03249 8.9026,-2.68501 16.0692,-2.2389 23.3009,1.45042 4.2917,2.18949 10.6294,8.73126 11.687,12.06337 0.4963,1.56377 1.1635,1.97847 2.3524,1.46219 7.5318,-3.27049 15.6417,-2.60379 22.1867,1.8239 l 3.3291,2.25213 5.5719,-5.54421 c 6.382,-6.35017 12.3888,-9.48352 20.7348,-10.81589 18.2342,-2.91097 36.608,8.51551 41.7621,25.97142 1.0719,3.63008 1.7745,4.27571 6.9361,6.37356 17.7057,7.19611 29.5846,19.70991 34.7212,36.5769 l 1.9983,6.56178 6.7097,-3.39448 c 6.086,-3.07888 7.3606,-3.36092 13.7098,-3.03352 15.1064,0.77897 26.0186,11.10459 28.063,26.55444 0.3821,2.8875 0.4117,5.25 0.066,5.25 -0.3458,0 -0.6288,-0.69293 -0.6288,-1.53984 z M 501.76166,321.29274 c 1.24391,-0.23919 3.04391,-0.23011 4,0.0202 0.95609,0.25029 -0.0617,0.446 -2.26166,0.4349 -2.2,-0.0111 -2.98225,-0.21589 -1.73834,-0.45508 z M 128.8125,301.31689 c 0.72187,-0.28887 1.58437,-0.25335 1.91667,0.0789 0.33229,0.33229 -0.25834,0.56864 -1.3125,0.52522 -1.16495,-0.048 -1.4019,-0.28494 -0.60417,-0.60416 z m 6,0 c 0.72187,-0.28887 1.58437,-0.25335 1.91667,0.0789 0.33229,0.33229 -0.25834,0.56864 -1.3125,0.52522 -1.16495,-0.048 -1.4019,-0.28494 -0.60417,-0.60416 z m 1601,0 c 0.7219,-0.28887 1.5844,-0.25335 1.9167,0.0789 0.3323,0.33229 -0.2584,0.56864 -1.3125,0.52522 -1.165,-0.048 -1.4019,-0.28494 -0.6042,-0.60416 z m 6,0 c 0.7219,-0.28887 1.5844,-0.25335 1.9167,0.0789 0.3323,0.33229 -0.2584,0.56864 -1.3125,0.52522 -1.165,-0.048 -1.4019,-0.28494 -0.6042,-0.60416 z m -1528,-4 c 0.72187,-0.28887 1.58437,-0.25335 1.91667,0.0789 0.33229,0.33229 -0.25834,0.56864 -1.3125,0.52522 -1.16495,-0.048 -1.4019,-0.28494 -0.60417,-0.60416 z m 1443,0 c 0.7219,-0.28887 1.5844,-0.25335 1.9167,0.0789 0.3323,0.33229 -0.2584,0.56864 -1.3125,0.52522 -1.165,-0.048 -1.4019,-0.28494 -0.6042,-0.60416 z M 236,284.5 c 1.29175,-1.375 2.57363,-2.5 2.84863,-2.5 0.275,0 -0.55688,1.125 -1.84863,2.5 -1.29175,1.375 -2.57363,2.5 -2.84863,2.5 -0.275,0 0.55688,-1.125 1.84863,-2.5 z m 1398.9243,-0.25 -2.4243,-2.75 2.75,2.42431 c 2.5703,2.26589 3.2086,3.07569 2.4243,3.07569 -0.1791,0 -1.4166,-1.2375 -2.75,-2.75 z M 930.22178,26.25 930.5,12.5 933.75,12.186642 937,11.873283 V 25.936642 40 h -3.52822 -3.52822 z M 942,26 V 12 h 3.5 3.5 v 14 14 h -3.5 -3.5 z m 12,0 V 12 h 3.5 3.5 v 14 14 h -3.5 -3.5 z m 12,0 V 12 h 3.5 3.5 v 14 14 h -3.5 -3.5 z m 12,0 V 12 h 3.5 3.5 v 14 14 h -3.5 -3.5 z m 12,-0.0499 V 11.900196 l 5.75,0.299904 5.75,0.299904 0.2782,13.75 0.2782,13.75 h -6.02818 L 990,40 V 25.950096 Z"  ,
            "m 1310,410 c 0,-1.85965 0.6667,-2 9.5,-2 8.8333,0 9.5,0.14035 9.5,2 0,1.85965 -0.6667,2 -9.5,2 -8.8333,0 -9.5,-0.14035 -9.5,-2 z M 526.34941,396 c 0,-4.675 0.17226,-6.5875 0.3828,-4.25 0.21053,2.3375 0.21053,6.1625 0,8.5 -0.21054,2.3375 -0.3828,0.425 -0.3828,-4.25 z m 84.04798,-6 c 0,-7.975 0.1553,-11.2375 0.34512,-7.25 0.18981,3.9875 0.18981,10.5125 0,14.5 -0.18982,3.9875 -0.34512,0.725 -0.34512,-7.25 z m 19.95202,6 c 0,-4.675 0.17226,-6.5875 0.3828,-4.25 0.21053,2.3375 0.21053,6.1625 0,8.5 -0.21054,2.3375 -0.3828,0.425 -0.3828,-4.25 z m 675.03909,-4.5 c 0,-7.15 0.1611,-9.94379 0.354,-6.20841 0.1929,3.73537 0.1915,9.58537 0,13 -0.1947,3.41462 -0.3525,0.35841 -0.3508,-6.79159 z M 1310,402 c 0,-1.85965 0.6667,-2 9.5,-2 8.8333,0 9.5,0.14035 9.5,2 0,1.85965 -0.6667,2 -9.5,2 -8.8333,0 -9.5,-0.14035 -9.5,-2 z m 83.4705,-60 c 0,-34.375 0.1255,-48.4375 0.279,-31.25 0.1534,17.1875 0.1534,45.3125 0,62.5 -0.1535,17.1875 -0.279,3.125 -0.279,-31.25 z M 1310,394 c 0,-1.85965 0.6667,-2 9.5,-2 8.8333,0 9.5,0.14035 9.5,2 0,1.85965 -0.6667,2 -9.5,2 -8.8333,0 -9.5,-0.14035 -9.5,-2 z m 0,-10.91667 c 0,-2.95555 0.4986,-5.14934 1.25,-5.5 1,-0.46666 1,-0.7 0,-1.16666 -0.8768,-0.40915 -1.25,-3.54445 -1.25,-10.5 V 356 h 9.5 9.5 v 16 16 h -9.5 -9.5 z M 1318,374 c 0,-1.46667 -0.6667,-2 -2.5,-2 -1.8333,0 -2.5,0.53333 -2.5,2 0,1.46667 0.6667,2 2.5,2 1.8333,0 2.5,-0.53333 2.5,-2 z m -791,6 v -4 h 39.5 39.5 v 4 4 H 566.5 527 Z m 104,0 v -4 h 65.5 65.5 v 4 4 H 696.5 631 Z m 674.3854,-16 c 0,-6.875 0.1597,-9.6875 0.355,-6.25 0.1953,3.4375 0.1953,9.0625 0,12.5 -0.1953,3.4375 -0.355,0.625 -0.355,-6.25 z M 526.43244,324 c 0,-13.475 0.14155,-18.9875 0.31456,-12.25 0.17301,6.7375 0.17301,17.7625 0,24.5 -0.17301,6.7375 -0.31456,1.225 -0.31456,-12.25 z m 68,0 c 0,-13.475 0.14155,-18.9875 0.31456,-12.25 0.17301,6.7375 0.17301,17.7625 0,24.5 -0.17301,6.7375 -0.31456,1.225 -0.31456,-12.25 z m -68.11237,-42 c 0,-3.575 0.1815,-5.0375 0.40333,-3.25 0.22182,1.7875 0.22182,4.7125 0,6.5 -0.22183,1.7875 -0.40333,0.325 -0.40333,-3.25 z m 20,0 c 0,-3.575 0.1815,-5.0375 0.40333,-3.25 0.22182,1.7875 0.22182,4.7125 0,6.5 -0.22183,1.7875 -0.40333,0.325 -0.40333,-3.25 z m 16,0 c 0,-3.575 0.1815,-5.0375 0.40333,-3.25 0.22182,1.7875 0.22182,4.7125 0,6.5 -0.22183,1.7875 -0.40333,0.325 -0.40333,-3.25 z m 16,0 c 0,-3.575 0.1815,-5.0375 0.40333,-3.25 0.22182,1.7875 0.22182,4.7125 0,6.5 -0.22183,1.7875 -0.40333,0.325 -0.40333,-3.25 z m 16,0 c 0,-3.575 0.1815,-5.0375 0.40333,-3.25 0.22182,1.7875 0.22182,4.7125 0,6.5 -0.22183,1.7875 -0.40333,0.325 -0.40333,-3.25 z m 16,0 c 0,-3.575 0.1815,-5.0375 0.40333,-3.25 0.22182,1.7875 0.22182,4.7125 0,6.5 -0.22183,1.7875 -0.40333,0.325 -0.40333,-3.25 z m 16,0 c 0,-3.575 0.1815,-5.0375 0.40333,-3.25 0.22182,1.7875 0.22182,4.7125 0,6.5 -0.22183,1.7875 -0.40333,0.325 -0.40333,-3.25 z m 16,0 c 0,-3.575 0.1815,-5.0375 0.40333,-3.25 0.22182,1.7875 0.22182,4.7125 0,6.5 -0.22183,1.7875 -0.40333,0.325 -0.40333,-3.25 z m 16,0 c 0,-3.575 0.1815,-5.0375 0.40333,-3.25 0.22182,1.7875 0.22182,4.7125 0,6.5 -0.22183,1.7875 -0.40333,0.325 -0.40333,-3.25 z m 734.83783,-8 c 0,-1.375 0.227,-1.9375 0.5044,-1.25 0.2774,0.6875 0.2774,1.8125 0,2.5 -0.2774,0.6875 -0.5044,0.125 -0.5044,-1.25 z m 0.2121,-16 c 0,-5.775 0.1652,-8.1375 0.3672,-5.25 0.202,2.8875 0.202,7.6125 0,10.5 -0.202,2.8875 -0.3672,0.525 -0.3672,-5.25 z m -91.3343,-23.38472 c 0.8054,-0.76159 10.156,-9.09636 20.7792,-18.52171 l 19.3148,-17.13699 2.8298,2.27171 c 1.5563,1.24944 10.918,9.47171 20.8038,18.27171 l 17.9741,16 -3.8856,0.30832 c -3.7026,0.29381 -4.5325,-0.26794 -17.6187,-11.92668 -7.5532,-6.72926 -15.0903,-13.49175 -16.7492,-15.02776 l -3.016,-2.79275 -16.8694,14.96944 C 1309.7217,235.11925 1308.4891,236 1304.6503,236 c -3.5131,0 -3.8757,-0.19209 -2.6146,-1.38472 z M 1397,231.5 c -0.6847,-0.825 -1.0199,-1.5 -0.7449,-1.5 0.275,0 1.0602,0.675 1.7449,1.5 0.6847,0.825 1.0199,1.5 0.7449,1.5 -0.275,0 -1.0602,-0.675 -1.7449,-1.5 z m -9,-8 c -0.6847,-0.825 -1.0199,-1.5 -0.7449,-1.5 0.275,0 1.0602,0.675 1.7449,1.5 0.6847,0.825 1.0199,1.5 0.7449,1.5 -0.275,0 -1.0602,-0.675 -1.7449,-1.5 z m -89.5,-2.5 c 0.9955,-1.1 2.035,-2 2.31,-2 0.275,0 -0.3145,0.9 -1.31,2 -0.9955,1.1 -2.035,2 -2.31,2 -0.275,0 0.3145,-0.9 1.31,-2 z"  ,
            "M 890,227.99371 V 51.987428 l 75.75,0.256286 75.75,0.256286 0.2528,175.75 0.2528,175.75 H 966.00279 890 Z M 906,226 c 0,-161.333333 -0.008,-162 -2,-162 -1.99177,0 -2,0.666667 -2,162 0,161.33333 0.008,162 2,162 1.99177,0 2,-0.66667 2,-162 z m 32,150 v -12 h -12 -12 v 12 12 h 12 12 z m 40,0 v -12 h -12 -12 v 12 12 h 12 12 z m 40,0 v -12 h -12 -12 v 12 12 h 12 12 z m 12,-150 V 64 h -2.5 -2.5 v 162 162 h 2.5 2.5 z m -92,114 v -12 h -12 -12 v 12 12 h 12 12 z m 40,0 v -12 h -12 -12 v 12 12 h 12 12 z m 40,0 v -12 h -12 -12 v 12 12 h 12 12 z m -80,-36 v -12 h -12 -12 v 12 12 h 12 12 z m 40,0 v -12 h -12 -12 v 12 12 h 12 12 z m 40,0 v -12 h -12 -12 v 12 12 h 12 12 z m -80,-36 v -12 h -12 -12 v 12 12 h 12 12 z m 40,0 v -12 h -12 -12 v 12 12 h 12 12 z m 40,0 v -12 h -12 -12 v 12 12 h 12 12 z m -80,-36 v -12 h -12 -12 v 12 12 h 12 12 z m 40,0 v -12 h -12 -12 v 12 12 h 12 12 z m 40,0 v -12 h -12 -12 v 12 12 h 12 12 z m -80,-36 v -12 h -12 -12 v 12 12 h 12 12 z m 40,0 v -12 h -12 -12 v 12 12 h 12 12 z m 40,0 v -12 h -12 -12 v 12 12 h 12 12 z m -80,-36 v -12 h -12 -12 v 12 12 h 12 12 z m 40,0 v -12 h -12 -12 v 12 12 h 12 12 z m 40,0 v -12 h -12 -12 v 12 12 h 12 12 z m -80,-36 v -12 h -12 -12 v 12 12 h 12 12 z m 40,0 v -12 h -12 -12 v 12 12 h 12 12 z m 40,0 v -12 h -12 -12 v 12 12 h 12 12 z M 938,88 V 76 h -12 -12 v 12 12 h 12 12 z m 40,0 V 76 h -12 -12 v 12 12 h 12 12 z m 40,0 V 76 h -12 -12 v 12 12 h 12 12 z M 9.5,381 c 0.995486,-1.1 2.034975,-2 2.309975,-2 0.275,0 -0.314489,0.9 -1.309975,2 -0.9954863,1.1 -2.0349751,2 -2.3099751,2 -0.275,0 0.3144888,-0.9 1.3099751,-2 z m 1851.905,-0.25 -1.905,-2.25 2.25,1.90499 c 2.1144,1.79022 2.7052,2.59501 1.905,2.59501 -0.1898,0 -1.2023,-1.0125 -2.25,-2.25 z M 62,352.62244 c 0,-0.20765 0.7875,-0.99515 1.75,-1.75 1.586056,-1.24387 1.621426,-1.2085 0.377555,0.37756 C 62.821186,352.91575 62,353.44548 62,352.62244 Z M 1808,351.5 c -0.6847,-0.825 -1.0199,-1.5 -0.7449,-1.5 0.275,0 1.0602,0.675 1.7449,1.5 0.6847,0.825 1.0199,1.5 0.7449,1.5 -0.275,0 -1.0602,-0.675 -1.7449,-1.5 z M 67,347.62244 c 0,-0.20765 0.7875,-0.99515 1.75,-1.75 1.586056,-1.24387 1.621426,-1.2085 0.377555,0.37756 C 67.821186,347.91575 67,348.44548 67,347.62244 Z M 1803,346.5 c -0.6847,-0.825 -1.0199,-1.5 -0.7449,-1.5 0.275,0 1.0602,0.675 1.7449,1.5 0.6847,0.825 1.0199,1.5 0.7449,1.5 -0.275,0 -1.0602,-0.675 -1.7449,-1.5 z M 501.73097,337.34406 c 0.67703,-0.27392 2.02703,-0.29059 3,-0.0371 0.97297,0.25354 0.41903,0.47766 -1.23097,0.49804 -1.65,0.0204 -2.44606,-0.18706 -1.76903,-0.46099 z m -140.12796,-8.17739 c -0.28327,-0.45834 0.12038,-0.83334 0.89699,-0.83334 0.77661,0 1.18026,0.375 0.89699,0.83334 C 363.11373,329.625 362.71008,330 362.5,330 c -0.21008,0 -0.61373,-0.375 -0.89699,-0.83333 z m 139.66074,0.11575 c 1.52006,-0.22986 3.77006,-0.22371 5,0.0136 1.22994,0.23736 -0.0138,0.42542 -2.76375,0.41792 -2.75,-0.008 -3.75631,-0.20172 -2.23625,-0.43157 z M 1508.603,329.16667 c -0.2833,-0.45834 0.1204,-0.83334 0.897,-0.83334 0.7766,0 1.1803,0.375 0.897,0.83334 -0.2833,0.45833 -0.6869,0.83333 -0.897,0.83333 -0.2101,0 -0.6137,-0.375 -0.897,-0.83333 z M 410.40499,323.75 408.5,321.5 l 2.25,1.90499 c 1.2375,1.04774 2.25,2.06024 2.25,2.25 0,0.80025 -0.80479,0.20945 -2.59501,-1.90499 z M 1460.5,324 c 0.9955,-1.1 2.035,-2 2.31,-2 0.275,0 -0.3145,0.9 -1.31,2 -0.9955,1.1 -2.035,2 -2.31,2 -0.275,0 0.3145,-0.9 1.31,-2 z M 366,324.62244 c 0,-0.20765 0.7875,-0.99515 1.75,-1.75 1.58606,-1.24387 1.62143,-1.2085 0.37756,0.37756 C 366.82119,324.91575 366,325.44548 366,324.62244 Z M 1504,323.5 c -0.6847,-0.825 -1.0199,-1.5 -0.7449,-1.5 0.275,0 1.0602,0.675 1.7449,1.5 0.6847,0.825 1.0199,1.5 0.7449,1.5 -0.275,0 -1.0602,-0.675 -1.7449,-1.5 z M 437,322.62244 c 0,-0.20765 0.7875,-0.99515 1.75,-1.75 1.58606,-1.24387 1.62143,-1.2085 0.37756,0.37756 C 437.82119,322.91575 437,323.44548 437,322.62244 Z M 483,321.5 c -0.68469,-0.825 -1.01989,-1.5 -0.74489,-1.5 0.275,0 1.0602,0.675 1.74489,1.5 0.68469,0.825 1.01989,1.5 0.74489,1.5 -0.275,0 -1.0602,-0.675 -1.74489,-1.5 z m 950,0 c -0.6847,-0.825 -1.0199,-1.5 -0.7449,-1.5 0.275,0 1.0602,0.675 1.7449,1.5 0.6847,0.825 1.0199,1.5 0.7449,1.5 -0.275,0 -1.0602,-0.675 -1.7449,-1.5 z M 130.76166,317.29274 c 1.24391,-0.23919 3.04391,-0.23011 4,0.0202 0.95609,0.25029 -0.0617,0.446 -2.26166,0.4349 -2.2,-0.0111 -2.98225,-0.21589 -1.73834,-0.45508 z m 1607.00004,0 c 1.2439,-0.23919 3.0439,-0.23011 4,0.0202 0.956,0.25029 -0.062,0.446 -2.2617,0.4349 -2.2,-0.0111 -2.9823,-0.21589 -1.7383,-0.45508 z M 438,313.5 c 1.29175,-1.375 2.57363,-2.5 2.84863,-2.5 0.275,0 -0.55688,1.125 -1.84863,2.5 -1.29175,1.375 -2.57363,2.5 -2.84863,2.5 -0.275,0 0.55688,-1.125 1.84863,-2.5 z m 44.92431,-0.25 -2.42431,-2.75 2.75,2.42431 c 2.57029,2.26589 3.20859,3.07569 2.42431,3.07569 -0.17912,0 -1.41662,-1.2375 -2.75,-2.75 z m 949.99999,0 -2.4243,-2.75 2.75,2.42431 c 1.5125,1.33338 2.75,2.57088 2.75,2.75 0,0.78428 -0.8098,0.14598 -3.0757,-2.42431 z M 196,314.62244 c 0,-0.20765 0.7875,-0.99515 1.75,-1.75 1.58606,-1.24387 1.62143,-1.2085 0.37756,0.37756 C 196.82119,314.91575 196,315.44548 196,314.62244 Z M 1674,313.5 c -0.6847,-0.825 -1.0199,-1.5 -0.7449,-1.5 0.275,0 1.0602,0.675 1.7449,1.5 0.6847,0.825 1.0199,1.5 0.7449,1.5 -0.275,0 -1.0602,-0.675 -1.7449,-1.5 z M 215.25,313.31067 c 0.9625,-0.25152 2.5375,-0.25152 3.5,0 0.9625,0.25153 0.175,0.45733 -1.75,0.45733 -1.925,0 -2.7125,-0.2058 -1.75,-0.45733 z m 1438,0 c 0.9625,-0.25152 2.5375,-0.25152 3.5,0 0.9625,0.25153 0.175,0.45733 -1.75,0.45733 -1.925,0 -2.7125,-0.2058 -1.75,-0.45733 z M 128.8125,309.31689 c 0.72187,-0.28887 1.58437,-0.25335 1.91667,0.0789 0.33229,0.33229 -0.25834,0.56864 -1.3125,0.52522 -1.16495,-0.048 -1.4019,-0.28494 -0.60417,-0.60416 z m 6,0 c 0.72187,-0.28887 1.58437,-0.25335 1.91667,0.0789 0.33229,0.33229 -0.25834,0.56864 -1.3125,0.52522 -1.16495,-0.048 -1.4019,-0.28494 -0.60417,-0.60416 z m 1601,0 c 0.7219,-0.28887 1.5844,-0.25335 1.9167,0.0789 0.3323,0.33229 -0.2584,0.56864 -1.3125,0.52522 -1.165,-0.048 -1.4019,-0.28494 -0.6042,-0.60416 z m 6,0 c 0.7219,-0.28887 1.5844,-0.25335 1.9167,0.0789 0.3323,0.33229 -0.2584,0.56864 -1.3125,0.52522 -1.165,-0.048 -1.4019,-0.28494 -0.6042,-0.60416 z m -1528,-4 c 0.72187,-0.28887 1.58437,-0.25335 1.91667,0.0789 0.33229,0.33229 -0.25834,0.56864 -1.3125,0.52522 -1.16495,-0.048 -1.4019,-0.28494 -0.60417,-0.60416 z m 1443,0 c 0.7219,-0.28887 1.5844,-0.25335 1.9167,0.0789 0.3323,0.33229 -0.2584,0.56864 -1.3125,0.52522 -1.165,-0.048 -1.4019,-0.28494 -0.6042,-0.60416 z M 335.40499,302.75 333.5,300.5 l 2.25,1.90499 c 1.2375,1.04774 2.25,2.06024 2.25,2.25 0,0.80025 -0.80479,0.20945 -2.59501,-1.90499 z M 1535.5,303 c 0.9955,-1.1 2.035,-2 2.31,-2 0.275,0 -0.3145,0.9 -1.31,2 -0.9955,1.1 -2.035,2 -2.31,2 -0.275,0 0.3145,-0.9 1.31,-2 z M 131.8125,301.31689 c 0.72187,-0.28887 1.58437,-0.25335 1.91667,0.0789 0.33229,0.33229 -0.25834,0.56864 -1.3125,0.52522 -1.16495,-0.048 -1.4019,-0.28494 -0.60417,-0.60416 z m 1607,0 c 0.7219,-0.28887 1.5844,-0.25335 1.9167,0.0789 0.3323,0.33229 -0.2584,0.56864 -1.3125,0.52522 -1.165,-0.048 -1.4019,-0.28494 -0.6042,-0.60416 z m -1522,-4 c 0.72187,-0.28887 1.58437,-0.25335 1.91667,0.0789 0.33229,0.33229 -0.25834,0.56864 -1.3125,0.52522 -1.16495,-0.048 -1.4019,-0.28494 -0.60417,-0.60416 z m 1437,0 c 0.7219,-0.28887 1.5844,-0.25335 1.9167,0.0789 0.3323,0.33229 -0.2584,0.56864 -1.3125,0.52522 -1.165,-0.048 -1.4019,-0.28494 -0.6042,-0.60416 z M 937.39739,26 c 0,-7.975 0.1553,-11.2375 0.34512,-7.25 0.18981,3.9875 0.18981,10.5125 0,14.5 -0.18982,3.9875 -0.34512,0.725 -0.34512,-7.25 z m 12,0 c 0,-7.975 0.1553,-11.2375 0.34512,-7.25 0.18981,3.9875 0.18981,10.5125 0,14.5 -0.18982,3.9875 -0.34512,0.725 -0.34512,-7.25 z m 12,0 c 0,-7.975 0.1553,-11.2375 0.34512,-7.25 0.18981,3.9875 0.18981,10.5125 0,14.5 -0.18982,3.9875 -0.34512,0.725 -0.34512,-7.25 z m 12,0 c 0,-7.975 0.1553,-11.2375 0.34512,-7.25 0.18981,3.9875 0.18981,10.5125 0,14.5 -0.18982,3.9875 -0.34512,0.725 -0.34512,-7.25 z m 12,0 c 0,-7.975 0.1553,-11.2375 0.34512,-7.25 0.18981,3.9875 0.18981,10.5125 0,14.5 -0.18982,3.9875 -0.34512,0.725 -0.34512,-7.25 z"  ,
            "m 1054,396 v -8 h 111.5 111.5 v 8 8 H 1165.5 1054 Z m 275.1579,6 c 0,-1.375 0.227,-1.9375 0.5044,-1.25 0.2774,0.6875 0.2774,1.8125 0,2.5 -0.2774,0.6875 -0.5044,0.125 -0.5044,-1.25 z m 0,-8 c 0,-1.375 0.227,-1.9375 0.5044,-1.25 0.2774,0.6875 0.2774,1.8125 0,2.5 -0.2774,0.6875 -0.5044,0.125 -0.5044,-1.25 z m 0.1281,-10.5 c 0.01,-2.75 0.2017,-3.75631 0.4316,-2.23625 0.2298,1.52006 0.2237,3.77006 -0.014,5 -0.2373,1.22994 -0.4254,-0.0138 -0.4179,-2.76375 z M 526.27236,380 c 0,-2.475 0.19502,-3.4875 0.43337,-2.25 0.23836,1.2375 0.23836,3.2625 0,4.5 -0.23835,1.2375 -0.43337,0.225 -0.43337,-2.25 z m 104,0 c 0,-2.475 0.19502,-3.4875 0.43337,-2.25 0.23836,1.2375 0.23836,3.2625 0,4.5 -0.23835,1.2375 -0.43337,0.225 -0.43337,-2.25 z M 1054,366 v -10 h 10 10 v 10 10 h -10 -10 z m 24,0 v -10 h 10 10 v 10 10 h -10 -10 z m 24,0 v -10 h 8 8 v 10 10 h -8 -8 z m 20,0 v -10 h 10 10 v 10 10 h -10 -10 z m 24,0 v -10 h 10 10 v 10 10 h -10 -10 z m 24,0 v -10 h 10 10 v 10 10 h -10 -10 z m 24,0 v -10 h 8 8 v 10 10 h -8 -8 z m 20,0 v -10 h 10 10 v 10 10 h -10 -10 z m 24,0 v -10 h 10 10 v 10 10 h -10 -10 z m 24,0 v -10 h 8 8 v 10 10 h -8 -8 z m 51.1579,8 c 0,-1.375 0.227,-1.9375 0.5044,-1.25 0.2774,0.6875 0.2774,1.8125 0,2.5 -0.2774,0.6875 -0.5044,0.125 -0.5044,-1.25 z m 16.2121,-8 c 0,-5.775 0.1652,-8.1375 0.3672,-5.25 0.202,2.8875 0.202,7.6125 0,10.5 -0.202,2.8875 -0.3672,0.525 -0.3672,-5.25 z M 1054,342 v -10 h 10 10 v 10 10 h -10 -10 z m 24,0 v -10 h 10 10 v 10 10 h -10 -10 z m 24,0 v -10 h 8 8 v 10 10 h -8 -8 z m 20,0 v -10 h 10 10 v 10 10 h -10 -10 z m 24,0 v -10 h 10 10 v 10 10 h -10 -10 z m 24,0 v -10 h 10 10 v 10 10 h -10 -10 z m 24,0 v -10 h 8 8 v 10 10 h -8 -8 z m 20,0 v -10 h 10 10 v 10 10 h -10 -10 z m 24,0 v -10 h 10 10 v 10 10 h -10 -10 z m 24,0 v -10 h 8 8 v 10 10 h -8 -8 z m -208,-24 v -10 h 10 10 v 10 10 h -10 -10 z m 24,0 v -10 h 10 10 v 10 10 h -10 -10 z m 24,0 v -10 h 8 8 v 10 10 h -8 -8 z m 20,0 v -10 h 10 10 v 10 10 h -10 -10 z m 24,0 v -10 h 10 10 v 10 10 h -10 -10 z m 24,0 v -10 h 10 10 v 10 10 h -10 -10 z m 24,0 v -10 h 8 8 v 10 10 h -8 -8 z m 20,0 v -10 h 10 10 v 10 10 h -10 -10 z m 24,0 v -10 h 10 10 v 10 10 h -10 -10 z m 24,0 v -10 h 8 8 v 10 10 h -8 -8 z M 514.44225,293 c 0,-16.225 0.13752,-22.8625 0.30561,-14.75 0.16808,8.1125 0.16808,21.3875 0,29.5 -0.16809,8.1125 -0.30561,1.475 -0.30561,-14.75 z M 1054,296 v -8 h 10 10 v 8 8 h -10 -10 z m 24,0 v -8 h 10 10 v 8 8 h -10 -10 z m 24,0 v -8 h 8 8 v 8 8 h -8 -8 z m 20,0 v -8 h 10 10 v 8 8 h -10 -10 z m 24,0 v -8 h 10 10 v 8 8 h -10 -10 z m 24,0 v -8 h 10 10 v 8 8 h -10 -10 z m 24,0 v -8 h 8 8 v 8 8 h -8 -8 z m 20,0 v -8 h 10 10 v 8 8 h -10 -10 z m 24,0 v -8 h 10 10 v 8 8 h -10 -10 z m 24,0 v -8 h 8 8 v 8 8 h -8 -8 z m 143.4439,-30 c 0,-16.775 0.1368,-23.6375 0.3041,-15.25 0.1672,8.3875 0.1672,22.1125 0,30.5 -0.1673,8.3875 -0.3041,1.525 -0.3041,-15.25 z m -863.13403,16.5 c 0.006,-3.3 0.1923,-4.52944 0.41486,-2.73209 0.22256,1.79735 0.21797,4.49735 -0.0102,6 -0.22818,1.50265 -0.41027,0.0321 -0.40466,-3.26791 z m 16,0 c 0.006,-3.3 0.1923,-4.52944 0.41486,-2.73209 0.22256,1.79735 0.21797,4.49735 -0.0102,6 -0.22818,1.50265 -0.41027,0.0321 -0.40466,-3.26791 z m 16,0 c 0.006,-3.3 0.1923,-4.52944 0.41486,-2.73209 0.22256,1.79735 0.21797,4.49735 -0.0102,6 -0.22818,1.50265 -0.41027,0.0321 -0.40466,-3.26791 z M 1054,274 v -10 h 10 10 v 10 10 h -10 -10 z m 24,0 v -10 h 10 10 v 10 10 h -10 -10 z m 24,0 v -10 h 8 8 v 10 10 h -8 -8 z m 20,0 v -10 h 10 10 v 10 10 h -10 -10 z m 24,0 v -10 h 10 10 v 10 10 h -10 -10 z m 24,0 v -10 h 10 10 v 10 10 h -10 -10 z m 24,0 v -10 h 8 8 v 10 10 h -8 -8 z m 20,0 v -10 h 10 10 v 10 10 h -10 -10 z m 24,0 v -10 h 10 10 v 10 10 h -10 -10 z m 24,0 v -10 h 8 8 v 10 10 h -8 -8 z m -208,-24 v -10 h 10 10 v 10 10 h -10 -10 z m 24,0 v -10 h 10 10 v 10 10 h -10 -10 z m 24,0 v -10 h 8 8 v 10 10 h -8 -8 z m 20,0 v -10 h 10 10 v 10 10 h -10 -10 z m 24,0 v -10 h 10 10 v 10 10 h -10 -10 z m 24,0 v -10 h 10 10 v 10 10 h -10 -10 z m 24,0 v -10 h 8 8 v 10 10 h -8 -8 z m 20,0 v -10 h 10 10 v 10 10 h -10 -10 z m 24,0 v -10 h 10 10 v 10 10 h -10 -10 z m 24,0 v -10 h 8 8 v 10 10 h -8 -8 z m 118,-17.5 c -0.6847,-0.825 -1.0199,-1.5 -0.7449,-1.5 0.275,0 1.0602,0.675 1.7449,1.5 0.6847,0.825 1.0199,1.5 0.7449,1.5 -0.275,0 -1.0602,-0.675 -1.7449,-1.5 z M 1054,224 v -8 h 111.5 111.5 v 8 8 H 1165.5 1054 Z m 16,2 c 0,-1.7037 -0.6667,-2 -4.5,-2 -3.8333,0 -4.5,0.2963 -4.5,2 0,1.7037 0.6667,2 4.5,2 3.8333,0 4.5,-0.2963 4.5,-2 z m 24,0 c 0,-1.7037 -0.6667,-2 -4.5,-2 -3.8333,0 -4.5,0.2963 -4.5,2 0,1.7037 0.6667,2 4.5,2 3.8333,0 4.5,-0.2963 4.5,-2 z m 24,0 c 0,-1.7037 -0.6667,-2 -4.5,-2 -3.8333,0 -4.5,0.2963 -4.5,2 0,1.7037 0.6667,2 4.5,2 3.8333,0 4.5,-0.2963 4.5,-2 z m 24,0 c 0,-1.7037 -0.6667,-2 -4.5,-2 -3.8333,0 -4.5,0.2963 -4.5,2 0,1.7037 0.6667,2 4.5,2 3.8333,0 4.5,-0.2963 4.5,-2 z m 24,0 c 0,-1.7037 -0.6667,-2 -4.5,-2 -3.8333,0 -4.5,0.2963 -4.5,2 0,1.7037 0.6667,2 4.5,2 3.8333,0 4.5,-0.2963 4.5,-2 z m 24,0 c 0,-1.7037 -0.6667,-2 -4.5,-2 -3.8333,0 -4.5,0.2963 -4.5,2 0,1.7037 0.6667,2 4.5,2 3.8333,0 4.5,-0.2963 4.5,-2 z m 24,0 c 0,-1.7037 -0.6667,-2 -4.5,-2 -3.8333,0 -4.5,0.2963 -4.5,2 0,1.7037 0.6667,2 4.5,2 3.8333,0 4.5,-0.2963 4.5,-2 z m 24,0 c 0,-1.7037 -0.6667,-2 -4.5,-2 -3.8333,0 -4.5,0.2963 -4.5,2 0,1.7037 0.6667,2 4.5,2 3.8333,0 4.5,-0.2963 4.5,-2 z m 24,0 c 0,-1.7037 -0.6667,-2 -4.5,-2 -3.8333,0 -4.5,0.2963 -4.5,2 0,1.7037 0.6667,2 4.5,2 3.8333,0 4.5,-0.2963 4.5,-2 z m -108,-40 v -18 h 49.5 49.5 v 18 18 h -11.5 -11.5 v -5.82186 c 0,-7.71571 -2.324,-14.17532 -6.7335,-18.71557 -5.4053,-5.56566 -10.3424,-7.41865 -19.7665,-7.41865 -9.2559,0 -14.214,1.82937 -19.1993,7.08397 -4.5799,4.82728 -6.3007,9.69951 -6.3007,17.83999 V 204 h -12 -12 z m 0,-28 v -6 h 49.5 49.5 v 6 6 h -49.5 -49.5 z"  ,
            "M 7.7680134,405.56677 C 7.083138,401.98408 13.304524,394.37112 20,390.59878 24.878249,387.8503 26.404365,387.5 33.5,387.5 c 7.16991,0 8.590459,0.33463 13.690548,3.225 l 5.690548,3.22499 0.694233,-2.22499 c 0.381829,-1.22375 1.033665,-2.45 1.448525,-2.725 0.41486,-0.275 0.972713,-2.1353 1.239674,-4.134 1.364591,-10.21654 14.093734,-24.91755 27.297652,-31.52632 4.371314,-2.18791 8.958314,-4.24227 10.193332,-4.56523 1.297109,-0.3392 2.249614,-1.36586 2.255257,-2.43083 0.01703,-3.21322 4.568601,-11.67328 8.907731,-16.55687 2.6122,-2.93997 6.70168,-5.94984 10.86955,-8 6.26895,-3.08368 7.33147,-3.28675 17.19736,-3.28675 10.07635,0 10.77927,0.14297 16.82818,3.42269 3.47192,1.88247 8.19692,5.51389 10.5,8.06982 l 4.18741,4.64715 4.38634,-2.779 c 6.69501,-4.24169 13.27928,-4.68133 21.22074,-1.41697 1.15901,0.47642 1.95666,-0.18336 2.86091,-2.36642 1.76645,-4.26458 8.81031,-10.44528 14.28817,-12.5373 4.55501,-1.73957 14.91819,-1.80104 20.24384,-0.12006 1.68476,0.53177 2.38177,-0.25701 4.42215,-5.00441 6.54297,-15.22367 24.73576,-24.71039 41.18232,-21.47473 3.48088,0.68482 8.52897,2.36 11.21797,3.72262 5.21218,2.64122 12.86478,9.86419 15.16632,14.31487 1.36433,2.63833 1.51091,2.67532 6.5281,1.64756 9.97066,-2.04246 23.54057,3.63916 30.00483,12.56282 1.59937,2.20787 3.18351,4.88252 3.5203,5.94367 0.49871,1.57129 1.21805,1.81573 3.87596,1.31711 5.0735,-0.9518 11.24379,1.21232 15.45043,5.41896 l 3.76288,3.76288 3.78293,-4.34873 c 2.08062,-2.3918 6.10108,-5.56502 8.93437,-7.0516 4.42389,-2.32114 6.35192,-2.70287 13.65144,-2.70287 7.26618,0 9.22578,0.38418 13.5,2.64668 2.75,1.45567 6.50712,4.21682 8.34915,6.13588 l 3.34916,3.4892 4.54807,-2.01183 c 3.07496,-1.3602 5.7842,-1.84603 8.36445,-1.49995 3.62576,0.48632 3.9403,0.30043 6.29744,-3.72172 C 439.41655,318.31395 449.2924,312.5987 461,312.5987 c 8.9917,0 14.68922,2.2301 21.32542,8.34714 4.22137,3.89113 9.67458,13.02316 9.67458,16.20122 0,1.1624 1.33034,1.36441 6.75,1.02501 l 6.75,-0.42272 -45.92196,35.12532 L 413.65608,408 H 210.94462 8.2331543 Z M 1455.3458,359.86462 l -48.1541,-48.1295 5.9973,0.62684 c 10.7353,1.12207 20.0437,7.05988 25.4027,16.20436 2.3572,4.02215 2.6717,4.20804 6.2975,3.72172 2.5802,-0.34608 5.2895,0.13975 8.3644,1.49995 l 4.5481,2.01183 3.3491,-3.4892 c 1.8421,-1.91906 5.5992,-4.68021 8.3492,-6.13588 4.2742,-2.2625 6.2338,-2.64668 13.5,-2.64668 7.2995,0 9.2276,0.38173 13.6514,2.70287 2.8333,1.48658 6.8538,4.6598 8.9344,7.0516 l 3.7829,4.34873 3.7629,-3.76288 c 4.2067,-4.20664 10.377,-6.37076 15.4505,-5.41896 2.6579,0.49862 3.3772,0.25418 3.8759,-1.31711 0.3368,-1.06115 1.9209,-3.7358 3.5203,-5.94367 6.4643,-8.92366 20.0342,-14.60528 30.0048,-12.56282 5.0172,1.02776 5.1638,0.99077 6.5281,-1.64756 2.3155,-4.47766 9.9665,-11.67988 15.2538,-14.35919 2.7371,-1.387 7.9092,-3.06218 11.4936,-3.72262 16.4597,-3.03282 34.312,6.37855 40.8192,21.51905 2.0404,4.7474 2.7374,5.53618 4.4222,5.00441 5.3256,-1.68098 15.6888,-1.61951 20.2438,0.12006 5.4779,2.09202 12.5218,8.27272 14.2882,12.5373 0.9043,2.18306 1.7019,2.84284 2.8609,2.36642 7.9415,-3.26436 14.5257,-2.82472 21.2208,1.41697 l 4.3863,2.779 4.1874,-4.64715 c 2.3031,-2.55593 7.0281,-6.18735 10.5,-8.06982 6.0489,-3.27972 6.7518,-3.42269 16.8282,-3.42269 9.8659,0 10.9284,0.20307 17.1973,3.28675 4.1679,2.05016 8.2574,5.06003 10.8696,8 4.3391,4.88359 8.8907,13.34365 8.9077,16.55687 0.01,1.06497 0.9582,2.09163 2.2553,2.43083 1.235,0.32296 5.822,2.37732 10.1933,4.56523 13.2039,6.60877 25.9331,21.30978 27.2977,31.52632 0.2669,1.9987 0.8248,3.859 1.2396,4.134 0.4149,0.275 1.0667,1.50125 1.4486,2.725 l 0.6942,2.22499 5.6906,-3.22499 c 5.1,-2.89037 6.5206,-3.225 13.6905,-3.225 7.0956,0 8.6218,0.3503 13.5,3.09878 6.6955,3.77234 12.9169,11.3853 12.232,14.96799 L 1863.7668,408 1683.6334,407.997 1503.5,407.994 1455.3458,359.86451 Z M 31.25,378.31067 c 0.9625,-0.25152 2.5375,-0.25152 3.5,0 0.9625,0.25153 0.175,0.45733 -1.75,0.45733 -1.925,0 -2.7125,-0.2058 -1.75,-0.45733 z m 1806,0 c 0.9625,-0.25152 2.5375,-0.25152 3.5,0 0.9625,0.25153 0.175,0.45733 -1.75,0.45733 -1.925,0 -2.7125,-0.2058 -1.75,-0.45733 z M 68,355.5 c 1.291745,-1.375 2.573628,-2.5 2.848628,-2.5 0.275,0 -0.556883,1.125 -1.848628,2.5 -1.291745,1.375 -2.573628,2.5 -2.848628,2.5 -0.275,0 0.556883,-1.125 1.848628,-2.5 z m 1734.9243,-0.25 -2.4243,-2.75 2.75,2.42431 c 2.5703,2.26589 3.2086,3.07569 2.4243,3.07569 -0.1791,0 -1.4166,-1.2375 -2.75,-2.75 z M 508.61514,335.82092 c 1.58667,-1.1985 3.44736,-2.6036 4.13486,-3.12245 0.93453,-0.70528 1.25,-0.15533 1.25,2.17909 0,2.99315 -0.17121,3.12244 -4.13486,3.12244 h -4.13486 z M 105,320.5 c 1.29175,-1.375 2.57363,-2.5 2.84863,-2.5 0.275,0 -0.55688,1.125 -1.84863,2.5 -1.29175,1.375 -2.57363,2.5 -2.84863,2.5 -0.275,0 0.55688,-1.125 1.84863,-2.5 z m 1660.9243,-0.25 -2.4243,-2.75 2.75,2.42431 c 1.5125,1.33338 2.75,2.57088 2.75,2.75 0,0.78428 -0.8098,0.14598 -3.0757,-2.42431 z M 387.25,314.31067 c 0.9625,-0.25152 2.5375,-0.25152 3.5,0 0.9625,0.25153 0.175,0.45733 -1.75,0.45733 -1.925,0 -2.7125,-0.2058 -1.75,-0.45733 z m 1094,0 c 0.9625,-0.25152 2.5375,-0.25152 3.5,0 0.9625,0.25153 0.175,0.45733 -1.75,0.45733 -1.925,0 -2.7125,-0.2058 -1.75,-0.45733 z"  ,
            "M 0.66153808,410.03587 C -1.9965072,384.60507 20.718842,365.10358 43.86672,372.94355 c 3.501696,1.18599 6.47456,2.02137 6.606365,1.8564 0.131804,-0.16497 1.063588,-2.49812 2.07063,-5.18478 4.627072,-12.34443 16.971773,-25.73303 29.510333,-32.00582 C 86.022114,335.62421 89.848355,334 90.556805,334 c 0.70845,0 1.833681,-1.6875 2.500514,-3.75 3.283087,-10.15452 11.651141,-19.53147 21.911611,-24.5534 6.14376,-3.00703 7.18464,-3.1966 17.5521,-3.1966 10.38406,0 11.39773,0.18545 17.53893,3.20875 3.58485,1.76482 8.4689,5.00991 10.85345,7.21131 4.19134,3.86942 4.42954,3.95396 7.1611,2.54141 4.94053,-2.55485 12.16337,-3.64278 16.98787,-2.55879 3.62038,0.81345 4.56898,0.72053 5.26056,-0.51525 2.08599,-3.72746 6.96855,-8.23238 11.85821,-10.94103 4.83008,-2.67564 6.22874,-2.95564 15.22045,-3.04692 l 9.90159,-0.10053 1.77482,-3.45948 c 0.97615,-1.90271 3.78353,-5.68247 6.23861,-8.39947 16.90815,-18.71196 45.69915,-18.64368 62.42243,0.14804 5.54081,6.22612 5.90252,6.45015 9.4658,5.86246 4.50488,-0.74299 13.93121,1.08822 19.09021,3.70855 4.94802,2.51318 11.38452,8.37312 14.34085,13.05624 1.5767,2.49766 2.85502,3.53355 3.87669,3.1415 2.41134,-0.92532 10.67447,1.55523 14.24755,4.27704 l 3.26015,2.48344 4.31951,-3.53952 c 7.41646,-6.07723 12.98711,-8.05821 22.66019,-8.05821 9.61518,0 15.24574,1.98263 22.4909,7.91949 2.8917,2.36954 4.58108,3.13452 5.57105,2.52268 0.78146,-0.48296 3.78175,-1.17309 6.66733,-1.53362 4.83411,-0.60399 5.51693,-1.03193 8.68707,-5.44454 15.45346,-21.51008 49.65021,-18.24018 60.67988,5.80224 l 2.36041,5.1452 9.02168,0.28451 9.02168,0.2845 0.29557,3.5 0.29558,3.5 -10.68327,-0.0703 -10.68327,-0.0703 -1.89245,-5.07313 c -2.45433,-6.57939 -8.26006,-13.09962 -14.97675,-16.81992 -4.88414,-2.70527 -6.19139,-2.96606 -14.85541,-2.96354 -7.93686,0.002 -10.19472,0.37354 -13.7222,2.25614 -5.94114,3.17078 -10.92713,7.7866 -13.91104,12.87825 -2.47274,4.2194 -2.71971,4.36285 -7.51144,4.36285 -2.72505,0 -6.33391,0.71325 -8.01968,1.58499 -2.98114,1.54161 -3.15086,1.5049 -6.20034,-1.34133 -7.69078,-7.17817 -17.85251,-10.99717 -25.95605,-9.75484 -6.6508,1.01961 -16.30942,6.16825 -19.86019,10.58671 l -3.17024,3.94495 -3.07441,-3.15801 C 355.58634,321.76595 351.24231,320 345.15344,320 c -4.48683,0 -5.01551,-0.25279 -6.12365,-2.92808 -1.76567,-4.26269 -9.34403,-11.55542 -14.80068,-14.24283 -3.83029,-1.88642 -6.49168,-2.35432 -14.00285,-2.46183 l -9.27374,-0.13273 -2.80466,-3.86727 c -4.05576,-5.59238 -9.75849,-10.29069 -16.10223,-13.26615 -4.81732,-2.2595 -6.8617,-2.60111 -15.56666,-2.60111 -9.30005,0 -10.49951,0.23556 -16.67169,3.27411 -7.78741,3.83373 -15.61756,11.78702 -18.43723,18.72719 -1.84415,4.53908 -1.91853,4.59173 -5.37005,3.80077 -6.69993,-1.53538 -16.19741,-0.842 -20.7222,1.51284 -5.80041,3.01873 -10.7828,7.57583 -12.30763,11.2571 -1.02204,2.46742 -1.69399,2.95364 -3.37322,2.44081 -8.03003,-2.45231 -15.51988,-1.73296 -21.05313,2.02201 l -3.65734,2.48193 -4.91798,-5.04909 c -3.00714,-3.08733 -7.55043,-6.29604 -11.69324,-8.25839 C 142.2104,309.8365 140.55633,309.5 132.5,309.5 c -7.7157,0 -9.83278,0.39014 -14.83589,2.734 -10.94345,5.12679 -17.6198,12.40999 -21.313723,23.25107 -1.096971,3.21943 -2.313153,4.95394 -3.734092,5.32552 -1.158999,0.30309 -5.602683,2.30057 -9.874853,4.43886 -13.521017,6.76749 -25.272928,21.05796 -28.783038,35.00055 -0.657709,2.6125 -1.410446,4.75 -1.672748,4.75 -0.262303,0 -1.73709,-0.89732 -3.277304,-1.99405 C 45.065326,380.19827 34.554813,377.6785 30.129513,378.47998 15.450888,381.13846 4.9081998,392.77312 4.2862209,407 l -0.2841707,6.5 1.6906729,-5 c 1.2989246,-3.84144 1.7781524,-4.47921 2.0682089,-2.75242 l 0.377536,2.24758 202.595292,0.25242 202.5953,0.25242 -4.33023,3 -4.33023,3 38.9157,0.51766 c 21.40363,0.28472 -69.35769,0.62222 -201.69184,0.75 L 1.2849128,416 Z M 1462.5,414.95719 c 25.3,-0.35268 46.1967,-0.71232 46.4371,-0.79921 0.2404,-0.0869 -0.8563,-1.50798 -2.4371,-3.15798 l -2.8742,-3 h 180.1176 180.1175 l 0.3779,-2.25 c 0.2906,-1.73047 0.7682,-1.09549 2.0685,2.75 l 1.6906,5 -0.2841,-6.5 c -0.622,-14.22688 -11.1647,-25.86154 -25.8433,-28.52002 -4.4253,-0.80148 -14.9358,1.71829 -18.8789,4.52597 -1.5402,1.09673 -3.015,1.99405 -3.2773,1.99405 -0.2623,0 -1.015,-2.1375 -1.6727,-4.75 -3.5101,-13.94259 -15.262,-28.23306 -28.783,-35.00055 -4.2722,-2.13829 -8.7159,-4.13577 -9.8749,-4.43886 -1.4209,-0.37158 -2.6371,-2.10609 -3.7341,-5.32552 -3.6939,-10.84108 -10.3703,-18.12428 -21.3137,-23.25107 -5.0031,-2.34386 -7.1202,-2.734 -14.8359,-2.734 -8.0563,0 -9.7104,0.3365 -15.7753,3.20928 -4.1428,1.96235 -8.6861,5.17106 -11.6932,8.25839 l -4.918,5.04909 -3.6573,-2.48193 c -5.4933,-3.72783 -12.6947,-4.44688 -20.9562,-2.09241 -1.5744,0.44869 -2.5765,-0.38807 -4.7091,-3.93229 -2.9874,-4.96494 -9.9239,-9.92784 -16.2755,-11.64487 -3.6813,-0.99514 -10.233,-0.72306 -16.5154,0.68583 -2.217,0.49719 -2.7117,0.0392 -4.3701,-4.04599 -2.8181,-6.94218 -10.6472,-14.89598 -18.4372,-18.73099 -6.1722,-3.03855 -7.3716,-3.27411 -16.6717,-3.27411 -8.7049,0 -10.7493,0.34161 -15.5666,2.60111 -6.3438,2.97546 -12.0465,7.67377 -16.1023,13.26615 l -2.8046,3.86727 -9.2738,0.13273 c -7.5111,0.10751 -10.1725,0.57541 -14.0028,2.46183 -5.4567,2.68741 -13.035,9.98014 -14.8007,14.24283 -1.1081,2.67529 -1.6368,2.92808 -6.1236,2.92808 -6.0889,0 -10.4329,1.76595 -14.421,5.86247 l -3.0744,3.15801 -3.1703,-3.94495 c -3.5507,-4.41846 -13.2094,-9.5671 -19.8602,-10.58671 -8.1035,-1.24233 -18.2652,2.57667 -25.956,9.75484 -3.0495,2.84623 -3.2192,2.88294 -6.2003,1.34133 -1.6858,-0.87174 -5.2947,-1.58499 -8.0197,-1.58499 -4.7917,0 -5.0387,-0.14345 -7.5115,-4.36285 -5.4297,-9.26513 -14.3865,-14.70867 -25.3832,-15.42674 l -7.25,-0.47342 v -3.30111 c 0,-4.01655 1.9241,-4.86594 8.7369,-3.85688 10.6413,1.57611 19.1917,6.53308 24.8467,14.40455 3.1702,4.41261 3.853,4.84055 8.6871,5.44454 2.8856,0.36053 5.8859,1.05066 6.6673,1.53362 0.99,0.61184 2.6794,-0.15314 5.5711,-2.52268 7.2452,-5.93686 12.8757,-7.91949 22.4909,-7.91949 9.6731,0 15.2437,1.98098 22.6602,8.05821 l 4.3195,3.53952 3.2602,-2.48344 c 3.573,-2.72181 11.8362,-5.20236 14.2475,-4.27704 1.0217,0.39205 2.3,-0.64384 3.8767,-3.1415 2.9563,-4.68312 9.3928,-10.54306 14.3408,-13.05624 5.4151,-2.7504 14.4729,-4.40489 19.7682,-3.61082 2.8857,0.43274 4.5269,0.30436 4.5269,-0.3541 0,-0.56812 2.2852,-3.53337 5.0783,-6.58943 16.2559,-17.78659 45.1321,-17.39506 61.6051,0.8353 2.4551,2.717 5.2624,6.49676 6.2386,8.39947 l 1.7748,3.45948 9.9016,0.10053 c 8.9917,0.0913 10.3904,0.37128 15.2205,3.04692 4.8896,2.70865 9.7722,7.21357 11.8582,10.94103 0.6915,1.23578 1.6401,1.3287 5.2605,0.51525 4.8245,-1.08399 12.0474,0.004 16.9879,2.55879 2.7316,1.41255 2.9698,1.32801 7.1611,-2.54141 2.3845,-2.2014 7.2686,-5.44649 10.8534,-7.21131 6.1412,-3.0233 7.1549,-3.20875 17.539,-3.20875 10.3674,0 11.4083,0.18957 17.5521,3.1966 10.2604,5.02193 18.6285,14.39888 21.9116,24.5534 0.6668,2.0625 1.792,3.75 2.5005,3.75 0.7084,0 4.5347,1.62421 8.5028,3.60935 12.5385,6.27279 24.8832,19.66139 29.5103,32.00582 1.007,2.68666 1.9388,5.01981 2.0706,5.18478 0.1318,0.16497 3.1047,-0.67041 6.6064,-1.8564 23.1479,-7.83997 45.8632,11.66152 43.2052,37.09232 L 1870.7151,416 1643.6075,415.79921 C 1518.6833,415.68876 1437.1969,415.3099 1462.5,414.95719 Z M 54.710251,387 c 0.287656,-1.1 0.695528,-2 0.90638,-2 C 55.827484,385 56,385.9 56,387 c 0,1.1 -0.407871,2 -0.90638,2 -0.49851,0 -0.671025,-0.9 -0.383369,-2 z M 1816,387 c 0,-1.1 0.1725,-2 0.3834,-2 0.2108,0 0.6187,0.9 0.9063,2 0.2877,1.1 0.1152,2 -0.3833,2 -0.4985,0 -0.9064,-0.9 -0.9064,-2 z M 1025.4881,226 c 0,-89.375 0.1178,-125.9375 0.2618,-81.25 0.144,44.6875 0.144,117.8125 0,162.5 -0.144,44.6875 -0.2618,8.125 -0.2618,-81.25 z m 383.9169,88.75 -1.905,-2.25 2.25,1.90499 c 2.1144,1.79022 2.7052,2.59501 1.905,2.59501 -0.1898,0 -1.2023,-1.0125 -2.25,-2.25 z"  ,
            "m 1305.3201,410 c 0,-3.575 0.1815,-5.0375 0.4033,-3.25 0.2218,1.7875 0.2218,4.7125 0,6.5 -0.2218,1.7875 -0.4033,0.325 -0.4033,-3.25 z m 23.8378,0 c 0,-1.375 0.227,-1.9375 0.5044,-1.25 0.2774,0.6875 0.2774,1.8125 0,2.5 -0.2774,0.6875 -0.5044,0.125 -0.5044,-1.25 z M 762.34941,396 c 0,-4.675 0.17226,-6.5875 0.3828,-4.25 0.21053,2.3375 0.21053,6.1625 0,8.5 -0.21054,2.3375 -0.3828,0.425 -0.3828,-4.25 z m 514.99999,0 c 0,-4.675 0.1723,-6.5875 0.3828,-4.25 0.2105,2.3375 0.2105,6.1625 0,8.5 -0.2105,2.3375 -0.3828,0.425 -0.3828,-4.25 z m 56.0873,-18 c 0,-14.575 0.1398,-20.5375 0.3107,-13.25 0.1709,7.2875 0.1709,19.2125 0,26.5 -0.1709,7.2875 -0.3107,1.325 -0.3107,-13.25 z M 590.43244,324 c 0,-13.475 0.14155,-18.9875 0.31456,-12.25 0.17301,6.7375 0.17301,17.7625 0,24.5 -0.17301,6.7375 -0.31456,1.225 -0.31456,-12.25 z m -76.14643,10.5 c 0.008,-2.75 0.20172,-3.75631 0.43157,-2.23625 0.22986,1.52006 0.22371,3.77006 -0.0136,5 -0.23736,1.22994 -0.42542,-0.0138 -0.41792,-2.76375 z m 891.06899,-30 c 0,-4.95 0.1746,-6.84892 0.3813,-4.21983 0.2066,2.6291 0.2042,6.6791 -0.01,9 -0.2097,2.32091 -0.3788,0.16983 -0.3757,-4.78017 z M 590.32007,282 c 0,-3.575 0.1815,-5.0375 0.40333,-3.25 0.22182,1.7875 0.22182,4.7125 0,6.5 -0.22183,1.7875 -0.40333,0.325 -0.40333,-3.25 z m 16,0 c 0,-3.575 0.1815,-5.0375 0.40333,-3.25 0.22182,1.7875 0.22182,4.7125 0,6.5 -0.22183,1.7875 -0.40333,0.325 -0.40333,-3.25 z m 16,0 c 0,-3.575 0.1815,-5.0375 0.40333,-3.25 0.22182,1.7875 0.22182,4.7125 0,6.5 -0.22183,1.7875 -0.40333,0.325 -0.40333,-3.25 z m 16,0 c 0,-3.575 0.1815,-5.0375 0.40333,-3.25 0.22182,1.7875 0.22182,4.7125 0,6.5 -0.22183,1.7875 -0.40333,0.325 -0.40333,-3.25 z m 16,0 c 0,-3.575 0.1815,-5.0375 0.40333,-3.25 0.22182,1.7875 0.22182,4.7125 0,6.5 -0.22183,1.7875 -0.40333,0.325 -0.40333,-3.25 z m 16,0 c 0,-3.575 0.1815,-5.0375 0.40333,-3.25 0.22182,1.7875 0.22182,4.7125 0,6.5 -0.22183,1.7875 -0.40333,0.325 -0.40333,-3.25 z m 16,0 c 0,-3.575 0.1815,-5.0375 0.40333,-3.25 0.22182,1.7875 0.22182,4.7125 0,6.5 -0.22183,1.7875 -0.40333,0.325 -0.40333,-3.25 z m 16,0 c 0,-3.575 0.1815,-5.0375 0.40333,-3.25 0.22182,1.7875 0.22182,4.7125 0,6.5 -0.22183,1.7875 -0.40333,0.325 -0.40333,-3.25 z m 16,0 c 0,-3.575 0.1815,-5.0375 0.40333,-3.25 0.22182,1.7875 0.22182,4.7125 0,6.5 -0.22183,1.7875 -0.40333,0.325 -0.40333,-3.25 z m 16,0 c 0,-3.575 0.1815,-5.0375 0.40333,-3.25 0.22182,1.7875 0.22182,4.7125 0,6.5 -0.22183,1.7875 -0.40333,0.325 -0.40333,-3.25 z m 16,0 c 0,-3.575 0.1815,-5.0375 0.40333,-3.25 0.22182,1.7875 0.22182,4.7125 0,6.5 -0.22183,1.7875 -0.40333,0.325 -0.40333,-3.25 z m 23.83782,-4 c 0,-1.375 0.22698,-1.9375 0.50439,-1.25 0.27741,0.6875 0.27741,1.8125 0,2.5 -0.27741,0.6875 -0.50439,0.125 -0.50439,-1.25 z m 32,-4 c 0,-1.375 0.22698,-1.9375 0.50439,-1.25 0.27741,0.6875 0.27741,1.8125 0,2.5 -0.27741,0.6875 -0.50439,0.125 -0.50439,-1.25 z m 36,0 c 0,-1.375 0.22698,-1.9375 0.50439,-1.25 0.27741,0.6875 0.27741,1.8125 0,2.5 -0.27741,0.6875 -0.50439,0.125 -0.50439,-1.25 z m -68,-4 c 0,-1.375 0.22698,-1.9375 0.50439,-1.25 0.27741,0.6875 0.27741,1.8125 0,2.5 -0.27741,0.6875 -0.50439,0.125 -0.50439,-1.25 z m 8.21207,-12 c 0,-5.775 0.16528,-8.1375 0.36728,-5.25 0.202,2.8875 0.202,7.6125 0,10.5 -0.202,2.8875 -0.36728,0.525 -0.36728,-5.25 z m 12,0 c 0,-5.775 0.16528,-8.1375 0.36728,-5.25 0.202,2.8875 0.202,7.6125 0,10.5 -0.202,2.8875 -0.36728,0.525 -0.36728,-5.25 z m 12,0 c 0,-5.775 0.16528,-8.1375 0.36728,-5.25 0.202,2.8875 0.202,7.6125 0,10.5 -0.202,2.8875 -0.36728,0.525 -0.36728,-5.25 z m 12,0 c 0,-5.775 0.16528,-8.1375 0.36728,-5.25 0.202,2.8875 0.202,7.6125 0,10.5 -0.202,2.8875 -0.36728,0.525 -0.36728,-5.25 z m 12,0 c 0,-5.775 0.16528,-8.1375 0.36728,-5.25 0.202,2.8875 0.202,7.6125 0,10.5 -0.202,2.8875 -0.36728,0.525 -0.36728,-5.25 z m 12,0 c 0,-5.775 0.16528,-8.1375 0.36728,-5.25 0.202,2.8875 0.202,7.6125 0,10.5 -0.202,2.8875 -0.36728,0.525 -0.36728,-5.25 z m -79.97257,-8 c 0,-7.975 0.1553,-11.2375 0.34512,-7.25 0.18981,3.9875 0.18981,10.5125 0,14.5 -0.18982,3.9875 -0.34512,0.725 -0.34512,-7.25 z m 514.95201,-26 c 0,-4.675 0.1723,-6.5875 0.3828,-4.25 0.2105,2.3375 0.2105,6.1625 0,8.5 -0.2105,2.3375 -0.3828,0.425 -0.3828,-4.25 z M 1377,229.5 c -0.6847,-0.825 -1.0199,-1.5 -0.7449,-1.5 0.275,0 1.0602,0.675 1.7449,1.5 0.6847,0.825 1.0199,1.5 0.7449,1.5 -0.275,0 -1.0602,-0.675 -1.7449,-1.5 z m -68.5,-1.5 c 0.9955,-1.1 2.035,-2 2.31,-2 0.275,0 -0.3145,0.9 -1.31,2 -0.9955,1.1 -2.035,2 -2.31,2 -0.275,0 0.3145,-0.9 1.31,-2 z m 84.5,0.5 c -0.6847,-0.825 -1.0199,-1.5 -0.7449,-1.5 0.275,0 1.0602,0.675 1.7449,1.5 0.6847,0.825 1.0199,1.5 0.7449,1.5 -0.275,0 -1.0602,-0.675 -1.7449,-1.5 z M 1061.1579,226 c 0,-1.375 0.227,-1.9375 0.5044,-1.25 0.2774,0.6875 0.2774,1.8125 0,2.5 -0.2774,0.6875 -0.5044,0.125 -0.5044,-1.25 z m 24,0 c 0,-1.375 0.227,-1.9375 0.5044,-1.25 0.2774,0.6875 0.2774,1.8125 0,2.5 -0.2774,0.6875 -0.5044,0.125 -0.5044,-1.25 z m 24,0 c 0,-1.375 0.227,-1.9375 0.5044,-1.25 0.2774,0.6875 0.2774,1.8125 0,2.5 -0.2774,0.6875 -0.5044,0.125 -0.5044,-1.25 z m 24,0 c 0,-1.375 0.227,-1.9375 0.5044,-1.25 0.2774,0.6875 0.2774,1.8125 0,2.5 -0.2774,0.6875 -0.5044,0.125 -0.5044,-1.25 z m 24,0 c 0,-1.375 0.227,-1.9375 0.5044,-1.25 0.2774,0.6875 0.2774,1.8125 0,2.5 -0.2774,0.6875 -0.5044,0.125 -0.5044,-1.25 z m 24,0 c 0,-1.375 0.227,-1.9375 0.5044,-1.25 0.2774,0.6875 0.2774,1.8125 0,2.5 -0.2774,0.6875 -0.5044,0.125 -0.5044,-1.25 z M 1292,227.62244 c 0,-0.20765 0.7875,-0.99515 1.75,-1.75 1.5861,-1.24387 1.6214,-1.2085 0.3776,0.37756 -1.3064,1.66575 -2.1276,2.19548 -2.1276,1.37244 z m 76.405,-5.87244 -1.905,-2.25 2.25,1.90499 c 2.1144,1.79022 2.7052,2.59501 1.905,2.59501 -0.1898,0 -1.2023,-1.0125 -2.25,-2.25 z M 1317.5,220 c 0.9955,-1.1 2.035,-2 2.31,-2 0.275,0 -0.3145,0.9 -1.31,2 -0.9955,1.1 -2.035,2 -2.31,2 -0.275,0 0.3145,-0.9 1.31,-2 z m 63.5,-2.5 c -0.6847,-0.825 -1.0199,-1.5 -0.7449,-1.5 0.275,0 1.0602,0.675 1.7449,1.5 0.6847,0.825 1.0199,1.5 0.7449,1.5 -0.275,0 -1.0602,-0.675 -1.7449,-1.5 z m -77,-0.87756 c 0,-0.20765 0.7875,-0.99515 1.75,-1.75 1.5861,-1.24387 1.6214,-1.2085 0.3776,0.37756 -1.3064,1.66575 -2.1276,2.19548 -2.1276,1.37244 z m 55.405,-2.87244 -1.905,-2.25 2.25,1.90499 c 1.2375,1.04774 2.25,2.06024 2.25,2.25 0,0.80025 -0.8048,0.20945 -2.595,-1.90499 z M 1326.5,212 c 0.9955,-1.1 2.035,-2 2.31,-2 0.275,0 -0.3145,0.9 -1.31,2 -0.9955,1.1 -2.035,2 -2.31,2 -0.275,0 0.3145,-0.9 1.31,-2 z m 45.5,-2.5 c -0.6847,-0.825 -1.0199,-1.5 -0.7449,-1.5 0.275,0 1.0602,0.675 1.7449,1.5 0.6847,0.825 1.0199,1.5 0.7449,1.5 -0.275,0 -1.0602,-0.675 -1.7449,-1.5 z m -59,-0.87756 c 0,-0.20765 0.7875,-0.99515 1.75,-1.75 1.5861,-1.24387 1.6214,-1.2085 0.3776,0.37756 -1.3064,1.66575 -2.1276,2.19548 -2.1276,1.37244 z m 37.405,-2.87244 -1.905,-2.25 2.25,1.90499 c 2.1144,1.79022 2.7052,2.59501 1.905,2.59501 -0.1898,0 -1.2023,-1.0125 -2.25,-2.25 z M 1335.5,204 c 0.9955,-1.1 2.035,-2 2.31,-2 0.275,0 -0.3145,0.9 -1.31,2 -0.9955,1.1 -2.035,2 -2.31,2 -0.275,0 0.3145,-0.9 1.31,-2 z m -82.0849,-18 c 0,-10.175 0.1485,-14.3375 0.33,-9.25 0.1815,5.0875 0.1815,13.4125 0,18.5 -0.1815,5.0875 -0.33,0.925 -0.33,-9.25 z m 109.9899,15.75 -1.905,-2.25 2.25,1.90499 c 2.1144,1.79022 2.7052,2.59501 1.905,2.59501 -0.1898,0 -1.2023,-1.0125 -2.25,-2.25 z M 1321,201.62244 c 0,-0.20765 0.7875,-0.99515 1.75,-1.75 1.5861,-1.24387 1.6214,-1.2085 0.3776,0.37756 -1.3064,1.66575 -2.1276,2.19548 -2.1276,1.37244 z M 1355,194.5 c -0.6847,-0.825 -1.0199,-1.5 -0.7449,-1.5 0.275,0 1.0602,0.675 1.7449,1.5 0.6847,0.825 1.0199,1.5 0.7449,1.5 -0.275,0 -1.0602,-0.675 -1.7449,-1.5 z m -25,-0.87756 c 0,-0.20765 0.7875,-0.99515 1.75,-1.75 1.5861,-1.24387 1.6214,-1.2085 0.3776,0.37756 -1.3064,1.66575 -2.1276,2.19548 -2.1276,1.37244 z M 1346,186.5 c -0.6847,-0.825 -1.0199,-1.5 -0.7449,-1.5 0.275,0 1.0602,0.675 1.7449,1.5 0.6847,0.825 1.0199,1.5 0.7449,1.5 -0.275,0 -1.0602,-0.675 -1.7449,-1.5 z m -7,-0.87756 c 0,-0.20765 0.7875,-0.99515 1.75,-1.75 1.5861,-1.24387 1.6214,-1.2085 0.3776,0.37756 -1.3064,1.66575 -2.1276,2.19548 -2.1276,1.37244 z M 1253.3201,158 c 0,-3.575 0.1815,-5.0375 0.4033,-3.25 0.2218,1.7875 0.2218,4.7125 0,6.5 -0.2218,1.7875 -0.4033,0.325 -0.4033,-3.25 z"  ,
            "m 486.75,415.26276 c 2.8875,-0.202 7.6125,-0.202 10.5,0 2.8875,0.202 0.525,0.36728 -5.25,0.36728 -5.775,0 -8.1375,-0.16528 -5.25,-0.36728 z m 921.4821,0.0227 c 1.5026,-0.22817 4.2026,-0.23276 6,-0.0102 1.7973,0.22256 0.5679,0.40925 -2.7321,0.41486 -3.3,0.006 -4.7706,-0.17648 -3.2679,-0.40466 z m 79.9915,-1.01236 c 2.0479,-0.21488 5.6479,-0.21785 8,-0.007 2.352,0.21125 0.6764,0.38706 -3.7236,0.39069 -4.4,0.004 -6.3244,-0.16921 -4.2764,-0.38408 z M 416.03571,406.57853 c 0.80536,-0.7818 21.26429,-16.54901 45.46429,-35.03822 42.45428,-32.43581 44.14052,-33.60664 48,-33.32854 3.99775,0.28807 4.00017,0.29083 4.29928,4.90337 0.29158,4.49632 0.21498,4.63201 -2.97515,5.27003 -8.51822,1.70365 -15.59215,10.96496 -16.56433,21.68629 L 493.72222,376 H 503.86111 514 v 16 16 h -49.71429 c -42.98985,0 -49.51622,-0.19227 -48.25,-1.42147 z M 1406,360.5 c 0,-35.56406 0.2936,-47.5 1.1684,-47.5 0.6426,0 22.5801,21.36935 48.75,47.48745 l 47.5816,47.48746 -48.75,0.0125 L 1406,408 Z"  ,
            "m 1290,410 v -6 h 7.5 7.5 v 6 6 h -7.5 -7.5 z m 44,0 v -6 h 30.0293 30.0293 l -0.1187,-78 -0.1188,-78 h -51.7596 -51.7595 l -0.5884,-13.22929 c -0.3236,-7.27611 -0.4197,-13.39795 -0.2136,-13.60409 0.2062,-0.20613 0.5155,1.58042 0.6874,3.97011 l 0.3126,4.34489 10.9117,-9.99081 c 6.0015,-5.49494 17.6698,-15.9403 25.9297,-23.21189 l 15.018,-13.22109 6.0703,5.37797 c 3.3387,2.95789 12.8528,11.3572 21.1424,18.66514 8.2897,7.30794 17.2407,15.33734 19.8911,17.84311 8.5868,8.11835 12.2502,11.05595 13.7874,11.05595 1.3244,0 1.5902,9.38207 2.1893,77.25 0.375,42.4875 0.6545,82.9875 0.621,90 L 1406,416 h -36 -36 z m 50,-174.41182 c 0,-0.2265 -7.9875,-7.49933 -17.75,-16.16185 -9.7625,-8.66252 -19.1093,-17.01542 -20.7706,-18.562 l -3.0206,-2.81197 -16.4794,14.62744 c -9.0637,8.0451 -18.6656,16.58331 -21.3376,18.97382 L 1299.7837,236 h 42.1081 C 1365.0513,236 1384,235.81468 1384,235.58818 Z M 1309.4405,384 c 0,-15.675 0.1383,-22.0875 0.3072,-14.25 0.169,7.8375 0.169,20.6625 0,28.5 -0.1689,7.8375 -0.3072,1.425 -0.3072,-14.25 z m -703.09109,12 c 0,-4.675 0.17226,-6.5875 0.3828,-4.25 0.21053,2.3375 0.21053,6.1625 0,8.5 -0.21054,2.3375 -0.3828,0.425 -0.3828,-4.25 z m 20.04798,-6 c 0,-7.975 0.1553,-11.2375 0.34512,-7.25 0.18981,3.9875 0.18981,10.5125 0,14.5 -0.18982,3.9875 -0.34512,0.725 -0.34512,-7.25 z m 136.25629,1.843 C 762.29415,385.15665 762,361.75665 762,339.843 V 300 h -84 -84 v 24 c 0,20.66667 -0.20833,24 -1.5,24 -1.29167,0 -1.5,-3.33333 -1.5,-24 V 300 H 558.5 526 v 24 24 h -5.87742 -5.87742 l 0.2545,-12.75 c 0.13998,-7.0125 0.30982,-25.9125 0.37742,-42 L 515,264 h 124 124 v -14 -14 h 57.5 57.5 v 6 6 h -4 -4 v 10 10 h 4 c 3.33333,0 4,0.33333 4,2 0,1.91667 -0.66667,2 -16,2 -15.33333,0 -16,0.0833 -16,2 0,1.91667 0.66667,2 16,2 15.33333,0 16,0.0833 16,2 0,1.97411 -0.66667,2 -51.5,2 -50.83333,0 -51.5,-0.0259 -51.5,-2 0,-1.91667 0.66667,-2 16,-2 15.33333,0 16,-0.0833 16,-2 0,-1.91667 -0.66667,-2 -16,-2 -15.33333,0 -16,-0.0833 -16,-2 0,-1.66667 0.66667,-2 4,-2 h 4 v -10 -10 h -4.5 -4.5 v 78 78 h -5.34632 -5.34633 z M 543,282 v -6 h -8.5 -8.5 v 6 6 h 8.5 8.5 z m 16,0 v -6 h -6.5 -6.5 v 6 6 h 6.5 6.5 z m 16,0 v -6 h -6.5 -6.5 v 6 6 h 6.5 6.5 z m 16,0 v -6 h -6.5 -6.5 v 6 6 h 6.5 6.5 z m 16,0 v -6 h -6.5 -6.5 v 6 6 h 6.5 6.5 z m 16,0 v -6 h -6.5 -6.5 v 6 6 h 6.5 6.5 z m 16,0 v -6 h -6.5 -6.5 v 6 6 h 6.5 6.5 z m 16,0 v -6 h -6.5 -6.5 v 6 6 h 6.5 6.5 z m 16,0 v -6 h -6.5 -6.5 v 6 6 h 6.5 6.5 z m 16,0 v -6 h -6.5 -6.5 v 6 6 h 6.5 6.5 z m 16,0 v -6 h -6.5 -6.5 v 6 6 h 6.5 6.5 z m 16,0 v -6 h -6.5 -6.5 v 6 6 h 6.5 6.5 z m 16,0 v -6 h -6.5 -6.5 v 6 6 h 6.5 6.5 z m 16,0 v -6 h -6.5 -6.5 v 6 6 h 6.5 6.5 z m 11,0 v -6 h -4 -4 v 6 6 h 4 4 z m 81,-8 c 0,-1.91919 -0.66667,-2 -16.5,-2 -15.83333,0 -16.5,0.0808 -16.5,2 0,1.91919 0.66667,2 16.5,2 15.83333,0 16.5,-0.0808 16.5,-2 z m -48,-16 v -10 h -4.5 -4.5 v 10 10 h 4.5 4.5 z m 12,0 v -10 h -4.5 -4.5 v 10 10 h 4.5 4.5 z m 12,0 v -10 h -4.5 -4.5 v 10 10 h 4.5 4.5 z m 12,0 v -10 h -4.5 -4.5 v 10 10 h 4.5 4.5 z m 12,0 v -10 h -4.5 -4.5 v 10 10 h 4.5 4.5 z m 11,0 v -10 h -4 -4 v 10 10 h 4 4 z m 12,0 v -10 h -4 -4 v 10 10 h 4 4 z m 463.1579,140 c 0,-1.375 0.227,-1.9375 0.5044,-1.25 0.2774,0.6875 0.2774,1.8125 0,2.5 -0.2774,0.6875 -0.5044,0.125 -0.5044,-1.25 z m 0,-8 c 0,-1.375 0.227,-1.9375 0.5044,-1.25 0.2774,0.6875 0.2774,1.8125 0,2.5 -0.2774,0.6875 -0.5044,0.125 -0.5044,-1.25 z m -803.00001,-4 c 0,-1.375 0.22698,-1.9375 0.50439,-1.25 0.27741,0.6875 0.27741,1.8125 0,2.5 -0.27741,0.6875 -0.50439,0.125 -0.50439,-1.25 z m 80.11447,-6 c 0,-2.475 0.19502,-3.4875 0.43337,-2.25 0.23836,1.2375 0.23836,3.2625 0,4.5 -0.23835,1.2375 -0.43337,0.225 -0.43337,-2.25 z m 710.88554,-6 c 0,-1.375 0.227,-1.9375 0.5044,-1.25 0.2774,0.6875 0.2774,1.8125 0,2.5 -0.2774,0.6875 -0.5044,0.125 -0.5044,-1.25 z m -112,-148 c 0,-1.375 0.227,-1.9375 0.5044,-1.25 0.2774,0.6875 0.2774,1.8125 0,2.5 -0.2774,0.6875 -0.5044,0.125 -0.5044,-1.25 z m 24,0 c 0,-1.375 0.227,-1.9375 0.5044,-1.25 0.2774,0.6875 0.2774,1.8125 0,2.5 -0.2774,0.6875 -0.5044,0.125 -0.5044,-1.25 z m 24,0 c 0,-1.375 0.227,-1.9375 0.5044,-1.25 0.2774,0.6875 0.2774,1.8125 0,2.5 -0.2774,0.6875 -0.5044,0.125 -0.5044,-1.25 z m 36.1145,-18 c 0,-2.475 0.195,-3.4875 0.4333,-2.25 0.2384,1.2375 0.2384,3.2625 0,4.5 -0.2383,1.2375 -0.4333,0.225 -0.4333,-2.25 z M 1190,199.5651 c 0,-5.27981 1.3658,-9.24583 4.2409,-12.3151 1.7928,-1.91386 3.1424,-2.25 9.0334,-2.25 6.543,0 7.1136,0.1879 10.3257,3.4 3.1235,3.1235 3.4,3.89608 3.4,9.5 v 6.1 h -13.5 -13.5 z"  ,
            "m 503.00374,367.25 c 0.01,-1.96313 4.32215,-7.47813 7.23712,-9.2554 3.20584,-1.95463 5.29104,-1.98719 127.50914,-1.99086 L 762,356 v 6 6 H 632.5 c -71.225,0 -129.49832,-0.3375 -129.49626,-0.75 z"  ,
            "M 454.03976,415.01443 405.57952,414.5 l 4.10415,-3.25 4.10414,-3.25 H 463.8939 514 v 4 4 l -5.75,-0.23557 c -3.1625,-0.12956 -27.55711,-0.46706 -54.21024,-0.75 z M 1406,411.5 V 408 h 48.7308 48.7307 l 2.8397,2.83964 2.8396,2.83964 -18.2307,0.66036 C 1480.8832,414.70284 1457.6765,415 1439.3397,415 H 1406 Z"  ,
            "m 514,396 v -20 h 6 6 v 14 14 h 40.5 40.5 v -8 -8 h -40 c -39.33333,0 -40,-0.0333 -40,-2 0,-1.96667 0.66667,-2 40,-2 h 40 v -4 c 0,-2.88889 0.41667,-4 1.5,-4 1.2619,0 1.5,2.22222 1.5,14 v 14 h 8.5 8.5 v -14 c 0,-11.77778 0.2381,-14 1.5,-14 1.08333,0 1.5,1.11111 1.5,4 v 4 h 66 c 65.33333,0 66,0.0202 66,2 0,1.9798 -0.66667,2 -66,2 h -66 v 8 8 h 124 124 v 6 6 H 696 514 Z m 775.4168,1.5 c -9e-4,-10.45 0.1465,-14.86087 0.3276,-9.80194 0.1811,5.05893 0.1819,13.60893 0,19 -0.1801,5.39107 -0.3283,1.25194 -0.3293,-9.19806 z m 16.5832,0 c 0,-11.66667 0.3694,-18.5 1,-18.5 0.55,0 1,-0.675 1,-1.5 0,-0.825 -0.45,-1.5 -1,-1.5 -0.6111,0 -1,-4.66667 -1,-12 v -12 h 13.5 13.5 v 22.84638 c 0,12.5655 0.2924,26.9655 0.6497,32 L 1334.2995,416 H 1320.1497 1306 Z m 24,12.5 c 0,-1.86667 -0.6667,-2 -10,-2 -9.3333,0 -10,-0.13333 -10,-2 0,-1.86667 0.6667,-2 10,-2 h 10 v -12.5 c 0,-7.66667 0.3867,-12.5 1,-12.5 0.55,0 1,-0.675 1,-1.5 0,-0.825 -0.45,-1.5 -1,-1.5 -0.6,0 -1,-4 -1,-10 v -10 h -10.5 -10.5 v 28 28 h 10.5 c 9.8333,0 10.5,-0.12698 10.5,-2 z m -20,-12 c 0,-1.85965 0.6667,-2 9.5,-2 8.8333,0 9.5,0.14035 9.5,2 0,1.85965 -0.6667,2 -9.5,2 -8.8333,0 -9.5,-0.14035 -9.5,-2 z m 0,-8 c 0,-1.85965 0.6667,-2 9.5,-2 8.8333,0 9.5,0.14035 9.5,2 0,1.85965 -0.6667,2 -9.5,2 -8.8333,0 -9.5,-0.14035 -9.5,-2 z m 4,-16 c 0,-1.11111 0.6667,-2 1.5,-2 0.8333,0 1.5,0.88889 1.5,2 0,1.11111 -0.6667,2 -1.5,2 -0.8333,0 -1.5,-0.88889 -1.5,-2 z m 35,10 c 0,-3.33333 0.3333,-4 2,-4 1.9048,0 2,-0.66667 2,-14 v -14 h 10.5 10.5 v 14 c 0,13.33333 0.095,14 2,14 1.6667,0 2,0.66667 2,4 v 4 h -14.5 -14.5 z m 21,-10 v -6 h -6.5 -6.5 v 6 6 h 6.5 6.5 z m 0,-14 v -4 h -6.5 -6.5 v 4 4 h 6.5 6.5 z m -580,16 c 0,-3.33333 0.33333,-4 2,-4 1.91667,0 2,-0.66667 2,-16 v -16 h 10 10 v 16 c 0,15.33333 0.0833,16 2,16 1.66667,0 2,0.66667 2,4 v 4 h -14 -14 z m 20,-12 v -8 h -6 -6 v 8 8 h 6 6 z m 0,-16 v -4 h -6 -6 v 4 4 h 6 6 z m 24,28 c 0,-3.33333 0.33333,-4 2,-4 1.91667,0 2,-0.66667 2,-16 v -16 h 10 10 v 16 c 0,15.33333 0.0833,16 2,16 1.66667,0 2,0.66667 2,4 v 4 h -14 -14 z m 20,-12 v -8 h -6 -6 v 8 8 h 6 6 z m 0,-16 v -4 h -6 -6 v 4 4 h 6 6 z m 435.4679,-45 c -0.01,-40.975 0.1194,-65.6125 0.2809,-54.75 l 0.2935,19.75 h 51.4788 c 50.8122,0 51.4789,0.0259 51.4789,2 0,1.97411 -0.6667,2 -51.5,2 -50.8333,0 -51.5,0.0259 -51.5,2 0,1.97411 0.6667,2 51.5,2 50.8333,0 51.5,0.0259 51.5,2 0,1.97411 -0.6667,2 -51.4905,2 h -51.4905 l -0.2692,48.75 c -0.1481,26.8125 -0.275,15.225 -0.2819,-25.75 z m -76.0979,63 c 0,-5.775 0.1652,-8.1375 0.3672,-5.25 0.202,2.8875 0.202,7.6125 0,10.5 -0.202,2.8875 -0.3672,0.525 -0.3672,-5.25 z m 24,0 c 0,-5.775 0.1652,-8.1375 0.3672,-5.25 0.202,2.8875 0.202,7.6125 0,10.5 -0.202,2.8875 -0.3672,0.525 -0.3672,-5.25 z m 24,0 c 0,-5.775 0.1652,-8.1375 0.3672,-5.25 0.202,2.8875 0.202,7.6125 0,10.5 -0.202,2.8875 -0.3672,0.525 -0.3672,-5.25 z m -48,-24 c 0,-5.775 0.1652,-8.1375 0.3672,-5.25 0.202,2.8875 0.202,7.6125 0,10.5 -0.202,2.8875 -0.3672,0.525 -0.3672,-5.25 z m 24,0 c 0,-5.775 0.1652,-8.1375 0.3672,-5.25 0.202,2.8875 0.202,7.6125 0,10.5 -0.202,2.8875 -0.3672,0.525 -0.3672,-5.25 z m 24,0 c 0,-5.775 0.1652,-8.1375 0.3672,-5.25 0.202,2.8875 0.202,7.6125 0,10.5 -0.202,2.8875 -0.3672,0.525 -0.3672,-5.25 z m 43.63,-6 c 0,-3.33333 0.3333,-4 2,-4 1.9048,0 2,-0.66667 2,-14 v -14 h 10.5 10.5 v 14 c 0,13.33333 0.095,14 2,14 1.6667,0 2,0.66667 2,4 v 4 h -14.5 -14.5 z m 21,-10 v -6 h -6.5 -6.5 v 6 6 h 6.5 6.5 z m 0,-14 v -4 h -6.5 -6.5 v 4 4 h 6.5 6.5 z m 23,24 c 0,-3.33333 0.3333,-4 2,-4 1.9048,0 2,-0.66667 2,-14 v -14 h 10.5 10.5 v 14 c 0,13.33333 0.095,14 2,14 1.6667,0 2,0.66667 2,4 v 4 h -14.5 -14.5 z m 21,-10 v -6 h -6.5 -6.5 v 6 6 h 6.5 6.5 z m 0,-14 v -4 h -6.5 -6.5 v 4 4 h 6.5 6.5 z m -764.54444,22.92809 c -0.37471,-0.60629 -0.26336,-1.52029 0.24746,-2.03111 0.54087,-0.54087 12.80375,-0.81771 29.36287,-0.66287 C 659.55582,332.46312 663.5,332.70807 663.5,334 c 0,1.2923 -3.97139,1.53672 -28.68157,1.76522 -20.08197,0.1857 -28.88585,-0.0653 -29.36287,-0.83713 z m 68.01762,0.0285 c -1.31929,-2.13466 1.23818,-3.05935 7.62839,-2.75817 4.8868,0.23032 6.39843,0.65595 6.39843,1.80157 0,1.15389 -1.53765,1.56778 -6.66396,1.79373 -4.17939,0.18421 -6.92453,-0.1279 -7.36286,-0.83713 z m 27.98367,-0.0264 c -1.58708,-2.56795 2.10043,-2.95646 25.61134,-2.69838 20.9313,0.22976 24.43181,0.48311 24.43181,1.76819 0,1.28559 -3.52773,1.53821 -24.68028,1.76732 -17.19739,0.18627 -24.88724,-0.0675 -25.36287,-0.83713 z M 790,324 c 0,-3.33333 0.33333,-4 2,-4 1.91667,0 2,-0.66667 2,-16 v -16 h 10 10 v 16 c 0,15.33333 0.0833,16 2,16 1.66667,0 2,0.66667 2,4 v 4 h -14 -14 z m 20,-12 v -8 h -6 -6 v 8 8 h 6 6 z m 0,-16 v -4 h -6 -6 v 4 4 h 6 6 z m 24,28 c 0,-3.33333 0.33333,-4 2,-4 1.91667,0 2,-0.66667 2,-16 v -16 h 10 10 v 16 c 0,15.33333 0.0833,16 2,16 1.66667,0 2,0.66667 2,4 v 4 h -14 -14 z m 20,-12 v -8 h -6 -6 v 8 8 h 6 6 z m 0,-16 v -4 h -6 -6 v 4 4 h 6 6 z m 359.37,22 c 0,-5.775 0.1652,-8.1375 0.3672,-5.25 0.202,2.8875 0.202,7.6125 0,10.5 -0.202,2.8875 -0.3672,0.525 -0.3672,-5.25 z m 24,0 c 0,-5.775 0.1652,-8.1375 0.3672,-5.25 0.202,2.8875 0.202,7.6125 0,10.5 -0.202,2.8875 -0.3672,0.525 -0.3672,-5.25 z m 24,0 c 0,-5.775 0.1652,-8.1375 0.3672,-5.25 0.202,2.8875 0.202,7.6125 0,10.5 -0.202,2.8875 -0.3672,0.525 -0.3672,-5.25 z m -48.0206,-22 c 0,-4.675 0.1723,-6.5875 0.3828,-4.25 0.2105,2.3375 0.2105,6.1625 0,8.5 -0.2105,2.3375 -0.3828,0.425 -0.3828,-4.25 z m 24,0 c 0,-4.675 0.1723,-6.5875 0.3828,-4.25 0.2105,2.3375 0.2105,6.1625 0,8.5 -0.2105,2.3375 -0.3828,0.425 -0.3828,-4.25 z m 24,0 c 0,-4.675 0.1723,-6.5875 0.3828,-4.25 0.2105,2.3375 0.2105,6.1625 0,8.5 -0.2105,2.3375 -0.3828,0.425 -0.3828,-4.25 z M 1213.37,274 c 0,-5.775 0.1652,-8.1375 0.3672,-5.25 0.202,2.8875 0.202,7.6125 0,10.5 -0.202,2.8875 -0.3672,0.525 -0.3672,-5.25 z m 24,0 c 0,-5.775 0.1652,-8.1375 0.3672,-5.25 0.202,2.8875 0.202,7.6125 0,10.5 -0.202,2.8875 -0.3672,0.525 -0.3672,-5.25 z m 24,0 c 0,-5.775 0.1652,-8.1375 0.3672,-5.25 0.202,2.8875 0.202,7.6125 0,10.5 -0.202,2.8875 -0.3672,0.525 -0.3672,-5.25 z m -48,-24 c 0,-5.775 0.1652,-8.1375 0.3672,-5.25 0.202,2.8875 0.202,7.6125 0,10.5 -0.202,2.8875 -0.3672,0.525 -0.3672,-5.25 z m 24,0 c 0,-5.775 0.1652,-8.1375 0.3672,-5.25 0.202,2.8875 0.202,7.6125 0,10.5 -0.202,2.8875 -0.3672,0.525 -0.3672,-5.25 z m 24,0 c 0,-5.775 0.1652,-8.1375 0.3672,-5.25 0.202,2.8875 0.202,7.6125 0,10.5 -0.202,2.8875 -0.3672,0.525 -0.3672,-5.25 z m -44.0601,-51.5 c 0.01,-3.3 0.1923,-4.52944 0.4148,-2.73209 0.2226,1.79735 0.218,4.49735 -0.01,6 -0.2281,1.50265 -0.4102,0.0321 -0.4046,-3.26791 z m 12,0 c 0.01,-3.3 0.1923,-4.52944 0.4148,-2.73209 0.2226,1.79735 0.218,4.49735 -0.01,6 -0.2281,1.50265 -0.4102,0.0321 -0.4046,-3.26791 z m 36.137,-26.5 c 0,-17.875 0.1356,-25.1875 0.3013,-16.25 0.1657,8.9375 0.1657,23.5625 0,32.5 -0.1657,8.9375 -0.3013,1.625 -0.3013,-16.25 z M 1191,190.34098 c 0,-0.54579 1.2375,-2.08329 2.75,-3.41667 l 2.75,-2.42431 -2.5,3 c -1.375,1.65 -2.6125,3.1875 -2.75,3.41667 -0.1375,0.22916 -0.25,-0.0299 -0.25,-0.57569 z m 21.6942,-2.87258 c -1.5431,-1.35762 -2.4091,-2.4684 -1.9243,-2.4684 0.4848,0 1.9384,1.125 3.2301,2.5 2.9886,3.18124 2.328,3.16525 -1.3058,-0.0316 z m -12.9442,-3.1918 c 1.7875,-0.22182 4.7125,-0.22182 6.5,0 1.7875,0.22183 0.325,0.40333 -3.25,0.40333 -3.575,0 -5.0375,-0.1815 -3.25,-0.40333 z"  ,
            "m 1054,410 v -6 h 112 112 v -8 -8 h -112 -112 v -6 -6 h 10 10 v -10 -10 h -10 c -9.3333,0 -10,-0.13333 -10,-2 0,-1.86667 0.6667,-2 10,-2 h 10 v -10 -10 h -10 c -9.3333,0 -10,-0.13333 -10,-2 0,-1.86667 0.6667,-2 10,-2 h 10 v -10 -10 h -10 c -9.3333,0 -10,-0.13333 -10,-2 0,-1.86667 0.6667,-2 10,-2 h 10 v -8 -8 h -10 c -9.3333,0 -10,-0.13333 -10,-2 0,-1.86667 0.6667,-2 10,-2 h 10 v -10 -10 h -10 c -9.3333,0 -10,-0.13333 -10,-2 0,-1.86667 0.6667,-2 10,-2 h 10 v -10 -10 h -10 -10 v -4 -4 h 112 112 v -8 -8 h -112 -112 v -6 -6 h 44 44 v -32 -32 h 61.5 61.5 v 32 32 h 12 12 l 0.046,4.25 c 0.025,2.3375 0.022,41.6 -0.01,87.25 -0.029,45.65 -0.05,91.4375 -0.046,101.75 L 1289,416 H 1171.5 1054 Z m 44,-44 v -10 h -10 -10 v 10 10 h 10 10 z m 20,0 v -10 h -8 -8 v 10 10 h 8 8 z m 24,0 v -10 h -10 -10 v 10 10 h 10 10 z m 24,0 v -10 h -10 -10 v 10 10 h 10 10 z m 24,0 v -10 h -10 -10 v 10 10 h 10 10 z m 20,0 v -10 h -8 -8 v 10 10 h 8 8 z m 24,0 v -10 h -10.5 -10.5 v 10 10 h 10.5 10.5 z m 24,0 v -10 h -10.5 -10.5 v 10 10 h 10.5 10.5 z m 20,0 v -10 h -8.5 -8.5 v 10 10 h 8.5 8.5 z m -180,-24 v -10 h -10 -10 v 10 10 h 10 10 z m 20,0 v -10 h -8 -8 v 10 10 h 8 8 z m 24,0 v -10 h -10 -10 v 10 10 h 10 10 z m 24,0 v -10 h -10 -10 v 10 10 h 10 10 z m 24,0 v -10 h -10 -10 v 10 10 h 10 10 z m 20,0 v -10 h -8 -8 v 10 10 h 8 8 z m 24,0 v -10 h -10.5 -10.5 v 10 10 h 10.5 10.5 z m 24,0 v -10 h -10.5 -10.5 v 10 10 h 10.5 10.5 z m 20,0 v -10 h -8.5 -8.5 v 10 10 h 8.5 8.5 z m -180,-24 v -10 h -10 -10 v 10 10 h 10 10 z m 20,0 v -10 h -8 -8 v 10 10 h 8 8 z m 24,0 v -10 h -10 -10 v 10 10 h 10 10 z m 24,0 v -10 h -10 -10 v 10 10 h 10 10 z m 24,0 v -10 h -10 -10 v 10 10 h 10 10 z m 20,0 v -10 h -8 -8 v 10 10 h 8 8 z m 24,0 v -10 h -10.5 -10.5 v 10 10 h 10.5 10.5 z m 24,0 v -10 h -10.5 -10.5 v 10 10 h 10.5 10.5 z m 20,0 v -10 h -8.5 -8.5 v 10 10 h 8.5 8.5 z m -180,-22 v -8 h -10 -10 v 8 8 h 10 10 z m 20,0 v -8 h -8 -8 v 8 8 h 8 8 z m 24,0 v -8 h -10 -10 v 8 8 h 10 10 z m 24,0 v -8 h -10 -10 v 8 8 h 10 10 z m 24,0 v -8 h -10 -10 v 8 8 h 10 10 z m 20,0 v -8 h -8 -8 v 8 8 h 8 8 z m 24,0 v -8 h -10.5 -10.5 v 8 8 h 10.5 10.5 z m 24,0 v -8 h -10.5 -10.5 v 8 8 h 10.5 10.5 z m 20,0 v -8 h -8.5 -8.5 v 8 8 h 8.5 8.5 z m -180,-22 v -10 h -10 -10 v 10 10 h 10 10 z m 20,0 v -10 h -8 -8 v 10 10 h 8 8 z m 24,0 v -10 h -10 -10 v 10 10 h 10 10 z m 24,0 v -10 h -10 -10 v 10 10 h 10 10 z m 24,0 v -10 h -10 -10 v 10 10 h 10 10 z m 20,0 v -10 h -8 -8 v 10 10 h 8 8 z m 24,0 v -10 h -10.5 -10.5 v 10 10 h 10.5 10.5 z m 24,0 v -10 h -10.5 -10.5 v 10 10 h 10.5 10.5 z m 20,0 v -10 h -8.5 -8.5 v 10 10 h 8.5 8.5 z m -180,-24 v -10 h -10 -10 v 10 10 h 10 10 z m 20,0 v -10 h -8 -8 v 10 10 h 8 8 z m 24,0 v -10 h -10 -10 v 10 10 h 10 10 z m 24,0 v -10 h -10 -10 v 10 10 h 10 10 z m 24,0 v -10 h -10 -10 v 10 10 h 10 10 z m 20,0 v -10 h -8 -8 v 10 10 h 8 8 z m 24,0 v -10 h -10.5 -10.5 v 10 10 h 10.5 10.5 z m 24,0 v -10 h -10.5 -10.5 v 10 10 h 10.5 10.5 z m 20,0 v -10 h -8.5 -8.5 v 10 10 h 8.5 8.5 z m -99.7896,-53.25 c 0.7939,-12.1573 6.5349,-20.39719 16.2211,-23.28151 18.7342,-5.57861 34.5685,5.2901 34.5685,23.72785 V 204 h 12.5 12.5 v -18 -18 h -50 -50 v 18 18 h 11.8685 11.8685 z M 1218,198.64788 c 0,-3.91528 -0.6121,-6.2604 -2.28,-8.73543 -3.0319,-4.49909 -6.0651,-5.88 -12.9542,-5.89771 -4.9181,-0.0126 -6.1935,0.39559 -8.9607,2.86811 -2.9575,2.64251 -3.26,3.4762 -3.6286,10 L 1189.7743,204 H 1203.8872 1218 Z M 1254,158 v -6 h -50 -50 v 6 6 h 50 50 z m 51,219.5 c 0,-0.825 0.675,-1.5 1.5,-1.5 0.825,0 1.5,0.675 1.5,1.5 0,0.825 -0.675,1.5 -1.5,1.5 -0.825,0 -1.5,-0.675 -1.5,-1.5 z m 24,0 c 0,-0.825 0.675,-1.5 1.5,-1.5 0.825,0 1.5,0.675 1.5,1.5 0,0.825 -0.675,1.5 -1.5,1.5 -0.825,0 -1.5,-0.675 -1.5,-1.5 z m -19,-0.5 c 0,-0.55 0.45,-1 1,-1 0.55,0 1,0.45 1,1 0,0.55 -0.45,1 -1,1 -0.55,0 -1,-0.45 -1,-1 z m -815.72764,-5 c 0,-2.475 0.19502,-3.4875 0.43337,-2.25 0.23836,1.2375 0.23836,3.2625 0,4.5 -0.23835,1.2375 -0.43337,0.225 -0.43337,-2.25 z"  ,
            "M 878,228 V 40 h 20 20 V 20 0 h 48 48 v 20 20 h 20 20 v 188 188 h -88 -88 z m 164,0 V 52 h -76 -76 v 176 176 h 76 76 z M 938,26 V 12 h -4 -4 v 14 14 h 4 4 z m 12,0 V 12 h -4 -4 v 14 14 h 4 4 z m 12,0 V 12 h -4 -4 v 14 14 h 4 4 z m 12,0 V 12 h -4 -4 v 14 14 h 4 4 z m 12,0 V 12 h -4 -4 v 14 14 h 4 4 z m 16,0 V 12 h -6 -6 v 14 14 h 6 6 z"  ,
            "m 495.02196,370.75 c 0.0359,-8.57055 4.64104,-16.34192 12.09064,-20.40327 3.23526,-1.76378 9.03545,-1.85864 129.1374,-2.11185 L 762,347.96977 V 351.98488 356 H 637.36803 C 514.15656,356 512.69889,356.023 509.4745,358.01576 506.75822,359.69451 503,365.14239 503,367.40113 503,367.73051 561.275,368 632.5,368 H 762 v 4 4 H 628.5 495 l 0.022,-5.25 z M 1213.1579,226 c 0,-1.375 0.227,-1.9375 0.5044,-1.25 0.2774,0.6875 0.2774,1.8125 0,2.5 -0.2774,0.6875 -0.5044,0.125 -0.5044,-1.25 z m 24,0 c 0,-1.375 0.227,-1.9375 0.5044,-1.25 0.2774,0.6875 0.2774,1.8125 0,2.5 -0.2774,0.6875 -0.5044,0.125 -0.5044,-1.25 z m 24,0 c 0,-1.375 0.227,-1.9375 0.5044,-1.25 0.2774,0.6875 0.2774,1.8125 0,2.5 -0.2774,0.6875 -0.5044,0.125 -0.5044,-1.25 z"  ,
            "m 902,226 c 0,-161.333333 0.008,-162 2,-162 1.99177,0 2,0.666667 2,162 0,161.33333 -0.008,162 -2,162 -1.99177,0 -2,-0.66667 -2,-162 z m 12,150 v -12 h 12 12 v 12 12 h -12 -12 z m 20,6 c 0,-1.83333 -0.66667,-2 -8,-2 -7.33333,0 -8,0.16667 -8,2 0,1.83333 0.66667,2 8,2 7.33333,0 8,-0.16667 8,-2 z m 0,-10 v -4 h -8 -8 v 4 4 h 8 8 z m 20,4 v -12 h 12 12 v 12 12 h -12 -12 z m 20,6 c 0,-1.83333 -0.66667,-2 -8,-2 -7.33333,0 -8,0.16667 -8,2 0,1.83333 0.66667,2 8,2 7.33333,0 8,-0.16667 8,-2 z m 0,-10 v -4 h -8 -8 v 4 4 h 8 8 z m 20,4 v -12 h 12 12 v 12 12 h -12 -12 z m 20,6 c 0,-1.83333 -0.6667,-2 -8,-2 -7.33333,0 -8,0.16667 -8,2 0,1.83333 0.66667,2 8,2 7.3333,0 8,-0.16667 8,-2 z m 0,-10 v -4 h -8 -8 v 4 4 h 8 8 z m 12,-146 c 0,-161.333333 0.01,-162 2,-162 1.9918,0 2,0.666667 2,162 0,161.33333 -0.01,162 -2,162 -1.9918,0 -2,-0.66667 -2,-162 z M 914,340 v -12 h 12 12 v 12 12 h -12 -12 z m 20,6 c 0,-1.83333 -0.66667,-2 -8,-2 -7.33333,0 -8,0.16667 -8,2 0,1.83333 0.66667,2 8,2 7.33333,0 8,-0.16667 8,-2 z m 0,-10 v -4 h -8 -8 v 4 4 h 8 8 z m 20,4 v -12 h 12 12 v 12 12 h -12 -12 z m 20,6 c 0,-1.83333 -0.66667,-2 -8,-2 -7.33333,0 -8,0.16667 -8,2 0,1.83333 0.66667,2 8,2 7.33333,0 8,-0.16667 8,-2 z m 0,-10 v -4 h -8 -8 v 4 4 h 8 8 z m 20,4 v -12 h 12 12 v 12 12 h -12 -12 z m 20,6 c 0,-1.83333 -0.6667,-2 -8,-2 -7.33333,0 -8,0.16667 -8,2 0,1.83333 0.66667,2 8,2 7.3333,0 8,-0.16667 8,-2 z m 0,-10 v -4 h -8 -8 v 4 4 h 8 8 z M 914,304 v -12 h 12 12 v 12 12 h -12 -12 z m 20,6 c 0,-1.83333 -0.66667,-2 -8,-2 -7.33333,0 -8,0.16667 -8,2 0,1.83333 0.66667,2 8,2 7.33333,0 8,-0.16667 8,-2 z m 0,-10 v -4 h -8 -8 v 4 4 h 8 8 z m 20,4 v -12 h 12 12 v 12 12 h -12 -12 z m 20,6 c 0,-1.83333 -0.66667,-2 -8,-2 -7.33333,0 -8,0.16667 -8,2 0,1.83333 0.66667,2 8,2 7.33333,0 8,-0.16667 8,-2 z m 0,-10 v -4 h -8 -8 v 4 4 h 8 8 z m 20,4 v -12 h 12 12 v 12 12 h -12 -12 z m 20,6 c 0,-1.83333 -0.6667,-2 -8,-2 -7.33333,0 -8,0.16667 -8,2 0,1.83333 0.66667,2 8,2 7.3333,0 8,-0.16667 8,-2 z m 0,-10 v -4 h -8 -8 v 4 4 h 8 8 z M 914,268 v -12 h 12 12 v 12 12 h -12 -12 z m 20,6 c 0,-1.83333 -0.66667,-2 -8,-2 -7.33333,0 -8,0.16667 -8,2 0,1.83333 0.66667,2 8,2 7.33333,0 8,-0.16667 8,-2 z m 0,-10 v -4 h -8 -8 v 4 4 h 8 8 z m 20,4 v -12 h 12 12 v 12 12 h -12 -12 z m 20,6 c 0,-1.83333 -0.66667,-2 -8,-2 -7.33333,0 -8,0.16667 -8,2 0,1.83333 0.66667,2 8,2 7.33333,0 8,-0.16667 8,-2 z m 0,-10 v -4 h -8 -8 v 4 4 h 8 8 z m 20,4 v -12 h 12 12 v 12 12 h -12 -12 z m 20,6 c 0,-1.83333 -0.6667,-2 -8,-2 -7.33333,0 -8,0.16667 -8,2 0,1.83333 0.66667,2 8,2 7.3333,0 8,-0.16667 8,-2 z m 0,-10 v -4 h -8 -8 v 4 4 h 8 8 z M 914,232 v -12 h 12 12 v 12 12 h -12 -12 z m 20,6 c 0,-1.83333 -0.66667,-2 -8,-2 -7.33333,0 -8,0.16667 -8,2 0,1.83333 0.66667,2 8,2 7.33333,0 8,-0.16667 8,-2 z m 0,-10 v -4 h -8 -8 v 4 4 h 8 8 z m 20,4 v -12 h 12 12 v 12 12 h -12 -12 z m 20,6 c 0,-1.83333 -0.66667,-2 -8,-2 -7.33333,0 -8,0.16667 -8,2 0,1.83333 0.66667,2 8,2 7.33333,0 8,-0.16667 8,-2 z m 0,-10 v -4 h -8 -8 v 4 4 h 8 8 z m 20,4 v -12 h 12 12 v 12 12 h -12 -12 z m 20,6 c 0,-1.83333 -0.6667,-2 -8,-2 -7.33333,0 -8,0.16667 -8,2 0,1.83333 0.66667,2 8,2 7.3333,0 8,-0.16667 8,-2 z m 0,-10 v -4 h -8 -8 v 4 4 h 8 8 z m 48,-2 c 0,-1.66667 0.6667,-2 4,-2 3.3333,0 4,0.33333 4,2 0,1.66667 -0.6667,2 -4,2 -3.3333,0 -4,-0.33333 -4,-2 z m 24,0 c 0,-1.66667 0.6667,-2 4,-2 3.3333,0 4,0.33333 4,2 0,1.66667 -0.6667,2 -4,2 -3.3333,0 -4,-0.33333 -4,-2 z m 24,0 c 0,-1.66667 0.6667,-2 4,-2 3.3333,0 4,0.33333 4,2 0,1.66667 -0.6667,2 -4,2 -3.3333,0 -4,-0.33333 -4,-2 z m 24,0 c 0,-1.66667 0.6667,-2 4,-2 3.3333,0 4,0.33333 4,2 0,1.66667 -0.6667,2 -4,2 -3.3333,0 -4,-0.33333 -4,-2 z m 24,0 c 0,-1.66667 0.6667,-2 4,-2 3.3333,0 4,0.33333 4,2 0,1.66667 -0.6667,2 -4,2 -3.3333,0 -4,-0.33333 -4,-2 z m 24,0 c 0,-1.66667 0.6667,-2 4,-2 3.3333,0 4,0.33333 4,2 0,1.66667 -0.6667,2 -4,2 -3.3333,0 -4,-0.33333 -4,-2 z m 24,0 c 0,-1.61905 0.6667,-2 3.5,-2 2.8333,0 3.5,0.38095 3.5,2 0,1.61905 -0.6667,2 -3.5,2 -2.8333,0 -3.5,-0.38095 -3.5,-2 z m 24,0 c 0,-1.61905 0.6667,-2 3.5,-2 2.8333,0 3.5,0.38095 3.5,2 0,1.61905 -0.6667,2 -3.5,2 -2.8333,0 -3.5,-0.38095 -3.5,-2 z m 24,0 c 0,-1.61905 0.6667,-2 3.5,-2 2.8333,0 3.5,0.38095 3.5,2 0,1.61905 -0.6667,2 -3.5,2 -2.8333,0 -3.5,-0.38095 -3.5,-2 z M 914,196 v -12 h 12 12 v 12 12 h -12 -12 z m 20,6 c 0,-1.83333 -0.66667,-2 -8,-2 -7.33333,0 -8,0.16667 -8,2 0,1.83333 0.66667,2 8,2 7.33333,0 8,-0.16667 8,-2 z m 0,-10 v -4 h -8 -8 v 4 4 h 8 8 z m 20,4 v -12 h 12 12 v 12 12 h -12 -12 z m 20,6 c 0,-1.83333 -0.66667,-2 -8,-2 -7.33333,0 -8,0.16667 -8,2 0,1.83333 0.66667,2 8,2 7.33333,0 8,-0.16667 8,-2 z m 0,-10 v -4 h -8 -8 v 4 4 h 8 8 z m 20,4 v -12 h 12 12 v 12 12 h -12 -12 z m 20,6 c 0,-1.83333 -0.6667,-2 -8,-2 -7.33333,0 -8,0.16667 -8,2 0,1.83333 0.66667,2 8,2 7.3333,0 8,-0.16667 8,-2 z m 0,-10 v -4 h -8 -8 v 4 4 h 8 8 z M 914,160 v -12 h 12 12 v 12 12 h -12 -12 z m 20,6 c 0,-1.83333 -0.66667,-2 -8,-2 -7.33333,0 -8,0.16667 -8,2 0,1.83333 0.66667,2 8,2 7.33333,0 8,-0.16667 8,-2 z m 0,-10 v -4 h -8 -8 v 4 4 h 8 8 z m 20,4 v -12 h 12 12 v 12 12 h -12 -12 z m 20,6 c 0,-1.83333 -0.66667,-2 -8,-2 -7.33333,0 -8,0.16667 -8,2 0,1.83333 0.66667,2 8,2 7.33333,0 8,-0.16667 8,-2 z m 0,-10 v -4 h -8 -8 v 4 4 h 8 8 z m 20,4 v -12 h 12 12 v 12 12 h -12 -12 z m 20,6 c 0,-1.83333 -0.6667,-2 -8,-2 -7.33333,0 -8,0.16667 -8,2 0,1.83333 0.66667,2 8,2 7.3333,0 8,-0.16667 8,-2 z m 0,-10 v -4 h -8 -8 v 4 4 h 8 8 z M 914,124 v -12 h 12 12 v 12 12 h -12 -12 z m 20,6 c 0,-1.83333 -0.66667,-2 -8,-2 -7.33333,0 -8,0.16667 -8,2 0,1.83333 0.66667,2 8,2 7.33333,0 8,-0.16667 8,-2 z m 0,-10 v -4 h -8 -8 v 4 4 h 8 8 z m 20,4 v -12 h 12 12 v 12 12 h -12 -12 z m 20,6 c 0,-1.83333 -0.66667,-2 -8,-2 -7.33333,0 -8,0.16667 -8,2 0,1.83333 0.66667,2 8,2 7.33333,0 8,-0.16667 8,-2 z m 0,-10 v -4 h -8 -8 v 4 4 h 8 8 z m 20,4 v -12 h 12 12 v 12 12 h -12 -12 z m 20,6 c 0,-1.83333 -0.6667,-2 -8,-2 -7.33333,0 -8,0.16667 -8,2 0,1.83333 0.66667,2 8,2 7.3333,0 8,-0.16667 8,-2 z m 0,-10 v -4 h -8 -8 v 4 4 h 8 8 z M 914,88 V 76 h 12 12 v 12 12 h -12 -12 z m 20,6 c 0,-1.833333 -0.66667,-2 -8,-2 -7.33333,0 -8,0.166667 -8,2 0,1.833333 0.66667,2 8,2 7.33333,0 8,-0.166667 8,-2 z m 0,-10 v -4 h -8 -8 v 4 4 h 8 8 z m 20,4 V 76 h 12 12 v 12 12 h -12 -12 z m 20,6 c 0,-1.833333 -0.66667,-2 -8,-2 -7.33333,0 -8,0.166667 -8,2 0,1.833333 0.66667,2 8,2 7.33333,0 8,-0.166667 8,-2 z m 0,-10 v -4 h -8 -8 v 4 4 h 8 8 z m 20,4 V 76 h 12 12 v 12 12 h -12 -12 z m 20,6 c 0,-1.833333 -0.6667,-2 -8,-2 -7.33333,0 -8,0.166667 -8,2 0,1.833333 0.66667,2 8,2 7.3333,0 8,-0.166667 8,-2 z m 0,-10 v -4 h -8 -8 v 4 4 h 8 8 z"  ,
    };

    protected static int[] townColors = new int[]{
            0xfff2ebe0,
            0xffb3ddeb,
            0xff98d2d0,
            0xffc0b8b1,
            0xff85acbe,
            0xffafa68b,
            0xff69b3af,
            0xff679893,
            0xff8c7982,
            0xff549691,
            0xff847079,
            0xffb65649,
            0xff52837e,
            0xff66525d,
            0xff434343,
            0xff2b4247,
            0xff360000,
            0xff000000,
    };

    protected static int[] skyColors = new int[]{
            0xff38adc1,
            0x88ffffff,
    };
    protected static String[] skyPaths = new String[]{
            "M0,0L1600,0L1600,1040L0,1040z",
            "m412,660v-4h76,76v4,4h-76,-76zM1200,654c0,-2 0.7,-2 76,-2 75.3,0 76,0 76,2 0,2 -0.7,2 -76,2 -75.3,0 -76,-0 -76,-2zM904,638c0,-2 0.7,-2 56,-2 55.3,0 56,0 56,2 0,2 -0.7,2 -56,2 -55.3,0 -56,-0 -56,-2zM184,610c0,-2 0.7,-2 72,-2 71.3,0 72,0 72,2 0,2 -0.7,2 -72,2 -71.3,0 -72,-0 -72,-2zM852,578c0,-2 0.7,-2 67.9,-2h67.9l1.2,-7.4c2.1,-13.2 11,-27.4 20,-32.1 2.3,-1.2 2.8,-2.3 3.4,-6.6 2.2,-18.8 21.7,-31.8 39.8,-26.6 3,0.9 6.7,2.6 8.2,3.7 1.5,1.2 2.8,2 2.9,1.8 6.9,-11.6 16.3,-20.9 26.7,-26.3 29.2,-15.4 64.5,-6.4 82.9,21 5.1,7.6 10.1,20.7 10.1,26.5 0,1.6 0.8,3.6 1.8,4.4 14.6,12.2 19,18.9 22,33.3L1208.5,576h195.8c195.1,0 195.8,0 195.8,2 0,2 -0.7,2 -197.9,2h-197.9l-0.6,-6.7c-1.2,-12.7 -9.2,-25.4 -20.5,-32.3 -4.8,-3 -4.8,-3 -5.4,-9.3 -1.6,-16.9 -13.5,-34.7 -29,-43.5 -16.9,-9.6 -38.9,-9.9 -56.2,-0.9 -8,4.2 -20.1,16.4 -24.4,24.5l-3.3,6.3 -3.9,-3.5c-5.3,-4.8 -10.3,-6.7 -17.5,-6.8 -14.6,-0.1 -26.2,10.6 -26.8,24.7 -0.2,4.9 -0.3,5.1 -5.8,8.6 -9.8,6.4 -17.2,19.5 -18.6,33L991.7,580L921.9,580C852.7,580 852,580 852,578ZM0,522c0,-2 0.7,-2 127.3,-2l127.3,-0 1.6,-8.2c2.2,-11.5 6.1,-19.1 13.3,-26.3C279,475.9 289.3,472 305.1,472c7.8,0 8,-0.1 9,-2.8 6.4,-17.3 20.6,-30.7 36.8,-34.7 3.7,-0.9 7.3,-2 8,-2.3 0.7,-0.4 2.6,-4 4.3,-8 7.9,-19.7 22,-34.6 41.4,-43.7 12.9,-6.1 21.5,-7.9 36,-7.8 9.9,0.1 13.6,0.6 21,2.8 21.3,6.3 38.3,19.5 49.5,38.5 4.5,7.5 6.5,12.7 8.9,22.5l1.7,7 5.9,0.7c21.7,2.4 40.5,19.7 46.1,42.3 1.4,5.6 2.1,6.8 5.5,9 6.3,4.2 11.3,12.3 13.3,21.8l0.6,2.8h71.5C735.3,520 736,520 736,522c0,2 -0.7,2 -73.4,2h-73.4l-1,-2.8c-0.6,-1.5 -1.6,-4.6 -2.3,-6.8 -0.7,-2.2 -2.3,-5.7 -3.7,-7.7C579.9,503.2 573.4,498 571.3,498c-0.6,0 -1.5,-2.6 -2.1,-5.8 -4.2,-23.5 -21.6,-40.7 -43.7,-43.2 -7.9,-0.9 -9.5,-1.8 -9.5,-5.6 -0,-4.3 -4.3,-17.3 -8.3,-24.8 -7,-13.5 -22.8,-28.3 -36.4,-34.2 -9.9,-4.3 -16.1,-5.6 -28.4,-6.2 -10.7,-0.5 -13.8,-0.2 -21,1.6 -28.5,7.2 -48.2,26.5 -57.4,56.4 -0.4,1.2 -1.6,1.8 -4.1,1.8 -5,0 -14.8,3.5 -20.9,7.4 -9.9,6.4 -18.3,17.6 -21,28.4l-1.1,4.3 -11.5,0.3c-7.7,0.2 -13.3,0.9 -17,2.1 -16.2,5.3 -26.1,18.4 -28.4,37.8L259.9,524L129.9,524C0.7,524 0,524 0,522ZM1208,396v-4h16,16v4,4h-16,-16zM1280,396v-4h74,74v4,4h-74,-74z",
    };

    protected static int[] sunColors = new int[]{
            0xfffef9e8,
            0xfff3e59c,
    };
    protected static String[] sunPaths = new String[]{
            "m109.1,226.62c-0.79,-0.95 -1.06,-6.89 -0.87,-19.14 0.24,-15.65 0.48,-17.89 2.02,-18.86 1.28,-0.8 2.22,-0.8 3.5,0 1.54,0.97 1.78,3.22 2.02,18.86C116.06,225.82 115.66,228 112,228c-0.97,0 -2.27,-0.62 -2.9,-1.38zM56.2,211.8c-0.66,-0.66 -1.2,-1.75 -1.2,-2.42 0,-0.67 3.91,-8 8.68,-16.3C71.62,179.3 72.61,178 75.16,178c5.4,0 4.68,3.34 -3.95,18.26 -4.35,7.52 -8.48,14.36 -9.18,15.2C60.5,213.3 57.85,213.45 56.2,211.8ZM165.97,211.47c-0.7,-0.84 -4.83,-7.68 -9.18,-15.2C148.16,181.34 147.43,178 152.84,178c2.56,0 3.55,1.3 11.48,15.08 4.78,8.3 8.68,15.63 8.68,16.3 0,3.33 -4.81,4.76 -7.03,2.08zM16.2,171.8c-1.65,-1.65 -1.5,-4.3 0.33,-5.83 0.84,-0.7 7.68,-4.83 15.2,-9.18C46.66,148.16 50,147.43 50,152.84c0,2.56 -1.3,3.55 -15.08,11.48C26.62,169.09 19.29,173 18.62,173 17.95,173 16.86,172.46 16.2,171.8ZM192.75,164.26C179.38,156.4 178,155.33 178,152.81c0,-5.44 3.35,-4.67 18.95,4.39 7.89,4.58 14.83,9.1 15.44,10.06 1.38,2.19 -0.25,5.15 -2.99,5.45 -1.04,0.12 -8.54,-3.69 -16.65,-8.46zM105.06,164.91C90.72,162.1 75.91,150.34 69.37,136.56 48.31,92.21 94.21,46.31 138.56,67.37c10.34,4.91 19.16,13.73 24.07,24.07 18.52,38.99 -15.04,81.81 -57.58,73.47zM125.2,156.89c12.02,-2.51 23.55,-11.32 29.53,-22.54 13.91,-26.1 -2.19,-58.49 -31.58,-63.53 -29.3,-5.02 -55.36,21.03 -50.33,50.33 4.23,24.68 27.93,40.85 52.38,35.74zM1.22,118.82C0.55,118.15 0,116.85 0,115.92c0,-3.57 2.26,-3.98 20.52,-3.7 15.65,0.24 17.89,0.48 18.86,2.02 0.8,1.28 0.8,2.22 -0,3.5 -0.97,1.54 -3.22,1.78 -19.02,2.02 -13.09,0.2 -18.25,-0.06 -19.14,-0.95zM189.22,118.82C188.55,118.15 188,116.85 188,115.92c0,-3.57 2.26,-3.98 20.52,-3.7 15.65,0.24 17.89,0.48 18.86,2.02 0.8,1.28 0.8,2.22 -0,3.5 -0.97,1.54 -3.22,1.78 -19.02,2.02 -13.09,0.2 -18.25,-0.06 -19.14,-0.95zM30.61,70.66c-7.64,-4.49 -14.39,-8.95 -14.99,-9.91 -1.28,-2.02 0.14,-5.06 2.59,-5.54 0.82,-0.16 8.31,3.63 16.64,8.43C48.51,71.51 50,72.63 50,75.08c0,2.57 -1.65,4.04 -4.33,3.84 -0.64,-0.05 -7.42,-3.76 -15.06,-8.25zM179.25,78.34C178.56,78.06 178,76.6 178,75.1c0,-2.48 1.44,-3.56 15.16,-11.46 8.34,-4.8 15.83,-8.59 16.64,-8.43 2.44,0.48 3.86,3.52 2.59,5.53 -1.22,1.93 -28.89,18.3 -30.73,18.18 -0.64,-0.04 -1.72,-0.31 -2.41,-0.58zM63.65,34.92C58.83,26.62 55.02,19.13 55.19,18.27c0.49,-2.51 3.51,-3.95 5.55,-2.66 0.96,0.6 5.48,7.55 10.06,15.44C79.85,46.65 80.63,50 75.19,50 72.66,50 71.62,48.63 63.65,34.92ZM149.46,47.69c-0.43,-1.71 1.57,-6.01 7.74,-16.65 4.58,-7.89 9.1,-14.83 10.06,-15.44 2.02,-1.27 5.05,0.15 5.53,2.59 0.16,0.82 -3.63,8.31 -8.43,16.64C156.39,48.7 155.39,50 152.84,50c-2.09,0 -2.95,-0.59 -3.38,-2.31zM109.1,38.62c-0.79,-0.95 -1.06,-6.89 -0.87,-19.14 0.24,-15.65 0.48,-17.89 2.02,-18.86 1.28,-0.8 2.22,-0.8 3.5,0 1.54,0.97 1.78,3.22 2.02,18.86C116.06,37.82 115.66,40 112,40c-0.97,0 -2.27,-0.62 -2.9,-1.38z",
            "M105.5,156.61C83.66,151.3 69.02,129.01 72.82,106.85 76.91,83 99.57,66.78 123.15,70.82c23.85,4.09 40.07,26.75 36.03,50.33 -4.31,25.12 -29.03,41.45 -53.68,35.46z"
    };
    //</editor-fold>

    protected Drawable mDrawableSun;
    protected Drawable mDrawableSky;
    protected Drawable mDrawableTown;
    protected Matrix mMatrix;
    protected float mPercent;
    protected float mRotate;
    protected int mHeaderHeight;
    protected int mSunSize;
    protected boolean isRefreshing;
    protected Animation mAnimation;

    //<editor-fold desc="View">
    public PhoenixHeader(Context context) {
        this(context, null);
    }

    public PhoenixHeader(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public PhoenixHeader(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);

        mMatrix = new Matrix();
        DensityUtil density = new DensityUtil();
        mSunSize = density.dip2px(40);
        final View thisView = this;
        thisView.setMinimumHeight(density.dip2px(100));

        mSpinnerStyle = SpinnerStyle.Scale;


        //<editor-fold desc="setupAnimation">
        mAnimation = new Animation() {
            @Override
            public void applyTransformation(float interpolatedTime, Transformation t) {
                final View thisView = PhoenixHeader.this;
                mRotate = (interpolatedTime);
                thisView.invalidate();
            }
        };
        mAnimation.setRepeatCount(Animation.INFINITE);
        mAnimation.setRepeatMode(Animation.RESTART);
        mAnimation.setInterpolator(LINEAR_INTERPOLATOR);
        mAnimation.setDuration(ANIMATION_DURATION);
        //</editor-fold>

        //<editor-fold desc="setupPathsDrawable">
        int widthPixels = Resources.getSystem().getDisplayMetrics().widthPixels;
        PathsDrawable townDrawable = new PathsDrawable();
        townDrawable.parserColors(townColors);
        if (!townDrawable.parserPaths(townPaths)) {
            townDrawable.declareOriginal(1, 0, 1870, 416);
        }
//        townDrawable.printOriginal("townDrawable");
        mDrawableTown = townDrawable;
        Rect bounds = mDrawableTown.getBounds();
        mDrawableTown.setBounds(0, 0, widthPixels, widthPixels * bounds.height() / bounds.width());

        PathsDrawable skyDrawable = new PathsDrawable();
        skyDrawable.parserColors(skyColors);
        if (!skyDrawable.parserPaths(skyPaths)) {
            skyDrawable.declareOriginal(0, 0, 1600, 1040);
        }
//        skyDrawable.printOriginal("skyDrawable");
        mDrawableSky = skyDrawable;
        bounds = mDrawableSky.getBounds();
        mDrawableSky.setBounds(0, 0, widthPixels, widthPixels * bounds.height() / bounds.width());

        PathsDrawable sunDrawable = new PathsDrawable();
        sunDrawable.parserColors(sunColors);
        if (!sunDrawable.parserPaths(sunPaths)) {
            sunDrawable.declareOriginal(0, 0, 228, 228);
        }
//        sunDrawable.printOriginal("sunDrawable");
        mDrawableSun = sunDrawable;
        mDrawableSun.setBounds(0, 0, mSunSize, mSunSize);

        //</editor-fold>


        TypedArray ta = context.obtainStyledAttributes(attrs, R.styleable.PhoenixHeader);

        int primaryColor = ta.getColor(R.styleable.PhoenixHeader_phPrimaryColor, 0);
        int accentColor = ta.getColor(R.styleable.PhoenixHeader_phAccentColor, 0);
        if (primaryColor != 0) {
            thisView.setBackgroundColor(primaryColor);
            if (accentColor != 0) {
                skyDrawable.parserColors(primaryColor, accentColor);
            } else {
                skyDrawable.parserColors(primaryColor);
            }
        }

        ta.recycle();
    }

    //</editor-fold>

    //<editor-fold desc="RefreshHeader">

    @Override
    public void onMoving(boolean isDragging, float percent, int offset, int height, int maxDragHeight) {
        mHeaderHeight = height;
        mRotate = mPercent = 1f * offset / height;
    }

//    @Override
//    public void onPulling(float percent, int offset, int height, int maxDragHeight) {
//        mRotate = mPercent = 1f * offset / height;
//        mHeaderHeight = height;
//    }
//
//    @Override
//    public void onReleasing(float percent, int offset, int height, int maxDragHeight) {
//        mRotate = mPercent = 1f * offset / height;
//        mHeaderHeight = height;
//    }

    @Override
    public void onReleased(@NonNull RefreshLayout layout, int height, int maxDragHeight) {
        isRefreshing = true;
        final View thisView = this;
        thisView.startAnimation(mAnimation);
    }

    @Override
    public int onFinish(@NonNull RefreshLayout layout, boolean success) {
        final View thisView = this;
        isRefreshing = false;
        thisView.clearAnimation();
        return 0;
    }

    /**
     * @param colors 对应Xml中配置的 srlPrimaryColor srlAccentColor
     * @deprecated 请使用 {@link RefreshLayout#setPrimaryColorsId(int...)}
     */
    @Override@Deprecated
    public void setPrimaryColors(@ColorInt int ... colors) {
        if (mDrawableSky instanceof PathsDrawable) {
            final View thisView = this;
            if (colors.length > 1) {
                thisView.setBackgroundColor(colors[0]);
                ((PathsDrawable) mDrawableSky).parserColors(colors);
            } else if (colors.length > 0) {
                thisView.setBackgroundColor(colors[0]);
                ((PathsDrawable) mDrawableSky).parserColors(colors[0], skyColors[1]);
            }
        }
    }
//
//    @NonNull
//    @Override
//    public SpinnerStyle getSpinnerStyle() {
//        return SpinnerStyle.Scale;
//    }
    //</editor-fold>

//    @Override
//    public int defineHeight() {
//        return (int)(Resources.getSystem().getDisplayMetrics().widthPixels * 0.27);
//    }
//
//    @Override
//    public int definemaxDragHeight() {
//        return (int) (defineHeight() * 0.3f);
//    }

    //<editor-fold desc="draw">


    @Override
    protected void dispatchDraw(Canvas canvas) {

        final View thisView = this;
        final int width = thisView.getWidth();
        final int height = thisView.getHeight();
        drawSky(canvas, width, height);
        drawSun(canvas, width);
        drawTown(canvas, width, height);

        super.dispatchDraw(canvas);
    }


    private void drawSky(Canvas canvas, int width, int height) {
        Matrix matrix = mMatrix;
        matrix.reset();

        int bWidth = mDrawableSky.getBounds().width();//mSky.getWidth();
        int bHeight = mDrawableSky.getBounds().height();//mSky.getHeight();
        float townScale = 1f * width / bWidth;
        float offsetX = 0;
        float offsetY = height / 2f - bHeight / 2f;

//        matrix.postScale(townScale, townScale);
//        matrix.postTranslate(offsetX, offsetY);
//
//        canvas.drawBitmap(mSky, matrix, null);

        final int saveCount = canvas.getSaveCount();
        canvas.save();
        canvas.translate(offsetX, offsetY);
        matrix.postScale(townScale, townScale);
        mDrawableSky.draw(canvas);
        canvas.restoreToCount(saveCount);
    }

    private void drawTown(Canvas canvas, int width, int height) {
        Matrix matrix = mMatrix;
        matrix.reset();

        int bWidth = mDrawableTown.getBounds().width();//mTown.getWidth();
        int bHeight = mDrawableTown.getBounds().height();//mTown.getHeight();
        float townScale = 1f * width / bWidth;
        float amplification = (0.3f * Math.max(mPercent - 1, 0) + 1);
        float offsetX = width / 2f - (int) (width * amplification) / 2f;
        float offsetY = mHeaderHeight * 0.1f * mPercent;
        townScale = amplification * townScale;

        if (offsetY + bHeight * townScale < height) {
            offsetY = height - bHeight * townScale;
        }

//        matrix.postScale(townScale, townScale, mDrawableTown.getBounds().width() / 2, mDrawableTown.getBounds().height() / 2);
//        matrix.postTranslate(offsetX, offsetY);
//        canvas.drawBitmap(mTown, matrix, null);

        final int saveCount = canvas.getSaveCount();
        canvas.save();
        canvas.translate(offsetX, offsetY);
        canvas.scale(townScale, townScale);
        mDrawableTown.draw(canvas);
        canvas.restoreToCount(saveCount);
    }

    private void drawSun(Canvas canvas, int width) {
        Matrix matrix = mMatrix;
        matrix.reset();


        float mSunLeftOffset = 0.3f * (float) width;
        float mSunTopOffset = (mHeaderHeight * 0.1f);

        float sunRadius = (float) mSunSize / 2.0f;
        float offsetX = mSunLeftOffset + sunRadius;
        float offsetY = mSunTopOffset + (mHeaderHeight / 2f) * (1.0f - Math.min(mPercent, 1)); // Move the sun up

        int bWidth = mDrawableSun.getBounds().width();
        float sunScale = 1f * mSunSize / bWidth;

        if (mPercent > 1) {
            sunScale = sunScale * (1.0f - 0.5f * (mPercent - 1));
            sunRadius = sunRadius * (1.0f - 0.5f * (mPercent - 1));
        }

        matrix.preScale(sunScale, sunScale);
        matrix.postRotate((isRefreshing ? -360 : 360) * mRotate * (isRefreshing ? 1 : SUN_INITIAL_ROTATE_GROWTH),
                sunRadius,
                sunRadius);

//        canvas.save();
//        canvas.translate(offsetX, offsetY);
//        canvas.drawBitmap(mSun, matrix, null);
//        canvas.restore();

        final int saveCount = canvas.getSaveCount();
        canvas.save();
        canvas.translate(offsetX, offsetY);
        canvas.concat(matrix);
        mDrawableSun.draw(canvas);
        canvas.restoreToCount(saveCount);
    }
    //</editor-fold>

}


