/*
 * Decompiled with CFR 0.152.
 */
package com.scwang.smartrefresh.header;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.graphics.ColorUtils;
import android.util.AttributeSet;
import android.view.animation.AccelerateInterpolator;
import com.scwang.smartrefresh.header.R;
import com.scwang.smartrefresh.header.internal.pathview.PathsDrawable;
import com.scwang.smartrefresh.layout.api.RefreshHeader;
import com.scwang.smartrefresh.layout.api.RefreshInternal;
import com.scwang.smartrefresh.layout.api.RefreshKernel;
import com.scwang.smartrefresh.layout.api.RefreshLayout;
import com.scwang.smartrefresh.layout.constant.RefreshState;
import com.scwang.smartrefresh.layout.constant.SpinnerStyle;
import com.scwang.smartrefresh.layout.internal.InternalAbstract;
import com.scwang.smartrefresh.layout.util.SmartUtil;

public class DropBoxHeader
extends InternalAbstract
implements RefreshHeader {
    protected static String[] drawable1Paths = new String[]{"M3 2h18v20h-18z", "m4,1c-1.105,0 -2,0.895 -2,2v3,11 3,1c0,1.105 0.895,2 2,2h2,12 2c1.105,0 2,-0.895 2,-2v-1,-3 -11,-3c0,-1.105 -0.895,-2 -2,-2h-2,-12 -2zM3.5,3h1c0.276,0 0.5,0.224 0.5,0.5v1c0,0.276 -0.224,0.5 -0.5,0.5h-1c-0.276,0 -0.5,-0.224 -0.5,-0.5v-1c0,-0.276 0.224,-0.5 0.5,-0.5zM19.5,3h1c0.276,0 0.5,0.224 0.5,0.5v1c0,0.276 -0.224,0.5 -0.5,0.5h-1c-0.276,0 -0.5,-0.224 -0.5,-0.5v-1c0,-0.276 0.224,-0.5 0.5,-0.5zM3.5,6h1c0.276,0 0.5,0.224 0.5,0.5v1c0,0.276 -0.224,0.5 -0.5,0.5h-1c-0.276,0 -0.5,-0.224 -0.5,-0.5v-1c0,-0.276 0.224,-0.5 0.5,-0.5zM19.5,6h1c0.276,0 0.5,0.224 0.5,0.5v1c0,0.276 -0.224,0.5 -0.5,0.5h-1c-0.276,0 -0.5,-0.224 -0.5,-0.5v-1c0,-0.276 0.224,-0.5 0.5,-0.5zM3.5,9h1c0.276,0 0.5,0.224 0.5,0.5v1c0,0.276 -0.224,0.5 -0.5,0.5h-1c-0.276,0 -0.5,-0.224 -0.5,-0.5v-1c0,-0.276 0.224,-0.5 0.5,-0.5zM19.5,9h1c0.276,0 0.5,0.224 0.5,0.5v1c0,0.276 -0.224,0.5 -0.5,0.5h-1c-0.276,0 -0.5,-0.224 -0.5,-0.5v-1c0,-0.276 0.224,-0.5 0.5,-0.5zM3.5,12h1c0.276,0 0.5,0.224 0.5,0.5v1c0,0.276 -0.224,0.5 -0.5,0.5h-1c-0.276,0 -0.5,-0.224 -0.5,-0.5v-1c0,-0.276 0.224,-0.5 0.5,-0.5zM19.5,12h1c0.276,0 0.5,0.224 0.5,0.5v1c0,0.276 -0.224,0.5 -0.5,0.5h-1c-0.276,0 -0.5,-0.224 -0.5,-0.5v-1c0,-0.276 0.224,-0.5 0.5,-0.5zM3.5,15h1c0.276,0 0.5,0.224 0.5,0.5v1c0,0.276 -0.224,0.5 -0.5,0.5h-1c-0.276,0 -0.5,-0.224 -0.5,-0.5v-1c0,-0.276 0.224,-0.5 0.5,-0.5zM19.5,15h1c0.276,0 0.5,0.224 0.5,0.5v1c0,0.276 -0.224,0.5 -0.5,0.5h-1c-0.276,0 -0.5,-0.224 -0.5,-0.5v-1c0,-0.276 0.224,-0.5 0.5,-0.5zM3.5,18h1c0.276,0 0.5,0.224 0.5,0.5v1c0,0.276 -0.224,0.5 -0.5,0.5h-1c-0.276,0 -0.5,-0.224 -0.5,-0.5v-1c0,-0.276 0.224,-0.5 0.5,-0.5zM19.5,18h1c0.276,0 0.5,0.224 0.5,0.5v1c0,0.276 -0.224,0.5 -0.5,0.5h-1c-0.276,0 -0.5,-0.224 -0.5,-0.5v-1c0,-0.276 0.224,-0.5 0.5,-0.5z"};
    protected static int[] drawable1Colors = new int[]{-1249039, -245496};
    protected static String[] drawable2Paths = new String[]{"M49,16.5l-14,-14l-27,0l0,53l41,0z", "m16,23.5h25c0.55,0 1,-0.45 1,-1 0,-0.55 -0.45,-1 -1,-1L16,21.5c-0.55,0 -1,0.45 -1,1 0,0.55 0.45,1 1,1z", "m16,15.5h10c0.55,0 1,-0.45 1,-1 0,-0.55 -0.45,-1 -1,-1L16,13.5c-0.55,0 -1,0.45 -1,1 0,0.55 0.45,1 1,1z", "M41,29.5L16,29.5c-0.55,0 -1,0.45 -1,1 0,0.55 0.45,1 1,1h25c0.55,0 1,-0.45 1,-1 0,-0.55 -0.45,-1 -1,-1z", "M41,37.5L16,37.5c-0.55,0 -1,0.45 -1,1 0,0.55 0.45,1 1,1h25c0.55,0 1,-0.45 1,-1 0,-0.55 -0.45,-1 -1,-1z", "M41,45.5L16,45.5c-0.55,0 -1,0.45 -1,1 0,0.55 0.45,1 1,1h25c0.55,0 1,-0.45 1,-1 0,-0.55 -0.45,-1 -1,-1z", "M49,16.5l-14,-14l0,14z"};
    protected static int[] drawable2Colors = new int[]{-76695, -2773417};
    protected static String[] drawable3Paths = new String[]{"M6.021,2.188L6.021,11.362C5.46,11.327 4.843,11.414 4.229,11.663C2.624,12.312 1.696,13.729 2.155,14.825C2.62,15.924 4.294,16.284 5.898,15.634C7.131,15.134 7.856,14.184 7.965,13.272L7.958,4.387L15.02,3.028L15.02,9.406C14.422,9.343 13.746,9.432 13.076,9.703C11.471,10.353 10.544,11.77 11.004,12.866C11.467,13.964 13.141,14.325 14.746,13.675C15.979,13.174 16.836,12.224 16.947,11.313L16.958,0.002L6.021,2.188L6.021,2.188Z"};
    protected static int[] drawable3Colors = new int[]{-6760607};
    protected Path mPath = new Path();
    protected Paint mPaint = new Paint();
    protected BoxBody mBoxBody = new BoxBody();
    protected int mHeight;
    protected int mAccentColor;
    protected int mHeaderHeight;
    protected int mBackgroundColor;
    protected boolean mDropOutOverFlow;
    protected Drawable mDrawable1;
    protected Drawable mDrawable2;
    protected Drawable mDrawable3;
    protected float mDropOutPercent;
    protected float mReboundPercent;
    protected ValueAnimator mReboundAnimator;
    protected ValueAnimator mDropOutAnimator;
    protected RefreshState mState;
    protected RefreshKernel mKernel;

    public DropBoxHeader(Context context) {
        this(context, null);
    }

    public DropBoxHeader(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs, 0);
        this.mPaint.setAntiAlias(true);
        this.mAccentColor = -9524737;
        this.mBackgroundColor = -14141883;
        DropBoxHeader thisView = this;
        thisView.setMinimumHeight(SmartUtil.dp2px((float)150.0f));
        this.mSpinnerStyle = SpinnerStyle.FixedBehind;
        TypedArray ta = context.obtainStyledAttributes(attrs, R.styleable.DropBoxHeader);
        if (ta.hasValue(R.styleable.DropBoxHeader_dhDrawable1)) {
            this.mDrawable1 = ta.getDrawable(R.styleable.DropBoxHeader_dhDrawable1);
        } else {
            PathsDrawable drawable1 = new PathsDrawable();
            drawable1.parserColors(drawable1Colors);
            if (!drawable1.parserPaths(drawable1Paths)) {
                drawable1.declareOriginal(2, 1, 20, 22);
            }
            this.mDrawable1 = drawable1;
        }
        if (ta.hasValue(R.styleable.DropBoxHeader_dhDrawable2)) {
            this.mDrawable2 = ta.getDrawable(R.styleable.DropBoxHeader_dhDrawable2);
        } else {
            PathsDrawable drawable2 = new PathsDrawable();
            drawable2.parserColors(drawable2Colors);
            if (!drawable2.parserPaths(drawable2Paths)) {
                drawable2.declareOriginal(8, 3, 41, 53);
            }
            this.mDrawable2 = drawable2;
        }
        if (ta.hasValue(R.styleable.DropBoxHeader_dhDrawable3)) {
            this.mDrawable3 = ta.getDrawable(R.styleable.DropBoxHeader_dhDrawable3);
        } else {
            PathsDrawable drawable3 = new PathsDrawable();
            drawable3.parserColors(drawable3Colors);
            if (!drawable3.parserPaths(drawable3Paths)) {
                drawable3.declareOriginal(2, 0, 15, 16);
            }
            this.mDrawable3 = drawable3;
        }
        ta.recycle();
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        AccelerateInterpolator interpolator = new AccelerateInterpolator();
        this.mReboundAnimator = ValueAnimator.ofFloat((float[])new float[]{0.0f, 1.0f, 0.0f});
        this.mReboundAnimator.setInterpolator((TimeInterpolator)interpolator);
        this.mReboundAnimator.setDuration(300L);
        this.mReboundAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                DropBoxHeader thisView = DropBoxHeader.this;
                DropBoxHeader.this.mReboundPercent = ((Float)animation.getAnimatedValue()).floatValue();
                thisView.invalidate();
            }
        });
        this.mReboundAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                if (DropBoxHeader.this.mState == RefreshState.Refreshing) {
                    if (DropBoxHeader.this.mDropOutAnimator != null) {
                        DropBoxHeader.this.mDropOutAnimator.start();
                    }
                } else {
                    DropBoxHeader.this.mDropOutPercent = 0.0f;
                }
            }
        });
        this.mDropOutAnimator = ValueAnimator.ofFloat((float[])new float[]{0.0f, 1.0f});
        this.mDropOutAnimator.setInterpolator((TimeInterpolator)interpolator);
        this.mDropOutAnimator.setDuration(300L);
        this.mDropOutAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                if (DropBoxHeader.this.mDropOutPercent < 1.0f || DropBoxHeader.this.mDropOutPercent >= 3.0f) {
                    DropBoxHeader.this.mDropOutPercent = ((Float)animation.getAnimatedValue()).floatValue();
                } else if (DropBoxHeader.this.mDropOutPercent < 2.0f) {
                    DropBoxHeader.this.mDropOutPercent = 1.0f + ((Float)animation.getAnimatedValue()).floatValue();
                } else if (DropBoxHeader.this.mDropOutPercent < 3.0f) {
                    DropBoxHeader.this.mDropOutPercent = 2.0f + ((Float)animation.getAnimatedValue()).floatValue();
                    if (DropBoxHeader.this.mDropOutPercent == 3.0f) {
                        DropBoxHeader.this.mDropOutOverFlow = true;
                    }
                }
                DropBoxHeader thisView = DropBoxHeader.this;
                thisView.invalidate();
            }
        });
        this.mDropOutAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                if (DropBoxHeader.this.mReboundAnimator != null) {
                    DropBoxHeader.this.mReboundAnimator.start();
                }
            }
        });
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.mReboundAnimator != null) {
            this.mReboundAnimator.removeAllUpdateListeners();
            this.mReboundAnimator.removeAllListeners();
            this.mReboundAnimator = null;
        }
        if (this.mDropOutAnimator != null) {
            this.mDropOutAnimator.removeAllUpdateListeners();
            this.mDropOutAnimator.removeAllListeners();
            this.mDropOutAnimator = null;
        }
    }

    protected void dispatchDraw(Canvas canvas) {
        boolean footer;
        DropBoxHeader thisView = this;
        int width = thisView.getWidth();
        int height = this.mHeight;
        int sideLength = this.generateSideLength();
        boolean bl = footer = this.mKernel != null && this.equals(this.mKernel.getRefreshLayout().getRefreshFooter());
        if (footer) {
            canvas.save();
            canvas.translate(0.0f, (float)(thisView.getHeight() - this.mHeight));
        }
        BoxBody body = this.generateBoxBody(width, height, sideLength);
        this.mPaint.setColor(ColorUtils.setAlphaComponent((int)this.mAccentColor, (int)150));
        canvas.drawPath(this.generateBoxBodyPath(body), this.mPaint);
        this.mPaint.setColor(this.mAccentColor);
        canvas.drawPath(this.generateBoxCoverPath(body), this.mPaint);
        if (thisView.isInEditMode()) {
            this.mDropOutPercent = 2.5f;
        }
        if (this.mDropOutPercent > 0.0f) {
            canvas.clipPath(this.generateClipPath(body, width));
            float percent1 = Math.min(this.mDropOutPercent, 1.0f);
            Rect bounds1 = this.mDrawable1.getBounds();
            bounds1.offsetTo(width / 2 - bounds1.width() / 2, (int)((float)(body.boxCenterY - bounds1.height() / 2 + bounds1.height()) * percent1) - bounds1.height());
            this.mDrawable1.draw(canvas);
            float percent2 = Math.min(Math.max(this.mDropOutPercent - 1.0f, 0.0f), 1.0f);
            Rect bounds2 = this.mDrawable2.getBounds();
            bounds2.offsetTo(width / 2 - bounds2.width() / 2, (int)((float)(body.boxCenterY - bounds2.height() / 2 + bounds2.height()) * percent2) - bounds2.height());
            this.mDrawable2.draw(canvas);
            float percent3 = Math.min(Math.max(this.mDropOutPercent - 2.0f, 0.0f), 1.0f);
            Rect bounds3 = this.mDrawable3.getBounds();
            bounds3.offsetTo(width / 2 - bounds3.width() / 2, (int)((float)(body.boxCenterY - bounds3.height() / 2 + bounds3.height()) * percent3) - bounds3.height());
            this.mDrawable3.draw(canvas);
            if (this.mDropOutOverFlow) {
                bounds1.offsetTo(width / 2 - bounds1.width() / 2, body.boxCenterY - bounds1.height() / 2);
                this.mDrawable1.draw(canvas);
                bounds2.offsetTo(width / 2 - bounds2.width() / 2, body.boxCenterY - bounds2.height() / 2);
                this.mDrawable2.draw(canvas);
                bounds3.offsetTo(width / 2 - bounds3.width() / 2, body.boxCenterY - bounds3.height() / 2);
                this.mDrawable3.draw(canvas);
            }
        }
        if (footer) {
            canvas.restore();
        }
        super.dispatchDraw(canvas);
    }

    protected int generateSideLength() {
        return this.mHeaderHeight / 5;
    }

    @NonNull
    protected Path generateClipPath(BoxBody body, int width) {
        this.mPath.reset();
        this.mPath.lineTo(0.0f, (float)body.boxCenterTop);
        this.mPath.lineTo((float)body.boxLeft, (float)body.boxCenterTop);
        this.mPath.lineTo((float)body.boxCenterX, (float)body.boxCenterY);
        this.mPath.lineTo((float)body.boxRight, (float)body.boxCenterTop);
        this.mPath.lineTo((float)width, (float)body.boxCenterTop);
        this.mPath.lineTo((float)width, 0.0f);
        this.mPath.close();
        return this.mPath;
    }

    @NonNull
    protected BoxBody generateBoxBody(int width, int height, int sideLength) {
        int margin = sideLength / 2;
        return this.mBoxBody.measure(width, height, sideLength, margin);
    }

    @NonNull
    protected Path generateBoxCoverPath(BoxBody body) {
        this.mPath.reset();
        int sideLength = (body.boxCenterX - body.boxLeft) * 4 / 5;
        double offsetAngle = (double)this.mReboundPercent * 1.2566370614359172;
        float offsetLeftTopX = (float)sideLength * (float)Math.sin(1.0471975511965976 - offsetAngle / 2.0);
        float offsetLeftTopY = (float)sideLength * (float)Math.cos(1.0471975511965976 - offsetAngle / 2.0);
        this.mPath.moveTo((float)body.boxLeft, (float)body.boxCenterTop);
        this.mPath.lineTo((float)body.boxCenterX, (float)body.boxTop);
        this.mPath.lineTo((float)body.boxCenterX - offsetLeftTopX, (float)body.boxTop - offsetLeftTopY);
        this.mPath.lineTo((float)body.boxLeft - offsetLeftTopX, (float)body.boxCenterTop - offsetLeftTopY);
        this.mPath.close();
        float offsetLeftBottomX = (float)sideLength * (float)Math.sin(1.0471975511965976 + offsetAngle);
        float offsetLeftBottomY = (float)sideLength * (float)Math.cos(1.0471975511965976 + offsetAngle);
        this.mPath.moveTo((float)body.boxLeft, (float)body.boxCenterTop);
        this.mPath.lineTo((float)body.boxCenterX, (float)(body.boxBottom + body.boxTop) / 2.0f);
        this.mPath.lineTo((float)body.boxCenterX - offsetLeftBottomX, (float)(body.boxBottom + body.boxTop) / 2.0f + offsetLeftBottomY);
        this.mPath.lineTo((float)body.boxLeft - offsetLeftBottomX, (float)body.boxCenterTop + offsetLeftBottomY);
        this.mPath.close();
        float offsetRightTopX = (float)sideLength * (float)Math.sin(1.0471975511965976 - offsetAngle / 2.0);
        float offsetRightTopY = (float)sideLength * (float)Math.cos(1.0471975511965976 - offsetAngle / 2.0);
        this.mPath.moveTo((float)body.boxRight, (float)body.boxCenterTop);
        this.mPath.lineTo((float)body.boxCenterX, (float)body.boxTop);
        this.mPath.lineTo((float)body.boxCenterX + offsetRightTopX, (float)body.boxTop - offsetRightTopY);
        this.mPath.lineTo((float)body.boxRight + offsetRightTopX, (float)body.boxCenterTop - offsetRightTopY);
        this.mPath.close();
        float offsetRightBottomX = (float)sideLength * (float)Math.sin(1.0471975511965976 + offsetAngle);
        float offsetRightBottomY = (float)sideLength * (float)Math.cos(1.0471975511965976 + offsetAngle);
        this.mPath.moveTo((float)body.boxRight, (float)body.boxCenterTop);
        this.mPath.lineTo((float)body.boxCenterX, (float)(body.boxBottom + body.boxTop) / 2.0f);
        this.mPath.lineTo((float)body.boxCenterX + offsetRightBottomX, (float)(body.boxBottom + body.boxTop) / 2.0f + offsetRightBottomY);
        this.mPath.lineTo((float)body.boxRight + offsetRightBottomX, (float)body.boxCenterTop + offsetRightBottomY);
        this.mPath.close();
        return this.mPath;
    }

    @NonNull
    protected Path generateBoxBodyPath(BoxBody body) {
        this.mPath.reset();
        this.mPath.moveTo((float)body.boxLeft, (float)body.boxCenterBottom);
        this.mPath.lineTo((float)body.boxCenterX, (float)body.boxBottom);
        this.mPath.lineTo((float)body.boxRight, (float)body.boxCenterBottom);
        this.mPath.quadTo((float)body.boxRight + (float)body.boxSideLength / 2.0f * this.mReboundPercent, (float)body.boxCenterY, (float)body.boxRight, (float)body.boxCenterTop);
        this.mPath.lineTo((float)body.boxCenterX, (float)body.boxTop);
        this.mPath.lineTo((float)body.boxLeft, (float)body.boxCenterTop);
        this.mPath.quadTo((float)body.boxLeft - (float)body.boxSideLength / 2.0f * this.mReboundPercent, (float)body.boxCenterY, (float)body.boxLeft, (float)body.boxCenterBottom);
        this.mPath.close();
        return this.mPath;
    }

    public void onInitialized(@NonNull RefreshKernel kernel, int height, int maxDragHeight) {
        this.mKernel = kernel;
        this.mHeaderHeight = height;
        kernel.requestDrawBackgroundFor((RefreshInternal)this, this.mBackgroundColor);
        int sideLength = this.generateSideLength();
        this.mDrawable1.setBounds(0, 0, sideLength, sideLength);
        this.mDrawable2.setBounds(0, 0, sideLength, sideLength);
        this.mDrawable3.setBounds(0, 0, sideLength, sideLength);
    }

    public void onMoving(boolean isDragging, float percent, int offset, int height, int maxDragHeight) {
        this.mHeight = offset;
        if (!isDragging || this.mState != RefreshState.Refreshing) {
            this.mReboundPercent = 1.0f * (float)Math.max(0, offset - height) / (float)maxDragHeight;
        }
        this.invalidate();
    }

    public void onStateChanged(@NonNull RefreshLayout refreshLayout, @NonNull RefreshState oldState, @NonNull RefreshState newState) {
        this.mState = newState;
        if (newState == RefreshState.None) {
            this.mDropOutOverFlow = false;
        }
    }

    @Deprecated
    public void setPrimaryColors(int ... colors) {
        if (colors.length > 0) {
            this.mBackgroundColor = colors[0];
            if (this.mKernel != null) {
                this.mKernel.requestDrawBackgroundFor((RefreshInternal)this, this.mBackgroundColor);
            }
            if (colors.length > 1) {
                this.mAccentColor = colors[1];
            }
        }
    }

    public void onStartAnimator(@NonNull RefreshLayout layout, int height, int maxDragHeight) {
        if (this.mDropOutAnimator != null) {
            this.mDropOutAnimator.start();
        }
    }

    public int onFinish(@NonNull RefreshLayout layout, boolean success) {
        this.mDropOutPercent = 0.0f;
        return 0;
    }

    protected static class BoxBody {
        int boxCenterX;
        int boxCenterY;
        int boxBottom;
        int boxTop;
        int boxLeft;
        int boxCenterTop;
        int boxCenterBottom;
        int boxRight;
        int boxSideLength;

        protected BoxBody() {
        }

        BoxBody measure(int width, int height, int sideLength, int margin) {
            this.boxSideLength = sideLength;
            this.boxCenterX = width / 2;
            this.boxBottom = height - margin;
            this.boxTop = this.boxBottom - 2 * sideLength;
            this.boxLeft = this.boxCenterX - (int)((double)sideLength * Math.sin(1.0471975511965976));
            this.boxCenterTop = this.boxTop + sideLength / 2;
            this.boxCenterBottom = this.boxBottom - sideLength / 2;
            this.boxRight = width - this.boxLeft;
            this.boxCenterY = this.boxBottom - sideLength;
            return this;
        }
    }
}

