/*
 * Decompiled with CFR 0.152.
 */
package com.scwang.smartrefresh.header;

import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.support.annotation.NonNull;
import android.support.v4.content.ContextCompat;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.view.View;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.view.animation.Animation;
import android.view.animation.Transformation;
import android.widget.ImageView;
import com.scwang.smartrefresh.header.R;
import com.scwang.smartrefresh.header.internal.MaterialProgressDrawable;
import com.scwang.smartrefresh.header.waveswipe.WaveView;
import com.scwang.smartrefresh.layout.api.RefreshHeader;
import com.scwang.smartrefresh.layout.api.RefreshLayout;
import com.scwang.smartrefresh.layout.constant.RefreshState;
import com.scwang.smartrefresh.layout.constant.SpinnerStyle;
import com.scwang.smartrefresh.layout.internal.InternalAbstract;
import com.scwang.smartrefresh.layout.util.SmartUtil;

public class WaveSwipeHeader
extends InternalAbstract
implements RefreshHeader {
    protected static final float MAX_PROGRESS_ROTATION_RATE = 0.8f;
    protected WaveView mWaveView;
    protected RefreshState mState;
    protected MaterialProgressDrawable mProgress;
    protected ProgressAnimationImageView mCircleView;
    protected float mLastFirstBounds;

    public WaveSwipeHeader(Context context) {
        this(context, null);
    }

    public WaveSwipeHeader(Context context, AttributeSet attrs) {
        super(context, attrs, 0);
        this.mSpinnerStyle = SpinnerStyle.MatchLayout;
        WaveSwipeHeader thisGroup = this;
        this.mWaveView = new WaveView(context);
        thisGroup.addView(this.mWaveView);
        this.mCircleView = new ProgressAnimationImageView(context);
        thisGroup.addView((View)this.mCircleView);
        TypedArray ta = context.obtainStyledAttributes(attrs, R.styleable.WaveSwipeHeader);
        int primaryColor = ta.getColor(R.styleable.WaveSwipeHeader_wshPrimaryColor, 0);
        int accentColor = ta.getColor(R.styleable.WaveSwipeHeader_wshAccentColor, 0);
        if (primaryColor != 0) {
            this.mWaveView.setWaveColor(primaryColor);
        }
        if (accentColor != 0) {
            this.mProgress.setColorSchemeColors(accentColor);
        } else {
            this.mProgress.setColorSchemeColors(-1);
        }
        if (ta.hasValue(R.styleable.WaveSwipeHeader_wshShadowRadius)) {
            int radius = ta.getDimensionPixelOffset(R.styleable.WaveSwipeHeader_wshShadowRadius, 0);
            int color = ta.getColor(R.styleable.WaveSwipeHeader_wshShadowColor, -16777216);
            this.mWaveView.setShadow(radius, color);
        }
        ta.recycle();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.setMeasuredDimension(View.MeasureSpec.getSize((int)widthMeasureSpec), View.MeasureSpec.getSize((int)heightMeasureSpec));
        WaveView waveView = this.mWaveView;
        ProgressAnimationImageView circleView = this.mCircleView;
        MaterialProgressDrawable progress = this.mProgress;
        int circleDiameter = progress.getIntrinsicWidth();
        int spec = View.MeasureSpec.makeMeasureSpec((int)circleDiameter, (int)0x40000000);
        circleView.measure(spec, spec);
        waveView.measure(View.MeasureSpec.makeMeasureSpec((int)View.MeasureSpec.getSize((int)widthMeasureSpec), (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)View.MeasureSpec.getSize((int)heightMeasureSpec), (int)0x40000000));
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        WaveSwipeHeader thisView = this;
        WaveView waveView = this.mWaveView;
        ProgressAnimationImageView circleView = this.mCircleView;
        waveView.layout(0, 0, thisView.getMeasuredWidth(), thisView.getMeasuredHeight());
        int thisWidth = thisView.getMeasuredWidth();
        int circleWidth = circleView.getMeasuredWidth();
        int circleHeight = circleView.getMeasuredHeight();
        circleView.layout((thisWidth - circleWidth) / 2, -circleHeight, (thisWidth + circleWidth) / 2, 0);
        if (thisView.isInEditMode()) {
            this.onMoving(true, 0.99f, SmartUtil.dp2px((float)99.0f), SmartUtil.dp2px((float)100.0f), SmartUtil.dp2px((float)100.0f));
        }
    }

    public void setColorSchemeColors(int ... colors) {
        this.mProgress.setColorSchemeColors(colors);
    }

    public void setColorSchemeColorIds(int ... resources) {
        WaveSwipeHeader thisView = this;
        Context context = thisView.getContext();
        int[] colorRes = new int[resources.length];
        for (int i = 0; i < resources.length; ++i) {
            colorRes[i] = ContextCompat.getColor((Context)context, (int)resources[1]);
        }
        this.mProgress.setColorSchemeColors(colorRes);
    }

    public void onMoving(boolean isDragging, float percent, int offset, int height, int maxDragHeight) {
        if (isDragging) {
            if (this.mState == RefreshState.Refreshing) {
                return;
            }
            ProgressAnimationImageView circleView = this.mCircleView;
            float dragPercent = Math.min(1.0f, percent);
            float adjustedPercent = (float)Math.max((double)dragPercent - 0.4, 0.0) * 5.0f / 3.0f;
            float tensionSlingshotPercent = percent > 3.0f ? 2.0f : (percent > 1.0f ? percent - 1.0f : 0.0f);
            float tensionPercent = (4.0f - tensionSlingshotPercent) * tensionSlingshotPercent / 8.0f;
            if (percent < 1.0f) {
                float strokeStart = adjustedPercent * 0.8f;
                this.mProgress.setStartEndTrim(0.0f, Math.min(0.8f, strokeStart));
                this.mProgress.setArrowScale(Math.min(1.0f, adjustedPercent));
            }
            float rotation = (-0.25f + 0.4f * adjustedPercent + tensionPercent * 2.0f) * 0.5f;
            this.mProgress.setProgressRotation(rotation);
            circleView.setTranslationY(this.mWaveView.getCurrentCircleCenterY());
            WaveSwipeHeader thisView = this;
            float seed = 1.0f * (float)offset / (float)Math.min(thisView.getMeasuredWidth(), thisView.getMeasuredHeight());
            float firstBounds = seed * (5.0f - 2.0f * seed) / 3.5f;
            float secondBounds = firstBounds - VERTICAL_DRAG_THRESHOLD.FIRST.val;
            float finalBounds = (firstBounds - VERTICAL_DRAG_THRESHOLD.SECOND.val) / 5.0f;
            this.mLastFirstBounds = firstBounds;
            if (firstBounds < VERTICAL_DRAG_THRESHOLD.FIRST.val) {
                this.mWaveView.beginPhase(firstBounds);
            } else if (firstBounds < VERTICAL_DRAG_THRESHOLD.SECOND.val) {
                this.mWaveView.appearPhase(firstBounds, secondBounds);
            } else {
                this.mWaveView.expandPhase(firstBounds, secondBounds, finalBounds);
            }
        } else if (this.mLastFirstBounds != 0.0f && this.mState == RefreshState.None) {
            this.mProgress.showArrow(false);
            this.mProgress.setProgressRotation(0.0f);
            this.mProgress.setStartEndTrim(0.0f, 0.0f);
            this.mWaveView.startWaveAnimation(this.mLastFirstBounds);
            this.mLastFirstBounds = 0.0f;
        }
    }

    public void onReleased(@NonNull RefreshLayout layout, int height, int maxDragHeight) {
        this.mLastFirstBounds = 0.0f;
        this.mWaveView.animationDropCircle();
        this.mProgress.setAlpha(255);
        this.mProgress.start();
        ValueAnimator animator = ValueAnimator.ofFloat((float[])new float[]{0.0f, 0.0f});
        animator.setDuration(500L);
        animator.setInterpolator((TimeInterpolator)new AccelerateDecelerateInterpolator());
        animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator valueAnimator) {
                ProgressAnimationImageView circleView = WaveSwipeHeader.this.mCircleView;
                circleView.setTranslationY(WaveSwipeHeader.this.mWaveView.getCurrentCircleCenterY() + (float)circleView.getHeight() / 2.0f);
            }
        });
        animator.start();
    }

    public void onStateChanged(@NonNull RefreshLayout refreshLayout, @NonNull RefreshState oldState, @NonNull RefreshState newState) {
        ProgressAnimationImageView circleView = this.mCircleView;
        this.mState = newState;
        switch (newState) {
            case None: 
            case ReleaseToRefresh: 
            case Refreshing: {
                break;
            }
            case PullDownToRefresh: {
                this.mProgress.showArrow(true);
                circleView.setScaleX(1.0f);
                circleView.setScaleY(1.0f);
                this.mProgress.setAlpha(255);
                break;
            }
            case PullDownCanceled: {
                this.mProgress.showArrow(false);
                this.mProgress.setProgressRotation(0.0f);
                this.mProgress.setStartEndTrim(0.0f, 0.0f);
                this.mWaveView.startWaveAnimation(this.mLastFirstBounds);
                this.mLastFirstBounds = 0.0f;
            }
        }
    }

    public int onFinish(@NonNull RefreshLayout layout, boolean success) {
        ProgressAnimationImageView circleView = this.mCircleView;
        Animation scaleDownAnimation = new Animation((View)circleView){
            final /* synthetic */ View val$circleView;
            {
                this.val$circleView = view;
            }

            public void applyTransformation(float interpolatedTime, Transformation t) {
                this.val$circleView.setScaleX(1.0f - interpolatedTime);
                this.val$circleView.setScaleY(1.0f - interpolatedTime);
            }
        };
        scaleDownAnimation.setDuration(200L);
        this.mCircleView.setAnimationListener(new Animation.AnimationListener(){

            public void onAnimationStart(Animation animation) {
            }

            public void onAnimationRepeat(Animation animation) {
            }

            public void onAnimationEnd(Animation animation) {
                WaveSwipeHeader.this.mProgress.stop();
                WaveSwipeHeader.this.mProgress.setAlpha(255);
                WaveSwipeHeader.this.mWaveView.startDisappearCircleAnimation();
            }
        });
        circleView.clearAnimation();
        circleView.startAnimation(scaleDownAnimation);
        return 0;
    }

    @Deprecated
    public void setPrimaryColors(int ... colors) {
        if (colors.length > 0) {
            this.mWaveView.setWaveColor(colors[0]);
            if (colors.length > 1) {
                this.mProgress.setColorSchemeColors(colors[1]);
            }
        }
    }

    public static boolean isOver600dp() {
        DisplayMetrics displayMetrics = Resources.getSystem().getDisplayMetrics();
        return (float)displayMetrics.widthPixels / displayMetrics.density >= 600.0f;
    }

    protected class ProgressAnimationImageView
    extends ImageView {
        protected Animation.AnimationListener mListener;

        public void setAnimationListener(Animation.AnimationListener listener) {
            this.mListener = listener;
        }

        public void onAnimationStart() {
            super.onAnimationStart();
            if (this.mListener != null) {
                this.mListener.onAnimationStart(this.getAnimation());
            }
        }

        public void onAnimationEnd() {
            super.onAnimationEnd();
            if (this.mListener != null) {
                this.mListener.onAnimationEnd(this.getAnimation());
            }
        }

        public ProgressAnimationImageView(Context context) {
            super(context);
            WaveSwipeHeader.this.mProgress = new MaterialProgressDrawable((View)WaveSwipeHeader.this);
            if (WaveSwipeHeader.isOver600dp()) {
                WaveSwipeHeader.this.mProgress.updateSizes(0);
            }
            super.setImageDrawable((Drawable)WaveSwipeHeader.this.mProgress);
        }
    }

    protected static enum VERTICAL_DRAG_THRESHOLD {
        FIRST(0.1f),
        SECOND(0.16f + VERTICAL_DRAG_THRESHOLD.FIRST.val),
        THIRD(0.5f + VERTICAL_DRAG_THRESHOLD.FIRST.val);

        final float val;

        private VERTICAL_DRAG_THRESHOLD(float val) {
            this.val = val;
        }
    }
}

