/*
 * Decompiled with CFR 0.152.
 */
package com.scwang.smartrefresh.header.storehouse;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PointF;
import android.view.animation.Animation;
import android.view.animation.Transformation;
import java.util.Random;

public class StoreHouseBarItem
extends Animation {
    public PointF midPoint;
    public float translationX;
    public int index;
    protected final Paint mPaint = new Paint();
    protected float mFromAlpha = 1.0f;
    protected float mToAlpha = 0.4f;
    protected PointF mCStartPoint;
    protected PointF mCEndPoint;

    public StoreHouseBarItem(int index, PointF start, PointF end, int color, int lineWidth) {
        this.index = index;
        this.midPoint = new PointF((start.x + end.x) / 2.0f, (start.y + end.y) / 2.0f);
        this.mCStartPoint = new PointF(start.x - this.midPoint.x, start.y - this.midPoint.y);
        this.mCEndPoint = new PointF(end.x - this.midPoint.x, end.y - this.midPoint.y);
        this.setColor(color);
        this.setLineWidth(lineWidth);
        this.mPaint.setAntiAlias(true);
        this.mPaint.setStyle(Paint.Style.STROKE);
    }

    public void setLineWidth(int width) {
        this.mPaint.setStrokeWidth((float)width);
    }

    public void setColor(int color) {
        this.mPaint.setColor(color);
    }

    public void resetPosition(int horizontalRandomness) {
        Random random = new Random();
        this.translationX = -random.nextInt(horizontalRandomness) + horizontalRandomness;
    }

    protected void applyTransformation(float interpolatedTime, Transformation t) {
        float alpha = this.mFromAlpha;
        alpha += (this.mToAlpha - alpha) * interpolatedTime;
        this.setAlpha(alpha);
    }

    public void start(float fromAlpha, float toAlpha) {
        this.mFromAlpha = fromAlpha;
        this.mToAlpha = toAlpha;
        super.start();
    }

    public void setAlpha(float alpha) {
        this.mPaint.setAlpha((int)(alpha * 255.0f));
    }

    public void draw(Canvas canvas) {
        canvas.drawLine(this.mCStartPoint.x, this.mCStartPoint.y, this.mCEndPoint.x, this.mCEndPoint.y, this.mPaint);
    }
}

