/*
 * Decompiled with CFR 0.152.
 */
package com.scwang.smartrefresh.layout.footer;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.util.AttributeSet;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.view.animation.Interpolator;
import androidx.annotation.AttrRes;
import androidx.annotation.ColorInt;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.graphics.ColorUtils;
import com.scwang.smartrefresh.layout.R;
import com.scwang.smartrefresh.layout.api.RefreshFooter;
import com.scwang.smartrefresh.layout.api.RefreshLayout;
import com.scwang.smartrefresh.layout.constant.SpinnerStyle;
import com.scwang.smartrefresh.layout.internal.InternalAbstract;
import com.scwang.smartrefresh.layout.util.DensityUtil;

public class BallPulseFooter
extends InternalAbstract
implements RefreshFooter {
    protected boolean mManualNormalColor;
    protected boolean mManualAnimationColor;
    protected Paint mPaint;
    protected int mNormalColor = -1118482;
    protected int mAnimatingColor = -1615546;
    protected float mCircleSpacing;
    protected long mStartTime = 0L;
    protected boolean mIsStarted = false;
    protected Interpolator mInterpolator = new AccelerateDecelerateInterpolator();

    public BallPulseFooter(@NonNull Context context) {
        this(context, null);
    }

    public BallPulseFooter(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public BallPulseFooter(@NonNull Context context, @Nullable AttributeSet attrs, @AttrRes int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        BallPulseFooter thisView = this;
        thisView.setMinimumHeight(DensityUtil.dp2px(60.0f));
        TypedArray ta = context.obtainStyledAttributes(attrs, R.styleable.BallPulseFooter);
        this.mPaint = new Paint();
        this.mPaint.setColor(-1);
        this.mPaint.setStyle(Paint.Style.FILL);
        this.mPaint.setAntiAlias(true);
        this.mSpinnerStyle = SpinnerStyle.Translate;
        this.mSpinnerStyle = SpinnerStyle.values()[ta.getInt(R.styleable.BallPulseFooter_srlClassicsSpinnerStyle, this.mSpinnerStyle.ordinal())];
        if (ta.hasValue(R.styleable.BallPulseFooter_srlNormalColor)) {
            this.setNormalColor(ta.getColor(R.styleable.BallPulseFooter_srlNormalColor, 0));
        }
        if (ta.hasValue(R.styleable.BallPulseFooter_srlAnimatingColor)) {
            this.setAnimatingColor(ta.getColor(R.styleable.BallPulseFooter_srlAnimatingColor, 0));
        }
        ta.recycle();
        this.mCircleSpacing = DensityUtil.dp2px(4.0f);
    }

    protected void dispatchDraw(Canvas canvas) {
        BallPulseFooter thisView = this;
        int width = thisView.getWidth();
        int height = thisView.getHeight();
        float radius = ((float)Math.min(width, height) - this.mCircleSpacing * 2.0f) / 6.0f;
        float x = (float)width / 2.0f - (radius * 2.0f + this.mCircleSpacing);
        float y = (float)height / 2.0f;
        long now = System.currentTimeMillis();
        for (int i = 0; i < 3; ++i) {
            float scale;
            long time = now - this.mStartTime - (long)(120 * (i + 1));
            float percent = time > 0L ? (float)(time % 750L) / 750.0f : 0.0f;
            percent = this.mInterpolator.getInterpolation(percent);
            canvas.save();
            float translateX = x + radius * 2.0f * (float)i + this.mCircleSpacing * (float)i;
            canvas.translate(translateX, y);
            if ((double)percent < 0.5) {
                scale = 1.0f - percent * 2.0f * 0.7f;
                canvas.scale(scale, scale);
            } else {
                scale = percent * 2.0f * 0.7f - 0.4f;
                canvas.scale(scale, scale);
            }
            canvas.drawCircle(0.0f, 0.0f, radius, this.mPaint);
            canvas.restore();
        }
        super.dispatchDraw(canvas);
        if (this.mIsStarted) {
            thisView.invalidate();
        }
    }

    @Override
    public void onStartAnimator(@NonNull RefreshLayout layout, int height, int maxDragHeight) {
        if (this.mIsStarted) {
            return;
        }
        BallPulseFooter thisView = this;
        thisView.invalidate();
        this.mIsStarted = true;
        this.mStartTime = System.currentTimeMillis();
        this.mPaint.setColor(this.mAnimatingColor);
    }

    @Override
    public int onFinish(@NonNull RefreshLayout layout, boolean success) {
        this.mIsStarted = false;
        this.mStartTime = 0L;
        this.mPaint.setColor(this.mNormalColor);
        return 0;
    }

    @Override
    public boolean setNoMoreData(boolean noMoreData) {
        return false;
    }

    @Override
    @Deprecated
    public void setPrimaryColors(int ... colors) {
        if (!this.mManualAnimationColor && colors.length > 1) {
            this.setAnimatingColor(colors[0]);
            this.mManualAnimationColor = false;
        }
        if (!this.mManualNormalColor) {
            if (colors.length > 1) {
                this.setNormalColor(colors[1]);
            } else if (colors.length > 0) {
                this.setNormalColor(ColorUtils.compositeColors((int)-1711276033, (int)colors[0]));
            }
            this.mManualNormalColor = false;
        }
    }

    public BallPulseFooter setSpinnerStyle(SpinnerStyle mSpinnerStyle) {
        this.mSpinnerStyle = mSpinnerStyle;
        return this;
    }

    public BallPulseFooter setNormalColor(@ColorInt int color) {
        this.mNormalColor = color;
        this.mManualNormalColor = true;
        if (!this.mIsStarted) {
            this.mPaint.setColor(color);
        }
        return this;
    }

    public BallPulseFooter setAnimatingColor(@ColorInt int color) {
        this.mAnimatingColor = color;
        this.mManualAnimationColor = true;
        if (this.mIsStarted) {
            this.mPaint.setColor(color);
        }
        return this;
    }
}

