/*
 * Decompiled with CFR 0.152.
 */
package com.scwang.smartrefresh.layout.impl;

import android.animation.ValueAnimator;
import android.graphics.PointF;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AbsListView;
import android.widget.FrameLayout;
import androidx.annotation.NonNull;
import androidx.core.view.NestedScrollingChild;
import androidx.core.view.NestedScrollingParent;
import androidx.legacy.widget.Space;
import androidx.viewpager.widget.ViewPager;
import com.scwang.smartrefresh.layout.api.RefreshContent;
import com.scwang.smartrefresh.layout.api.RefreshKernel;
import com.scwang.smartrefresh.layout.api.ScrollBoundaryDecider;
import com.scwang.smartrefresh.layout.impl.ScrollBoundaryDeciderAdapter;
import com.scwang.smartrefresh.layout.listener.CoordinatorLayoutListener;
import com.scwang.smartrefresh.layout.util.DesignUtil;
import com.scwang.smartrefresh.layout.util.ScrollBoundaryUtil;
import com.scwang.smartrefresh.layout.util.SmartUtil;
import java.util.LinkedList;
import java.util.List;

public class RefreshContentWrapper
implements RefreshContent,
CoordinatorLayoutListener,
ValueAnimator.AnimatorUpdateListener {
    protected View mContentView;
    protected View mOriginalContentView;
    protected View mScrollableView;
    protected View mFixedHeader;
    protected View mFixedFooter;
    protected int mLastSpinner = 0;
    protected boolean mEnableRefresh = true;
    protected boolean mEnableLoadMore = true;
    protected ScrollBoundaryDeciderAdapter mBoundaryAdapter = new ScrollBoundaryDeciderAdapter();

    public RefreshContentWrapper(@NonNull View view) {
        this.mOriginalContentView = this.mScrollableView = view;
        this.mContentView = this.mScrollableView;
    }

    protected void findScrollableView(View content, RefreshKernel kernel) {
        View scrollableView = null;
        boolean isInEditMode = this.mContentView.isInEditMode();
        while ((scrollableView == null || scrollableView instanceof NestedScrollingParent && !(scrollableView instanceof NestedScrollingChild)) && (content = this.findScrollableViewInternal(content, scrollableView == null)) != scrollableView) {
            if (!isInEditMode) {
                DesignUtil.checkCoordinatorLayout(content, kernel, this);
            }
            scrollableView = content;
        }
        if (scrollableView != null) {
            this.mScrollableView = scrollableView;
        }
    }

    @Override
    public void onCoordinatorUpdate(boolean enableRefresh, boolean enableLoadMore) {
        this.mEnableRefresh = enableRefresh;
        this.mEnableLoadMore = enableLoadMore;
    }

    protected View findScrollableViewInternal(View content, boolean selfAble) {
        View scrollableView = null;
        LinkedList views = new LinkedList();
        List list = views;
        list.add(content);
        while (list.size() > 0 && scrollableView == null) {
            View view = (View)views.poll();
            if (view == null) continue;
            if ((selfAble || view != content) && SmartUtil.isContentView(view)) {
                scrollableView = view;
                continue;
            }
            if (!(view instanceof ViewGroup)) continue;
            ViewGroup group = (ViewGroup)view;
            for (int j = 0; j < group.getChildCount(); ++j) {
                list.add(group.getChildAt(j));
            }
        }
        return scrollableView == null ? content : scrollableView;
    }

    protected View findScrollableViewByPoint(View content, PointF event, View orgScrollableView) {
        if (content instanceof ViewGroup && event != null) {
            ViewGroup viewGroup = (ViewGroup)content;
            int childCount = viewGroup.getChildCount();
            PointF point = new PointF();
            for (int i = childCount; i > 0; --i) {
                View child = viewGroup.getChildAt(i - 1);
                if (!ScrollBoundaryUtil.isTransformedTouchPointInView((View)viewGroup, child, event.x, event.y, point)) continue;
                if (child instanceof ViewPager || !SmartUtil.isContentView(child)) {
                    event.offset(point.x, point.y);
                    child = this.findScrollableViewByPoint(child, event, orgScrollableView);
                    event.offset(-point.x, -point.y);
                }
                return child;
            }
        }
        return orgScrollableView;
    }

    @Override
    @NonNull
    public View getView() {
        return this.mContentView;
    }

    @Override
    @NonNull
    public View getScrollableView() {
        return this.mScrollableView;
    }

    @Override
    public void moveSpinner(int spinner, int headerTranslationViewId, int footerTranslationViewId) {
        View footerTranslationView;
        View headerTranslationView;
        boolean translated = false;
        if (headerTranslationViewId != -1 && (headerTranslationView = this.mOriginalContentView.findViewById(headerTranslationViewId)) != null) {
            if (spinner > 0) {
                translated = true;
                headerTranslationView.setTranslationY((float)spinner);
            } else if (headerTranslationView.getTranslationY() > 0.0f) {
                headerTranslationView.setTranslationY(0.0f);
            }
        }
        if (footerTranslationViewId != -1 && (footerTranslationView = this.mOriginalContentView.findViewById(footerTranslationViewId)) != null) {
            if (spinner < 0) {
                translated = true;
                footerTranslationView.setTranslationY((float)spinner);
            } else if (footerTranslationView.getTranslationY() < 0.0f) {
                footerTranslationView.setTranslationY(0.0f);
            }
        }
        if (!translated) {
            this.mOriginalContentView.setTranslationY((float)spinner);
        } else {
            this.mOriginalContentView.setTranslationY(0.0f);
        }
        if (this.mFixedHeader != null) {
            this.mFixedHeader.setTranslationY((float)Math.max(0, spinner));
        }
        if (this.mFixedFooter != null) {
            this.mFixedFooter.setTranslationY((float)Math.min(0, spinner));
        }
    }

    @Override
    public boolean canRefresh() {
        return this.mEnableRefresh && this.mBoundaryAdapter.canRefresh(this.mContentView);
    }

    @Override
    public boolean canLoadMore() {
        return this.mEnableLoadMore && this.mBoundaryAdapter.canLoadMore(this.mContentView);
    }

    @Override
    public void onActionDown(MotionEvent e) {
        PointF point = new PointF(e.getX(), e.getY());
        point.offset((float)(-this.mContentView.getLeft()), (float)(-this.mContentView.getTop()));
        if (this.mScrollableView != this.mContentView) {
            this.mScrollableView = this.findScrollableViewByPoint(this.mContentView, point, this.mScrollableView);
        }
        this.mBoundaryAdapter.mActionEvent = this.mScrollableView == this.mContentView ? null : point;
    }

    @Override
    public void setUpComponent(RefreshKernel kernel, View fixedHeader, View fixedFooter) {
        this.findScrollableView(this.mContentView, kernel);
        if (fixedHeader != null || fixedFooter != null) {
            int index;
            ViewGroup parent;
            ViewGroup.LayoutParams lp;
            this.mFixedHeader = fixedHeader;
            this.mFixedFooter = fixedFooter;
            FrameLayout frameLayout = new FrameLayout(this.mContentView.getContext());
            kernel.getRefreshLayout().getLayout().removeView(this.mContentView);
            ViewGroup.LayoutParams layoutParams = this.mContentView.getLayoutParams();
            frameLayout.addView(this.mContentView, -1, -1);
            kernel.getRefreshLayout().getLayout().addView((View)frameLayout, layoutParams);
            this.mContentView = frameLayout;
            if (fixedHeader != null) {
                fixedHeader.setClickable(true);
                lp = fixedHeader.getLayoutParams();
                parent = (ViewGroup)fixedHeader.getParent();
                index = parent.indexOfChild(fixedHeader);
                parent.removeView(fixedHeader);
                lp.height = SmartUtil.measureViewHeight(fixedHeader);
                parent.addView((View)new Space(this.mContentView.getContext()), index, lp);
                frameLayout.addView(fixedHeader);
            }
            if (fixedFooter != null) {
                fixedFooter.setClickable(true);
                lp = fixedFooter.getLayoutParams();
                parent = (ViewGroup)fixedFooter.getParent();
                index = parent.indexOfChild(fixedFooter);
                parent.removeView(fixedFooter);
                FrameLayout.LayoutParams flp = new FrameLayout.LayoutParams(lp);
                lp.height = SmartUtil.measureViewHeight(fixedFooter);
                parent.addView((View)new Space(this.mContentView.getContext()), index, lp);
                flp.gravity = 80;
                frameLayout.addView(fixedFooter, (ViewGroup.LayoutParams)flp);
            }
        }
    }

    @Override
    public void setScrollBoundaryDecider(ScrollBoundaryDecider boundary) {
        if (boundary instanceof ScrollBoundaryDeciderAdapter) {
            this.mBoundaryAdapter = (ScrollBoundaryDeciderAdapter)boundary;
        } else {
            this.mBoundaryAdapter.boundary = boundary;
        }
    }

    @Override
    public void setEnableLoadMoreWhenContentNotFull(boolean enable) {
        this.mBoundaryAdapter.mEnableLoadMoreWhenContentNotFull = enable;
    }

    @Override
    public ValueAnimator.AnimatorUpdateListener scrollContentWhenFinished(int spinner) {
        if (this.mScrollableView != null && spinner != 0 && (spinner < 0 && ScrollBoundaryUtil.canScrollDown(this.mScrollableView) || spinner > 0 && ScrollBoundaryUtil.canScrollUp(this.mScrollableView))) {
            this.mLastSpinner = spinner;
            return this;
        }
        return null;
    }

    public void onAnimationUpdate(ValueAnimator animation) {
        int value = (Integer)animation.getAnimatedValue();
        try {
            if (this.mScrollableView instanceof AbsListView) {
                SmartUtil.scrollListBy((AbsListView)this.mScrollableView, value - this.mLastSpinner);
            } else {
                this.mScrollableView.scrollBy(0, value - this.mLastSpinner);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.mLastSpinner = value;
    }
}

