/*
 * Decompiled with CFR 0.152.
 */
package com.seomse.poi.excel;

import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.FormulaEvaluator;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;

public class ExcelGet {
    private FormulaEvaluator formulaEvaluator;

    public void setFormulaEvaluator(FormulaEvaluator formulaEvaluator) {
        this.formulaEvaluator = formulaEvaluator;
    }

    public Workbook setWorkbook(String workbookPath) throws IOException {
        Workbook workbook = WorkbookFactory.create((File)new File(workbookPath));
        this.formulaEvaluator = workbook.getCreationHelper().createFormulaEvaluator();
        return workbook;
    }

    public Workbook setWorkbook(File file) throws IOException {
        Workbook workbook = WorkbookFactory.create((File)file);
        this.formulaEvaluator = workbook.getCreationHelper().createFormulaEvaluator();
        return workbook;
    }

    public void setWorkbook(Workbook workbook) {
        this.formulaEvaluator = workbook.getCreationHelper().createFormulaEvaluator();
    }

    public String getCellValue(Sheet sheet, int rowNum, int cellNum) {
        return this.getCellValue(sheet, rowNum, cellNum, null);
    }

    public String getCellValue(Row row, int cellNum) {
        return this.getCellValue(row, cellNum, null);
    }

    public String getCellValue(Row row, int cellNum, String dateFormat) {
        if (row == null) {
            return null;
        }
        return this.getCellValue(row.getCell(cellNum), dateFormat);
    }

    public String getCellValue(Sheet sheet, int rowNum, int cellNum, String dateFormat) {
        Row row = sheet.getRow(rowNum);
        if (row == null) {
            return null;
        }
        return this.getCellValue(row.getCell(cellNum), dateFormat);
    }

    public String getCellValue(Cell cell) {
        return this.getCellValue(cell, null);
    }

    public String getCellValue(Cell cell, String dateFormat) {
        if (cell == null) {
            return null;
        }
        switch (cell.getCellType()) {
            case NUMERIC: {
                return this.cellNumber(cell, dateFormat);
            }
            case STRING: {
                return cell.getStringCellValue();
            }
            case BOOLEAN: {
                return cell.getBooleanCellValue() + "";
            }
            case ERROR: {
                return Byte.toString(cell.getErrorCellValue());
            }
            case BLANK: {
                return null;
            }
            case _NONE: {
                return null;
            }
            case FORMULA: {
                try {
                    switch (this.formulaEvaluator.evaluateFormulaCell(cell)) {
                        case NUMERIC: {
                            return this.cellNumber(cell, dateFormat);
                        }
                        case STRING: {
                            return cell.getStringCellValue();
                        }
                        case BOOLEAN: {
                            return cell.getBooleanCellValue() + "";
                        }
                        case ERROR: {
                            return Byte.toString(cell.getErrorCellValue());
                        }
                    }
                    return null;
                }
                catch (Exception e) {
                    switch (cell.getCachedFormulaResultType()) {
                        case NUMERIC: {
                            return this.cellNumber(cell, dateFormat);
                        }
                        case STRING: {
                            return cell.getStringCellValue();
                        }
                        case BOOLEAN: {
                            return cell.getBooleanCellValue() + "";
                        }
                        case ERROR: {
                            return Byte.toString(cell.getErrorCellValue());
                        }
                    }
                    return null;
                }
            }
        }
        return null;
    }

    private String cellNumber(Cell cell, String dateFormat) {
        if (DateUtil.isCellDateFormatted((Cell)cell) && dateFormat != null) {
            SimpleDateFormat formatter = new SimpleDateFormat(dateFormat);
            return formatter.format(cell.getDateCellValue());
        }
        String cellValue = Double.toString(cell.getNumericCellValue());
        if (cellValue.endsWith(".0")) {
            cellValue = cellValue.substring(0, cellValue.length() - 2);
        }
        return cellValue;
    }

    public int getRowCount(Sheet sheet) {
        int rowCount = sheet.getLastRowNum();
        try {
            Row row;
            while ((row = sheet.getRow(rowCount)) != null) {
                ++rowCount;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return rowCount;
    }

    public int getColumnCount(Row row) {
        int columnCount = row.getLastCellNum();
        try {
            Cell cell;
            while ((cell = row.getCell(columnCount)) != null) {
                ++columnCount;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return columnCount;
    }
}

