/*
 * Decompiled with CFR 0.152.
 */
package com.shobhitpuri.custombuttons;

import android.content.Context;
import android.content.res.TypedArray;
import android.support.v4.content.ContextCompat;
import android.support.v7.widget.AppCompatButton;
import android.util.AttributeSet;
import com.shobhitpuri.custombuttons.R;

public class GoogleSignInButton
extends AppCompatButton {
    private String mText;
    private boolean mIsDarkTheme;

    public GoogleSignInButton(Context context) {
        super(context);
    }

    public GoogleSignInButton(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.init(context, attributeSet, 0);
    }

    public GoogleSignInButton(Context context, AttributeSet attributeSet, int defStyleAttr) {
        super(context, attributeSet, defStyleAttr);
        this.init(context, attributeSet, defStyleAttr);
    }

    private void init(Context context, AttributeSet attributeSet, int defStyleAttr) {
        this.parseAttributes(context, attributeSet, defStyleAttr);
        this.setButtonParams();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseAttributes(Context context, AttributeSet attributeSet, int defStyleAttr) {
        if (attributeSet == null) {
            return;
        }
        TypedArray typedArray = context.getTheme().obtainStyledAttributes(attributeSet, R.styleable.ButtonStyleable, defStyleAttr, 0);
        try {
            this.mText = typedArray.getString(R.styleable.ButtonStyleable_android_text);
            this.mIsDarkTheme = typedArray.getBoolean(R.styleable.ButtonStyleable_isDarkTheme, false);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            typedArray.recycle();
        }
    }

    private void setButtonParams() {
        this.setTransformationMethod(null);
        this.setButtonText();
        this.setButtonTextSize();
        this.setButtonTextColor();
        this.setButtonBackground();
    }

    private void setButtonTextSize() {
        this.setTextSize(2, 14.0f);
    }

    private void setButtonBackground() {
        int googleIconImageSelector = this.mIsDarkTheme ? R.drawable.dark_theme_google_icon_selector : R.drawable.light_theme_google_icon_selector;
        this.setBackgroundResource(googleIconImageSelector);
    }

    private void setButtonTextColor() {
        int textColor = this.mIsDarkTheme ? 17170443 : R.color.text_color_dark;
        this.setTextColor(ContextCompat.getColor((Context)this.getContext(), (int)textColor));
    }

    private void setButtonText() {
        if (this.mText == null || this.mText.isEmpty()) {
            this.mText = this.getContext().getString(R.string.google_sign_in);
        }
        this.setText(this.mText);
    }
}

