/*
 * Decompiled with CFR 0.152.
 */
package com.simplify.ink;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.MotionEvent;
import android.view.View;
import com.simplify.ink.R;
import java.util.ArrayList;

public class InkView
extends View {
    public static final float DEFAULT_MAX_STROKE_WIDTH = 5.0f;
    public static final float DEFAULT_MIN_STROKE_WIDTH = 1.5f;
    public static final float DEFAULT_SMOOTHING_RATIO = 0.75f;
    public static final int FLAG_INTERPOLATION = 1;
    public static final int FLAG_RESPONSIVE_WIDTH = 2;
    @Deprecated
    public static final int FLAG_DEBUG = Integer.MIN_VALUE;
    static final float THRESHOLD_VELOCITY = 7.0f;
    static final float THRESHOLD_ACCELERATION = 3.0f;
    static final float FILTER_RATIO_MIN = 0.22f;
    static final float FILTER_RATIO_ACCELERATION_MODIFIER = 0.1f;
    static final int DEFAULT_FLAGS = 3;
    static final int DEFAULT_STROKE_COLOR = -16777216;
    int flags;
    float maxStrokeWidth;
    float minStrokeWidth;
    float smoothingRatio;
    ArrayList<InkPoint> pointQueue = new ArrayList();
    ArrayList<InkPoint> pointRecycle = new ArrayList();
    float density;
    Bitmap bitmap;
    Canvas canvas;
    Paint paint;
    RectF dirty;
    ArrayList<InkListener> listeners = new ArrayList();
    private boolean isEmpty;

    public InkView(Context context) {
        this(context, 3);
    }

    public InkView(Context context, int flags) {
        super(context);
        this.init(flags);
    }

    public InkView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public InkView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        TypedArray a = this.getContext().obtainStyledAttributes(attrs, R.styleable.InkView, defStyleAttr, 0);
        int flags = a.getInt(R.styleable.InkView_inkFlags, 3);
        a.recycle();
        this.init(flags);
    }

    private void init(int flags) {
        this.setFlags(flags);
        DisplayMetrics metrics = this.getResources().getDisplayMetrics();
        this.density = (metrics.xdpi + metrics.ydpi) / 2.0f;
        this.paint = new Paint();
        this.paint.setStrokeCap(Paint.Cap.ROUND);
        this.paint.setAntiAlias(true);
        this.setColor(-16777216);
        this.setMaxStrokeWidth(5.0f);
        this.setMinStrokeWidth(1.5f);
        this.setSmoothingRatio(0.75f);
        this.dirty = new RectF();
        this.isEmpty = true;
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.clear();
    }

    public boolean onTouchEvent(MotionEvent e) {
        int action = e.getAction();
        this.isEmpty = false;
        if (action == 0) {
            this.addPoint(this.getRecycledPoint(e.getX(), e.getY(), e.getEventTime()));
            for (InkListener listener : this.listeners) {
                listener.onInkDraw();
            }
        } else if (action == 2 && !this.pointQueue.get(this.pointQueue.size() - 1).equals(e.getX(), e.getY())) {
            this.addPoint(this.getRecycledPoint(e.getX(), e.getY(), e.getEventTime()));
        }
        if (action == 1) {
            if (this.pointQueue.size() == 1) {
                this.draw(this.pointQueue.get(0));
            } else if (this.pointQueue.size() == 2) {
                this.pointQueue.get(1).findControlPoints(this.pointQueue.get(0), null);
                this.draw(this.pointQueue.get(0), this.pointQueue.get(1));
            }
            this.pointRecycle.addAll(this.pointQueue);
            this.pointQueue.clear();
        }
        return true;
    }

    protected void onDraw(Canvas canvas) {
        canvas.drawBitmap(this.bitmap, 0.0f, 0.0f, null);
        super.onDraw(canvas);
    }

    public void setFlags(int flags) {
        this.flags = flags;
    }

    public void addFlags(int flags) {
        this.flags |= flags;
    }

    public void addFlag(int flag) {
        this.addFlags(flag);
    }

    public void removeFlags(int flags) {
        this.flags &= ~flags;
    }

    public void removeFlag(int flag) {
        this.removeFlags(flag);
    }

    public boolean hasFlags(int flags) {
        return (this.flags & flags) > 0;
    }

    public boolean hasFlag(int flag) {
        return this.hasFlags(flag);
    }

    public void clearFlags() {
        this.flags = 0;
    }

    public void addListener(InkListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    @Deprecated
    public void addInkListener(InkListener listener) {
        this.addListener(listener);
    }

    public void removeListener(InkListener listener) {
        this.listeners.remove(listener);
    }

    @Deprecated
    public void removeInkListener(InkListener listener) {
        this.removeListener(listener);
    }

    public void setColor(int color) {
        this.paint.setColor(color);
    }

    public void setMaxStrokeWidth(float width) {
        this.maxStrokeWidth = TypedValue.applyDimension((int)1, (float)width, (DisplayMetrics)this.getResources().getDisplayMetrics());
    }

    public void setMinStrokeWidth(float width) {
        this.minStrokeWidth = TypedValue.applyDimension((int)1, (float)width, (DisplayMetrics)this.getResources().getDisplayMetrics());
    }

    public float getSmoothingRatio() {
        return this.smoothingRatio;
    }

    public void setSmoothingRatio(float ratio) {
        this.smoothingRatio = Math.max(Math.min(ratio, 1.0f), 0.0f);
    }

    public boolean isViewEmpty() {
        return this.isEmpty;
    }

    public void clear() {
        if (this.bitmap != null) {
            this.bitmap.recycle();
        }
        this.bitmap = Bitmap.createBitmap((int)this.getWidth(), (int)this.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        this.canvas = new Canvas(this.bitmap);
        for (InkListener listener : this.listeners) {
            listener.onInkClear();
        }
        this.invalidate();
        this.isEmpty = true;
    }

    public Bitmap getBitmap() {
        return this.getBitmap(0);
    }

    public Bitmap getBitmap(int backgroundColor) {
        Bitmap bitmap = Bitmap.createBitmap((int)this.getWidth(), (int)this.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas bitmapCanvas = new Canvas(bitmap);
        if (backgroundColor != 0) {
            bitmapCanvas.drawColor(backgroundColor);
        }
        bitmapCanvas.drawBitmap(this.bitmap, 0.0f, 0.0f, null);
        return bitmap;
    }

    public void drawBitmap(Bitmap bitmap, float x, float y, Paint paint) {
        this.canvas.drawBitmap(bitmap, x, y, paint);
        this.invalidate();
    }

    float getDensity() {
        return this.density;
    }

    void addPoint(InkPoint p) {
        this.pointQueue.add(p);
        int queueSize = this.pointQueue.size();
        if (queueSize == 1) {
            int recycleSize = this.pointRecycle.size();
            p.velocity = recycleSize > 0 ? this.pointRecycle.get(recycleSize - 1).velocityTo(p) / 2.0f : 0.0f;
            this.paint.setStrokeWidth(this.computeStrokeWidth(p.velocity));
        } else if (queueSize == 2) {
            InkPoint p0 = this.pointQueue.get(0);
            p.velocity = p0.velocityTo(p);
            p0.velocity += p.velocity / 2.0f;
            p0.findControlPoints(null, p);
            this.paint.setStrokeWidth(this.computeStrokeWidth(p0.velocity));
        } else if (queueSize == 3) {
            InkPoint p0 = this.pointQueue.get(0);
            InkPoint p1 = this.pointQueue.get(1);
            p1.findControlPoints(p0, p);
            p.velocity = p1.velocityTo(p);
            this.draw(p0, p1);
            this.pointRecycle.add(this.pointQueue.remove(0));
        }
    }

    InkPoint getRecycledPoint(float x, float y, long time) {
        if (this.pointRecycle.size() == 0) {
            return new InkPoint(x, y, time);
        }
        return this.pointRecycle.remove(0).reset(x, y, time);
    }

    float computeStrokeWidth(float velocity) {
        if (this.hasFlags(2)) {
            return this.maxStrokeWidth - (this.maxStrokeWidth - this.minStrokeWidth) * Math.min(velocity / 7.0f, 1.0f);
        }
        return this.maxStrokeWidth;
    }

    void draw(InkPoint p) {
        this.paint.setStyle(Paint.Style.FILL);
        this.canvas.drawCircle(p.x, p.y, this.paint.getStrokeWidth() / 2.0f, this.paint);
        this.invalidate();
    }

    void draw(InkPoint p1, InkPoint p2) {
        this.dirty.left = Math.min(p1.x, p2.x);
        this.dirty.right = Math.max(p1.x, p2.x);
        this.dirty.top = Math.min(p1.y, p2.y);
        this.dirty.bottom = Math.max(p1.y, p2.y);
        this.paint.setStyle(Paint.Style.STROKE);
        float acceleration = Math.abs((p2.velocity - p1.velocity) / (float)(p2.time - p1.time));
        float filterRatio = Math.min(0.22f + 0.1f * acceleration / 3.0f, 1.0f);
        float desiredWidth = this.computeStrokeWidth(p2.velocity);
        float startWidth = this.paint.getStrokeWidth();
        float endWidth = filterRatio * desiredWidth + (1.0f - filterRatio) * startWidth;
        float deltaWidth = endWidth - startWidth;
        if (this.hasFlags(1)) {
            int steps = (int)(Math.sqrt(Math.pow(p2.x - p1.x, 2.0) + Math.pow(p2.y - p1.y, 2.0)) / 5.0);
            float u = 1.0f / (float)(steps + 1);
            float uu = u * u;
            float uuu = u * u * u;
            float pre1 = 3.0f * u;
            float pre2 = 3.0f * uu;
            float pre3 = 6.0f * uu;
            float pre4 = 6.0f * uuu;
            float tmp1x = p1.x - p1.c2x * 2.0f + p2.c1x;
            float tmp1y = p1.y - p1.c2y * 2.0f + p2.c1y;
            float tmp2x = (p1.c2x - p2.c1x) * 3.0f - p1.x + p2.x;
            float tmp2y = (p1.c2y - p2.c1y) * 3.0f - p1.y + p2.y;
            float dx = (p1.c2x - p1.x) * pre1 + tmp1x * pre2 + tmp2x * uuu;
            float dy = (p1.c2y - p1.y) * pre1 + tmp1y * pre2 + tmp2y * uuu;
            float ddx = tmp1x * pre3 + tmp2x * pre4;
            float ddy = tmp1y * pre3 + tmp2y * pre4;
            float dddx = tmp2x * pre4;
            float dddy = tmp2y * pre4;
            float x1 = p1.x;
            float y1 = p1.y;
            int i = 0;
            while (i++ < steps) {
                float x2 = x1 + dx;
                float y2 = y1 + dy;
                this.paint.setStrokeWidth(startWidth + deltaWidth * (float)i / (float)steps);
                this.canvas.drawLine(x1, y1, x2, y2, this.paint);
                x1 = x2;
                y1 = y2;
                dx += ddx;
                dy += ddy;
                ddx += dddx;
                ddy += dddy;
                this.dirty.left = Math.min(this.dirty.left, x1);
                this.dirty.right = Math.max(this.dirty.right, x1);
                this.dirty.top = Math.min(this.dirty.top, y1);
                this.dirty.bottom = Math.max(this.dirty.bottom, y1);
            }
            this.paint.setStrokeWidth(endWidth);
            this.canvas.drawLine(x1, y1, p2.x, p2.y, this.paint);
        } else {
            this.canvas.drawLine(p1.x, p1.y, p2.x, p2.y, this.paint);
            this.paint.setStrokeWidth(endWidth);
        }
        this.invalidate((int)(this.dirty.left - this.maxStrokeWidth / 2.0f), (int)(this.dirty.top - this.maxStrokeWidth / 2.0f), (int)(this.dirty.right + this.maxStrokeWidth / 2.0f), (int)(this.dirty.bottom + this.maxStrokeWidth / 2.0f));
    }

    class InkPoint {
        float x;
        float y;
        float c1x;
        float c1y;
        float c2x;
        float c2y;
        float velocity;
        long time;

        InkPoint(float x, float y, long time) {
            this.reset(x, y, time);
        }

        InkPoint reset(float x, float y, long time) {
            this.x = x;
            this.y = y;
            this.time = time;
            this.velocity = 0.0f;
            this.c1x = x;
            this.c1y = y;
            this.c2x = x;
            this.c2y = y;
            return this;
        }

        boolean equals(float x, float y) {
            return this.x == x && this.y == y;
        }

        float distanceTo(InkPoint p) {
            float dx = p.x - this.x;
            float dy = p.y - this.y;
            return (float)Math.sqrt(dx * dx + dy * dy);
        }

        float velocityTo(InkPoint p) {
            return 1000.0f * this.distanceTo(p) / ((float)Math.abs(p.time - this.time) * InkView.this.getDensity());
        }

        void findControlPoints(InkPoint prev, InkPoint next) {
            if (prev == null && next == null) {
                return;
            }
            float r = InkView.this.getSmoothingRatio();
            if (prev == null) {
                this.c2x = this.x + r * (next.x - this.x) / 2.0f;
                this.c2y = this.y + r * (next.y - this.y) / 2.0f;
                return;
            }
            if (next == null) {
                this.c1x = this.x + r * (prev.x - this.x) / 2.0f;
                this.c1y = this.y + r * (prev.y - this.y) / 2.0f;
                return;
            }
            this.c1x = (this.x + prev.x) / 2.0f;
            this.c1y = (this.y + prev.y) / 2.0f;
            this.c2x = (this.x + next.x) / 2.0f;
            this.c2y = (this.y + next.y) / 2.0f;
            float len1 = this.distanceTo(prev);
            float len2 = this.distanceTo(next);
            float k = len1 / (len1 + len2);
            float xM = this.c1x + (this.c2x - this.c1x) * k;
            float yM = this.c1y + (this.c2y - this.c1y) * k;
            float dx = this.x - xM;
            float dy = this.y - yM;
            r = 1.0f - r;
            this.c1x += dx + r * (xM - this.c1x);
            this.c1y += dy + r * (yM - this.c1y);
            this.c2x += dx + r * (xM - this.c2x);
            this.c2y += dy + r * (yM - this.c2y);
        }
    }

    public static interface InkListener {
        public void onInkClear();

        public void onInkDraw();
    }
}

