/*
 * Decompiled with CFR 0.152.
 */
package spark.webserver.websocket;

import java.util.Objects;
import org.eclipse.jetty.websocket.api.WebSocketListener;
import org.eclipse.jetty.websocket.api.annotations.WebSocket;
import org.eclipse.jetty.websocket.servlet.ServletUpgradeRequest;
import org.eclipse.jetty.websocket.servlet.ServletUpgradeResponse;
import org.eclipse.jetty.websocket.servlet.WebSocketCreator;

public class WebSocketCreatorFactory {
    public static WebSocketCreator create(Class<?> handlerClass) {
        WebSocketCreatorFactory.validate(handlerClass);
        try {
            Object handler = handlerClass.newInstance();
            return new SparkWebSocketCreator(handler);
        }
        catch (IllegalAccessException | InstantiationException ex) {
            throw new RuntimeException("Could not instantiate websocket handler", ex);
        }
    }

    private static void validate(Class<?> handlerClass) {
        boolean valid;
        boolean bl = valid = WebSocketListener.class.isAssignableFrom(handlerClass) || handlerClass.isAnnotationPresent(WebSocket.class);
        if (!valid) {
            throw new IllegalArgumentException("WebSocket handler must implement 'WebSocketListener' or be annotated as '@WebSocket'");
        }
    }

    static class SparkWebSocketCreator
    implements WebSocketCreator {
        private final Object handler;

        private SparkWebSocketCreator(Object handler) {
            this.handler = Objects.requireNonNull(handler, "handler cannot be null");
        }

        public Object createWebSocket(ServletUpgradeRequest request, ServletUpgradeResponse response) {
            return this.handler;
        }

        Object getHandler() {
            return this.handler;
        }
    }
}

