/*
 * Decompiled with CFR 0.152.
 */
package retrofit2.adapter.rxjava2;

import io.reactivex.Completable;
import io.reactivex.Flowable;
import io.reactivex.Maybe;
import io.reactivex.Observable;
import io.reactivex.Scheduler;
import io.reactivex.Single;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import retrofit2.CallAdapter;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.adapter.rxjava2.Result;
import retrofit2.adapter.rxjava2.RxJava2CallAdapter;

public final class RxJava2CallAdapterFactory
extends CallAdapter.Factory {
    private final Scheduler scheduler;
    private final boolean isAsync;

    public static RxJava2CallAdapterFactory create() {
        return new RxJava2CallAdapterFactory(null, false);
    }

    public static RxJava2CallAdapterFactory createAsync() {
        return new RxJava2CallAdapterFactory(null, true);
    }

    public static RxJava2CallAdapterFactory createWithScheduler(Scheduler scheduler) {
        if (scheduler == null) {
            throw new NullPointerException("scheduler == null");
        }
        return new RxJava2CallAdapterFactory(scheduler, false);
    }

    private RxJava2CallAdapterFactory(Scheduler scheduler, boolean isAsync) {
        this.scheduler = scheduler;
        this.isAsync = isAsync;
    }

    public CallAdapter<?, ?> get(Type returnType, Annotation[] annotations, Retrofit retrofit) {
        Type responseType;
        boolean isMaybe;
        Class rawType = RxJava2CallAdapterFactory.getRawType((Type)returnType);
        if (rawType == Completable.class) {
            return new RxJava2CallAdapter((Type)((Object)Void.class), this.scheduler, this.isAsync, false, true, false, false, false, true);
        }
        boolean isFlowable = rawType == Flowable.class;
        boolean isSingle = rawType == Single.class;
        boolean bl = isMaybe = rawType == Maybe.class;
        if (!(rawType == Observable.class || isFlowable || isSingle || isMaybe)) {
            return null;
        }
        boolean isResult = false;
        boolean isBody = false;
        if (!(returnType instanceof ParameterizedType)) {
            String name = isFlowable ? "Flowable" : (isSingle ? "Single" : (isMaybe ? "Maybe" : "Observable"));
            throw new IllegalStateException(name + " return type must be parameterized as " + name + "<Foo> or " + name + "<? extends Foo>");
        }
        Type observableType = RxJava2CallAdapterFactory.getParameterUpperBound((int)0, (ParameterizedType)((ParameterizedType)returnType));
        Class rawObservableType = RxJava2CallAdapterFactory.getRawType((Type)observableType);
        if (rawObservableType == Response.class) {
            if (!(observableType instanceof ParameterizedType)) {
                throw new IllegalStateException("Response must be parameterized as Response<Foo> or Response<? extends Foo>");
            }
            responseType = RxJava2CallAdapterFactory.getParameterUpperBound((int)0, (ParameterizedType)((ParameterizedType)observableType));
        } else if (rawObservableType == Result.class) {
            if (!(observableType instanceof ParameterizedType)) {
                throw new IllegalStateException("Result must be parameterized as Result<Foo> or Result<? extends Foo>");
            }
            responseType = RxJava2CallAdapterFactory.getParameterUpperBound((int)0, (ParameterizedType)((ParameterizedType)observableType));
            isResult = true;
        } else {
            responseType = observableType;
            isBody = true;
        }
        return new RxJava2CallAdapter(responseType, this.scheduler, this.isAsync, isResult, isBody, isFlowable, isSingle, isMaybe, false);
    }
}

