/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.sqldelight.validation;

import com.squareup.sqldelight.SqliteParser;
import com.squareup.sqldelight.resolution.ResolutionError;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.RuleContext;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\tJ\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\tH\u0002J\f\u0010\u000b\u001a\u00020\u0003*\u00020\fH\u0002J\u0012\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006*\u00020\tH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/squareup/sqldelight/validation/ExpressionValidator;", "", "subqueriesAllowed", "", "(Z)V", "validate", "", "Lcom/squareup/sqldelight/resolution/ResolutionError;", "expression", "Lcom/squareup/sqldelight/SqliteParser$ExprContext;", "validateAndThrow", "canContainAggregate", "Lorg/antlr/v4/runtime/RuleContext;", "validateFunction", "sqldelight-compiler_main"})
public final class ExpressionValidator {
    private final boolean subqueriesAllowed;

    @NotNull
    public final List<ResolutionError> validate(@NotNull SqliteParser.ExprContext expression) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)expression), (String)"expression");
        try {
            return this.validateAndThrow(expression);
        }
        catch (Exception e) {
            if (e.getMessage() == null) {
                throw (Throwable)e;
            }
            ParserRuleContext parserRuleContext = expression;
            String string = e.getMessage();
            if (string == null) {
                Intrinsics.throwNpe();
            }
            return CollectionsKt.listOf((Object)new ResolutionError.ExpressionError(parserRuleContext, string));
        }
    }

    private final List<ResolutionError> validateAndThrow(SqliteParser.ExprContext expression) {
        if (expression.function_name() != null) {
            return this.validateFunction(expression);
        }
        if (expression.K_IN() != null && expression.select_stmt() != null && !this.subqueriesAllowed) {
            ParserRuleContext parserRuleContext = expression.select_stmt();
            Intrinsics.checkExpressionValueIsNotNull((Object)parserRuleContext, (String)"expression.select_stmt()");
            return CollectionsKt.listOf((Object)new ResolutionError.ExpressionError(parserRuleContext, "Subqueries are not permitted as part of CREATE TABLE statements"));
        }
        if (expression.select_stmt() != null && !this.subqueriesAllowed) {
            ParserRuleContext parserRuleContext = expression.select_stmt();
            Intrinsics.checkExpressionValueIsNotNull((Object)parserRuleContext, (String)"expression.select_stmt()");
            return CollectionsKt.listOf((Object)new ResolutionError.ExpressionError(parserRuleContext, "Subqueries are not permitted as part of CREATE TABLE statements"));
        }
        return CollectionsKt.emptyList();
    }

    /*
     * WARNING - void declaration
     */
    private final List<ResolutionError> validateFunction(@NotNull SqliteParser.ExprContext $receiver) {
        void destination$iv$iv;
        void $receiver$iv$iv;
        void $receiver$iv;
        ArrayList errors = CollectionsKt.arrayListOf((Object[])new ResolutionError[0]);
        Object object = $receiver.function_name().getText();
        String string = object;
        if (string == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string2 = string.toLowerCase();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.String).toLowerCase()");
        object = string2;
        String it = object;
        switch (it) {
            case "changes": 
            case "random": 
            case "last_insert_rowid": 
            case "total_changes": 
            case "sqlite_source_id": 
            case "sqlite_version": {
                if ($receiver.expr().size() == 0) break;
                errors.add(new ResolutionError.ExpressionError($receiver, it + " takes no arguments"));
                break;
            }
            case "count": {
                if ($receiver.expr().size() <= 1 && ($receiver.expr().size() != 0 || $receiver.STAR() != null)) break;
                errors.add(new ResolutionError.ExpressionError($receiver, it + " expects a single argument"));
                break;
            }
            case "upper": 
            case "randomblob": 
            case "sum": 
            case "total": 
            case "quote": 
            case "avg": 
            case "hex": 
            case "typeof": 
            case "likely": 
            case "unlikely": 
            case "lower": 
            case "length": 
            case "sqlite_compileoption_used": 
            case "sqlite_compileoption_get": 
            case "zeroblob": 
            case "abs": 
            case "soundex": 
            case "unicode": {
                if ($receiver.expr().size() == 1) break;
                errors.add(new ResolutionError.ExpressionError($receiver, it + " expects a single argument"));
                break;
            }
            case "instr": 
            case "ifnull": 
            case "likelihood": 
            case "nullif": {
                if ($receiver.expr().size() == 2) break;
                errors.add(new ResolutionError.ExpressionError($receiver, it + " expects two arguments"));
                break;
            }
            case "replace": {
                if ($receiver.expr().size() == 3) break;
                errors.add(new ResolutionError.ExpressionError($receiver, it + " expects three arguments"));
                break;
            }
            case "trim": 
            case "ltrim": 
            case "rtrim": 
            case "round": 
            case "group_concat": {
                if ($receiver.expr().size() == 1 || $receiver.expr().size() == 2) break;
                errors.add(new ResolutionError.ExpressionError($receiver, it + " expects one or two arguments"));
                break;
            }
            case "substr": {
                if ($receiver.expr().size() == 2 || $receiver.expr().size() == 3) break;
                errors.add(new ResolutionError.ExpressionError($receiver, it + " expects two or three arguments"));
                break;
            }
            case "date": 
            case "printf": 
            case "datetime": 
            case "min": 
            case "juliantime": 
            case "max": 
            case "char": 
            case "time": {
                if ($receiver.expr().size() >= 1) break;
                errors.add(new ResolutionError.ExpressionError($receiver, it + " expects 1 or more arguments"));
                break;
            }
            case "coalesce": 
            case "strftime": {
                if ($receiver.expr().size() >= 2) break;
                errors.add(new ResolutionError.ExpressionError($receiver, it + " expects 2 or more arguments"));
                break;
            }
            default: {
                errors.add(new ResolutionError.ExpressionError($receiver, "function " + it + " does not exist"));
            }
        }
        switch (it) {
            case "min": 
            case "max": {
                if ($receiver.expr().size() == 1 && !this.canContainAggregate($receiver.parent)) {
                    errors.add(new ResolutionError.ExpressionError($receiver, "Aggregate function " + it + " must be" + " used in a result column or having clause."));
                }
                break;
            }
            case "total": 
            case "avg": 
            case "group_concat": 
            case "count": 
            case "sum": {
                if (!this.canContainAggregate($receiver.parent)) {
                    errors.add(new ResolutionError.ExpressionError($receiver, "Aggregate function " + it + " must be" + " used in a result column or having clause."));
                }
                break;
            }
            default: {
                if ($receiver.K_DISTINCT() == null) break;
                errors.add(new ResolutionError.ExpressionError($receiver, "Non aggregate functions cannot use DISTINCT"));
            }
        }
        object = $receiver.expr();
        ArrayList arrayList = errors;
        it = $receiver$iv;
        Object object2 = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            SqliteParser.ExprContext it2;
            SqliteParser.ExprContext exprContext = it2 = (SqliteParser.ExprContext)((Object)element$iv$iv);
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)exprContext), (String)"it");
            Iterable list$iv$iv = this.validate(exprContext);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List list = (List)destination$iv$iv;
        arrayList.addAll(list);
        return errors;
    }

    private final boolean canContainAggregate(@NotNull RuleContext $receiver) {
        return $receiver instanceof SqliteParser.Result_columnContext || $receiver instanceof SqliteParser.Having_stmtContext || $receiver.parent != null && this.canContainAggregate($receiver.parent);
    }

    public ExpressionValidator(boolean subqueriesAllowed) {
        this.subqueriesAllowed = subqueriesAllowed;
    }

    public /* synthetic */ ExpressionValidator(boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = true;
        }
        this(bl);
    }

    public ExpressionValidator() {
        this(false, 1, null);
    }
}

