/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model.identity;

import com.google.gson.annotations.SerializedName;
import com.stripe.exception.StripeException;
import com.stripe.model.Address;
import com.stripe.model.HasId;
import com.stripe.model.StripeObject;
import com.stripe.model.identity.VerificationReportCollection;
import com.stripe.net.ApiRequest;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.identity.VerificationReportListParams;
import com.stripe.param.identity.VerificationReportRetrieveParams;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public class VerificationReport
extends ApiResource
implements HasId {
    @SerializedName(value="client_reference_id")
    String clientReferenceId;
    @SerializedName(value="created")
    Long created;
    @SerializedName(value="document")
    Document document;
    @SerializedName(value="email")
    Email email;
    @SerializedName(value="id")
    String id;
    @SerializedName(value="id_number")
    IdNumber idNumber;
    @SerializedName(value="livemode")
    Boolean livemode;
    @SerializedName(value="object")
    String object;
    @SerializedName(value="options")
    Options options;
    @SerializedName(value="phone")
    Phone phone;
    @SerializedName(value="selfie")
    Selfie selfie;
    @SerializedName(value="type")
    String type;
    @SerializedName(value="verification_flow")
    String verificationFlow;
    @SerializedName(value="verification_session")
    String verificationSession;

    public static VerificationReportCollection list(Map<String, Object> params) throws StripeException {
        return VerificationReport.list(params, (RequestOptions)null);
    }

    public static VerificationReportCollection list(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = "/v1/identity/verification_reports";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, params, options);
        return (VerificationReportCollection)VerificationReport.getGlobalResponseGetter().request(request, (Type)((Object)VerificationReportCollection.class));
    }

    public static VerificationReportCollection list(VerificationReportListParams params) throws StripeException {
        return VerificationReport.list(params, (RequestOptions)null);
    }

    public static VerificationReportCollection list(VerificationReportListParams params, RequestOptions options) throws StripeException {
        String path = "/v1/identity/verification_reports";
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options);
        return (VerificationReportCollection)VerificationReport.getGlobalResponseGetter().request(request, (Type)((Object)VerificationReportCollection.class));
    }

    public static VerificationReport retrieve(String report) throws StripeException {
        return VerificationReport.retrieve(report, (Map<String, Object>)null, (RequestOptions)null);
    }

    public static VerificationReport retrieve(String report, RequestOptions options) throws StripeException {
        return VerificationReport.retrieve(report, (Map<String, Object>)null, options);
    }

    public static VerificationReport retrieve(String report, Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/identity/verification_reports/%s", ApiResource.urlEncodeId(report));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, params, options);
        return (VerificationReport)VerificationReport.getGlobalResponseGetter().request(request, (Type)((Object)VerificationReport.class));
    }

    public static VerificationReport retrieve(String report, VerificationReportRetrieveParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/identity/verification_reports/%s", ApiResource.urlEncodeId(report));
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options);
        return (VerificationReport)VerificationReport.getGlobalResponseGetter().request(request, (Type)((Object)VerificationReport.class));
    }

    @Override
    public void setResponseGetter(StripeResponseGetter responseGetter) {
        super.setResponseGetter(responseGetter);
        this.trySetResponseGetter(this.document, responseGetter);
        this.trySetResponseGetter(this.email, responseGetter);
        this.trySetResponseGetter(this.idNumber, responseGetter);
        this.trySetResponseGetter(this.options, responseGetter);
        this.trySetResponseGetter(this.phone, responseGetter);
        this.trySetResponseGetter(this.selfie, responseGetter);
    }

    @Generated
    public String getClientReferenceId() {
        return this.clientReferenceId;
    }

    @Generated
    public Long getCreated() {
        return this.created;
    }

    @Generated
    public Document getDocument() {
        return this.document;
    }

    @Generated
    public Email getEmail() {
        return this.email;
    }

    @Generated
    public IdNumber getIdNumber() {
        return this.idNumber;
    }

    @Generated
    public Boolean getLivemode() {
        return this.livemode;
    }

    @Generated
    public String getObject() {
        return this.object;
    }

    @Generated
    public Options getOptions() {
        return this.options;
    }

    @Generated
    public Phone getPhone() {
        return this.phone;
    }

    @Generated
    public Selfie getSelfie() {
        return this.selfie;
    }

    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public String getVerificationFlow() {
        return this.verificationFlow;
    }

    @Generated
    public String getVerificationSession() {
        return this.verificationSession;
    }

    @Generated
    public void setClientReferenceId(String clientReferenceId) {
        this.clientReferenceId = clientReferenceId;
    }

    @Generated
    public void setCreated(Long created) {
        this.created = created;
    }

    @Generated
    public void setDocument(Document document) {
        this.document = document;
    }

    @Generated
    public void setEmail(Email email) {
        this.email = email;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setIdNumber(IdNumber idNumber) {
        this.idNumber = idNumber;
    }

    @Generated
    public void setLivemode(Boolean livemode) {
        this.livemode = livemode;
    }

    @Generated
    public void setObject(String object) {
        this.object = object;
    }

    @Generated
    public void setOptions(Options options) {
        this.options = options;
    }

    @Generated
    public void setPhone(Phone phone) {
        this.phone = phone;
    }

    @Generated
    public void setSelfie(Selfie selfie) {
        this.selfie = selfie;
    }

    @Generated
    public void setType(String type) {
        this.type = type;
    }

    @Generated
    public void setVerificationFlow(String verificationFlow) {
        this.verificationFlow = verificationFlow;
    }

    @Generated
    public void setVerificationSession(String verificationSession) {
        this.verificationSession = verificationSession;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof VerificationReport)) {
            return false;
        }
        VerificationReport other = (VerificationReport)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$created = this.getCreated();
        Long other$created = other.getCreated();
        if (this$created == null ? other$created != null : !((Object)this$created).equals(other$created)) {
            return false;
        }
        Boolean this$livemode = this.getLivemode();
        Boolean other$livemode = other.getLivemode();
        if (this$livemode == null ? other$livemode != null : !((Object)this$livemode).equals(other$livemode)) {
            return false;
        }
        String this$clientReferenceId = this.getClientReferenceId();
        String other$clientReferenceId = other.getClientReferenceId();
        if (this$clientReferenceId == null ? other$clientReferenceId != null : !this$clientReferenceId.equals(other$clientReferenceId)) {
            return false;
        }
        Document this$document = this.getDocument();
        Document other$document = other.getDocument();
        if (this$document == null ? other$document != null : !((Object)this$document).equals(other$document)) {
            return false;
        }
        Email this$email = this.getEmail();
        Email other$email = other.getEmail();
        if (this$email == null ? other$email != null : !((Object)this$email).equals(other$email)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        IdNumber this$idNumber = this.getIdNumber();
        IdNumber other$idNumber = other.getIdNumber();
        if (this$idNumber == null ? other$idNumber != null : !((Object)this$idNumber).equals(other$idNumber)) {
            return false;
        }
        String this$object = this.getObject();
        String other$object = other.getObject();
        if (this$object == null ? other$object != null : !this$object.equals(other$object)) {
            return false;
        }
        Options this$options = this.getOptions();
        Options other$options = other.getOptions();
        if (this$options == null ? other$options != null : !((Object)this$options).equals(other$options)) {
            return false;
        }
        Phone this$phone = this.getPhone();
        Phone other$phone = other.getPhone();
        if (this$phone == null ? other$phone != null : !((Object)this$phone).equals(other$phone)) {
            return false;
        }
        Selfie this$selfie = this.getSelfie();
        Selfie other$selfie = other.getSelfie();
        if (this$selfie == null ? other$selfie != null : !((Object)this$selfie).equals(other$selfie)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$verificationFlow = this.getVerificationFlow();
        String other$verificationFlow = other.getVerificationFlow();
        if (this$verificationFlow == null ? other$verificationFlow != null : !this$verificationFlow.equals(other$verificationFlow)) {
            return false;
        }
        String this$verificationSession = this.getVerificationSession();
        String other$verificationSession = other.getVerificationSession();
        return !(this$verificationSession == null ? other$verificationSession != null : !this$verificationSession.equals(other$verificationSession));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof VerificationReport;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $created = this.getCreated();
        result = result * 59 + ($created == null ? 43 : ((Object)$created).hashCode());
        Boolean $livemode = this.getLivemode();
        result = result * 59 + ($livemode == null ? 43 : ((Object)$livemode).hashCode());
        String $clientReferenceId = this.getClientReferenceId();
        result = result * 59 + ($clientReferenceId == null ? 43 : $clientReferenceId.hashCode());
        Document $document = this.getDocument();
        result = result * 59 + ($document == null ? 43 : ((Object)$document).hashCode());
        Email $email = this.getEmail();
        result = result * 59 + ($email == null ? 43 : ((Object)$email).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        IdNumber $idNumber = this.getIdNumber();
        result = result * 59 + ($idNumber == null ? 43 : ((Object)$idNumber).hashCode());
        String $object = this.getObject();
        result = result * 59 + ($object == null ? 43 : $object.hashCode());
        Options $options = this.getOptions();
        result = result * 59 + ($options == null ? 43 : ((Object)$options).hashCode());
        Phone $phone = this.getPhone();
        result = result * 59 + ($phone == null ? 43 : ((Object)$phone).hashCode());
        Selfie $selfie = this.getSelfie();
        result = result * 59 + ($selfie == null ? 43 : ((Object)$selfie).hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $verificationFlow = this.getVerificationFlow();
        result = result * 59 + ($verificationFlow == null ? 43 : $verificationFlow.hashCode());
        String $verificationSession = this.getVerificationSession();
        result = result * 59 + ($verificationSession == null ? 43 : $verificationSession.hashCode());
        return result;
    }

    @Override
    @Generated
    public String getId() {
        return this.id;
    }

    public static class Document
    extends StripeObject {
        @SerializedName(value="address")
        Address address;
        @SerializedName(value="dob")
        Dob dob;
        @SerializedName(value="error")
        Errors error;
        @SerializedName(value="expiration_date")
        ExpirationDate expirationDate;
        @SerializedName(value="files")
        List<String> files;
        @SerializedName(value="first_name")
        String firstName;
        @SerializedName(value="issued_date")
        IssuedDate issuedDate;
        @SerializedName(value="issuing_country")
        String issuingCountry;
        @SerializedName(value="last_name")
        String lastName;
        @SerializedName(value="number")
        String number;
        @SerializedName(value="status")
        String status;
        @SerializedName(value="type")
        String type;

        @Generated
        public Address getAddress() {
            return this.address;
        }

        @Generated
        public Dob getDob() {
            return this.dob;
        }

        @Generated
        public Errors getError() {
            return this.error;
        }

        @Generated
        public ExpirationDate getExpirationDate() {
            return this.expirationDate;
        }

        @Generated
        public List<String> getFiles() {
            return this.files;
        }

        @Generated
        public String getFirstName() {
            return this.firstName;
        }

        @Generated
        public IssuedDate getIssuedDate() {
            return this.issuedDate;
        }

        @Generated
        public String getIssuingCountry() {
            return this.issuingCountry;
        }

        @Generated
        public String getLastName() {
            return this.lastName;
        }

        @Generated
        public String getNumber() {
            return this.number;
        }

        @Generated
        public String getStatus() {
            return this.status;
        }

        @Generated
        public String getType() {
            return this.type;
        }

        @Generated
        public void setAddress(Address address) {
            this.address = address;
        }

        @Generated
        public void setDob(Dob dob) {
            this.dob = dob;
        }

        @Generated
        public void setError(Errors error) {
            this.error = error;
        }

        @Generated
        public void setExpirationDate(ExpirationDate expirationDate) {
            this.expirationDate = expirationDate;
        }

        @Generated
        public void setFiles(List<String> files) {
            this.files = files;
        }

        @Generated
        public void setFirstName(String firstName) {
            this.firstName = firstName;
        }

        @Generated
        public void setIssuedDate(IssuedDate issuedDate) {
            this.issuedDate = issuedDate;
        }

        @Generated
        public void setIssuingCountry(String issuingCountry) {
            this.issuingCountry = issuingCountry;
        }

        @Generated
        public void setLastName(String lastName) {
            this.lastName = lastName;
        }

        @Generated
        public void setNumber(String number) {
            this.number = number;
        }

        @Generated
        public void setStatus(String status) {
            this.status = status;
        }

        @Generated
        public void setType(String type) {
            this.type = type;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Document)) {
                return false;
            }
            Document other = (Document)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Address this$address = this.getAddress();
            Address other$address = other.getAddress();
            if (this$address == null ? other$address != null : !((Object)this$address).equals(other$address)) {
                return false;
            }
            Dob this$dob = this.getDob();
            Dob other$dob = other.getDob();
            if (this$dob == null ? other$dob != null : !((Object)this$dob).equals(other$dob)) {
                return false;
            }
            Errors this$error = this.getError();
            Errors other$error = other.getError();
            if (this$error == null ? other$error != null : !((Object)this$error).equals(other$error)) {
                return false;
            }
            ExpirationDate this$expirationDate = this.getExpirationDate();
            ExpirationDate other$expirationDate = other.getExpirationDate();
            if (this$expirationDate == null ? other$expirationDate != null : !((Object)this$expirationDate).equals(other$expirationDate)) {
                return false;
            }
            List<String> this$files = this.getFiles();
            List<String> other$files = other.getFiles();
            if (this$files == null ? other$files != null : !((Object)this$files).equals(other$files)) {
                return false;
            }
            String this$firstName = this.getFirstName();
            String other$firstName = other.getFirstName();
            if (this$firstName == null ? other$firstName != null : !this$firstName.equals(other$firstName)) {
                return false;
            }
            IssuedDate this$issuedDate = this.getIssuedDate();
            IssuedDate other$issuedDate = other.getIssuedDate();
            if (this$issuedDate == null ? other$issuedDate != null : !((Object)this$issuedDate).equals(other$issuedDate)) {
                return false;
            }
            String this$issuingCountry = this.getIssuingCountry();
            String other$issuingCountry = other.getIssuingCountry();
            if (this$issuingCountry == null ? other$issuingCountry != null : !this$issuingCountry.equals(other$issuingCountry)) {
                return false;
            }
            String this$lastName = this.getLastName();
            String other$lastName = other.getLastName();
            if (this$lastName == null ? other$lastName != null : !this$lastName.equals(other$lastName)) {
                return false;
            }
            String this$number = this.getNumber();
            String other$number = other.getNumber();
            if (this$number == null ? other$number != null : !this$number.equals(other$number)) {
                return false;
            }
            String this$status = this.getStatus();
            String other$status = other.getStatus();
            if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
                return false;
            }
            String this$type = this.getType();
            String other$type = other.getType();
            return !(this$type == null ? other$type != null : !this$type.equals(other$type));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Document;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Address $address = this.getAddress();
            result = result * 59 + ($address == null ? 43 : ((Object)$address).hashCode());
            Dob $dob = this.getDob();
            result = result * 59 + ($dob == null ? 43 : ((Object)$dob).hashCode());
            Errors $error = this.getError();
            result = result * 59 + ($error == null ? 43 : ((Object)$error).hashCode());
            ExpirationDate $expirationDate = this.getExpirationDate();
            result = result * 59 + ($expirationDate == null ? 43 : ((Object)$expirationDate).hashCode());
            List<String> $files = this.getFiles();
            result = result * 59 + ($files == null ? 43 : ((Object)$files).hashCode());
            String $firstName = this.getFirstName();
            result = result * 59 + ($firstName == null ? 43 : $firstName.hashCode());
            IssuedDate $issuedDate = this.getIssuedDate();
            result = result * 59 + ($issuedDate == null ? 43 : ((Object)$issuedDate).hashCode());
            String $issuingCountry = this.getIssuingCountry();
            result = result * 59 + ($issuingCountry == null ? 43 : $issuingCountry.hashCode());
            String $lastName = this.getLastName();
            result = result * 59 + ($lastName == null ? 43 : $lastName.hashCode());
            String $number = this.getNumber();
            result = result * 59 + ($number == null ? 43 : $number.hashCode());
            String $status = this.getStatus();
            result = result * 59 + ($status == null ? 43 : $status.hashCode());
            String $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            return result;
        }

        public static class Dob
        extends StripeObject {
            @SerializedName(value="day")
            Long day;
            @SerializedName(value="month")
            Long month;
            @SerializedName(value="year")
            Long year;

            @Generated
            public Long getDay() {
                return this.day;
            }

            @Generated
            public Long getMonth() {
                return this.month;
            }

            @Generated
            public Long getYear() {
                return this.year;
            }

            @Generated
            public void setDay(Long day) {
                this.day = day;
            }

            @Generated
            public void setMonth(Long month) {
                this.month = month;
            }

            @Generated
            public void setYear(Long year) {
                this.year = year;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Dob)) {
                    return false;
                }
                Dob other = (Dob)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Long this$day = this.getDay();
                Long other$day = other.getDay();
                if (this$day == null ? other$day != null : !((Object)this$day).equals(other$day)) {
                    return false;
                }
                Long this$month = this.getMonth();
                Long other$month = other.getMonth();
                if (this$month == null ? other$month != null : !((Object)this$month).equals(other$month)) {
                    return false;
                }
                Long this$year = this.getYear();
                Long other$year = other.getYear();
                return !(this$year == null ? other$year != null : !((Object)this$year).equals(other$year));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Dob;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Long $day = this.getDay();
                result = result * 59 + ($day == null ? 43 : ((Object)$day).hashCode());
                Long $month = this.getMonth();
                result = result * 59 + ($month == null ? 43 : ((Object)$month).hashCode());
                Long $year = this.getYear();
                result = result * 59 + ($year == null ? 43 : ((Object)$year).hashCode());
                return result;
            }
        }

        public static class Errors
        extends StripeObject {
            @SerializedName(value="code")
            String code;
            @SerializedName(value="reason")
            String reason;

            @Generated
            public String getCode() {
                return this.code;
            }

            @Generated
            public String getReason() {
                return this.reason;
            }

            @Generated
            public void setCode(String code) {
                this.code = code;
            }

            @Generated
            public void setReason(String reason) {
                this.reason = reason;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Errors)) {
                    return false;
                }
                Errors other = (Errors)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$code = this.getCode();
                String other$code = other.getCode();
                if (this$code == null ? other$code != null : !this$code.equals(other$code)) {
                    return false;
                }
                String this$reason = this.getReason();
                String other$reason = other.getReason();
                return !(this$reason == null ? other$reason != null : !this$reason.equals(other$reason));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Errors;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $code = this.getCode();
                result = result * 59 + ($code == null ? 43 : $code.hashCode());
                String $reason = this.getReason();
                result = result * 59 + ($reason == null ? 43 : $reason.hashCode());
                return result;
            }
        }

        public static class ExpirationDate
        extends StripeObject {
            @SerializedName(value="day")
            Long day;
            @SerializedName(value="month")
            Long month;
            @SerializedName(value="year")
            Long year;

            @Generated
            public Long getDay() {
                return this.day;
            }

            @Generated
            public Long getMonth() {
                return this.month;
            }

            @Generated
            public Long getYear() {
                return this.year;
            }

            @Generated
            public void setDay(Long day) {
                this.day = day;
            }

            @Generated
            public void setMonth(Long month) {
                this.month = month;
            }

            @Generated
            public void setYear(Long year) {
                this.year = year;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof ExpirationDate)) {
                    return false;
                }
                ExpirationDate other = (ExpirationDate)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Long this$day = this.getDay();
                Long other$day = other.getDay();
                if (this$day == null ? other$day != null : !((Object)this$day).equals(other$day)) {
                    return false;
                }
                Long this$month = this.getMonth();
                Long other$month = other.getMonth();
                if (this$month == null ? other$month != null : !((Object)this$month).equals(other$month)) {
                    return false;
                }
                Long this$year = this.getYear();
                Long other$year = other.getYear();
                return !(this$year == null ? other$year != null : !((Object)this$year).equals(other$year));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof ExpirationDate;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Long $day = this.getDay();
                result = result * 59 + ($day == null ? 43 : ((Object)$day).hashCode());
                Long $month = this.getMonth();
                result = result * 59 + ($month == null ? 43 : ((Object)$month).hashCode());
                Long $year = this.getYear();
                result = result * 59 + ($year == null ? 43 : ((Object)$year).hashCode());
                return result;
            }
        }

        public static class IssuedDate
        extends StripeObject {
            @SerializedName(value="day")
            Long day;
            @SerializedName(value="month")
            Long month;
            @SerializedName(value="year")
            Long year;

            @Generated
            public Long getDay() {
                return this.day;
            }

            @Generated
            public Long getMonth() {
                return this.month;
            }

            @Generated
            public Long getYear() {
                return this.year;
            }

            @Generated
            public void setDay(Long day) {
                this.day = day;
            }

            @Generated
            public void setMonth(Long month) {
                this.month = month;
            }

            @Generated
            public void setYear(Long year) {
                this.year = year;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof IssuedDate)) {
                    return false;
                }
                IssuedDate other = (IssuedDate)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Long this$day = this.getDay();
                Long other$day = other.getDay();
                if (this$day == null ? other$day != null : !((Object)this$day).equals(other$day)) {
                    return false;
                }
                Long this$month = this.getMonth();
                Long other$month = other.getMonth();
                if (this$month == null ? other$month != null : !((Object)this$month).equals(other$month)) {
                    return false;
                }
                Long this$year = this.getYear();
                Long other$year = other.getYear();
                return !(this$year == null ? other$year != null : !((Object)this$year).equals(other$year));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof IssuedDate;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Long $day = this.getDay();
                result = result * 59 + ($day == null ? 43 : ((Object)$day).hashCode());
                Long $month = this.getMonth();
                result = result * 59 + ($month == null ? 43 : ((Object)$month).hashCode());
                Long $year = this.getYear();
                result = result * 59 + ($year == null ? 43 : ((Object)$year).hashCode());
                return result;
            }
        }
    }

    public static class Email
    extends StripeObject {
        @SerializedName(value="email")
        String email;
        @SerializedName(value="error")
        Errors error;
        @SerializedName(value="status")
        String status;

        @Generated
        public String getEmail() {
            return this.email;
        }

        @Generated
        public Errors getError() {
            return this.error;
        }

        @Generated
        public String getStatus() {
            return this.status;
        }

        @Generated
        public void setEmail(String email) {
            this.email = email;
        }

        @Generated
        public void setError(Errors error) {
            this.error = error;
        }

        @Generated
        public void setStatus(String status) {
            this.status = status;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Email)) {
                return false;
            }
            Email other = (Email)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$email = this.getEmail();
            String other$email = other.getEmail();
            if (this$email == null ? other$email != null : !this$email.equals(other$email)) {
                return false;
            }
            Errors this$error = this.getError();
            Errors other$error = other.getError();
            if (this$error == null ? other$error != null : !((Object)this$error).equals(other$error)) {
                return false;
            }
            String this$status = this.getStatus();
            String other$status = other.getStatus();
            return !(this$status == null ? other$status != null : !this$status.equals(other$status));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Email;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $email = this.getEmail();
            result = result * 59 + ($email == null ? 43 : $email.hashCode());
            Errors $error = this.getError();
            result = result * 59 + ($error == null ? 43 : ((Object)$error).hashCode());
            String $status = this.getStatus();
            result = result * 59 + ($status == null ? 43 : $status.hashCode());
            return result;
        }

        public static class Errors
        extends StripeObject {
            @SerializedName(value="code")
            String code;
            @SerializedName(value="reason")
            String reason;

            @Generated
            public String getCode() {
                return this.code;
            }

            @Generated
            public String getReason() {
                return this.reason;
            }

            @Generated
            public void setCode(String code) {
                this.code = code;
            }

            @Generated
            public void setReason(String reason) {
                this.reason = reason;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Errors)) {
                    return false;
                }
                Errors other = (Errors)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$code = this.getCode();
                String other$code = other.getCode();
                if (this$code == null ? other$code != null : !this$code.equals(other$code)) {
                    return false;
                }
                String this$reason = this.getReason();
                String other$reason = other.getReason();
                return !(this$reason == null ? other$reason != null : !this$reason.equals(other$reason));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Errors;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $code = this.getCode();
                result = result * 59 + ($code == null ? 43 : $code.hashCode());
                String $reason = this.getReason();
                result = result * 59 + ($reason == null ? 43 : $reason.hashCode());
                return result;
            }
        }
    }

    public static class IdNumber
    extends StripeObject {
        @SerializedName(value="dob")
        Dob dob;
        @SerializedName(value="error")
        Errors error;
        @SerializedName(value="first_name")
        String firstName;
        @SerializedName(value="id_number")
        String idNumber;
        @SerializedName(value="id_number_type")
        String idNumberType;
        @SerializedName(value="last_name")
        String lastName;
        @SerializedName(value="status")
        String status;

        @Generated
        public Dob getDob() {
            return this.dob;
        }

        @Generated
        public Errors getError() {
            return this.error;
        }

        @Generated
        public String getFirstName() {
            return this.firstName;
        }

        @Generated
        public String getIdNumber() {
            return this.idNumber;
        }

        @Generated
        public String getIdNumberType() {
            return this.idNumberType;
        }

        @Generated
        public String getLastName() {
            return this.lastName;
        }

        @Generated
        public String getStatus() {
            return this.status;
        }

        @Generated
        public void setDob(Dob dob) {
            this.dob = dob;
        }

        @Generated
        public void setError(Errors error) {
            this.error = error;
        }

        @Generated
        public void setFirstName(String firstName) {
            this.firstName = firstName;
        }

        @Generated
        public void setIdNumber(String idNumber) {
            this.idNumber = idNumber;
        }

        @Generated
        public void setIdNumberType(String idNumberType) {
            this.idNumberType = idNumberType;
        }

        @Generated
        public void setLastName(String lastName) {
            this.lastName = lastName;
        }

        @Generated
        public void setStatus(String status) {
            this.status = status;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof IdNumber)) {
                return false;
            }
            IdNumber other = (IdNumber)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Dob this$dob = this.getDob();
            Dob other$dob = other.getDob();
            if (this$dob == null ? other$dob != null : !((Object)this$dob).equals(other$dob)) {
                return false;
            }
            Errors this$error = this.getError();
            Errors other$error = other.getError();
            if (this$error == null ? other$error != null : !((Object)this$error).equals(other$error)) {
                return false;
            }
            String this$firstName = this.getFirstName();
            String other$firstName = other.getFirstName();
            if (this$firstName == null ? other$firstName != null : !this$firstName.equals(other$firstName)) {
                return false;
            }
            String this$idNumber = this.getIdNumber();
            String other$idNumber = other.getIdNumber();
            if (this$idNumber == null ? other$idNumber != null : !this$idNumber.equals(other$idNumber)) {
                return false;
            }
            String this$idNumberType = this.getIdNumberType();
            String other$idNumberType = other.getIdNumberType();
            if (this$idNumberType == null ? other$idNumberType != null : !this$idNumberType.equals(other$idNumberType)) {
                return false;
            }
            String this$lastName = this.getLastName();
            String other$lastName = other.getLastName();
            if (this$lastName == null ? other$lastName != null : !this$lastName.equals(other$lastName)) {
                return false;
            }
            String this$status = this.getStatus();
            String other$status = other.getStatus();
            return !(this$status == null ? other$status != null : !this$status.equals(other$status));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof IdNumber;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Dob $dob = this.getDob();
            result = result * 59 + ($dob == null ? 43 : ((Object)$dob).hashCode());
            Errors $error = this.getError();
            result = result * 59 + ($error == null ? 43 : ((Object)$error).hashCode());
            String $firstName = this.getFirstName();
            result = result * 59 + ($firstName == null ? 43 : $firstName.hashCode());
            String $idNumber = this.getIdNumber();
            result = result * 59 + ($idNumber == null ? 43 : $idNumber.hashCode());
            String $idNumberType = this.getIdNumberType();
            result = result * 59 + ($idNumberType == null ? 43 : $idNumberType.hashCode());
            String $lastName = this.getLastName();
            result = result * 59 + ($lastName == null ? 43 : $lastName.hashCode());
            String $status = this.getStatus();
            result = result * 59 + ($status == null ? 43 : $status.hashCode());
            return result;
        }

        public static class Dob
        extends StripeObject {
            @SerializedName(value="day")
            Long day;
            @SerializedName(value="month")
            Long month;
            @SerializedName(value="year")
            Long year;

            @Generated
            public Long getDay() {
                return this.day;
            }

            @Generated
            public Long getMonth() {
                return this.month;
            }

            @Generated
            public Long getYear() {
                return this.year;
            }

            @Generated
            public void setDay(Long day) {
                this.day = day;
            }

            @Generated
            public void setMonth(Long month) {
                this.month = month;
            }

            @Generated
            public void setYear(Long year) {
                this.year = year;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Dob)) {
                    return false;
                }
                Dob other = (Dob)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Long this$day = this.getDay();
                Long other$day = other.getDay();
                if (this$day == null ? other$day != null : !((Object)this$day).equals(other$day)) {
                    return false;
                }
                Long this$month = this.getMonth();
                Long other$month = other.getMonth();
                if (this$month == null ? other$month != null : !((Object)this$month).equals(other$month)) {
                    return false;
                }
                Long this$year = this.getYear();
                Long other$year = other.getYear();
                return !(this$year == null ? other$year != null : !((Object)this$year).equals(other$year));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Dob;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Long $day = this.getDay();
                result = result * 59 + ($day == null ? 43 : ((Object)$day).hashCode());
                Long $month = this.getMonth();
                result = result * 59 + ($month == null ? 43 : ((Object)$month).hashCode());
                Long $year = this.getYear();
                result = result * 59 + ($year == null ? 43 : ((Object)$year).hashCode());
                return result;
            }
        }

        public static class Errors
        extends StripeObject {
            @SerializedName(value="code")
            String code;
            @SerializedName(value="reason")
            String reason;

            @Generated
            public String getCode() {
                return this.code;
            }

            @Generated
            public String getReason() {
                return this.reason;
            }

            @Generated
            public void setCode(String code) {
                this.code = code;
            }

            @Generated
            public void setReason(String reason) {
                this.reason = reason;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Errors)) {
                    return false;
                }
                Errors other = (Errors)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$code = this.getCode();
                String other$code = other.getCode();
                if (this$code == null ? other$code != null : !this$code.equals(other$code)) {
                    return false;
                }
                String this$reason = this.getReason();
                String other$reason = other.getReason();
                return !(this$reason == null ? other$reason != null : !this$reason.equals(other$reason));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Errors;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $code = this.getCode();
                result = result * 59 + ($code == null ? 43 : $code.hashCode());
                String $reason = this.getReason();
                result = result * 59 + ($reason == null ? 43 : $reason.hashCode());
                return result;
            }
        }
    }

    public static class Options
    extends StripeObject {
        @SerializedName(value="document")
        Document document;
        @SerializedName(value="id_number")
        IdNumber idNumber;

        @Generated
        public Document getDocument() {
            return this.document;
        }

        @Generated
        public IdNumber getIdNumber() {
            return this.idNumber;
        }

        @Generated
        public void setDocument(Document document) {
            this.document = document;
        }

        @Generated
        public void setIdNumber(IdNumber idNumber) {
            this.idNumber = idNumber;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Options)) {
                return false;
            }
            Options other = (Options)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Document this$document = this.getDocument();
            Document other$document = other.getDocument();
            if (this$document == null ? other$document != null : !((Object)this$document).equals(other$document)) {
                return false;
            }
            IdNumber this$idNumber = this.getIdNumber();
            IdNumber other$idNumber = other.getIdNumber();
            return !(this$idNumber == null ? other$idNumber != null : !((Object)this$idNumber).equals(other$idNumber));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Options;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Document $document = this.getDocument();
            result = result * 59 + ($document == null ? 43 : ((Object)$document).hashCode());
            IdNumber $idNumber = this.getIdNumber();
            result = result * 59 + ($idNumber == null ? 43 : ((Object)$idNumber).hashCode());
            return result;
        }

        public static class Document
        extends StripeObject {
            @SerializedName(value="allowed_types")
            List<String> allowedTypes;
            @SerializedName(value="require_id_number")
            Boolean requireIdNumber;
            @SerializedName(value="require_live_capture")
            Boolean requireLiveCapture;
            @SerializedName(value="require_matching_selfie")
            Boolean requireMatchingSelfie;

            @Generated
            public List<String> getAllowedTypes() {
                return this.allowedTypes;
            }

            @Generated
            public Boolean getRequireIdNumber() {
                return this.requireIdNumber;
            }

            @Generated
            public Boolean getRequireLiveCapture() {
                return this.requireLiveCapture;
            }

            @Generated
            public Boolean getRequireMatchingSelfie() {
                return this.requireMatchingSelfie;
            }

            @Generated
            public void setAllowedTypes(List<String> allowedTypes) {
                this.allowedTypes = allowedTypes;
            }

            @Generated
            public void setRequireIdNumber(Boolean requireIdNumber) {
                this.requireIdNumber = requireIdNumber;
            }

            @Generated
            public void setRequireLiveCapture(Boolean requireLiveCapture) {
                this.requireLiveCapture = requireLiveCapture;
            }

            @Generated
            public void setRequireMatchingSelfie(Boolean requireMatchingSelfie) {
                this.requireMatchingSelfie = requireMatchingSelfie;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Document)) {
                    return false;
                }
                Document other = (Document)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Boolean this$requireIdNumber = this.getRequireIdNumber();
                Boolean other$requireIdNumber = other.getRequireIdNumber();
                if (this$requireIdNumber == null ? other$requireIdNumber != null : !((Object)this$requireIdNumber).equals(other$requireIdNumber)) {
                    return false;
                }
                Boolean this$requireLiveCapture = this.getRequireLiveCapture();
                Boolean other$requireLiveCapture = other.getRequireLiveCapture();
                if (this$requireLiveCapture == null ? other$requireLiveCapture != null : !((Object)this$requireLiveCapture).equals(other$requireLiveCapture)) {
                    return false;
                }
                Boolean this$requireMatchingSelfie = this.getRequireMatchingSelfie();
                Boolean other$requireMatchingSelfie = other.getRequireMatchingSelfie();
                if (this$requireMatchingSelfie == null ? other$requireMatchingSelfie != null : !((Object)this$requireMatchingSelfie).equals(other$requireMatchingSelfie)) {
                    return false;
                }
                List<String> this$allowedTypes = this.getAllowedTypes();
                List<String> other$allowedTypes = other.getAllowedTypes();
                return !(this$allowedTypes == null ? other$allowedTypes != null : !((Object)this$allowedTypes).equals(other$allowedTypes));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Document;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Boolean $requireIdNumber = this.getRequireIdNumber();
                result = result * 59 + ($requireIdNumber == null ? 43 : ((Object)$requireIdNumber).hashCode());
                Boolean $requireLiveCapture = this.getRequireLiveCapture();
                result = result * 59 + ($requireLiveCapture == null ? 43 : ((Object)$requireLiveCapture).hashCode());
                Boolean $requireMatchingSelfie = this.getRequireMatchingSelfie();
                result = result * 59 + ($requireMatchingSelfie == null ? 43 : ((Object)$requireMatchingSelfie).hashCode());
                List<String> $allowedTypes = this.getAllowedTypes();
                result = result * 59 + ($allowedTypes == null ? 43 : ((Object)$allowedTypes).hashCode());
                return result;
            }
        }

        public static class IdNumber
        extends StripeObject {
            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof IdNumber)) {
                    return false;
                }
                IdNumber other = (IdNumber)o;
                return other.canEqual(this);
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof IdNumber;
            }

            @Generated
            public int hashCode() {
                boolean result = true;
                return 1;
            }
        }
    }

    public static class Phone
    extends StripeObject {
        @SerializedName(value="error")
        Errors error;
        @SerializedName(value="phone")
        String phone;
        @SerializedName(value="status")
        String status;

        @Generated
        public Errors getError() {
            return this.error;
        }

        @Generated
        public String getPhone() {
            return this.phone;
        }

        @Generated
        public String getStatus() {
            return this.status;
        }

        @Generated
        public void setError(Errors error) {
            this.error = error;
        }

        @Generated
        public void setPhone(String phone) {
            this.phone = phone;
        }

        @Generated
        public void setStatus(String status) {
            this.status = status;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Phone)) {
                return false;
            }
            Phone other = (Phone)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Errors this$error = this.getError();
            Errors other$error = other.getError();
            if (this$error == null ? other$error != null : !((Object)this$error).equals(other$error)) {
                return false;
            }
            String this$phone = this.getPhone();
            String other$phone = other.getPhone();
            if (this$phone == null ? other$phone != null : !this$phone.equals(other$phone)) {
                return false;
            }
            String this$status = this.getStatus();
            String other$status = other.getStatus();
            return !(this$status == null ? other$status != null : !this$status.equals(other$status));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Phone;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Errors $error = this.getError();
            result = result * 59 + ($error == null ? 43 : ((Object)$error).hashCode());
            String $phone = this.getPhone();
            result = result * 59 + ($phone == null ? 43 : $phone.hashCode());
            String $status = this.getStatus();
            result = result * 59 + ($status == null ? 43 : $status.hashCode());
            return result;
        }

        public static class Errors
        extends StripeObject {
            @SerializedName(value="code")
            String code;
            @SerializedName(value="reason")
            String reason;

            @Generated
            public String getCode() {
                return this.code;
            }

            @Generated
            public String getReason() {
                return this.reason;
            }

            @Generated
            public void setCode(String code) {
                this.code = code;
            }

            @Generated
            public void setReason(String reason) {
                this.reason = reason;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Errors)) {
                    return false;
                }
                Errors other = (Errors)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$code = this.getCode();
                String other$code = other.getCode();
                if (this$code == null ? other$code != null : !this$code.equals(other$code)) {
                    return false;
                }
                String this$reason = this.getReason();
                String other$reason = other.getReason();
                return !(this$reason == null ? other$reason != null : !this$reason.equals(other$reason));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Errors;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $code = this.getCode();
                result = result * 59 + ($code == null ? 43 : $code.hashCode());
                String $reason = this.getReason();
                result = result * 59 + ($reason == null ? 43 : $reason.hashCode());
                return result;
            }
        }
    }

    public static class Selfie
    extends StripeObject {
        @SerializedName(value="document")
        String document;
        @SerializedName(value="error")
        Errors error;
        @SerializedName(value="selfie")
        String selfie;
        @SerializedName(value="status")
        String status;

        @Generated
        public String getDocument() {
            return this.document;
        }

        @Generated
        public Errors getError() {
            return this.error;
        }

        @Generated
        public String getSelfie() {
            return this.selfie;
        }

        @Generated
        public String getStatus() {
            return this.status;
        }

        @Generated
        public void setDocument(String document) {
            this.document = document;
        }

        @Generated
        public void setError(Errors error) {
            this.error = error;
        }

        @Generated
        public void setSelfie(String selfie) {
            this.selfie = selfie;
        }

        @Generated
        public void setStatus(String status) {
            this.status = status;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Selfie)) {
                return false;
            }
            Selfie other = (Selfie)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$document = this.getDocument();
            String other$document = other.getDocument();
            if (this$document == null ? other$document != null : !this$document.equals(other$document)) {
                return false;
            }
            Errors this$error = this.getError();
            Errors other$error = other.getError();
            if (this$error == null ? other$error != null : !((Object)this$error).equals(other$error)) {
                return false;
            }
            String this$selfie = this.getSelfie();
            String other$selfie = other.getSelfie();
            if (this$selfie == null ? other$selfie != null : !this$selfie.equals(other$selfie)) {
                return false;
            }
            String this$status = this.getStatus();
            String other$status = other.getStatus();
            return !(this$status == null ? other$status != null : !this$status.equals(other$status));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Selfie;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $document = this.getDocument();
            result = result * 59 + ($document == null ? 43 : $document.hashCode());
            Errors $error = this.getError();
            result = result * 59 + ($error == null ? 43 : ((Object)$error).hashCode());
            String $selfie = this.getSelfie();
            result = result * 59 + ($selfie == null ? 43 : $selfie.hashCode());
            String $status = this.getStatus();
            result = result * 59 + ($status == null ? 43 : $status.hashCode());
            return result;
        }

        public static class Errors
        extends StripeObject {
            @SerializedName(value="code")
            String code;
            @SerializedName(value="reason")
            String reason;

            @Generated
            public String getCode() {
                return this.code;
            }

            @Generated
            public String getReason() {
                return this.reason;
            }

            @Generated
            public void setCode(String code) {
                this.code = code;
            }

            @Generated
            public void setReason(String reason) {
                this.reason = reason;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Errors)) {
                    return false;
                }
                Errors other = (Errors)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$code = this.getCode();
                String other$code = other.getCode();
                if (this$code == null ? other$code != null : !this$code.equals(other$code)) {
                    return false;
                }
                String this$reason = this.getReason();
                String other$reason = other.getReason();
                return !(this$reason == null ? other$reason != null : !this$reason.equals(other$reason));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Errors;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $code = this.getCode();
                result = result * 59 + ($code == null ? 43 : $code.hashCode());
                String $reason = this.getReason();
                result = result * 59 + ($reason == null ? 43 : $reason.hashCode());
                return result;
            }
        }
    }
}

