/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.net;

import com.stripe.Stripe;
import com.stripe.exception.AuthenticationException;
import com.stripe.exception.InvalidRequestException;
import com.stripe.exception.StripeException;
import com.stripe.model.oauth.DeauthorizedAccount;
import com.stripe.model.oauth.TokenResponse;
import com.stripe.net.ApiRequest;
import com.stripe.net.ApiResource;
import com.stripe.net.BaseAddress;
import com.stripe.net.FormEncoder;
import com.stripe.net.LiveStripeResponseGetter;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;

public final class OAuth {
    private static StripeResponseGetter globalResponseGetter = new LiveStripeResponseGetter();

    public static void setGlobalResponseGetter(StripeResponseGetter srg) {
        globalResponseGetter = srg;
    }

    public static String authorizeUrl(Map<String, Object> params, RequestOptions options) throws AuthenticationException, InvalidRequestException {
        String base = Stripe.getConnectBase();
        params.put("client_id", OAuth.getClientId(params, options));
        if (params.get("response_type") == null) {
            params.put("response_type", "code");
        }
        String query = FormEncoder.createQueryString(params);
        String url = base + "/oauth/authorize?" + query;
        return url;
    }

    public static TokenResponse token(Map<String, Object> params, RequestOptions options) throws StripeException {
        ApiRequest request = new ApiRequest(BaseAddress.CONNECT, ApiResource.RequestMethod.POST, "/oauth/token", params, options);
        return (TokenResponse)globalResponseGetter.request(request, (Type)((Object)TokenResponse.class));
    }

    public static DeauthorizedAccount deauthorize(Map<String, Object> params, RequestOptions options) throws StripeException {
        HashMap<String, Object> paramsCopy = new HashMap<String, Object>();
        paramsCopy.putAll(params);
        paramsCopy.put("client_id", OAuth.getClientId(paramsCopy, options));
        ApiRequest request = new ApiRequest(BaseAddress.CONNECT, ApiResource.RequestMethod.POST, "/oauth/deauthorize", paramsCopy, options);
        return (DeauthorizedAccount)globalResponseGetter.request(request, (Type)((Object)DeauthorizedAccount.class));
    }

    private static String getClientId(Map<String, Object> params, RequestOptions options) throws AuthenticationException {
        String clientId = Stripe.clientId;
        if (options != null && options.getClientId() != null) {
            clientId = options.getClientId();
        }
        if (params != null && params.get("client_id") != null) {
            clientId = (String)params.get("client_id");
        }
        if (clientId == null) {
            throw new AuthenticationException("No client_id provided. (HINT: set client_id key using 'Stripe.clientId = <CLIENT-ID>'. You can find your client_ids in your Stripe dashboard at https://dashboard.stripe.com/account/applications/settings, after registering your account as a platform. See https://stripe.com/docs/connect/standard-accounts for details, or email support@stripe.com if you have any questions.", null, null, 0);
        }
        return clientId;
    }
}

