/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.service.issuing;

import com.google.gson.reflect.TypeToken;
import com.stripe.exception.StripeException;
import com.stripe.model.StripeCollection;
import com.stripe.model.issuing.Dispute;
import com.stripe.net.ApiRequest;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.ApiService;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.issuing.DisputeCreateParams;
import com.stripe.param.issuing.DisputeListParams;
import com.stripe.param.issuing.DisputeRetrieveParams;
import com.stripe.param.issuing.DisputeSubmitParams;
import com.stripe.param.issuing.DisputeUpdateParams;
import java.lang.reflect.Type;

public final class DisputeService
extends ApiService {
    public DisputeService(StripeResponseGetter responseGetter) {
        super(responseGetter);
    }

    public StripeCollection<Dispute> list(DisputeListParams params) throws StripeException {
        return this.list(params, null);
    }

    public StripeCollection<Dispute> list(RequestOptions options) throws StripeException {
        return this.list(null, options);
    }

    public StripeCollection<Dispute> list() throws StripeException {
        return this.list(null, null);
    }

    public StripeCollection<Dispute> list(DisputeListParams params, RequestOptions options) throws StripeException {
        String path = "/v1/issuing/disputes";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options);
        return (StripeCollection)this.request(request, new TypeToken<StripeCollection<Dispute>>(){}.getType());
    }

    public Dispute create(DisputeCreateParams params) throws StripeException {
        return this.create(params, null);
    }

    public Dispute create(RequestOptions options) throws StripeException {
        return this.create(null, options);
    }

    public Dispute create() throws StripeException {
        return this.create(null, null);
    }

    public Dispute create(DisputeCreateParams params, RequestOptions options) throws StripeException {
        String path = "/v1/issuing/disputes";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options);
        return (Dispute)this.request(request, (Type)((Object)Dispute.class));
    }

    public Dispute retrieve(String dispute, DisputeRetrieveParams params) throws StripeException {
        return this.retrieve(dispute, params, null);
    }

    public Dispute retrieve(String dispute, RequestOptions options) throws StripeException {
        return this.retrieve(dispute, null, options);
    }

    public Dispute retrieve(String dispute) throws StripeException {
        return this.retrieve(dispute, null, null);
    }

    public Dispute retrieve(String dispute, DisputeRetrieveParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/issuing/disputes/%s", ApiResource.urlEncodeId(dispute));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options);
        return (Dispute)this.request(request, (Type)((Object)Dispute.class));
    }

    public Dispute update(String dispute, DisputeUpdateParams params) throws StripeException {
        return this.update(dispute, params, null);
    }

    public Dispute update(String dispute, RequestOptions options) throws StripeException {
        return this.update(dispute, null, options);
    }

    public Dispute update(String dispute) throws StripeException {
        return this.update(dispute, null, null);
    }

    public Dispute update(String dispute, DisputeUpdateParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/issuing/disputes/%s", ApiResource.urlEncodeId(dispute));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options);
        return (Dispute)this.request(request, (Type)((Object)Dispute.class));
    }

    public Dispute submit(String dispute, DisputeSubmitParams params) throws StripeException {
        return this.submit(dispute, params, null);
    }

    public Dispute submit(String dispute, RequestOptions options) throws StripeException {
        return this.submit(dispute, null, options);
    }

    public Dispute submit(String dispute) throws StripeException {
        return this.submit(dispute, null, null);
    }

    public Dispute submit(String dispute, DisputeSubmitParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/issuing/disputes/%s/submit", ApiResource.urlEncodeId(dispute));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options);
        return (Dispute)this.request(request, (Type)((Object)Dispute.class));
    }
}

