/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.service.tax;

import com.stripe.exception.StripeException;
import com.stripe.model.tax.Calculation;
import com.stripe.net.ApiRequest;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.ApiService;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.tax.CalculationCreateParams;
import com.stripe.param.tax.CalculationRetrieveParams;
import com.stripe.service.tax.CalculationLineItemService;
import java.lang.reflect.Type;

public final class CalculationService
extends ApiService {
    public CalculationService(StripeResponseGetter responseGetter) {
        super(responseGetter);
    }

    public Calculation retrieve(String calculation, CalculationRetrieveParams params) throws StripeException {
        return this.retrieve(calculation, params, null);
    }

    public Calculation retrieve(String calculation, RequestOptions options) throws StripeException {
        return this.retrieve(calculation, null, options);
    }

    public Calculation retrieve(String calculation) throws StripeException {
        return this.retrieve(calculation, null, null);
    }

    public Calculation retrieve(String calculation, CalculationRetrieveParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/tax/calculations/%s", ApiResource.urlEncodeId(calculation));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options);
        return (Calculation)this.request(request, (Type)((Object)Calculation.class));
    }

    public Calculation create(CalculationCreateParams params) throws StripeException {
        return this.create(params, null);
    }

    public Calculation create(CalculationCreateParams params, RequestOptions options) throws StripeException {
        String path = "/v1/tax/calculations";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options);
        return (Calculation)this.request(request, (Type)((Object)Calculation.class));
    }

    public CalculationLineItemService lineItems() {
        return new CalculationLineItemService(this.getResponseGetter());
    }
}

