/*
 * Decompiled with CFR 0.152.
 */
package com.swift.sandhook.xposedcompat.utils;

import android.os.Build;
import android.text.TextUtils;
import com.swift.sandhook.xposedcompat.utils.DexLog;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;

public class FileUtils {
    public static final boolean IS_USING_PROTECTED_STORAGE = Build.VERSION.SDK_INT >= 24;

    public static void delete(File file) throws IOException {
        for (File childFile : file.listFiles()) {
            if (childFile.isDirectory()) {
                FileUtils.delete(childFile);
                continue;
            }
            if (childFile.delete()) continue;
            throw new IOException();
        }
        if (!file.delete()) {
            throw new IOException();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String readLine(File file) {
        try (BufferedReader reader = new BufferedReader(new FileReader(file));){
            String string = reader.readLine();
            return string;
        }
        catch (Throwable throwable6) {
            return "";
        }
    }

    public static void writeLine(File file, String line) {
        try {
            file.createNewFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(file));){
            writer.write(line);
            writer.flush();
        }
        catch (Throwable throwable) {
            DexLog.e("error writing line to file " + file + ": " + throwable.getMessage());
        }
    }

    public static String getPackageName(String dataDir) {
        if (TextUtils.isEmpty((CharSequence)dataDir)) {
            DexLog.e("getPackageName using empty dataDir");
            return "";
        }
        int lastIndex = dataDir.lastIndexOf("/");
        if (lastIndex < 0) {
            return dataDir;
        }
        return dataDir.substring(lastIndex + 1);
    }

    public static String getDataPathPrefix() {
        return IS_USING_PROTECTED_STORAGE ? "/data/user_de/0/" : "/data/data/";
    }
}

