/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.accs;

import android.content.Context;
import android.text.TextUtils;
import anet.channel.GlobalAppRuntimeInfo;
import anet.channel.SessionCenter;
import anet.channel.entity.ENV;
import anet.channel.util.ALog;
import com.alibaba.sdk.android.error.ErrorCode;
import com.alibaba.sdk.android.logger.ILog;
import com.taobao.accs.ACCSManager;
import com.taobao.accs.AccsClientConfig;
import com.taobao.accs.AccsException;
import com.taobao.accs.AccsState;
import com.taobao.accs.ChannelService;
import com.taobao.accs.EventReceiver;
import com.taobao.accs.IACCSManager;
import com.taobao.accs.IAppReceiver;
import com.taobao.accs.ILoginInfo;
import com.taobao.accs.ServiceReceiver;
import com.taobao.accs.a;
import com.taobao.accs.base.AccsAbstractDataListener;
import com.taobao.accs.base.TaoBaseService;
import com.taobao.accs.client.GlobalClientInfo;
import com.taobao.accs.internal.AccsJobService;
import com.taobao.accs.utl.AccsLogger;
import com.taobao.accs.utl.AdapterUtilityImpl;
import com.taobao.accs.utl.UtilityImpl;
import com.taobao.accs.utl.Utils;
import com.taobao.accs.utl.i;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ACCSClient {
    protected IACCSManager mAccsManager;
    private static ILog defaultLog = AccsLogger.getLogger("ACCSClient");
    private ILog log;
    private static Context mContext;
    private AccsClientConfig mConfig;
    public static Map<String, ACCSClient> mACCSClients;

    public ACCSClient(AccsClientConfig accsClientConfig) {
        this.mConfig = accsClientConfig;
        this.log = AccsLogger.getLogger("ACCSClient" + accsClientConfig.getTag());
        this.mAccsManager = ACCSManager.getAccsInstance(mContext, accsClientConfig.getAppKey(), accsClientConfig.getTag());
    }

    public static void changeNetworkSdkLoggerToAccs() {
        defaultLog.d("changeNetworkSdkLoggerToAccs");
        ALog.setLog((ALog.ILog)new i());
    }

    public static synchronized String init(Context context, AccsClientConfig accsClientConfig) throws AccsException {
        if (context == null || accsClientConfig == null) {
            defaultLog.err("init AccsClient params error").arg("context", (Object)context).arg("config", (Object)accsClientConfig).done();
            throw new AccsException("init AccsClient params error");
        }
        GlobalClientInfo.getInstance(context);
        mContext = context.getApplicationContext();
        ACCSClient.setCurrentProcessName(context);
        defaultLog.debug("init").arg("config", (Object)accsClientConfig).done();
        AccsState.getInstance().a("sv", (Object)"4.5.0-emas");
        return accsClientConfig.getTag();
    }

    public static synchronized ACCSClient getAccsClient(String string) throws AccsException {
        AccsClientConfig accsClientConfig;
        if (TextUtils.isEmpty((CharSequence)string)) {
            string = "default";
            defaultLog.w("getAccsClient with null tag, use default");
        }
        if ((accsClientConfig = AccsClientConfig.getConfigByTag(string)) == null) {
            defaultLog.err("getAccsClient with null config, please init config first").arg("configTag", (Object)string).done();
            throw new AccsException("configTag not exist");
        }
        ACCSClient aCCSClient = mACCSClients.get(string);
        if (aCCSClient == null) {
            defaultLog.d("getAccsClient create client");
            aCCSClient = new ACCSClient(accsClientConfig);
            mACCSClients.put(string, aCCSClient);
            aCCSClient.updateConfig(accsClientConfig);
            return aCCSClient;
        }
        if (!accsClientConfig.equals(aCCSClient.mConfig)) {
            defaultLog.warn("getAccsClient update config").arg("old", (Object)aCCSClient.mConfig).arg("new", (Object)accsClientConfig).done();
            aCCSClient.updateConfig(accsClientConfig);
        }
        return aCCSClient;
    }

    public static void enableChannelProcess(Context context, boolean bl) {
        UtilityImpl.a(context, bl);
        if (bl) {
            try {
                UtilityImpl.a(context, ChannelService.class.getName());
            }
            catch (Throwable throwable) {}
            try {
                UtilityImpl.a(context, ChannelService.KernelService.class.getName());
            }
            catch (Throwable throwable) {}
            try {
                UtilityImpl.a(context, EventReceiver.class.getName());
            }
            catch (Throwable throwable) {}
            try {
                UtilityImpl.a(context, ServiceReceiver.class.getName());
            }
            catch (Throwable throwable) {}
            try {
                UtilityImpl.a(context, AccsJobService.class.getName());
            }
            catch (Throwable throwable) {}
        } else {
            try {
                UtilityImpl.b(context, ChannelService.class.getName());
            }
            catch (Throwable throwable) {}
            try {
                UtilityImpl.b(context, ChannelService.KernelService.class.getName());
            }
            catch (Throwable throwable) {}
            try {
                UtilityImpl.b(context, EventReceiver.class.getName());
            }
            catch (Throwable throwable) {}
            try {
                UtilityImpl.b(context, ServiceReceiver.class.getName());
            }
            catch (Throwable throwable) {}
            try {
                UtilityImpl.b(context, AccsJobService.class.getName());
            }
            catch (Throwable throwable) {}
        }
    }

    public static void setCurrentProcessName(Context context) {
        try {
            GlobalAppRuntimeInfo.setCurrentProcess((String)AdapterUtilityImpl.getProcessName(context.getApplicationContext()));
        }
        catch (Throwable throwable) {
            defaultLog.e("setCurrentProcess", throwable);
        }
    }

    private void updateConfig(AccsClientConfig accsClientConfig) {
        this.mConfig = accsClientConfig;
        this.mAccsManager = ACCSManager.getAccsInstance(mContext, accsClientConfig.getAppKey(), accsClientConfig.getTag());
        if (this.mAccsManager != null) {
            this.mAccsManager.updateConfig(accsClientConfig);
        }
    }

    public static synchronized void setEnvironment(Context context, @AccsClientConfig.ENV int n2) {
        int n3 = n2;
        try {
            if (n2 < 0 || n2 > 2) {
                defaultLog.warn("env invalid, reset to release").arg("env", (Object)n2).done();
                n3 = 0;
            }
            int n4 = AccsClientConfig.mEnv;
            AccsClientConfig.mEnv = n3;
            if (n4 != n3 && Utils.isMainProcess(context)) {
                defaultLog.info("setEnvironment").arg("pre", (Object)n4).arg("to", (Object)n3).done();
                Utils.clearAllSharePreferences(context);
                Utils.clearAgooBindCache(context);
                Utils.killService(context);
                if (n3 == 2) {
                    SessionCenter.switchEnvironment((ENV)ENV.TEST);
                } else if (n3 == 1) {
                    SessionCenter.switchEnvironment((ENV)ENV.PREPARE);
                }
                for (Map.Entry<String, ACCSClient> entry : mACCSClients.entrySet()) {
                    try {
                        ACCSClient.getAccsClient(entry.getKey());
                    }
                    catch (AccsException accsException) {
                        defaultLog.e("setEnvironment update client", (Throwable)accsException);
                    }
                }
            }
        }
        catch (Throwable throwable) {
            defaultLog.e("setEnvironment", throwable);
        }
        finally {
            Utils.setMode(context, n3);
        }
    }

    public void bindApp(String string, IAppReceiver iAppReceiver) {
        if (this.mAccsManager == null) {
            this.log.e("bindApp mAccsManager null");
            ErrorCode errorCode = a.ERROR_SHOULD_NEVER_HAPPEN.copy().detail("bindApp accs is null").build();
            iAppReceiver.onBindApp(errorCode.getCodeInt());
            return;
        }
        this.mAccsManager.bindApp(mContext, this.mConfig.getAppKey(), this.mConfig.getAppSecret(), string, iAppReceiver);
    }

    public void cleanLocalBindInfo() {
        if (this.mAccsManager == null) {
            this.log.e("cleanLocalBindInfo mAccsManager null");
            return;
        }
        this.mAccsManager.cleanLocalBindInfo();
    }

    public void bindUser(String string) {
        if (this.mAccsManager == null) {
            this.log.e("bindUser mAccsManager null");
            return;
        }
        this.mAccsManager.bindUser(mContext, string);
    }

    public void bindUser(String string, boolean bl) {
        if (this.mAccsManager == null) {
            this.log.e("bindUser mAccsManager null");
            return;
        }
        this.mAccsManager.bindUser(mContext, string, bl);
    }

    public void unbindUser() {
        if (this.mAccsManager == null) {
            this.log.e("unbindUser mAccsManager null");
            return;
        }
        this.mAccsManager.unbindUser(mContext);
    }

    public void bindService(String string) {
        if (this.mAccsManager == null) {
            this.log.e("bindService mAccsManager null");
            return;
        }
        this.mAccsManager.bindService(mContext, string);
    }

    public void unbindService(String string) {
        if (this.mAccsManager == null) {
            this.log.e("unbindService mAccsManager null");
            return;
        }
        this.mAccsManager.unbindService(mContext, string);
    }

    public String sendData(ACCSManager.AccsRequest accsRequest) {
        if (this.mAccsManager == null) {
            this.log.e("sendData mAccsManager null");
            return null;
        }
        return this.mAccsManager.sendData(mContext, accsRequest);
    }

    public String sendRequest(ACCSManager.AccsRequest accsRequest) {
        if (this.mAccsManager == null) {
            this.log.e("sendRequest mAccsManager null");
            return null;
        }
        return this.mAccsManager.sendRequest(mContext, accsRequest);
    }

    public String sendPushResponse(ACCSManager.AccsRequest accsRequest, TaoBaseService.ExtraInfo extraInfo) {
        if (this.mAccsManager == null) {
            this.log.e("sendPushResponse mAccsManager null");
            return null;
        }
        return this.mAccsManager.sendPushResponse(mContext, accsRequest, extraInfo);
    }

    public boolean isNetworkReachable() {
        if (this.mAccsManager == null) {
            this.log.e("isNetworkReachable mAccsManager null");
            return false;
        }
        return this.mAccsManager.isNetworkReachable(mContext);
    }

    public void startInAppConnection(String string, IAppReceiver iAppReceiver) {
        if (this.mAccsManager == null) {
            this.log.e("startInAppConnection mAccsManager null");
            return;
        }
        this.mAccsManager.startInAppConnection(mContext, this.mConfig.getAppKey(), this.mConfig.getAppSecret(), string, iAppReceiver);
    }

    public void setLoginInfo(ILoginInfo iLoginInfo) {
        if (this.mAccsManager == null) {
            this.log.e("setLoginInfo mAccsManager null");
            return;
        }
        this.mAccsManager.setLoginInfo(mContext, iLoginInfo);
    }

    public void clearLoginInfo() {
        if (this.mAccsManager == null) {
            this.log.e("clearLoginInfo mAccsManager null");
            return;
        }
        this.mAccsManager.clearLoginInfo(mContext);
    }

    public boolean cancel(String string) {
        if (this.mAccsManager == null) {
            this.log.e("cancel mAccsManager null");
            return false;
        }
        return this.mAccsManager.cancel(mContext, string);
    }

    public boolean isChannelError(int n2) {
        if (this.mAccsManager == null) {
            this.log.e("isChannelError mAccsManager null");
            return true;
        }
        return this.mAccsManager.isChannelError(n2);
    }

    public Map<String, Boolean> getChannelState() throws Exception {
        if (this.mAccsManager == null) {
            this.log.e("getChannelState mAccsManager null");
            return null;
        }
        return this.mAccsManager.getChannelState();
    }

    public Map<String, Boolean> forceReConnectChannel() throws Exception {
        if (this.mAccsManager == null) {
            this.log.e("forceReConnectChannel mAccsManager null");
            return null;
        }
        return this.mAccsManager.forceReConnectChannel();
    }

    public void registerSerivce(String string, String string2) {
        if (this.mAccsManager == null) {
            this.log.e("registerSerivce mAccsManager null");
            return;
        }
        this.mAccsManager.registerSerivce(mContext, string, string2);
    }

    public void unRegisterSerivce(String string) {
        if (this.mAccsManager == null) {
            this.log.e("unRegisterSerivce mAccsManager null");
            return;
        }
        this.mAccsManager.unRegisterSerivce(mContext, string);
    }

    public void registerDataListener(String string, AccsAbstractDataListener accsAbstractDataListener) {
        if (this.mAccsManager == null) {
            this.log.e("registerDataListener mAccsManager null");
            return;
        }
        this.mAccsManager.registerDataListener(mContext, string, accsAbstractDataListener);
    }

    public void unRegisterDataListener(String string) {
        if (this.mAccsManager == null) {
            this.log.e("unRegisterDataListener mAccsManager null");
            return;
        }
        this.mAccsManager.unRegisterDataListener(mContext, string);
    }

    public void sendBusinessAck(String string, String string2, String string3, short s2, String string4, Map<Integer, String> map) {
        if (this.mAccsManager == null) {
            this.log.e("sendBusinessAck mAccsManager null");
            return;
        }
        this.mAccsManager.sendBusinessAck(string, string2, string3, s2, string4, map);
    }

    static {
        mACCSClients = new ConcurrentHashMap<String, ACCSClient>(2);
    }
}

