/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.accs;

import android.content.Context;
import android.text.TextUtils;
import com.alibaba.sdk.android.logger.ILog;
import com.taobao.accs.AccsException;
import com.taobao.accs.utl.AccsLogger;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class AccsClientConfig {
    private static ILog log = AccsLogger.getLogger("AccsClientConfig");
    public static final int SECURITY_TAOBAO = 0;
    public static final int SECURITY_OPEN = 1;
    public static final int SECURITY_OFF = 2;
    public static final String DEFAULT_CONFIGTAG = "default";
    public static final String[] DEFAULT_CENTER_HOSTS = new String[]{"msgacs.m.taobao.com", "msgacs.wapa.taobao.com", "msgacs.waptest.taobao.com"};
    private static final String[] DEFAULT_CHANNEL_HOSTS = new String[]{"accscdn.m.taobao.com", "acs.wapa.taobao.com", "acs.waptest.taobao.com"};
    private static Context mContext;
    @Deprecated
    public static boolean loadedStaticConfig;
    @ENV
    public static int mEnv;
    private static Map<String, AccsClientConfig> mReleaseConfigs;
    private static Map<String, AccsClientConfig> mPreviewConfigs;
    private static Map<String, AccsClientConfig> mDebugConfigs;
    private String mAppKey;
    private String mAppSecret;
    private String mInappHost;
    private String mChannelHost;
    private String mStoreId;
    private int mSecurity;
    private String mAuthCode;
    private int mInappPubKey;
    private int mChannelPubKey;
    private boolean mKeepalive;
    private boolean mAutoUnit;
    private String mTag;
    private int mConfigEnv;
    private boolean mDisableChannel;
    private boolean mQuickReconnect;
    private boolean mAccsHeartbeatEnable;
    private boolean mChannelLoopStart;
    private long loopInterval;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Context getContext() {
        if (mContext != null) {
            return mContext;
        }
        Class<AccsClientConfig> clazz = AccsClientConfig.class;
        synchronized (AccsClientConfig.class) {
            if (mContext != null) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return mContext;
            }
            try {
                Class<?> clazz2 = Class.forName("android.app.ActivityThread");
                Object object = clazz2.getMethod("currentActivityThread", new Class[0]).invoke(clazz2, new Object[0]);
                mContext = (Context)object.getClass().getMethod("getApplication", new Class[0]).invoke(object, new Object[0]);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            return mContext;
        }
    }

    protected AccsClientConfig() {
    }

    @Deprecated
    public static AccsClientConfig getConfig(String string) {
        Map<String, AccsClientConfig> map;
        switch (mEnv) {
            case 1: {
                map = mPreviewConfigs;
                break;
            }
            case 2: {
                map = mDebugConfigs;
                break;
            }
            default: {
                map = mReleaseConfigs;
            }
        }
        for (AccsClientConfig accsClientConfig : map.values()) {
            if (!accsClientConfig.mAppKey.equals(string) || accsClientConfig.mConfigEnv != mEnv) continue;
            return accsClientConfig;
        }
        log.err("getConfigByTag return null").arg("appKey", (Object)string).done();
        return null;
    }

    public static AccsClientConfig getConfigByTag(String string) {
        Map<String, AccsClientConfig> map;
        switch (mEnv) {
            case 1: {
                map = mPreviewConfigs;
                break;
            }
            case 2: {
                map = mDebugConfigs;
                break;
            }
            default: {
                map = mReleaseConfigs;
            }
        }
        AccsClientConfig accsClientConfig = map.get(string);
        if (accsClientConfig == null) {
            log.warn("getConfigByTag return null").arg("configTag", (Object)string).done();
        }
        return accsClientConfig;
    }

    public static List<String> tags() {
        Map<String, AccsClientConfig> map;
        switch (mEnv) {
            case 1: {
                map = mPreviewConfigs;
                break;
            }
            case 2: {
                map = mDebugConfigs;
                break;
            }
            default: {
                map = mReleaseConfigs;
            }
        }
        return new ArrayList<String>(map.keySet());
    }

    public String getAppKey() {
        return this.mAppKey;
    }

    public String getAppSecret() {
        return this.mAppSecret;
    }

    public String getInappHost() {
        return this.mInappHost;
    }

    public String getChannelHost() {
        return this.mChannelHost;
    }

    public int getSecurity() {
        return this.mSecurity;
    }

    public String getAuthCode() {
        return this.mAuthCode;
    }

    public int getInappPubKey() {
        return this.mInappPubKey;
    }

    public int getChannelPubKey() {
        return this.mChannelPubKey;
    }

    public boolean isKeepalive() {
        return this.mKeepalive;
    }

    public boolean isAutoUnit() {
        return this.mAutoUnit;
    }

    public String getTag() {
        return this.mTag;
    }

    public int getConfigEnv() {
        return this.mConfigEnv;
    }

    public boolean getDisableChannel() {
        return this.mDisableChannel;
    }

    public boolean isQuickReconnect() {
        return this.mQuickReconnect;
    }

    public String getStoreId() {
        return this.mStoreId;
    }

    public boolean isAccsHeartbeatEnable() {
        return this.mAccsHeartbeatEnable;
    }

    public boolean isChannelLoopStart() {
        return this.mChannelLoopStart;
    }

    public long getLoopInterval() {
        return this.loopInterval;
    }

    public String toString() {
        return "AccsClientConfig{" + "Tag=" + this.mTag + ", ConfigEnv=" + this.mConfigEnv + ", AppKey=" + this.mAppKey + ", AppSecret=" + this.mAppSecret + ", InappHost=" + this.mInappHost + ", ChannelHost=" + this.mChannelHost + ", Security=" + this.mSecurity + ", AuthCode=" + this.mAuthCode + ", InappPubKey=" + this.mInappPubKey + ", ChannelPubKey=" + this.mChannelPubKey + ", Keepalive=" + this.mKeepalive + ", AutoUnit=" + this.mAutoUnit + ", DisableChannel=" + this.mDisableChannel + ", QuickReconnect=" + this.mQuickReconnect + "}";
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        AccsClientConfig accsClientConfig = (AccsClientConfig)object;
        if (!this.mInappHost.equals(accsClientConfig.mInappHost)) {
            return false;
        }
        if (this.mInappPubKey != accsClientConfig.mInappPubKey) {
            return false;
        }
        if (!this.mChannelHost.equals(accsClientConfig.mChannelHost)) {
            return false;
        }
        if (this.mChannelPubKey != accsClientConfig.mChannelPubKey) {
            return false;
        }
        if (this.mSecurity != accsClientConfig.mSecurity) {
            return false;
        }
        if (this.mConfigEnv != accsClientConfig.mConfigEnv) {
            return false;
        }
        if (!this.mAppKey.equals(accsClientConfig.mAppKey)) {
            return false;
        }
        if (this.mKeepalive != accsClientConfig.mKeepalive) {
            return false;
        }
        if (this.mDisableChannel != accsClientConfig.mDisableChannel) {
            return false;
        }
        if (this.mAuthCode != null ? !this.mAuthCode.equals(accsClientConfig.mAuthCode) : accsClientConfig.mAuthCode != null) {
            return false;
        }
        if (this.mAppSecret != null ? !this.mAppSecret.equals(accsClientConfig.mAppSecret) : accsClientConfig.mAppSecret != null) {
            return false;
        }
        return this.mTag.equals(accsClientConfig.mTag);
    }

    static {
        loadedStaticConfig = true;
        mEnv = 0;
        mReleaseConfigs = new ConcurrentHashMap<String, AccsClientConfig>(1);
        mPreviewConfigs = new ConcurrentHashMap<String, AccsClientConfig>(1);
        mDebugConfigs = new ConcurrentHashMap<String, AccsClientConfig>(1);
    }

    public static class Builder {
        private String mAppKey;
        private String mTag;
        private String mAppSecret;
        private String mInappHost;
        private String mChannelHost;
        private String mAuthCode;
        private String mStoreId;
        private int mInappPubKey = -1;
        private int mChannelPubKey = -1;
        private boolean mKeepalive = true;
        private boolean mAutoUnit = true;
        private int mConfigEnv = -1;
        private boolean mDisableChannel = false;
        private boolean mQuickReconnect = false;
        private boolean mAccsHeartbeatEnable = false;
        private boolean mChannelLoopStart = false;
        private long loopInterval = 300000L;

        public Builder setAppKey(String string) {
            this.mAppKey = string;
            return this;
        }

        public Builder setAppSecret(String string) {
            this.mAppSecret = string;
            return this;
        }

        public Builder setInappHost(String string) {
            this.mInappHost = string;
            return this;
        }

        public Builder setChannelHost(String string) {
            this.mChannelHost = string;
            return this;
        }

        @Deprecated
        public Builder setAutoCode(String string) {
            this.mAuthCode = string;
            return this;
        }

        public Builder setInappPubKey(int n2) {
            this.mInappPubKey = n2;
            return this;
        }

        public Builder setChannelPubKey(int n2) {
            this.mChannelPubKey = n2;
            return this;
        }

        public Builder setKeepAlive(boolean bl) {
            this.mKeepalive = bl;
            return this;
        }

        public Builder setAutoUnit(boolean bl) {
            this.mAutoUnit = bl;
            return this;
        }

        public Builder setConfigEnv(@ENV int n2) {
            this.mConfigEnv = n2;
            return this;
        }

        public Builder setStoreId(String string) {
            this.mStoreId = string;
            return this;
        }

        public Builder setTag(String string) {
            this.mTag = string;
            return this;
        }

        public Builder setDisableChannel(boolean bl) {
            this.mDisableChannel = bl;
            return this;
        }

        public Builder setQuickReconnect(boolean bl) {
            this.mQuickReconnect = bl;
            return this;
        }

        public Builder setAccsHeartbeatEnable(boolean bl) {
            this.mAccsHeartbeatEnable = bl;
            return this;
        }

        public Builder loopChannelStart(boolean bl) {
            this.mChannelLoopStart = bl;
            return this;
        }

        public Builder loopChannelInterval(long l2) {
            this.loopInterval = l2;
            return this;
        }

        public AccsClientConfig build() throws AccsException {
            Map map;
            if (TextUtils.isEmpty((CharSequence)this.mAppKey)) {
                throw new AccsException("appkey null");
            }
            if (TextUtils.isEmpty((CharSequence)this.mAppSecret)) {
                throw new AccsException("appSecret null");
            }
            AccsClientConfig accsClientConfig = new AccsClientConfig();
            accsClientConfig.mAppKey = this.mAppKey;
            accsClientConfig.mAppSecret = this.mAppSecret;
            accsClientConfig.mAuthCode = this.mAuthCode;
            accsClientConfig.mKeepalive = this.mKeepalive;
            accsClientConfig.mAutoUnit = this.mAutoUnit;
            accsClientConfig.mInappPubKey = this.mInappPubKey;
            accsClientConfig.mChannelPubKey = this.mChannelPubKey;
            accsClientConfig.mInappHost = this.mInappHost;
            accsClientConfig.mChannelHost = this.mChannelHost;
            accsClientConfig.mTag = this.mTag;
            accsClientConfig.mStoreId = this.mStoreId;
            accsClientConfig.mConfigEnv = this.mConfigEnv;
            accsClientConfig.mDisableChannel = this.mDisableChannel;
            accsClientConfig.mQuickReconnect = this.mQuickReconnect;
            accsClientConfig.mAccsHeartbeatEnable = this.mAccsHeartbeatEnable;
            accsClientConfig.mChannelLoopStart = this.mChannelLoopStart;
            accsClientConfig.loopInterval = this.loopInterval;
            if (accsClientConfig.mConfigEnv < 0) {
                accsClientConfig.mConfigEnv = mEnv;
            }
            accsClientConfig.mSecurity = 2;
            if (TextUtils.isEmpty((CharSequence)accsClientConfig.mInappHost)) {
                accsClientConfig.mInappHost = DEFAULT_CENTER_HOSTS[accsClientConfig.mConfigEnv];
            }
            if (TextUtils.isEmpty((CharSequence)accsClientConfig.mChannelHost)) {
                accsClientConfig.mChannelHost = DEFAULT_CHANNEL_HOSTS[accsClientConfig.mConfigEnv];
            }
            if (TextUtils.isEmpty((CharSequence)accsClientConfig.mTag)) {
                accsClientConfig.mTag = accsClientConfig.mAppKey;
            }
            switch (accsClientConfig.mConfigEnv) {
                case 1: {
                    map = mPreviewConfigs;
                    break;
                }
                case 2: {
                    map = mDebugConfigs;
                    break;
                }
                default: {
                    map = mReleaseConfigs;
                }
            }
            log.debug("build config").arg((Object)accsClientConfig).done();
            AccsClientConfig accsClientConfig2 = (AccsClientConfig)map.get(accsClientConfig.getTag());
            if (accsClientConfig2 != null) {
                log.warn("build cover").arg("old", (Object)accsClientConfig2).arg("new", (Object)accsClientConfig).done();
            }
            map.put(accsClientConfig.getTag(), accsClientConfig);
            return accsClientConfig;
        }
    }

    @Retention(value=RetentionPolicy.CLASS)
    public static @interface ENV {
    }

    @Retention(value=RetentionPolicy.CLASS)
    public static @interface SECURITY_TYPE {
    }
}

