/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.accs.base;

import android.content.Context;
import android.content.Intent;
import android.text.TextUtils;
import com.alibaba.sdk.android.error.ErrorCode;
import com.taobao.accs.ACCSManager;
import com.taobao.accs.IACCSManager;
import com.taobao.accs.base.AccsDataListener;
import com.taobao.accs.base.TaoBaseService;
import com.taobao.accs.common.Constants;
import com.taobao.accs.ut.monitor.NetPerformanceMonitor;
import com.taobao.accs.utl.ALog;
import com.taobao.accs.utl.AppMonitorAdapter;
import com.taobao.accs.utl.UTMini;
import java.util.HashMap;
import java.util.Map;

public abstract class AccsAbstractDataListener
implements AccsDataListener {
    private static final String TAG = "AccsAbstractDataListener";

    @Override
    public void onConnected(TaoBaseService.ConnectInfo connectInfo) {
    }

    @Override
    public void onDisconnected(TaoBaseService.ConnectInfo connectInfo) {
    }

    @Override
    public void onAntiBrush(boolean bl, TaoBaseService.ExtraInfo extraInfo) {
    }

    public static int onReceiveData(Context context, Intent intent, AccsDataListener accsDataListener) {
        block23: {
            if (accsDataListener == null || context == null) {
                ALog.e(TAG, "onReceiveData listener or context null", new Object[0]);
                return 2;
            }
            if (intent != null) {
                String string = "";
                try {
                    int n2 = intent.getIntExtra("command", -1);
                    ErrorCode errorCode = Constants.getErrorCode(intent);
                    String string2 = intent.getStringExtra("userInfo");
                    String string3 = intent.getStringExtra("dataId");
                    string = intent.getStringExtra("serviceId");
                    if (ALog.isPrintLog(ALog.Level.I)) {
                        ALog.i(TAG, "onReceiveData", "dataId", string3, "serviceId", string, "command", n2, "className", accsDataListener.getClass().getName());
                    }
                    if (n2 > 0) {
                        UTMini.getInstance().commitEvent(66001, "MsgToBuss5", "commandId=" + n2, "serviceId=" + string + " dataId=" + string3, 221);
                        AppMonitorAdapter.commitCount("accs", "to_buss", "3commandId=" + n2 + "serviceId=" + string, 0.0);
                        switch (n2) {
                            case 5: {
                                accsDataListener.onBind(string, errorCode.getCodeInt(), AccsAbstractDataListener.getExtraInfo(intent));
                                break;
                            }
                            case 6: {
                                accsDataListener.onUnbind(string, errorCode.getCodeInt(), AccsAbstractDataListener.getExtraInfo(intent));
                                break;
                            }
                            case 101: {
                                byte[] byArray = intent.getByteArrayExtra("data");
                                boolean bl = intent.getBooleanExtra("bizAck", false);
                                if (byArray != null) {
                                    NetPerformanceMonitor netPerformanceMonitor;
                                    string3 = intent.getStringExtra("dataId");
                                    if (ALog.isPrintLog(ALog.Level.D)) {
                                        ALog.d(TAG, "onReceiveData COMMAND_RECEIVE_DATA onData dataId:" + string3 + " serviceId:" + string, new Object[0]);
                                    }
                                    TaoBaseService.ExtraInfo extraInfo = AccsAbstractDataListener.getExtraInfo(intent);
                                    if (bl) {
                                        ALog.i(TAG, "onReceiveData try to send biz ack dataId " + string3, new Object[0]);
                                        AccsAbstractDataListener.sendBusinessAck(context, intent, string3, extraInfo.oriExtHeader);
                                    }
                                    if ((netPerformanceMonitor = (NetPerformanceMonitor)((Object)intent.getSerializableExtra("monitor"))) != null) {
                                        netPerformanceMonitor.onToAccsTime();
                                    }
                                    AppMonitorAdapter.commitCount("accs", "to_buss_success", "1commandId=101serviceId=" + string, 0.0);
                                    accsDataListener.onData(string, string2, string3, byArray, extraInfo);
                                    break;
                                }
                                ALog.e(TAG, "onReceiveData COMMAND_RECEIVE_DATA msg null", new Object[0]);
                                AppMonitorAdapter.commitAlarmFail("accs", "send_fail", string, "1", "COMMAND_RECEIVE_DATA msg null");
                                break;
                            }
                            case 100: {
                                string3 = intent.getStringExtra("dataId");
                                if (TextUtils.equals((CharSequence)"res", (CharSequence)intent.getStringExtra("send_type"))) {
                                    byte[] byArray = intent.getByteArrayExtra("data");
                                    accsDataListener.onResponse(string, string3, errorCode.getCodeInt(), byArray, AccsAbstractDataListener.getExtraInfo(intent));
                                    break;
                                }
                                accsDataListener.onSendData(string, string3, errorCode.getCodeInt(), AccsAbstractDataListener.getExtraInfo(intent));
                                break;
                            }
                            case 104: {
                                boolean bl = intent.getBooleanExtra("anti_brush_ret", false);
                                ALog.e(TAG, "onReceiveData anti brush result:" + bl, new Object[0]);
                                accsDataListener.onAntiBrush(bl, null);
                                break;
                            }
                            case 103: {
                                boolean bl = intent.getBooleanExtra("connect_avail", false);
                                String string4 = intent.getStringExtra("host");
                                boolean bl2 = intent.getBooleanExtra("type_inapp", false);
                                boolean bl3 = intent.getBooleanExtra("is_center_host", false);
                                if (!TextUtils.isEmpty((CharSequence)string4)) {
                                    if (bl) {
                                        accsDataListener.onConnected(new TaoBaseService.ConnectInfo(string4, bl2, bl3));
                                        break;
                                    }
                                    accsDataListener.onDisconnected(new TaoBaseService.ConnectInfo(string4, bl2, bl3, errorCode.getCodeInt(), errorCode.getMsg()));
                                    break;
                                }
                                break block23;
                            }
                            default: {
                                ALog.w(TAG, "onReceiveData command not handled " + n2, new Object[0]);
                                break;
                            }
                        }
                        break block23;
                    }
                    ALog.w(TAG, "onReceiveData command not handled " + n2, new Object[0]);
                }
                catch (Exception exception) {
                    AppMonitorAdapter.commitAlarmFail("accs", "send_fail", string, "1", "callback error" + exception.toString());
                    ALog.e(TAG, "onReceiveData", exception, new Object[0]);
                }
            }
        }
        return 2;
    }

    private static Map<TaoBaseService.ExtHeaderType, String> getExtHeader(Map<Integer, String> map) {
        HashMap<TaoBaseService.ExtHeaderType, String> hashMap = null;
        if (map == null) {
            return null;
        }
        try {
            hashMap = new HashMap<TaoBaseService.ExtHeaderType, String>();
            for (TaoBaseService.ExtHeaderType extHeaderType : TaoBaseService.ExtHeaderType.values()) {
                String string = map.get(extHeaderType.ordinal());
                if (TextUtils.isEmpty((CharSequence)string)) continue;
                hashMap.put(extHeaderType, string);
            }
        }
        catch (Exception exception) {
            ALog.e(TAG, "getExtHeader", exception, new Object[0]);
        }
        return hashMap;
    }

    private static TaoBaseService.ExtraInfo getExtraInfo(Intent intent) {
        TaoBaseService.ExtraInfo extraInfo = new TaoBaseService.ExtraInfo();
        try {
            HashMap hashMap = (HashMap)intent.getSerializableExtra("ext_header");
            Map<TaoBaseService.ExtHeaderType, String> map = AccsAbstractDataListener.getExtHeader(hashMap);
            String string = intent.getStringExtra("packageName");
            String string2 = intent.getStringExtra("host");
            extraInfo.connType = intent.getIntExtra("conn_type", 0);
            extraInfo.extHeader = map;
            extraInfo.oriExtHeader = hashMap;
            extraInfo.fromPackage = string;
            extraInfo.fromHost = string2;
        }
        catch (Throwable throwable) {
            ALog.e(TAG, "getExtraInfo", throwable, new Object[0]);
        }
        return extraInfo;
    }

    private static void sendBusinessAck(Context context, Intent intent, String string, Map<Integer, String> map) {
        try {
            ALog.i(TAG, "sendBusinessAck", "dataId", string);
            if (intent != null) {
                String string2 = intent.getStringExtra("host");
                String string3 = intent.getStringExtra("source");
                String string4 = intent.getStringExtra("target");
                String string5 = intent.getStringExtra("appKey");
                String string6 = intent.getStringExtra("configTag");
                short s2 = intent.getShortExtra("flags", (short)0);
                IACCSManager iACCSManager = ACCSManager.getAccsInstance(context, string5, string6);
                if (iACCSManager != null) {
                    iACCSManager.sendBusinessAck(string4, string3, string, s2, string2, map);
                    AppMonitorAdapter.commitCount("accs", "bizAckSucc", "", 0.0);
                } else {
                    AppMonitorAdapter.commitCount("accs", "bizAckFail", "no acsmgr", 0.0);
                }
            }
        }
        catch (Throwable throwable) {
            ALog.e(TAG, "sendBusinessAck", throwable, new Object[0]);
            AppMonitorAdapter.commitCount("accs", "bizAckFail", throwable.toString(), 0.0);
        }
    }
}

