/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.accs.client;

import android.app.ActivityManager;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.net.ConnectivityManager;
import android.text.TextUtils;
import com.taobao.accs.IProcessName;
import com.taobao.accs.utl.ALog;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

public class AdapterGlobalClientInfo {
    private static final String TAG = "AdapterGlobalClientInfo";
    private static volatile AdapterGlobalClientInfo mInstance;
    private static Context mContext;
    private ActivityManager mActivityManager;
    private ConnectivityManager mConnectivityManager;
    public static final int SECURITY_TAOBAO = 0;
    public static final int SECURITY_OPEN = 1;
    public static final int SECURITY_OFF = 2;
    public static int mSecurityType;
    public static String mAgooCustomServiceName;
    public static String mAuthCode;
    public static String mMainProcessName;
    public static String mChannelProcessName;
    public static IProcessName mProcessNameImpl;
    public static AtomicInteger mStartServiceTimes;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AdapterGlobalClientInfo getInstance(Context context) {
        if (mInstance != null) return mInstance;
        Class<AdapterGlobalClientInfo> clazz = AdapterGlobalClientInfo.class;
        synchronized (AdapterGlobalClientInfo.class) {
            if (mInstance != null) return mInstance;
            mInstance = new AdapterGlobalClientInfo(context);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return mInstance;
        }
    }

    public static Context getContext() {
        return mContext;
    }

    private AdapterGlobalClientInfo(Context context) {
        if (context == null) {
            throw new RuntimeException("Context is null!!");
        }
        if (mContext == null) {
            mContext = context.getApplicationContext();
        }
    }

    public ActivityManager getActivityManager() {
        if (this.mActivityManager == null) {
            this.mActivityManager = (ActivityManager)mContext.getSystemService("activity");
        }
        return this.mActivityManager;
    }

    public ConnectivityManager getConnectivityManager() {
        if (this.mConnectivityManager == null) {
            this.mConnectivityManager = (ConnectivityManager)mContext.getSystemService("connectivity");
        }
        return this.mConnectivityManager;
    }

    public static String getAgooCustomServiceName(Context context) {
        String string;
        if (TextUtils.isEmpty((CharSequence)mAgooCustomServiceName)) {
            string = AdapterGlobalClientInfo.tryfindAgooService(context);
            ALog.d(TAG, "Please call TaobaoRegister.setAgooMsgReceiveService() first!", new Object[0]);
        } else {
            string = mAgooCustomServiceName;
        }
        ALog.d(TAG, "getAgooCustomServiceName", "serviceName", string);
        return string;
    }

    private static String tryfindAgooService(Context context) {
        try {
            PackageManager packageManager = context.getPackageManager();
            Intent intent = new Intent("org.agoo.android.intent.action.RECEIVE");
            List list = packageManager.queryIntentServices(intent, 0);
            if (list != null && list.size() > 0) {
                for (ResolveInfo resolveInfo : list) {
                    if (!resolveInfo.serviceInfo.packageName.equals(context.getPackageName())) continue;
                    return resolveInfo.serviceInfo.name;
                }
            }
        }
        catch (Exception exception) {}
        return null;
    }

    public static boolean isFirstStartProc() {
        return mStartServiceTimes.intValue() == 0;
    }

    static {
        mSecurityType = 0;
        mAgooCustomServiceName = null;
        mStartServiceTimes = new AtomicInteger(-1);
    }
}

