/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.accs.dispatch;

import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Bundle;
import com.taobao.accs.dispatch.a;
import com.taobao.accs.utl.ALog;
import com.taobao.accs.utl.Utils;

public class IntentDispatch {
    public static final String TAG = IntentDispatch.class.getSimpleName();

    public static void dispatchIntent(Context context, Intent intent, boolean bl) {
        if (context == null || intent == null) {
            ALog.e(TAG, "dispatchIntent context or intent is null", new Object[0]);
            return;
        }
        Context context2 = context.getApplicationContext();
        try {
            if (Utils.isTarget26(context2)) {
                ALog.i(TAG, "dispatchIntent bind service start", "intent", intent.toString());
                Intent intent2 = IntentDispatch.filterExtras(intent);
                ALog.i(TAG, "dispatchIntent bind service start use filter", "intent", intent2.toString());
                ALog.i(TAG, "dispatchIntent bind service start bundle is ", IntentDispatch.printBundle(intent2.getExtras(), 0));
                context2.bindService(intent2, (ServiceConnection)new a(intent, bl, context2), 1);
            } else {
                ALog.i(TAG, "dispatchIntent start service ", new Object[0]);
                context2.startService(intent);
            }
        }
        catch (Exception exception) {
            ALog.e(TAG, "dispatchIntent method call with exception ", exception.toString());
            exception.printStackTrace();
        }
    }

    private static Intent filterExtras(Intent intent) {
        Intent intent2 = (Intent)intent.clone();
        intent2.replaceExtras(new Bundle());
        return intent2;
    }

    private static final String printBundle(Bundle bundle, int n2) {
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : bundle.keySet()) {
            Object object = bundle.get(string);
            for (int i2 = 0; i2 < n2; ++i2) {
                stringBuilder.append('\t');
            }
            if (object instanceof String) {
                stringBuilder.append("String\t").append(string).append('\t').append(object).append('\n');
                continue;
            }
            if (object instanceof Integer) {
                stringBuilder.append("int\t").append(string).append('\t').append(object).append('\n');
                continue;
            }
            if (object instanceof Long) {
                stringBuilder.append("long\t").append(string).append('\t').append(object).append('\n');
                continue;
            }
            if (object instanceof Boolean) {
                stringBuilder.append("boolean\t").append(string).append('\t').append(object).append('\n');
                continue;
            }
            if (object instanceof Bundle) {
                stringBuilder.append("Bundle\t").append(string).append('\t').append('\n');
                stringBuilder.append(IntentDispatch.printBundle((Bundle)object, n2 + 1));
                continue;
            }
            stringBuilder.append("unknown\t").append(string).append('\t').append(object).append('\n');
        }
        return stringBuilder.toString();
    }
}

