/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.accs.ut.monitor;

import anet.channel.statist.Dimension;
import anet.channel.statist.Measure;
import anet.channel.statist.Monitor;
import com.alibaba.sdk.android.error.ErrorCode;
import com.taobao.accs.a;
import com.taobao.accs.utl.BaseMonitor;

@Monitor(module="accs", monitorPoint="netperformance")
public class NetPerformanceMonitor
extends BaseMonitor {
    @Measure(max=60000.0, min=0.0, constantValue=0.0)
    public long total_time;
    @Measure(max=60000.0, min=0.0, constantValue=0.0)
    public long start_to_enter_queue_time;
    @Measure(max=60000.0, min=0.0, constantValue=0.0)
    public long in_queue_time;
    @Measure(max=60000.0, min=0.0, constantValue=0.0)
    public long talk_to_send_time;
    @Measure(max=60000.0, min=0.0, constantValue=0.0)
    public long send_to_receive_time;
    @Measure(max=60000.0, min=0.0, constantValue=0.0)
    public long receive_to_call_back_time;
    @Measure(max=60000.0, min=0.0, constantValue=0.0)
    public long receive_accs_to_call_time;
    @Measure(max=60000.0, min=0.0, constantValue=0.0)
    public long receive_agoo_to_call_time;
    @Dimension
    public int accs_sdk_version;
    @Dimension
    public String service_id = "none";
    @Dimension
    public String ret;
    @Dimension
    public int error_code;
    @Dimension
    public String fail_reasons;
    @Dimension
    public int accs_type;
    @Dimension
    public String host;
    @Dimension
    public int retry_times;
    @Dimension
    public int msgType;
    public String data_id;
    public String device_id;
    private long start_send_date;
    private long enter_queue_date;
    public long take_date;
    public long to_tnet_date;
    private long receive_ack_date;
    private long to_bz_date;
    private long receive_data_time;
    private long to_accs_time;
    private long to_agoo_time;

    public void setDeviceId(String string) {
        this.device_id = string;
    }

    public void setServiceId(String string) {
        this.service_id = string;
    }

    public void setDataId(String string) {
        this.data_id = string;
    }

    public void onSend() {
        this.start_send_date = System.currentTimeMillis();
    }

    public void onEnterQueueData() {
        this.enter_queue_date = System.currentTimeMillis();
    }

    public void onTakeFromQueue() {
        this.take_date = System.currentTimeMillis();
    }

    public void onSendData() {
        this.to_tnet_date = System.currentTimeMillis();
    }

    public void onReceiveData() {
        this.receive_data_time = System.currentTimeMillis();
    }

    public void onToAccsTime() {
        this.to_accs_time = System.currentTimeMillis();
    }

    public void onToAgooTime() {
        this.to_agoo_time = System.currentTimeMillis();
    }

    public void setRet(boolean bl) {
        this.ret = bl ? "y" : "n";
    }

    public void setFailReason(String string) {
        this.fail_reasons = string;
    }

    public void setMsgType(int n2) {
        this.msgType = n2;
    }

    public void setFailReason(ErrorCode errorCode) {
        this.error_code = errorCode.getCodeInt();
        if (errorCode.getCodeInt() != a.SUCCESS.getCodeInt()) {
            this.setFailReason(errorCode.getMsg());
        }
    }

    public void setHost(String string) {
        this.host = string;
    }

    public void onRecAck() {
        this.receive_ack_date = System.currentTimeMillis();
    }

    public void onToBizDate() {
        this.to_bz_date = System.currentTimeMillis();
    }

    public void setConnType(int n2) {
        this.accs_type = n2;
    }

    @Override
    public boolean beforeCommit() {
        this.accs_sdk_version = 221;
        this.total_time = this.computeTime(this.start_send_date, this.to_bz_date);
        this.start_to_enter_queue_time = this.computeTime(this.start_send_date, this.enter_queue_date);
        this.in_queue_time = this.computeTime(this.enter_queue_date, this.take_date);
        this.talk_to_send_time = this.computeTime(this.take_date, this.to_tnet_date);
        this.send_to_receive_time = this.computeTime(this.to_tnet_date, this.receive_ack_date);
        this.receive_to_call_back_time = this.computeTime(this.receive_ack_date, this.to_bz_date);
        this.receive_accs_to_call_time = this.computeTime(this.receive_data_time, this.to_accs_time);
        this.receive_agoo_to_call_time = this.computeTime(this.receive_data_time, this.to_agoo_time);
        return super.beforeCommit();
    }

    private long computeTime(long l2, long l3) {
        long l4 = 0L;
        if (l2 > 0L && l3 > 0L) {
            l4 = l3 - l2;
        }
        return l4;
    }
}

