/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.accs.utl;

import android.app.ActivityManager;
import android.app.AppOpsManager;
import android.app.Application;
import android.app.NotificationManager;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Build;
import android.os.Environment;
import android.os.Process;
import android.os.StatFs;
import android.text.TextUtils;
import com.ta.utdid2.device.UTDevice;
import com.taobao.accs.ChannelService;
import com.taobao.accs.client.AdapterGlobalClientInfo;
import com.taobao.accs.data.MsgDistributeService;
import com.taobao.accs.utl.ALog;
import com.taobao.accs.utl.Utils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;

public class AdapterUtilityImpl {
    private static final String TAG = "AdapterUtilityImpl";
    public static String BACK_APP_KEY = "";
    public static String mAgooAppSecret;
    private static boolean mIsMainProc;
    private static boolean mChecked;
    public static final String channelService;
    public static final String msgService;

    public static boolean isMainProcess(Context context) {
        if (mChecked) {
            return mIsMainProc;
        }
        String string = AdapterUtilityImpl.getProcessName(context);
        mIsMainProc = context.getPackageName().equalsIgnoreCase(string);
        mChecked = true;
        return mIsMainProc;
    }

    public static String getProcessName(Context context) {
        try {
            if (Build.VERSION.SDK_INT >= 28) {
                String string = Application.getProcessName();
                return string;
            }
        }
        catch (Exception exception) {}
        String string = AdapterUtilityImpl.getProcessNameByActivityThread(context);
        if (!TextUtils.isEmpty((CharSequence)string)) {
            return string;
        }
        string = AdapterUtilityImpl.getProcessNameByPid();
        if (!TextUtils.isEmpty((CharSequence)string)) {
            return string;
        }
        return AdapterUtilityImpl.getProcessNameByAm(context);
    }

    private static String getProcessNameByAm(Context context) {
        String string = "";
        ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
        if (activityManager == null) {
            return string;
        }
        List list = activityManager.getRunningAppProcesses();
        if (list == null) {
            return string;
        }
        int n2 = Process.myPid();
        for (ActivityManager.RunningAppProcessInfo runningAppProcessInfo : list) {
            if (runningAppProcessInfo.pid != n2) continue;
            string = runningAppProcessInfo.processName;
            break;
        }
        return string;
    }

    private static String getProcessNameByPid() {
        int n2 = Process.myPid();
        String string = null;
        BufferedReader bufferedReader = null;
        try {
            File file = new File("/proc/" + n2 + "/cmdline");
            if (file.exists()) {
                bufferedReader = new BufferedReader(new FileReader(file));
                string = bufferedReader.readLine().trim();
            }
        }
        catch (Exception exception) {
            ALog.w(TAG, "getProcessNameByPid error: ", exception, new Object[0]);
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
        return string;
    }

    private static String getProcessNameByActivityThread(Context context) {
        String string = null;
        try {
            Class<?> clazz = Class.forName("android.app.ActivityThread", false, context.getClassLoader());
            Method method = clazz.getDeclaredMethod("currentProcessName", new Class[0]);
            method.setAccessible(true);
            string = (String)method.invoke(null, new Object[0]);
        }
        catch (Exception exception) {
            ALog.w(TAG, "getProcessNameByActivityThread error: ", exception, new Object[0]);
        }
        return string;
    }

    public static long getUsableSpace() {
        long l2 = -1L;
        try {
            File file = Environment.getDataDirectory();
            if (file == null) {
                return l2;
            }
            return file.getUsableSpace();
        }
        catch (Throwable throwable) {
            ALog.e(TAG, "getUsableSpace", throwable, new Object[0]);
            return l2;
        }
    }

    public static String getStackMsg(Throwable throwable) {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
            if (stackTraceElementArray != null && stackTraceElementArray.length > 0) {
                for (int i2 = 0; i2 < stackTraceElementArray.length; ++i2) {
                    StackTraceElement stackTraceElement = stackTraceElementArray[i2];
                    stringBuffer.append(stackTraceElement.toString()).append("\n");
                }
            }
        }
        catch (Exception exception) {}
        return stringBuffer.toString();
    }

    public static String getDeviceId(Context context) {
        return UTDevice.getUtdid((Context)context);
    }

    public static boolean isNetworkConnected(Context context) {
        if (context != null) {
            try {
                ConnectivityManager connectivityManager = AdapterGlobalClientInfo.getInstance(context).getConnectivityManager();
                NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
                if (networkInfo != null) {
                    return networkInfo.isConnected();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return false;
    }

    public static final boolean checkIsWritable(String string, int n2) {
        boolean bl;
        if (string == null) {
            return false;
        }
        StatFs statFs = new StatFs(string);
        int n3 = statFs.getBlockSize();
        long l2 = statFs.getAvailableBlocks();
        boolean bl2 = bl = statFs.getAvailableBlocks() > 10 && l2 * (long)n3 > (long)n2;
        if (!bl) {
            ALog.w("FileCheckUtils", "target : " + n2 + " st.getAvailableBlocks()=" + statFs.getAvailableBlocks() + ",st.getAvailableBlocks() * blockSize=" + (long)statFs.getAvailableBlocks() * (long)n3, new Object[0]);
        }
        return bl;
    }

    public static String isNotificationEnabled(Context context) {
        String string = "unknown";
        if (Utils.isTarget26(context)) {
            ApplicationInfo applicationInfo = context.getApplicationInfo();
            String string2 = context.getApplicationContext().getPackageName();
            int n2 = applicationInfo.uid;
            try {
                NotificationManager notificationManager = (NotificationManager)context.getSystemService("notification");
                Method method = notificationManager.getClass().getDeclaredMethod("getService", new Class[0]);
                method.setAccessible(true);
                Object object = method.invoke((Object)notificationManager, new Object[0]);
                Method method2 = object.getClass().getDeclaredMethod("areNotificationsEnabledForPackage", String.class, Integer.TYPE);
                method2.setAccessible(true);
                string = String.valueOf(method2.invoke(object, string2, n2));
            }
            catch (Throwable throwable) {
                ALog.e(TAG, "Android O isNotificationEnabled", throwable, new Object[0]);
            }
        } else {
            try {
                AppOpsManager appOpsManager = (AppOpsManager)context.getSystemService("appops");
                ApplicationInfo applicationInfo = context.getApplicationInfo();
                String string3 = context.getApplicationContext().getPackageName();
                int n3 = applicationInfo.uid;
                Class<?> clazz = Class.forName(AppOpsManager.class.getName());
                Method method = clazz.getMethod("checkOpNoThrow", Integer.TYPE, Integer.TYPE, String.class);
                Field field = clazz.getDeclaredField("OP_POST_NOTIFICATION");
                int n4 = (Integer)field.get(appOpsManager);
                int n5 = (Integer)method.invoke((Object)appOpsManager, n4, n3, string3);
                string = String.valueOf(n5 == 0);
            }
            catch (Throwable throwable) {
                ALog.e(TAG, "isNotificationEnabled", throwable, new Object[0]);
            }
        }
        return string;
    }

    static {
        mIsMainProc = true;
        mChecked = false;
        channelService = ChannelService.class.getName();
        msgService = MsgDistributeService.class.getName();
    }
}

