/*
 * Decompiled with CFR 0.152.
 */
package anet.channel.session;

import android.content.Context;
import android.text.TextUtils;
import anet.channel.AwcnConfig;
import anet.channel.Config;
import anet.channel.DataFrameCb;
import anet.channel.GlobalAppRuntimeInfo;
import anet.channel.IAuth;
import anet.channel.RequestCb;
import anet.channel.Session;
import anet.channel.SessionInfo;
import anet.channel.appmonitor.AppMonitor;
import anet.channel.bytes.ByteArray;
import anet.channel.bytes.a;
import anet.channel.entity.b;
import anet.channel.heartbeat.HeartbeatManager;
import anet.channel.heartbeat.IHeartbeat;
import anet.channel.request.Cancelable;
import anet.channel.request.Request;
import anet.channel.request.c;
import anet.channel.security.ISecurity;
import anet.channel.session.h;
import anet.channel.session.i;
import anet.channel.session.j;
import anet.channel.statist.ExceptionStatistic;
import anet.channel.statist.RequestStatistic;
import anet.channel.statist.SessionMonitor;
import anet.channel.statist.StatObject;
import anet.channel.status.NetworkStatusHelper;
import anet.channel.strategy.ConnEvent;
import anet.channel.strategy.IConnStrategy;
import anet.channel.strategy.StrategyCenter;
import anet.channel.util.ALog;
import anet.channel.util.ErrorConstant;
import anet.channel.util.HttpHelper;
import anet.channel.util.Utils;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.android.spdy.AccsSSLCallback;
import org.android.spdy.RequestPriority;
import org.android.spdy.SessionCb;
import org.android.spdy.SpdyAgent;
import org.android.spdy.SpdyByteArray;
import org.android.spdy.SpdyDataProvider;
import org.android.spdy.SpdyErrorException;
import org.android.spdy.SpdyRequest;
import org.android.spdy.SpdySession;
import org.android.spdy.SpdySessionKind;
import org.android.spdy.SpdyVersion;
import org.android.spdy.Spdycb;
import org.android.spdy.SuperviseConnectInfo;
import org.android.spdy.SuperviseData;

public class TnetSpdySession
extends Session
implements SessionCb {
    protected SpdyAgent w;
    protected SpdySession x;
    protected volatile boolean y = false;
    protected long z;
    protected long A = 0L;
    private int H = 0;
    protected int B = -1;
    protected DataFrameCb C = null;
    protected IHeartbeat D = null;
    protected IAuth E = null;
    protected String F = null;
    protected ISecurity G = null;
    private boolean I = false;

    public TnetSpdySession(Context context, anet.channel.entity.a a2) {
        super(context, a2);
    }

    public void initConfig(Config config) {
        if (config != null) {
            this.F = config.getAppkey();
            this.G = config.getSecurity();
        }
    }

    public void initSessionInfo(SessionInfo sessionInfo) {
        if (sessionInfo != null) {
            this.C = sessionInfo.dataFrameCb;
            this.E = sessionInfo.auth;
            if (sessionInfo.isKeepAlive) {
                this.q.isKL = 1L;
                this.t = true;
                this.D = sessionInfo.heartbeat;
                this.I = sessionInfo.isAccs;
                if (this.D == null) {
                    this.D = sessionInfo.isAccs && !AwcnConfig.isAccsSessionCreateForbiddenInBg() ? HeartbeatManager.getDefaultBackgroundAccsHeartbeat() : HeartbeatManager.getDefaultHeartbeat();
                }
            }
        }
        if (AwcnConfig.isIdleSessionCloseEnable() && this.D == null) {
            this.D = new anet.channel.heartbeat.c();
        }
    }

    public void setTnetPublicKey(int n2) {
        this.B = n2;
    }

    @Override
    public Cancelable request(Request request, RequestCb requestCb) {
        c c2 = anet.channel.request.c.NULL;
        RequestStatistic requestStatistic = request != null ? request.a : new RequestStatistic(this.d, null);
        requestStatistic.setConnType(this.j);
        if (requestStatistic.start == 0L) {
            requestStatistic.start = requestStatistic.reqStart = System.currentTimeMillis();
        }
        requestStatistic.setIPAndPort(this.f, this.g);
        requestStatistic.ipRefer = this.k.getIpSource();
        requestStatistic.ipType = this.k.getIpType();
        requestStatistic.unit = this.l;
        if (request == null || requestCb == null) {
            if (requestCb != null) {
                requestCb.onFinish(-102, ErrorConstant.getErrMsg(-102), requestStatistic);
            }
            return c2;
        }
        try {
            if (this.x != null && (this.n == 0 || this.n == 4)) {
                Object object;
                if (this.m) {
                    request.setDnsOptimize(this.e, this.g);
                }
                request.setUrlScheme(this.j.isSSL());
                URL uRL = request.getUrl();
                if (ALog.isPrintLog(2)) {
                    ALog.i("awcn.TnetSpdySession", "", request.getSeq(), "request URL", uRL.toString());
                    ALog.i("awcn.TnetSpdySession", "", request.getSeq(), "request Method", request.getMethod());
                    ALog.i("awcn.TnetSpdySession", "", request.getSeq(), "request headers", request.getHeaders());
                }
                SpdyRequest spdyRequest = TextUtils.isEmpty((CharSequence)this.h) || this.i <= 0 ? new SpdyRequest(uRL, request.getMethod(), RequestPriority.DEFAULT_PRIORITY, -1, request.getConnectTimeout()) : new SpdyRequest(uRL, uRL.getHost(), uRL.getPort(), this.h, this.i, request.getMethod(), RequestPriority.DEFAULT_PRIORITY, -1, request.getConnectTimeout(), 0);
                spdyRequest.setRequestRdTimeoutMs(request.getReadTimeout());
                Map<String, String> map = request.getHeaders();
                if (!map.containsKey("Host")) {
                    spdyRequest.addHeaders(map);
                    spdyRequest.addHeader(":host", this.m ? this.e : request.getHost());
                } else {
                    map = new HashMap<String, String>(request.getHeaders());
                    object = map.remove("Host");
                    map.put(":host", (String)(this.m ? this.e : object));
                    spdyRequest.addHeaders(map);
                }
                object = request.getBodyBytes();
                SpdyDataProvider spdyDataProvider = new SpdyDataProvider((byte[])object);
                request.a.sendStart = System.currentTimeMillis();
                request.a.processTime = request.a.sendStart - request.a.start;
                int n2 = this.x.submitRequest(spdyRequest, spdyDataProvider, (Object)this, (Spdycb)new a(request, requestCb));
                if (ALog.isPrintLog(1)) {
                    ALog.d("awcn.TnetSpdySession", "", request.getSeq(), "streamId", n2);
                }
                c2 = new c(this.x, n2, request.getSeq());
                ++this.q.requestCount;
                ++this.q.stdRCount;
                this.z = System.currentTimeMillis();
                if (this.D != null) {
                    this.D.reSchedule();
                }
            } else {
                requestCb.onFinish(-301, ErrorConstant.getErrMsg(-301), request.a);
            }
        }
        catch (SpdyErrorException spdyErrorException) {
            if (spdyErrorException.SpdyErrorGetCode() == -1104 || spdyErrorException.SpdyErrorGetCode() == -1103) {
                ALog.e("awcn.TnetSpdySession", "Send request on closed session!!!", this.p, new Object[0]);
                this.notifyStatus(6, new b(2));
            }
            requestCb.onFinish(-300, ErrorConstant.formatMsg(-300, String.valueOf(spdyErrorException.SpdyErrorGetCode())), requestStatistic);
        }
        catch (Exception exception) {
            requestCb.onFinish(-101, ErrorConstant.getErrMsg(-101), requestStatistic);
        }
        return c2;
    }

    @Override
    public void sendCustomFrame(int n2, byte[] byArray, int n3) {
        try {
            if (this.C == null) {
                return;
            }
            ALog.e("awcn.TnetSpdySession", "sendCustomFrame", this.p, "dataId", n2, "type", n3);
            if (this.n == 4 && this.x != null) {
                if (byArray != null && byArray.length > 16384) {
                    this.a(n2, -303, false, null);
                } else {
                    this.x.sendCustomControlFrame(n2, n3, 0, byArray == null ? 0 : byArray.length, byArray);
                    ++this.q.requestCount;
                    ++this.q.cfRCount;
                    this.z = System.currentTimeMillis();
                    if (this.D != null) {
                        this.D.reSchedule();
                    }
                }
            } else {
                ALog.e("awcn.TnetSpdySession", "sendCustomFrame", this.p, "sendCustomFrame con invalid mStatus:" + this.n);
                this.a(n2, -301, true, "session invalid");
            }
        }
        catch (SpdyErrorException spdyErrorException) {
            ALog.e("awcn.TnetSpdySession", "sendCustomFrame error", this.p, spdyErrorException, new Object[0]);
            this.a(n2, -300, true, "SpdyErrorException: " + spdyErrorException.toString());
        }
        catch (Exception exception) {
            ALog.e("awcn.TnetSpdySession", "sendCustomFrame error", this.p, exception, new Object[0]);
            this.a(n2, -101, true, exception.toString());
        }
    }

    private void a(int n2, int n3, boolean bl, String string) {
        if (this.C != null) {
            this.C.onException(n2, n3, bl, string);
        }
    }

    @Override
    public void connect() {
        if (this.n == 1 || this.n == 0 || this.n == 4) {
            return;
        }
        try {
            int n2;
            if (this.w == null) {
                this.c();
            }
            if (anet.channel.util.c.a() && anet.channel.strategy.utils.c.a(this.e)) {
                try {
                    this.f = anet.channel.util.c.a(this.e);
                }
                catch (Exception exception) {}
            }
            String string = String.valueOf(System.currentTimeMillis());
            ALog.e("awcn.TnetSpdySession", "connect", this.p, "host", this.c, "ip", this.f, "port", this.g, "sessionId", string, "SpdyProtocol,", this.j, "proxyIp,", this.h, "proxyPort,", this.i);
            org.android.spdy.SessionInfo sessionInfo = new org.android.spdy.SessionInfo(this.f, this.g, this.c + "_" + this.F, this.h, this.i, (Object)string, (SessionCb)this, this.j.getTnetConType());
            sessionInfo.setConnectionTimeoutMs((int)((float)this.r * Utils.getNetworkTimeFactor()));
            if (this.j.isPublicKeyAuto() || this.j.isH2S() || this.j.isHTTP3()) {
                sessionInfo.setCertHost(this.m ? this.e : this.d);
            } else if (this.B >= 0) {
                sessionInfo.setPubKeySeqNum(this.B);
            } else {
                this.B = this.j.getTnetPublicKey(this.G != null ? this.G.isSecOff() : true);
                sessionInfo.setPubKeySeqNum(this.B);
            }
            if (this.j.isHTTP3() && (n2 = AwcnConfig.getXquicCongControl()) >= 0) {
                sessionInfo.setXquicCongControl(n2);
            }
            this.x = this.w.createSession(sessionInfo);
            if (this.x.getRefCount() > 1) {
                ALog.e("awcn.TnetSpdySession", "get session ref count > 1!!!", this.p, new Object[0]);
                this.notifyStatus(0, new b(1));
                this.b();
                return;
            }
            this.notifyStatus(1, null);
            this.z = System.currentTimeMillis();
            this.q.isProxy = !TextUtils.isEmpty((CharSequence)this.h) ? 1 : 0;
            this.q.isTunnel = "false";
            this.q.isBackground = GlobalAppRuntimeInfo.isAppBackground();
            this.A = 0L;
        }
        catch (Throwable throwable) {
            this.notifyStatus(2, null);
            ALog.e("awcn.TnetSpdySession", "connect exception ", this.p, throwable, new Object[0]);
        }
    }

    @Override
    public void close() {
        ALog.e("awcn.TnetSpdySession", "force close!", this.p, "session", this);
        this.notifyStatus(7, null);
        try {
            if (this.D != null) {
                this.D.stop();
                this.D = null;
            }
            if (this.x != null) {
                this.x.closeSession();
            }
        }
        catch (Exception exception) {}
    }

    @Override
    protected void onDisconnect() {
        this.y = false;
    }

    @Override
    protected Runnable getRecvTimeOutRunnable() {
        return new h(this);
    }

    @Override
    public void ping(boolean bl) {
        this.ping(bl, this.s);
    }

    @Override
    public void ping(boolean bl, int n2) {
        if (ALog.isPrintLog(1)) {
            ALog.d("awcn.TnetSpdySession", "ping", this.p, "host", this.c, "thread", Thread.currentThread().getName());
        }
        try {
            if (bl) {
                if (this.x != null) {
                    if (this.n == 0 || this.n == 4) {
                        this.handleCallbacks(64, null);
                        if (this.y) {
                            return;
                        }
                        this.y = true;
                        ++this.q.ppkgCount;
                        this.x.submitPing();
                        if (ALog.isPrintLog(1)) {
                            ALog.d("awcn.TnetSpdySession", this.c + " submit ping ms:" + (System.currentTimeMillis() - this.z) + " force:" + bl, this.p, new Object[0]);
                        }
                        this.setPingTimeout(n2);
                        this.z = System.currentTimeMillis();
                        if (this.D != null) {
                            this.D.reSchedule();
                        }
                    }
                } else {
                    if (this.q != null) {
                        this.q.closeReason = "session null";
                    }
                    ALog.e("awcn.TnetSpdySession", this.c + " session null", this.p, new Object[0]);
                    this.close();
                }
            }
        }
        catch (SpdyErrorException spdyErrorException) {
            if (spdyErrorException.SpdyErrorGetCode() == -1104 || spdyErrorException.SpdyErrorGetCode() == -1103) {
                ALog.e("awcn.TnetSpdySession", "Send request on closed session!!!", this.p, new Object[0]);
                this.notifyStatus(6, new b(2));
            }
            ALog.e("awcn.TnetSpdySession", "ping", this.p, spdyErrorException, new Object[0]);
        }
        catch (Exception exception) {
            ALog.e("awcn.TnetSpdySession", "ping", this.p, exception, new Object[0]);
        }
    }

    protected void b() {
        if (this.E != null) {
            this.E.auth(this, new i(this));
        } else {
            this.notifyStatus(4, null);
            this.q.ret = 1;
            if (this.D != null) {
                this.D.start(this);
            }
        }
    }

    @Override
    public boolean isAvailable() {
        return this.n == 4;
    }

    private void c() {
        SpdyAgent.enableDebug = false;
        this.w = SpdyAgent.getInstance((Context)this.a, (SpdyVersion)SpdyVersion.SPDY3, (SpdySessionKind)SpdySessionKind.NONE_SESSION);
        if (this.G != null && !this.G.isSecOff()) {
            this.w.setAccsSslCallback((AccsSSLCallback)new j(this));
        }
        if (!AwcnConfig.isTnetHeaderCacheEnable()) {
            try {
                Class<?> clazz = this.w.getClass();
                clazz.getDeclaredMethod("disableHeaderCache", new Class[0]).invoke((Object)this.w, new Object[0]);
                ALog.i("awcn.TnetSpdySession", "tnet disableHeaderCache", null, new Object[0]);
            }
            catch (Exception exception) {
                ALog.e("awcn.TnetSpdySession", "tnet disableHeaderCache", null, exception, new Object[0]);
            }
        }
    }

    public void spdySessionConnectCB(SpdySession spdySession, SuperviseConnectInfo superviseConnectInfo) {
        this.q.connectionTime = superviseConnectInfo.connectTime;
        this.q.sslTime = superviseConnectInfo.handshakeTime;
        this.q.sslCalTime = superviseConnectInfo.doHandshakeTime;
        this.q.netType = NetworkStatusHelper.getNetworkSubType();
        this.A = System.currentTimeMillis();
        this.notifyStatus(0, new b(1));
        this.b();
        ALog.e("awcn.TnetSpdySession", "spdySessionConnectCB connect", this.p, "connectTime", superviseConnectInfo.connectTime, "sslTime", superviseConnectInfo.handshakeTime);
        if (this.j.isHTTP3()) {
            this.q.scid = superviseConnectInfo.scid;
            this.q.dcid = superviseConnectInfo.dcid;
            this.q.congControlKind = superviseConnectInfo.congControlKind;
            ALog.e("awcn.TnetSpdySession", "[HTTP3 spdySessionConnectCB]", this.p, "connectInfo", spdySession.getConnectInfoOnConnected());
        }
    }

    public void spdyPingRecvCallback(SpdySession spdySession, long l2, Object object) {
        if (ALog.isPrintLog(2)) {
            ALog.i("awcn.TnetSpdySession", "ping receive", this.p, "Host", this.c, "id", l2);
        }
        if (l2 < 0L) {
            return;
        }
        this.y = false;
        this.H = 0;
        if (this.D != null) {
            this.D.reSchedule();
        }
        this.handleCallbacks(128, null);
    }

    public void bioPingRecvCallback(SpdySession spdySession, int n2) {
    }

    public void spdyCustomControlFrameRecvCallback(SpdySession spdySession, Object object, int n2, int n3, int n4, int n5, byte[] byArray) {
        Object object2;
        ALog.e("awcn.TnetSpdySession", "[spdyCustomControlFrameRecvCallback]", this.p, "len", n5, "frameCb", this.C);
        if (ALog.isPrintLog(1)) {
            object2 = "";
            if (n5 < 512) {
                for (int i2 = 0; i2 < byArray.length; ++i2) {
                    object2 = (String)object2 + Integer.toHexString(0xFF & byArray[i2]) + " ";
                }
                ALog.e("awcn.TnetSpdySession", null, this.p, "str", object2);
            }
        }
        if (this.C != null) {
            this.C.onDataReceive(this, byArray, n2, n3);
        } else {
            ALog.e("awcn.TnetSpdySession", "AccsFrameCb is null", this.p, new Object[0]);
            object2 = new ExceptionStatistic(-105, null, "rt");
            AppMonitor.getInstance().commitStat((StatObject)object2);
        }
        ++this.q.inceptCount;
        if (this.D != null) {
            this.D.reSchedule();
        }
    }

    public void spdySessionFailedError(SpdySession spdySession, int n2, Object object) {
        try {
            if (spdySession != null) {
                spdySession.cleanUp();
            }
        }
        catch (Exception exception) {
            ALog.e("awcn.TnetSpdySession", "[spdySessionFailedError]session clean up failed!", null, exception, new Object[0]);
        }
        this.notifyStatus(2, new b(256, n2, "tnet connect fail"));
        ALog.e("awcn.TnetSpdySession", null, this.p, " errorId:", n2);
        this.q.errorCode = n2;
        this.q.ret = 0;
        this.q.netType = NetworkStatusHelper.getNetworkSubType();
        AppMonitor.getInstance().commitStat(this.q);
        if (anet.channel.strategy.utils.c.b(this.q.ip)) {
            AppMonitor.getInstance().commitStat(new SessionMonitor(this.q));
        }
        AppMonitor.getInstance().commitAlarm(this.q.getAlarmObject());
    }

    public void spdySessionCloseCallback(SpdySession spdySession, Object object, SuperviseConnectInfo superviseConnectInfo, int n2) {
        ALog.e("awcn.TnetSpdySession", "spdySessionCloseCallback", this.p, " errorCode:", n2);
        if (this.D != null) {
            this.D.stop();
            this.D = null;
        }
        try {
            if (spdySession != null) {
                spdySession.cleanUp();
            }
        }
        catch (Exception exception) {
            ALog.e("awcn.TnetSpdySession", "session clean up failed!", null, exception, new Object[0]);
        }
        if (n2 == -3516) {
            ConnEvent connEvent = new ConnEvent();
            connEvent.isSuccess = false;
            StrategyCenter.getInstance().notifyConnEvent(this.d, this.k, connEvent);
        }
        this.notifyStatus(6, new b(2));
        if (superviseConnectInfo != null) {
            this.q.requestCount = superviseConnectInfo.reused_counter;
            this.q.liveTime = superviseConnectInfo.keepalive_period_second;
            try {
                if (this.j.isHTTP3()) {
                    if (spdySession != null) {
                        ALog.e("awcn.TnetSpdySession", "[HTTP3 spdySessionCloseCallback]", this.p, "connectInfo", spdySession.getConnectInfoOnDisConnected());
                    }
                    this.q.xqc0RttStatus = superviseConnectInfo.xqc0RttStatus;
                    this.q.retransmissionRate = superviseConnectInfo.retransmissionRate;
                    this.q.lossRate = superviseConnectInfo.lossRate;
                    this.q.tlpCount = superviseConnectInfo.tlpCount;
                    this.q.rtoCount = superviseConnectInfo.rtoCount;
                    this.q.srtt = superviseConnectInfo.srtt;
                }
            }
            catch (Exception exception) {}
        }
        if (this.q.errorCode == 0L) {
            this.q.errorCode = n2;
        }
        this.q.lastPingInterval = (int)(System.currentTimeMillis() - this.z);
        AppMonitor.getInstance().commitStat(this.q);
        if (anet.channel.strategy.utils.c.b(this.q.ip)) {
            AppMonitor.getInstance().commitStat(new SessionMonitor(this.q));
        }
        AppMonitor.getInstance().commitAlarm(this.q.getAlarmObject());
    }

    public void spdyCustomControlFrameFailCallback(SpdySession spdySession, Object object, int n2, int n3) {
        ALog.e("awcn.TnetSpdySession", "spdyCustomControlFrameFailCallback", this.p, "dataId", n2);
        this.a(n2, n3, true, "tnet error");
    }

    public byte[] getSSLMeta(SpdySession spdySession) {
        byte[] byArray = null;
        String string = spdySession.getDomain();
        if (TextUtils.isEmpty((CharSequence)string)) {
            ALog.i("awcn.TnetSpdySession", "get sslticket host is null", null, new Object[0]);
            return byArray;
        }
        try {
            if (this.G != null) {
                byArray = this.G.getBytes(this.a, "accs_ssl_key2_" + string);
            }
        }
        catch (Throwable throwable) {
            ALog.e("awcn.TnetSpdySession", "getSSLMeta", null, throwable, new Object[0]);
        }
        return byArray;
    }

    public int putSSLMeta(SpdySession spdySession, byte[] byArray) {
        int n2 = -1;
        String string = spdySession.getDomain();
        if (TextUtils.isEmpty((CharSequence)string)) {
            return n2;
        }
        try {
            if (this.G != null) {
                n2 = this.G.saveBytes(this.a, "accs_ssl_key2_" + string, byArray) ? 0 : -1;
            }
        }
        catch (Throwable throwable) {
            ALog.e("awcn.TnetSpdySession", "putSSLMeta", null, throwable, new Object[0]);
        }
        return n2;
    }

    static /* synthetic */ void a(TnetSpdySession tnetSpdySession, int n2, b b2) {
        tnetSpdySession.handleCallbacks(n2, b2);
    }

    static /* synthetic */ String b(TnetSpdySession tnetSpdySession) {
        return tnetSpdySession.d;
    }

    static /* synthetic */ IConnStrategy c(TnetSpdySession tnetSpdySession) {
        return tnetSpdySession.k;
    }

    static /* synthetic */ void b(TnetSpdySession tnetSpdySession, int n2, b b2) {
        tnetSpdySession.notifyStatus(n2, b2);
    }

    static /* synthetic */ void c(TnetSpdySession tnetSpdySession, int n2, b b2) {
        tnetSpdySession.notifyStatus(n2, b2);
    }

    static /* synthetic */ Context d(TnetSpdySession tnetSpdySession) {
        return tnetSpdySession.a;
    }

    private class a
    extends anet.channel.session.a {
        private Request b;
        private RequestCb c;
        private int d = 0;
        private long e = 0L;

        public a(Request request, RequestCb requestCb) {
            this.b = request;
            this.c = requestCb;
        }

        @Override
        public void spdyDataChunkRecvCB(SpdySession spdySession, boolean bl, long l2, SpdyByteArray spdyByteArray, Object object) {
            if (ALog.isPrintLog(1)) {
                ALog.d("awcn.TnetSpdySession", "spdyDataChunkRecvCB", this.b.getSeq(), "len", spdyByteArray.getDataLength(), "fin", bl);
            }
            this.e += (long)spdyByteArray.getDataLength();
            this.b.a.recDataSize += (long)spdyByteArray.getDataLength();
            if (TnetSpdySession.this.D != null) {
                TnetSpdySession.this.D.reSchedule();
            }
            if (this.c != null) {
                ByteArray byteArray = a.a.a.a(spdyByteArray.getByteArray(), spdyByteArray.getDataLength());
                spdyByteArray.recycle();
                this.c.onDataReceive(byteArray, bl);
            }
            TnetSpdySession.this.handleCallbacks(32, null);
        }

        @Override
        public void spdyStreamCloseCallback(SpdySession spdySession, long l2, int n2, Object object, SuperviseData superviseData) {
            if (ALog.isPrintLog(1)) {
                ALog.d("awcn.TnetSpdySession", "spdyStreamCloseCallback", this.b.getSeq(), "streamId", l2, "errorCode", n2);
            }
            String string = "SUCCESS";
            if (n2 != 0) {
                this.d = -304;
                string = ErrorConstant.formatMsg(-304, String.valueOf(n2));
                if (n2 != -2005) {
                    AppMonitor.getInstance().commitStat(new ExceptionStatistic(-300, string, this.b.a, null));
                }
                ALog.e("awcn.TnetSpdySession", "spdyStreamCloseCallback error", this.b.getSeq(), "session", TnetSpdySession.this.p, "status code", n2, "URL", this.b.getHttpUrl().simpleUrlString());
            }
            this.b.a.tnetErrorCode = n2;
            this.a(superviseData, this.d, string);
            if (this.c != null) {
                this.c.onFinish(this.d, string, this.b.a);
            }
            if (n2 == -2004) {
                if (!TnetSpdySession.this.y) {
                    TnetSpdySession.this.ping(true);
                }
                if (++TnetSpdySession.this.H >= 2) {
                    ConnEvent connEvent = new ConnEvent();
                    connEvent.isSuccess = false;
                    connEvent.isAccs = TnetSpdySession.this.I;
                    StrategyCenter.getInstance().notifyConnEvent(TnetSpdySession.this.d, TnetSpdySession.this.k, connEvent);
                    TnetSpdySession.this.close(true);
                }
            }
        }

        private void a(SuperviseData superviseData, int n2, String string) {
            try {
                this.b.a.rspEnd = System.currentTimeMillis();
                if (this.b.a.isDone.get()) {
                    return;
                }
                if (n2 > 0) {
                    this.b.a.ret = 1;
                }
                this.b.a.statusCode = n2;
                this.b.a.msg = string;
                if (superviseData != null) {
                    this.b.a.rspEnd = superviseData.responseEnd;
                    this.b.a.sendBeforeTime = superviseData.sendStart - superviseData.requestStart;
                    this.b.a.sendDataTime = superviseData.sendEnd - this.b.a.sendStart;
                    this.b.a.firstDataTime = superviseData.responseStart - superviseData.sendEnd;
                    this.b.a.recDataTime = superviseData.responseEnd - superviseData.responseStart;
                    this.b.a.sendDataSize = superviseData.bodySize + superviseData.compressSize;
                    this.b.a.recDataSize = this.e + (long)superviseData.recvUncompressSize;
                    this.b.a.reqHeadInflateSize = superviseData.uncompressSize;
                    this.b.a.reqHeadDeflateSize = superviseData.compressSize;
                    this.b.a.reqBodyInflateSize = superviseData.bodySize;
                    this.b.a.reqBodyDeflateSize = superviseData.bodySize;
                    this.b.a.rspHeadDeflateSize = superviseData.recvCompressSize;
                    this.b.a.rspHeadInflateSize = superviseData.recvUncompressSize;
                    this.b.a.rspBodyDeflateSize = superviseData.recvBodySize;
                    this.b.a.rspBodyInflateSize = this.e;
                    if (this.b.a.contentLength == 0L) {
                        this.b.a.contentLength = superviseData.originContentLength;
                    }
                    TnetSpdySession.this.q.recvSizeCount += (long)(superviseData.recvBodySize + superviseData.recvCompressSize);
                    TnetSpdySession.this.q.sendSizeCount += (long)(superviseData.bodySize + superviseData.compressSize);
                }
            }
            catch (Exception exception) {}
        }

        @Override
        public void spdyOnStreamResponse(SpdySession spdySession, long l2, Map<String, List<String>> map, Object object) {
            this.b.a.firstDataTime = System.currentTimeMillis() - this.b.a.sendStart;
            this.d = HttpHelper.parseStatusCode(map);
            TnetSpdySession.this.H = 0;
            ALog.i("awcn.TnetSpdySession", "", this.b.getSeq(), "statusCode", this.d);
            ALog.i("awcn.TnetSpdySession", "", this.b.getSeq(), "response headers", map);
            if (this.c != null) {
                this.c.onResponseCode(this.d, HttpHelper.cloneMap(map));
            }
            TnetSpdySession.this.handleCallbacks(16, null);
            this.b.a.contentEncoding = HttpHelper.getSingleHeaderFieldByKey(map, "Content-Encoding");
            this.b.a.contentType = HttpHelper.getSingleHeaderFieldByKey(map, "Content-Type");
            this.b.a.contentLength = HttpHelper.parseContentLength(map);
            this.b.a.serverRT = HttpHelper.parseServerRT(map);
            TnetSpdySession.this.handleResponseCode(this.b, this.d);
            TnetSpdySession.this.handleResponseHeaders(this.b, map);
            if (TnetSpdySession.this.D != null) {
                TnetSpdySession.this.D.reSchedule();
            }
        }
    }
}

