/*
 * Decompiled with CFR 0.152.
 */
package anet.channel.util;

import android.text.TextUtils;
import anet.channel.request.Request;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class HttpHelper {
    public static Map<String, List<String>> cloneMap(Map<String, List<String>> map) {
        if (map == null) {
            return null;
        }
        if (map.isEmpty()) {
            return Collections.EMPTY_MAP;
        }
        HashMap<String, List<String>> hashMap = new HashMap<String, List<String>>(map.size());
        for (Map.Entry<String, List<String>> entry : map.entrySet()) {
            hashMap.put(entry.getKey(), new ArrayList(entry.getValue()));
        }
        return hashMap;
    }

    public static List<String> getHeaderFieldByKey(Map<String, List<String>> map, String string) {
        if (map == null || map.isEmpty() || TextUtils.isEmpty((CharSequence)string)) {
            return null;
        }
        for (Map.Entry<String, List<String>> entry : map.entrySet()) {
            if (!string.equalsIgnoreCase(entry.getKey())) continue;
            return entry.getValue();
        }
        return null;
    }

    public static String getSingleHeaderFieldByKey(Map<String, List<String>> map, String string) {
        List<String> list = HttpHelper.getHeaderFieldByKey(map, string);
        if (list == null || list.isEmpty()) {
            return null;
        }
        return list.get(0);
    }

    public static void removeHeaderFiledByKey(Map<String, List<String>> map, String string) {
        if (string == null) {
            return;
        }
        String string2 = null;
        Iterator<String> iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            if (!string.equalsIgnoreCase(iterator.next())) continue;
            string2 = string;
            break;
        }
        if (string2 != null) {
            map.remove(string2);
        }
    }

    public static boolean checkRedirect(Request request, int n2) {
        return request.isRedirectEnable() && n2 >= 300 && n2 < 400 && n2 != 304 && request.getRedirectTimes() < 10;
    }

    public static int parseContentLength(Map<String, List<String>> map) {
        int n2 = 0;
        try {
            n2 = Integer.parseInt(HttpHelper.getSingleHeaderFieldByKey(map, "Content-Length"));
        }
        catch (Exception exception) {}
        return n2;
    }

    public static long parseServerRT(Map<String, List<String>> map) {
        try {
            List<String> list = map.get("s-rt");
            if (list != null && !list.isEmpty()) {
                return Long.parseLong(list.get(0));
            }
        }
        catch (NumberFormatException numberFormatException) {}
        return 0L;
    }

    public static int parseStatusCode(Map<String, List<String>> map) {
        try {
            List<String> list = map.get(":status");
            if (list != null && !list.isEmpty()) {
                return Integer.parseInt(list.get(0));
            }
        }
        catch (NumberFormatException numberFormatException) {}
        return 0;
    }

    public static String trySolveFileExtFromUrlPath(String string) {
        if (string == null) {
            return null;
        }
        String string2 = null;
        try {
            int n2 = string.length();
            if (n2 <= 1) {
                return null;
            }
            int n3 = string.lastIndexOf(47);
            if (n3 == -1 || n3 == n2 - 1) {
                return null;
            }
            int n4 = string.lastIndexOf(46);
            if (n4 == -1 || n4 <= n3) {
                return null;
            }
            string2 = string.substring(n4 + 1, n2);
        }
        catch (Exception exception) {}
        return string2;
    }

    @Deprecated
    public static String trySolveFileExtFromURL(URL uRL) {
        return HttpHelper.trySolveFileExtFromUrlPath(uRL.getPath());
    }
}

