/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.common.tedis.commands;

import com.taobao.common.tedis.TedisException;
import com.taobao.common.tedis.binary.RedisCommands;
import com.taobao.common.tedis.core.AtomicCommands;
import com.taobao.common.tedis.core.BaseCommands;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class DefaultAtomicCommands
extends BaseCommands
implements AtomicCommands {
    protected RedisCommands redisCommands;

    public DefaultAtomicCommands() {
    }

    public DefaultAtomicCommands(RedisCommands redisCommands) {
        this.redisCommands = redisCommands;
    }

    public RedisCommands getRedisCommands() {
        return this.redisCommands;
    }

    public void setRedisCommands(RedisCommands redisCommands) {
        this.redisCommands = redisCommands;
    }

    public void init() {
        if (this.commandsProvider == null) {
            throw new TedisException("commandsProvider is null.please set a commandsProvider first.");
        }
        this.redisCommands = this.commandsProvider.getTedis();
    }

    public long get(final int namespace, final Object key) {
        return this.deserializeLong((byte[])this.doInTedis(namespace, new BaseCommands.TedisBlock(this.redisCommands){

            public Object execute() {
                return this.commands.get(DefaultAtomicCommands.this.rawKey(namespace, key));
            }
        }));
    }

    public long getAndSet(final int namespace, final Object key, final long value) {
        return this.deserializeLong((byte[])this.doInTedis(namespace, new BaseCommands.TedisBlock(this.redisCommands){

            public Object execute() {
                return this.commands.getSet(DefaultAtomicCommands.this.rawKey(namespace, key), DefaultAtomicCommands.this.rawLong(value));
            }
        }));
    }

    public Long increment(final int namespace, final Object key, final long delta) {
        return (Long)this.doInTedis(namespace, new BaseCommands.TedisBlock(this.redisCommands){

            public Object execute() {
                byte[] rawKey = DefaultAtomicCommands.this.rawKey(namespace, key);
                if (delta == 1L) {
                    return this.commands.incr(rawKey);
                }
                if (delta == -1L) {
                    return this.commands.decr(rawKey);
                }
                if (delta < 0L) {
                    return this.commands.decrBy(rawKey, delta);
                }
                return this.commands.incrBy(rawKey, delta);
            }
        });
    }

    public List<Long> multiGet(int namespace, Collection<? extends Object> keys) {
        if (keys.isEmpty()) {
            return Collections.emptyList();
        }
        final byte[][] rawKeys = new byte[keys.size()][];
        int counter = 0;
        for (Object object : keys) {
            rawKeys[counter++] = this.rawKey(namespace, object);
        }
        return this.deserializeLongs((List)this.doInTedis(namespace, new BaseCommands.TedisBlock(this.redisCommands){

            public Object execute() {
                return this.commands.mGet(rawKeys);
            }
        }));
    }

    public void multiSet(int namespace, Map<? extends Object, Long> m) {
        if (m.isEmpty()) {
            return;
        }
        final LinkedHashMap<byte[], byte[]> rawKeys = new LinkedHashMap<byte[], byte[]>(m.size());
        for (Map.Entry<? extends Object, Long> entry : m.entrySet()) {
            rawKeys.put(this.rawKey(namespace, entry.getKey()), this.rawLong(entry.getValue()));
        }
        this.doInTedis(namespace, new BaseCommands.TedisBlock(this.redisCommands){

            public Object execute() {
                this.commands.mSet(rawKeys);
                return null;
            }
        });
    }

    public void multiSetIfAbsent(int namespace, Map<? extends Object, Long> m) {
        if (m.isEmpty()) {
            return;
        }
        final LinkedHashMap<byte[], byte[]> rawKeys = new LinkedHashMap<byte[], byte[]>(m.size());
        for (Map.Entry<? extends Object, Long> entry : m.entrySet()) {
            rawKeys.put(this.rawKey(namespace, entry.getKey()), this.rawLong(entry.getValue()));
        }
        this.doInTedis(namespace, new BaseCommands.TedisBlock(this.redisCommands){

            public Object execute() {
                this.commands.mSetNX(rawKeys);
                return null;
            }
        });
    }

    public void set(final int namespace, final Object key, final long value) {
        this.doInTedis(namespace, new BaseCommands.TedisBlock(this.redisCommands){

            public Object execute() {
                this.commands.set(DefaultAtomicCommands.this.rawKey(namespace, key), DefaultAtomicCommands.this.rawLong(value));
                return null;
            }
        });
    }

    public void set(final int namespace, final Object key, final long value, final long timeout, final TimeUnit unit) {
        this.doInTedis(namespace, new BaseCommands.TedisBlock(this.redisCommands){

            public Object execute() {
                this.commands.setEx(DefaultAtomicCommands.this.rawKey(namespace, key), (long)((int)unit.toSeconds(timeout)), DefaultAtomicCommands.this.rawLong(value));
                return null;
            }
        });
    }

    public Boolean setIfAbsent(final int namespace, final Object key, final long value) {
        return (Boolean)this.doInTedis(namespace, new BaseCommands.TedisBlock(this.redisCommands){

            public Object execute() {
                return this.commands.setNX(DefaultAtomicCommands.this.rawKey(namespace, key), DefaultAtomicCommands.this.rawLong(value));
            }
        });
    }
}

